# S-TIP - **S**eamless **T**hreat **I**ntelligence **P**latform

<img src="https://github.com/s-tip/stip-common/blob/master/img/stip-logo.ico">

S-TIP is a threat intelligence platform to bring down barriers among separate practices of CTI sharing.

## Requirements

* **Python 3.6+**
* MySQL 5.7+
* MongoDB 4.0+
* Web server (e.g. apache)

## Getting Started

### Installation

There are a few install scripts that you can easily install S-TIP instance.

See the [Installation](https://github.com/s-tip/stip-common/wikis/installation).

### Docker images

S-TIP has a docker image and a docker-compose script.

See the [Running with docker](https://github.com/s-tip/stip-common/wikis/Running-with-Docker).

### Tutorial

See the [Tutorial](https://github.com/s-tip/stip-common/wikis/Tutorial).

### Configuration

See the [Configuration](https://github.com/s-tip/stip-common/wikis/configuration).

## Core Concept

Seamless Threat Intelligence Platform is built around a very simple, but extremely powerful concept - Convert whatever CTI into a STIX file or a set of STIX files, send them around, and create different views dynamically from those STIX files.

See the [wiki](https://github.com/s-tip/stip-common/wikis/home) for details.

## Preview

S-TIP SNS

![S-TIP SNS](https://raw.githubusercontent.com/s-tip/stip-common/images/stip-sns.gif "S-TIP SNS")

S-TIP GV
![S-TIP GV](https://raw.githubusercontent.com/s-tip/stip-common/images/stip-gv.gif "S-TIP GV")

## Slides

Slide deck for the Code Blue 2019 conference.

https://www.slideshare.net/codeblue_jp/cb19-seamless-threat-intelligence-platform-stip-by-koji-yamada-toshitaka-satomi



## Contributing

See the [Contributing](CONTRIBUTING.md).

## License

This software is licensed under [GNU Affero General Public License version 3](http://www.gnu.org/licenses/agpl-3.0.html)

* Copyright (c) 2019, Fujitsu System Integration Laboratories Ltd.
