"""
Django settings for cti_repository_system project.

Generated by 'django-admin startproject' using Django 1.10.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.10/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.10/ref/settings/
"""

import os
import json
from logging import config as logging_config
from logging import disable, WARNING
from unipath import Path
from decouple import Csv, config, UndefinedValueError
from stip.common.stix_customizer import StixCustomizer
from stip.common.matching_customizer import MatchingCustomizer

try:
    txc2_audit_long_conf_path = config('TXC2_AUDIT_LOG_CONF')
    with open(txc2_audit_long_conf_path) as fp:
        log_conf = json.load(fp)
        logging_config.dictConfig(log_conf)
except (FileNotFoundError, UndefinedValueError):
    disable(WARNING)

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# LOGIN_URL
LOGIN_URL = '/'

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.10/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
# If you will use S-TIP in production mode, please change SECRET_KEY in .env file.
# Please keep same SECRET_KEY among S-TIP apps (for Single Sign On).
DEFAULT_SECRET_KEY = 'j%yjl@$v=xi6((y3!=bf3$n5)e)+af)*+syuia#co)1edp=dv-'
SECRET_KEY = config('SECRET_KEY', default=DEFAULT_SECRET_KEY)

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = config('DEBUG', default=False, cast=bool)

ALLOWED_HOSTS = config('ALLOWED_HOSTS', cast=Csv())
mysql_user = config('MYSQL_USER')
mysql_password = config('MYSQL_PASSWORD')
try:
    mysql_dbname = config('MYSQL_DBNAME')
except UndefinedValueError:
    mysql_dbname = 's_tip'
try:
    mysql_host = config('MYSQL_HOST')
except UndefinedValueError:
    mysql_host = 'localhost'
try:
    mysql_port = config('MYSQL_PORT')
except UndefinedValueError:
    mysql_port = '3306'

try:
    TIME_ZONE = config('TIME_ZONE')
except UndefinedValueError:
    TIME_ZONE = 'UTC'
try:
    cookie_domain_name = config('COOKIE_DOMAIN_NAME')
except UndefinedValueError:
    cookie_domain_name = None

try:
    CSRF_TRUSTED_ORIGINS = json.loads(config('CSRF_TRUSTED_ORIGINS_RS'))
except Exception:
    CSRF_TRUSTED_ORIGINS = []

stix_customizer = StixCustomizer.get_instance()
try:
    stix_customizer.init_customizer_conf(config('STIX_CUSTOMIZER_CONF_PATH'))
except UndefinedValueError:
    pass

matching_customizer = MatchingCustomizer.get_instance()
try:
    matching_customizer.init_customizer_conf(config('MATCHING_CUSTOMIZER_CONF_PATH'))
except UndefinedValueError:
    pass

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'ctirs.core.boot_rs.StipRsBoot',
    'ctirs',
]


MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]
DEFAULT_AUTO_FIELD = 'django.db.models.AutoField'


ROOT_URLCONF = 'ctirs.urls'

SRC_DIR = BASE_DIR + os.sep
CTIRS_DIR = SRC_DIR + os.sep + 'ctirs' + os.sep
COMMON_PROJECT_DIR = '/opt/s-tip/common'
DIRS = [
    os.path.join(SRC_DIR, 'templates'),
    os.path.join(CTIRS_DIR, 'error/templates'),
    os.path.join(CTIRS_DIR, 'dashboard/templates'),
    os.path.join(CTIRS_DIR, 'login/templates'),
    os.path.join(CTIRS_DIR, 'upload/templates'),
    os.path.join(CTIRS_DIR, 'list/templates'),
    os.path.join(CTIRS_DIR, 'status/templates'),
    os.path.join(CTIRS_DIR, 'poll/templates'),
    os.path.join(CTIRS_DIR, 'profile/templates'),
    os.path.join(CTIRS_DIR, 'configuration/user/templates'),
    os.path.join(CTIRS_DIR, 'configuration/community/templates'),
    os.path.join(CTIRS_DIR, 'configuration/system/templates'),
    os.path.join(CTIRS_DIR, 'configuration/mongo/templates'),
    os.path.join(CTIRS_DIR, 'configuration/customizer/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii_client/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii_client/detail/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii2_client/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii2_client/detail/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii_server/templates'),
    os.path.join(CTIRS_DIR, 'configuration/taxii_server/detail/templates'),
    os.path.join(CTIRS_DIR, 'adapter/otx/templates'),
    os.path.join(CTIRS_DIR, 'adapter/otx/detail/templates'),
    os.path.join(CTIRS_DIR, 'adapter/isight/templates'),
    os.path.join(CTIRS_DIR, 'adapter/isight/detail/templates'),
    os.path.join(CTIRS_DIR, 'adapter/misp/templates'),
    os.path.join(CTIRS_DIR, 'adapter/misp/detail/templates'),
    os.path.join(COMMON_PROJECT_DIR, 'src/templates'),
]
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': DIRS,
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'ctirs.core.context_processors.headers',
            ],
        },
    },
]

WSGI_APPLICATION = 'ctirs.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.10/ref/settings/#databases
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': mysql_dbname,
        'USER': mysql_user,
        'PASSWORD': mysql_password,
        'HOST': mysql_host,
        'PORT': mysql_port,
    }
}
AUTH_USER_MODEL = 'ctirs.STIPUser'

# Internationalization
# https://docs.djangoproject.com/en/1.10/topics/i18n/

LANGUAGE_CODE = 'en-us'
# LANGUAGE_CODE = 'ja'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.10/howto/static-files/

STATIC_URL = '/static/'
PROJECT_DIR = Path(__file__).parent.parent
STATIC_ROOT = PROJECT_DIR.parent.child('staticfiles')
STATICFILES_DIRS = (
    ''.join([BASE_DIR, os.sep, 'static']),
    os.path.join(COMMON_PROJECT_DIR, 'src/static'),
)

SESSION_COOKIE_NAME = 'stip'
SESSION_ENGINE = 'django.contrib.sessions.backends.cached_db'

# HTTP 上で動作させるかどうかのフラグ
ENV_DEV_OVER_HTTP_KEY = 'DEV_OVER_HTTP'
dev_over_http = False
if (ENV_DEV_OVER_HTTP_KEY in os.environ):
    if os.environ[ENV_DEV_OVER_HTTP_KEY] == 'True':
        dev_over_http = True
# http で動作させないときは SESSION_COOKIE_SECURE を立てる
if not dev_over_http:
    SESSION_COOKIE_SECURE = True
    CSRF_COOKIE_SECURE = True
    SESSION_COOKIE_DOMAIN = cookie_domain_name
APPEND_SLASH = False

try:
    version_path = '/opt/s-tip/rs/version'
    fp = open(version_path, 'r', encoding='utf-8')
    STIP_RS_VERSION = fp.readline().strip()
    fp.close()
except IOError:
    STIP_RS_VERSION = None
