clean-local-coreclr:
	-rm -f $(CORECLR_TESTSI_CS)
	-rm -f $(CORECLR_COREMANGLIB_TESTSI_CS)
	-rm -f $(CORECLR_TESTSI_IL)

CLEANFILES += $(CORECLR_STRESSTESTSI_CS) GCStressTests.exe coreclr-testlibrary.dll

coreclr-validate:
	$(MAKE) validate-coreclr RESET_VERSIONS=1

coreclr-compile-tests: coreclr-validate
	$(MAKE) -j4 $(CORECLR_TESTSI_CS)
	$(MAKE) -j4 $(CORECLR_COREMANGLIB_TESTSI_CS)
	$(MAKE) -j4 $(CORECLR_TESTSI_IL)

# the CoreCLR tests rely on the coreclr-testlibrary.dll, we need to copy it to the test directory
coreclr-runtest-basic: coreclr-validate test-runner.exe $(CORECLR_TESTSI_CS) $(CORECLR_TESTSI_IL)
	@rm -f coreclr-testlist.txt
	@$(call dumpvariabletofile, coreclr-testlist.txt, $(CORECLR_TESTSI_CS))
	@$(call dumpvariabletofile, coreclr-testlist.txt, $(CORECLR_TESTSI_IL))
	@for var in $(sort $(dir $(CORECLR_TESTSI_CS))); do ln -sf $(abspath coreclr-testlibrary.dll) "$$var"; done
	$(RUNTIME) ./test-runner.exe -j a --testsuite-name "coreclr" --expected-exit-code 100 --input-file coreclr-testlist.txt
	@rm -f coreclr-testlist.txt

coreclr-runtest-coremanglib: coreclr-validate test-runner.exe $(CORECLR_COREMANGLIB_TESTSI_CS)
	@rm -f coreclr-testlist.txt
	@$(call dumpvariabletofile, coreclr-testlist.txt, $(CORECLR_COREMANGLIB_TESTSI_CS))
	@for var in $(sort $(dir $(CORECLR_COREMANGLIB_TESTSI_CS))); do ln -sf $(abspath coreclr-testlibrary.dll) "$$var"; done
	$(RUNTIME) ./test-runner.exe -j a --testsuite-name "coreclr-coremanglib" --expected-exit-code 100 --input-file coreclr-testlist.txt
	@rm -f coreclr-testlist.txt

check-coreclr: coreclr-compile-tests coreclr-runtest-basic coreclr-runtest-coremanglib

coreclr-gcstress: coreclr-validate GCStressTests.exe $(CORECLR_STRESSTESTSI_CS)
	BVT_ROOT=$(realpath $(CORECLR_PATH)/tests/src/GC/Stress/Tests) $(RUNTIME) GCStressTests.exe $(CORECLR_PATH)/tests/src/GC/Stress/$(if $(CI_PR),testmix_gc_pr.config,testmix_gc.config); if [ $$? -ne 100 ]; then exit 1; fi

# Output a variable in $(2) to the file $(1), separated by newline characters
# we need to do it in groups of 100 entries to make sure we don't exceed shell char limits
# note: the variable is appended to the file
define dumpvariabletofile
echo $(wordlist 1, 100, $(2)) | tr " " "\n" >> $(1)
$(if $(word 101, $(2)), $(call dumpvariabletofile, $(1), $(wordlist 101, $(words $(2)), $(2))))
endef

CORECLR_TEST_CS_SRC=		\
	$(CORECLR_PATH)/tests/src/GC/Coverage/LargeObjectAlloc.cs	\
	$(CORECLR_PATH)/tests/src/GC/Coverage/LargeObjectAlloc2.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta1/149926/149926.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta1/289745/289745.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta2/426480/426480.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta2/471729/471729.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-rtm/494226/494226.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-rtm/544701/544701.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Add1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/And1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AndRef.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Args4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Args5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AsgAdd1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AsgAnd1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AsgOr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AsgSub1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/AsgXor1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/BinaryRMW.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Call1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/CnsBool.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/CnsLng1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblAdd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblAddConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblArea.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblAvg2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblAvg6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblCall1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblCall2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblDist.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblDiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblDivConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblFillArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblMul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblMulConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblNeg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblRem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblRoots.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblSub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblSubConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/DblVar.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Eq1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPAdd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPAddConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPArea.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPAvg2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPAvg6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPCall1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPCall2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPConvDbl2Lng.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPConvF2F.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPConvF2I.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPConvF2Lng.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPConvI2F.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPDist.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPDiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPDivConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPError.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPFillArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPMath.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPMul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPMulConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPNeg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPRem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPRoots.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPSmall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPSub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPSubConst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FPVar.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FactorialRec.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FibLoop.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/FiboRec.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Gcd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Ge1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Gt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Ind1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/InitObj.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/InstanceCalls.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/IntArraySum.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/IntConv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrue1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueEqDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueEqFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueEqInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGeDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGeFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGeInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGtDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGtFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueGtInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLeDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLeFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLeInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLtDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLtFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueLtInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueNeDbl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueNeFP.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/JTrueNeInt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Jmp1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Le1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/LeftShift.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/LngConv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Localloc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/LocallocLarge.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/LongArgsAndReturn.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Lt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Ne1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/NegRMW.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/NestedCall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/NotAndNeg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/NotRMW.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/ObjAlloc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/OpMembersOfStructLocal.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Or1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/OrRef.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/RightShiftRef.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Rotate.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/StaticCalls.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/StaticValueField.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/StructFldAddr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/StructInstMethod.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Sub1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/SubRef.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Swap.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Switch.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Unbox.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/Xor1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/XorRef.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/addref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/div1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/div2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/divref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/mul1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/mul2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/mul3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/mul4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/CodeGenBringUpTests/rem1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Arrays/complex1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Arrays/complex2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Arrays/simple1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Arrays/simple2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Base_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Base_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Base_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Base_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Base_6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Peer_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Peer_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Peer_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Peer_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Generic_Test_CSharp_Peer_6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Base_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Base_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Base_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Base_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Peer_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Peer_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Peer_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/CheckedCtor/Test_CSharp_Peer_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StrAccess/straccess1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StrAccess/straccess2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StrAccess/straccess3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StrAccess/straccess4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1a2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1c.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP1d.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP2a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP2b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SP2c.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SpAddr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructPromote/SpAddrAT.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/TypedReference/TypedReference.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/UnrollLoop/Dev10_846218.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/UnrollLoop/loop1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/UnrollLoop/loop4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Bool_And_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Bool_No_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Bool_Or_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Bool_Xor_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Double_And_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Double_No_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Double_Or_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Double_Xor_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Float_And_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Float_No_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Float_Or_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Float_Xor_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Int_And_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Int_No_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Int_Or_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/cmov/Int_Xor_Op.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/flowgraph/xaddmuly.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/33objref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/cse1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/cse2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lclfldadd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lclflddiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lclfldmul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lclfldrem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lclfldsub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/gettypetypeof/gettypetypeofmatrix.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/IntrinsicTest_Overflow.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/cmpxchg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/cse_cmpxchg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/nullchecksuppress.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/regalloc1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/interlocked/regalloc2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/pow/pow0.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/pow/pow1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/pow/pow2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/intrinsic/pow/pow3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/lifetime/lifetime1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/localloc/localloc3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/int16.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/int32.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/int64.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/uint16.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/uint32.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/uint64.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/uint8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/Struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/Struct01_instance.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class01_instance.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class01_static.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class04.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class05.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class06.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/class07.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struc01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct01_static.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct04.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct05.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct06.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/Jagged/struct07.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/class01_Instance.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/class01_static.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/struct01_Instance.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/ConstructedTypes/MultiDim/struct01_static.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/TypeParameters/Jagged/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/TypeParameters/Jagged/struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/TypeParameters/MultiDim/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Arrays/TypeParameters/MultiDim/struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/class1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/class2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Call_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Call_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Convert_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Convert_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Transitive_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Constraints/Transitive_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Boxing/box_unbox01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToGen01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToGen02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToGen03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToNonGen01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToNonGen02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/GenToNonGen03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/NonGenToGen01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/NonGenToGen02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Conversions/Reference/NonGenToGen03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Coverage/chaos55915408cs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Coverage/chaos56200037cs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Coverage/chaos65204782cs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/general_class_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/general_class_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/general_struct_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/general_struct_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_class_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_class_instance02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_class_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_class_static02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_struct_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_struct_instance02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_struct_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Exceptions/specific_struct_static02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/instance_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Fields/static_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/BaseClass01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/BaseClass02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/BaseClass03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/Baseclass04.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/Baseclass05.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/class02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Classes/class03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Class02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Class03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Class04.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Class05.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Struct02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Struct03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Struct04.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Interfaces/Struct05.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Structs/struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Structs/struct02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Instantiation/Structs/struct03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/instance_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Locals/static_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/class_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/class_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/interface_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/interface_class02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/interface_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/interface_struct02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/struct_instance01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/MemberAccess/struct_static01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/instance_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_assignment_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_assignment_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_equalnull_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_equalnull_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_passing_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Parameters/static_passing_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/TypeParameters/default_class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/TypeParameters/default_struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/Struct02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/class01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/class02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/class03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/dynamicTypes.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/objectBoxing.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/refTypesdynamic.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/struct01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/struct03.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/Typeof/valueTypeBoxing.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcs2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsbas.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsbox.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsmax.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsmixed.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsval.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcsvalbox.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/gcarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/selfref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/i4/i4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/i4/i4flat.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/i8/i8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/i8/i8flat.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/r4/r4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/r4/r4flat.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/r8/r8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/AsgOp/r8/r8flat.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/misc/enum.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/misc/nestval.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/misc/tailjump.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Coverage/b433189.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/FPtrunc/convr4a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/FPtrunc/convr8a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param1a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param2a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param3a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally_tail.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/callvirt/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/ctor/val_ctor.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/deep/deep.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/obj.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/bool.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/byte.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/char.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/decimal.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/double.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/float.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/int.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/long.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/sbyte.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/short.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/uint.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/ulong.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/DataTypes/ushort.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/GaussJordan/classarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/GaussJordan/jaggedarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/GaussJordan/plainarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/GaussJordan/structarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/classarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/doublearr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/intarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/jaggedarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/stringarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/InnerProd/structarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/basics/classarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/basics/doublearr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/basics/jaggedarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/basics/stringarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/MDArray/basics/structarr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/arithm32.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/arithm64.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r4NaNadd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r4NaNdiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r4NaNmul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r4NaNrem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r4NaNsub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r8NaNadd.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r8NaNdiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r8NaNmul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r8NaNrem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/r8NaNsub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Overflow/FloatInfinitiesToInt.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Overflow/FloatOvfToInt2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/call.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumps.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/vtret.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/ctor_recurse.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/gc_nested.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/han2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/han3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/han3_ctor.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/han3_ref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/hanoi.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/knight.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/etc/nested.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/identity/accum.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/identity/vcall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/port/lcs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/port/lcs_gcref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/cast_throw.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/throw.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_call.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_ldarg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_ldloc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_newobj.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_call.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_ldarg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_ldloc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_newobj.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/iface/iface1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/ilseq/commonBase.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/precise1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/precise1b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/precise2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/precise4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/decimaldiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/i4div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/i8div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/negSignedMod.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/overlddiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/r4div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/r8div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/u4div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/div/u8div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/decimalrem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/i4rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/i8rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/overldrem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/r4rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/r8rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/u4rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/divrem/rem/u8rem.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/eh/interactions/ehSO.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/eh/interactions/volatileFromFinally.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_c.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_f4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_f8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_o.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_s.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit7.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/explicit8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_double.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_float.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_objref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_valref.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug614098/intToByte.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug619534/ehCodeMotion.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug619534/finallyclone.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug619534/twoEndFinallys.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug621705/ptuple_lost.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug647189/ssa_tuIsAddr.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug675304/arrayDim.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug675304/osrAddovershot.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679008/GCOverReporting.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679008/castClassEH.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679008/sealedCastVariance.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679008/singleRefField.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679008/zeroInitStackSlot.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug723489/qMarkColon.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/inlining/bug505642/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/arrays/lcs_long.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/arrays/lcs_ulong.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/misc/binop.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/misc/box.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_addsub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_div.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldfld_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldfld_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldsfld_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldsfld_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_muldiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/superlong/superlong.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/addsub.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldc_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldc_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldfld_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldfld_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldsfld_mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldsfld_mulovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/muldiv.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/classic.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/delegate.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/generics.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/generics2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/tailcall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/valuetype.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/array1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/array2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/format.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/gcreport.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/lcs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/native.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/virtcall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall_v4/delegateParamCallTarget.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/refanyval.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/unbox.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M09.5-PDC/b12008/b12008.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M11-Beta1/b40089/b40089.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M11-Beta1/b40138/b40138.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M11-Beta1/b45679/b45679.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M12-Beta2/b46847/b46847.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b11490/b11490.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b12399/b12399.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b12624/b12624.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b13569/b13569.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14716/b14716.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b15728/b15728.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16238/b16238.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16328/b16328.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16335/b16335.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16423/b16423.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b20913/b20913.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b22290/b22290.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b24727/b24727.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b24728/b24728.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25647/b25647.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26558/b26558.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26560/b26560.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26732/b26732.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26863/b26863.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27811/b27811.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27819/b27819.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27824/b27824.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28037/b28037.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28042/b28042.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28776/b28776.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28787/b28787.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28790/b28790.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30126/b30126.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30128/b30128.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30630/b30630.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31732/b31732.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31748/b31748.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31749/b31749.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31763/b31763.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31912/b31912.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32303/b32303.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32345/b32345.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32560/b32560.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32801/b32801.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b13170/b13170.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b13178/b13178.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b13647/b13647.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14057/b14057.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14059/b14059.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14277/b14277.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14314/b14314.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14367/b14367.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14396/b14396.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14422/b14422.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14428/b14428.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14443/b14443.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14616/b14616.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14624/b14624.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14640/b14640.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b14673/b14673.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15155/b15155.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15468/b15468.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15526/b15526.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15783/b15783.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15786/b15786.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15797/b15797.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b15864/b15864.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09/b16294/b16294.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b02051/b02051.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b02076/b02076.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05477/b05477.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06464/b06464.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06680/b06680.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06859/b06859.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06924/b06924.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08944/b08944a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08944/b08944b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b09287/b09287.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b09452/b09452.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b13330/b13330.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b13466/b13466.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b30586/b30586.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b31878/b31878.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b34945/b34945.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36274/b36274.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36332/b36332.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36470/b36470.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36471/b36471.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36472/b36472.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b37131/b37131.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b37598/b37598.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b37608/b37608.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b37636/b37636.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b38403/b38403.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b38556/b38556.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39217/b39217.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39224/b39224.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39951/b39951.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40141/b40141.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40216/b40216.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40221/b40221.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40496/b40496.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40521/b40521.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41063/b41063.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41234/b41234.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41391/b41391.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41470/b41470.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41488/b41488.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41495/b41495.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41621/b41621.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41918/b41918.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42009/b42009.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42013/b42013.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42918/b42918.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42929/b42929.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43010/b43010.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43313/b43313.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43719/b43719.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43958/b43958.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44193/b44193.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44297/b44297.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44410/b44410.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45015/b45015.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45259/b45259.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45270/b45270.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45458/b45458.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45535/b45535.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46170/b46170.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46629/b46629.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46641/b46641.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46649/b46649.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46867/b46867.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47047/b47047.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48248/b48248.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48797/b48797.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48805/b48805.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48864/b48864.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48872/b48872.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48990/b48990a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48990/b48990b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b49318/b49318.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b49322/b49322.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b49717/b49717.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31182/b31182.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31745/b31745.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31746/b31746.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31762/b31762.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31903/b31903.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31917/b31917.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37646/b37646.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b38269/b38269.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b41852/b41852.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b47975/b47975.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b48929/b48929.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b49809/b49809.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50042/b50042.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50145/b50145.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50145/b50145a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50145/b50145b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50145/b50145c.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50535/b50535.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51463/b51463.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51469/b51469.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51565/b51565.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51870/b51870.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52572/b52572.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52578/b52578.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52746/b52746.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52760/b52760.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52838/b52838.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b52839/b52839.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54667/b54667.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b55197/b55197.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56149/b56149.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56154/b56154.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56159/b56159.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59297/b59297.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b60723/b60723.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61028/b61028.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61515/b61515.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61640/b61640.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b62498/b62498.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b62555/b62555.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b62892/b62892.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63183/b63183.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b68361/b68361.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b68634/b68634.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71099/b71099.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71120/b71120.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71135/b71135.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71155/b71155.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71231/b71231.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72136/b72136.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72996/b72996.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b73921/b73921.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b74182/b74182.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75250/b75250.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75509/b75509.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b76590/b76590.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b77707/b77707.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b77713/b77713.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b78392/b78392.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b79418/b79418.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b80045/b80045.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b82866/b82866.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b83690/b83690.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b84836/b84836.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b91377/b91377.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b87284/b87284.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b88712/b88712.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b88793/b88793.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b88797/b88797.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89277/b89277.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89279/b89279.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89506/b89506.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89600/b89600.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89946/b89946.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91189/b91189.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91230/b91230.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91248/b91248.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91855/b91855.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91859/b91859.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91867/b91867.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91917/b91917.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b92568/b92568.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b92614/b92614.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b92693/b92693.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b93027/b93027.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M14-SP1/b119538/b119538a.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M14-SP1/b119538/b119538b.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b148815/testclass.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.1-M1-Beta1/b119294/b119294.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.1-M1-Beta1/b130333/byteshift.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.1-M1-Beta1/b140711/b140711.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b102879/dblinf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b124232/genisinst.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b169333/b169333.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b178119/hugemthfrm.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b178128/hugestruct.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b180381/constrained1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b191926/ParamLimit.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b219940/struct01_gen.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b00735/b00735.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b02345/b02345.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b07211/byteshift.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b07900/rpPasses.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b08020/bbHndIndex.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b11762/b11762.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b16386/gtnop.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b16399/gtIsValid64RsltMul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b19171/jmp2blk.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b30251/b578931.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b102533/DeadBlock.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b320147/1086745236.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b321799/repro.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b338014/vsw338014.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b405223/b405223.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b416667/b416667.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b369916/b369916.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/dev10/b392262/b392262.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/dev10/b400791/b400971.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/dev10/b402658/b402658.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/dev11/DevDiv_376412/DevDiv_376412.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b121938/ConstToString.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b151497/NullCheckBoxedValuetypeReturn.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b158861/b158861.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b163200/b163200.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b170362/b170362.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b33183/b33183.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b49778/b49778.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b106272/b106272.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b152292/b152292.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b565808/b565808.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b589202/b589202.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b598034/b598034.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b598649/b598649.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b602004/Inline_Vars2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b608066/b608066.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b608198/b608198.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b609280/b609280.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b610562/b610562.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b610750/32vs64.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b610750/b610750.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b611219/b611219.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b72218/b72218.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_457559/Dev11_457559.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_5437/Dev11_5437.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_617302/Dev11_617302.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_646049/Dev11_646049.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/DevDiv2_10623/DevDiv2_10623.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/DevDiv2_8863/DevDiv2_8863.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/dev10_94677/loopvt.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/dev11_13912/dev11_13912.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/dev11_165544/seqpts.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev14/DevDiv_876169/DevDiv_876169.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/DevDiv_794115/DevDiv_794115.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/DevDiv_794631/DevDiv_794631.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/DevDiv_815940/DevDiv_815940.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/DevDiv_816617/DevDiv_816617.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/GitHub_1296/GitHub_1296.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/JitBlue/GitHub_1323/GitHub_1323.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b100336/emptytryfinally.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b103846/d.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b111130/makework.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b115253/hello2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b119026/bug.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b119026/charbug.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b140298/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b141358/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b99219/b99219.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b102615/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b102860/structret1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b102887/struct5_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b124409/ericcprop3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b91074/pack8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b10789/switch.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b10790/locals10K.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b10827/MT_DEATH.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b19112/divbyte.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b19112/divshort.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b102729/b102729.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b102763/gcparamonstack.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b102886/ovf.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b19394/stringArray114.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b21015/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b26496/_1d6bgof.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b27978/gcparaminreg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b27980/struct1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b28077/struct5_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b28141/structret1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b29343/test.hfa12.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b184799/b184799.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b302558/_aopst1l.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b309539/_ba6c0ou.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b309548/_hngh669.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b311420/b311420.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b360587/repro.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-RTM/b539509/b539509.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/clr-x64-JIT/v4.0/DevDiv34372/overRepLocalOpt.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/148343.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/9_and_alloca2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/9param.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/eh1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/fgtest1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/fgtest2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/funclet.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/gcparaminreg.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/ret_struct_test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/ret_struct_test4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/simple1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct1_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct1_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct1_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct2_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct2_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct2_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct2_5_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct3_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct3_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct3_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct4_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct4_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct4_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct5_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct5_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct5_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct6_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct6_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct6_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct7_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct8.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct9.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/struct9_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_5.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp1_6.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp2_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp2_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp2_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp2_4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp3_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp4_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp5_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfp6_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfpseh5_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structfpseh6_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structref1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret1_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret1_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret2_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret2_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret2_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret3_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret3_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret3_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret4_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret4_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret4_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret5_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret5_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret5_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret6_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret6_2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structret6_3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/structva1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/test2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/test3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/test_noalloca.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/misc/vbil.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/regress/vswhidbey/143837.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/gc/regress/vswhidbey/339415.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/CGRecurse/CGRecurseAAA.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/CGRecurse/CGRecurseAAC.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/CGRecurse/CGRecurseACA.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/CGRecurse/CGRecurseACC.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/cgstress/CgStress1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/cgstress/CgStress2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/cgstress/CgStress3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/HugeArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/HugeArray1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/HugeField2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/arrayexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/arrayexpr2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/fieldExprUnchecked1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/fieldexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/fieldexpr1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/fieldexpr2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/hugeSimpleExpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/hugeexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/mixedexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/pointerexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/pointerexpr1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/simpleexpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/simpleexpr1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/simpleexpr2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/simpleexpr3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/simpleexpr4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/staticFieldExpr1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/staticFieldExpr1_1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/staticFieldExprUnchecked1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/volatilefield.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/volatilestaticfield.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/inl/caninline.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/lim/lim_002.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/lur/lur_02.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/osr/osr001.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/ArrayBound.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/ArrayWith2Loops.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/ArrayWithFunc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/BadMatrixMul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/JaggedArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/MatrixMul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/RngchkStress1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/RngchkStress2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/RngchkStress3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/rngchk/SimpleArray_01.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/asurt/143616/foo.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ddb/103087/103087.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ddb/113574/113574.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ddb/132977/132977.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ndpw/160545/simple.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ndpw/21015/interior_pointer.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/102964/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/329169/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/373472/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/471729/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/517867/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/524070/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/524070/test2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/528315/simple-repro.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/538615/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/539509/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/541067/test1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/543229/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/549880/test.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/601425/stret.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/610378/BigFrame.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/ArrayOfStructs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/DelegInstanceFtn.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/DelegStaticFtn.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/GenericStructs.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/InlineThrow.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_DelegateStruct.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_GenericMethods.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_Handler.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_MultipleReturn.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_NewObj.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_NormalizeStack.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_RecursiveMethod.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_RecursiveMethod21.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_STARG.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_SideAffects.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Inline_Vars.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/ReturnStruct_Method.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/StructAsParam_Method.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/StructInClass.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/Struct_Opcodes.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/args1.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/args2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/args3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/array.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/debug.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/deepcall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/ifelse.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/indexer.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/inline.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/inline_Many.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/inline_Recursion.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/interfaceCall.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/interfaceProperty.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/mathfunc.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/mthdimpl.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/property.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/size.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/throwTest.cs	\
	$(CORECLR_PATH)/tests/src/JIT/opt/Inline/trycatch.cs	\
	$(CORECLR_PATH)/tests/src/Loader/regressions/classloader/main.cs	\
	$(CORECLR_PATH)/tests/src/Loader/regressions/classloader/vsw307137.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/AboveStackLimit.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/ArrayCopy.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/CompEx.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/DisableTransparencyEnforcement.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/Marshal.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/ThreadCulture.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/ToLower.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/avtest.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/date.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/interlock.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/pow3.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/test1307.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/testClass.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/testInterface.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/common/unsafe.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0014/avtest.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0028/thread08-simplified.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0044/nullable.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0046/istype.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0069/date.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0075/largearraytest.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0077/interlock.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0080/delete_next_card_table.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0099/abovestacklimit.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0138/pow3.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0198/compex.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0202/threadculture.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0211/genrecur.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0275/marshal.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0308/tolower.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0342/unsafe.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0416/hello.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0487/test.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0570/test570.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0576/test0576.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0582/csgen.1.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0583/test583.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0792/test0792.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0828/test0828.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0829/test0829.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0857/override.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0939/test0939.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0968/test968.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1307/test1307.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1333/testclass.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1333/testinterface.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1337/test1337.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1386/co1727ctor_oo.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1402/test1402.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1514/interlockexchange.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1534/test1534.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1535/test1535.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1549/test1549.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/72162/test72162.cs	\
	$(CORECLR_PATH)/tests/src/Threading/ThreadStatics/ThreadStatic01.cs	\
	$(CORECLR_PATH)/tests/src/Threading/ThreadStatics/ThreadStatic02.cs	\
	$(CORECLR_PATH)/tests/src/Threading/ThreadStatics/ThreadStatic03.cs	\
	$(CORECLR_PATH)/tests/src/Threading/ThreadStatics/ThreadStatic05.cs	\
	$(CORECLR_PATH)/tests/src/Threading/ThreadStatics/ThreadStatic06.cs \
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/dev10_535767.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/test448035.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/genericexceptions08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch09.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/nested-try-catch10.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally-struct01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally-struct02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally-struct03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-finally03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch-struct09.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-catch09.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally-struct01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally-struct02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally-struct03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-finally03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter001.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter002.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter003.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter004.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter005.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter006.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter007.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter008.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter009.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter010.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter011.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter012.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter013.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter014.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter015.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter016.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter017.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/typeparameter018.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeybeta2/349379/349379.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeybeta2/366085/366085.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeym3.3/106011/106011.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/simple/finally.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/returnfromcatch.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/functional/threadpool/cs_threadpoolnullchecks/cs_threadpoolnullchecks.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/currentculture/culturechangesecurity.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread09.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread10.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread11.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread12.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread13.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread14.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread15.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread16.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread17.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread18.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread19.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread20.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread21.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread22.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread23.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread24.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread25.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread26.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread27.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread28.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread29.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/syncdelegate/thread30.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread04.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread06.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread07.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread08.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread09.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread10.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread11.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread12.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread13.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread14.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread15.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread16.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread17.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread18.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread19.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread20.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread21.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread22.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread23.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread24.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread25.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread26.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread27.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread28.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread29.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/generics/threadstart/thread30.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/exchange/exchangeint.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/exchange/exchangelong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/exchange/exchangetclass.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/exchange/exchangetstring.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/enter/enternull.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/exit/exitnull.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/pulse/pulsenull.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/pulseall/pulseallnull.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/unownedlock/enterexitexit.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/unownedlock/noenterobject.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/unownedlock/noenterobjectnew.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/monitor/unownedlock/noentervaltype.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/readerwriterlockslim/singlereleasewriteddbug71632.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/readerwriterlockslim/tryenterfailureddbugs124485.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/readerwriterlockslim/upgrader.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/regressions/576463/576463.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/regressions/6906/repro.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic01.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic02.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic03.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic05.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic06.cs	\
	$(CORECLR_PATH)/tests/src/hosting/coreclr/activation/sxshost/usercode.cs	\
	$(CORECLR_PATH)/tests/src/hosting/stress/testset1/csgen.1.cs	\
	$(CORECLR_PATH)/tests/src/hosting/stress/testset1/csgen.2.cs	\
	$(CORECLR_PATH)/tests/src/hosting/stress/testset1/simple1.cs	\
	$(CORECLR_PATH)/tests/src/managed/Compilation/HelloWorld.cs	\
	$(CORECLR_PATH)/tests/src/reflection/regression/dev10bugs/dev10_629953.cs	\
	$(CORECLR_PATH)/tests/src/reflection/regression/dev10bugs/dev10_630880.cs

CORECLR_COREMANGLIB_TEST_CS_SRC=		\
	$(CORECLR_PATH)/tests/src/CoreMangLib/components/stopwatch/co9600ctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/components/stopwatch/co9604get_isrunning.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/action/actionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/activator/activatorcreateinstance2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentexception/argumentexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentexception/argumentexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentnullexception/argumentnullexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentnullexception/argumentnullexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentoutofrangeexception/argumentoutofrangeexceptionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentoutofrangeexception/argumentoutofrangeexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/argumentoutofrangeexception/argumentoutofrangeexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/arithmeticexception/arithmeticexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch3b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch4b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch5b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraybinarysearch6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycopy1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycopy2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycreateinstance1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycreateinstance1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycreateinstance2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraycreateinstance2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetlength.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetlowerbound.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetupperbound.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetvalue1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetvalue2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraygetvalue2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayicollectionget_count.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistcontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistget_item.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistindexof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistinsert.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistremoveat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayilistset_item.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof3b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayindexof4b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayinitialize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof3b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylastindexof4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraylength.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayrank.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayreserse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayreserse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayreverse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arrayreverse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysetvalue1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysetvalue1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysetvalue2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysetvalue2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort3b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/array/arraysort9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/arraytypemismatchexception/arraytypemismatchexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/arraytypemismatchexception/arraytypemismatchexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/arraytypemismatchexception/arraytypemismatchexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attribute/ddb125472_gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attribute/gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsall.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsconstructor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsdelegate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsevent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsfield.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsgenericparameter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsinterface.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsmethod.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsmodule.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsparameter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsproperty.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsreturnvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributetargets/attributetargetsstruct.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributeusageattribute/attributeusageattributeallowmultiple.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/attributeusageattribute/attributeusageattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/badimageformatexception/badimageformatexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/badimageformatexception/badimageformatexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/badimageformatexception/badimageformatexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/badimageformatexception/badimageformatexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/badimageformatexception/badimageformatexceptiontostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleancompareto_boolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleanequals_boolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleanequals_object.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleanfalsestring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleangethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleaniconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleanparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleantostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleantruestring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/boolean/booleantryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteiconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytemaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteparse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/byteparse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytetostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytetostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytetostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytetostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/byte/bytetryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charcompateto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chargethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariscontrol1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariscontrol2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisdigit1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisdigit2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisletter1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisletter2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisletterordigit1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisletterordigit2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charislower1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charislower2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisnumber1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisnumber2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charispunctuation2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisseparator1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisseparator2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charissurrogate1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charissurrogate2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charissurrogatepair1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charissurrogatepair2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charissymbol1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisupper1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charisupper2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariswhitespace1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chariswhitespace2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charmaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/charminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chartolower1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chartostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chartostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chartoupper1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/char/chartryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/charenumerator/charenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/charenumerator/charenumeratorienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/charenumerator/charenumeratorienumgetcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/charenumerator/charenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/charenumerator/charenumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/clscompliantattribute/clscompliantattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/clscompliantattribute/clscompliantattributeiscompliant.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/dictionaryentry/dictionaryentryctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/dictionaryentry/dictionaryentrykey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/dictionaryentry/dictionaryentryvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/comparer/comparercompare1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/comparer/comparercompare2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/comparer/comparerctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/comparer/comparerdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarycomparer.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarycontainskey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarycontainsvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarycount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryctor6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarygetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectioncontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectioncopyto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionisreadonly2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionissynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionissynchronized2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionsyncroot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryicollectionsyncroot2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarycontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarygetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryisfixedsize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryisfixedsize2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryisreadonly2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryitem2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarykeys.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarykeys2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarykeys3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionarykeys4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryvalue2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryvalue3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryvalue4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryidictionaryvalues.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryienumerablegetenumerator2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionaryremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionary/dictionarytrygetvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratoridictionaryenumeratorget_entry.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratoridictionaryenumeratorget_key.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratoridictionaryenumeratorget_value.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratorienumeratorget_current.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratorienumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryenumerator/dictionaryenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/keycollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/keycollectioncount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/keycollectionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/keycollectiongetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericicollectionadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericicollectionclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericicollectioncontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericicollectionisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericicollectionremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsgenericienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsicollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsicollectionissynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsicollectionsyncroot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionarykeycollection/systemcollectionsienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/dictionaryvaluecollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/dictionaryvaluecollectioncount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/dictionaryvaluecollectionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/dictionaryvaluecollectiongetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/systemcollectionsicollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/systemcollectionsicollectionissynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/systemcollectionsicollectionsyncroot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericicollectionadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericicollectionclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericicollectioncontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericicollectionisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericicollectionremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectiongenericienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictionaryvaluecollection/valuecollectionienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionarykeycollectionenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionarykeycollectionenumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionarykeycollectionenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionaryvaluecollectionenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionaryvaluecollectionenumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/dictionaryvaluecollectionenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/keycollectionenumeratorienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/keycollectionenumeratorienumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/valuecollectionenumeratorienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictkeycollenum/valuecollectionenumeratorienumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictvalcollenum/dictionaryvaluecollectionenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictvalcollenum/dictionaryvaluecollectionenumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictvalcollenum/dictionaryvaluecollectionenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictvalcollenum/valuecollectionenumeratorienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/dictvalcollenum/valuecollectionenumeratorienumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/equalitycomparer/equalitycomparerequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/equalitycomparer/equalitycomparergethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/equalitycomparer/equlitycomparerdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectionadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectionclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectioncontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectioncount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectionisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/icollection/icollectionremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/idictionary/idictionarycontainskey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/idictionary/idictionaryitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/idictionary/idictionarykeys.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/idictionary/idictionarytrygetvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/idictionary/idictionaryvalues.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ienumerable/ienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ienumerator/ienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/iequalitycomparer/iequalitycomparerequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/iequalitycomparer/iequalitycomparergethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ilist/ilistindexof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ilist/ilistinsert.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ilist/ilistitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/ilist/ilistremoveat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keynotfoundexception/keynotfoundexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keynotfoundexception/keynotfoundexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keyvaluepair/keyvaluepairctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keyvaluepair/keyvaluepairkey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keyvaluepair/keyvaluepairtostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/keyvaluepair/keyvaluepairvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/binarysearch1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/binarysearch2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/binarysearch3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/copyto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/copyto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/copyto3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listaddrange.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listcapacity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listcontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listforeach.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listgetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listgetrange.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listicollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listicollectionisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listicollectionissynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listicollectionsyncroot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listienumerablegetenumerator2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistcontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistindexof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistinsert.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistisfixedsize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listilistremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listindexof1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listindexof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listindexof3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listinsertrange.cs.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listlastindexof1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listlastindexof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listlastindexof3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listremoveat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listremoverange.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listreverse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listreverse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listtoarray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/list/listtrimexcess.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queueclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuecontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuecopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuecount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuector2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuector3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuedequeue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queueenqueue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuepeek.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queue/queuetoarray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queueenumerator/enumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queueenumerator/enumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/queueenumerator/enumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackcontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackcopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackgetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackpeek.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackpop.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stackpush.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stack/stacktoarray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stackenumerator/stackenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stackenumerator/stackenumeratordispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/generic/stackenumerator/stackenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/icollection/icollectioncopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/icollection/icollectioncount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/icollection/icollectionissynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/icollection/icollectionsyncroot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/icomparer/icomparercompare.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionaryadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionaryclear.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionarycontains.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionarygetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionaryisfixedsize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionaryisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/idictionary/idictionaryremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/ienumerator/ienumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/ienumerator/ienumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/ienumerator/ienumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/ilist/ilistisfixedsize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/collections/ilist/ilistitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/comparison/comparisoninvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/console/consoleseterror.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/console/consolesetout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/convertchangetype2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/convertfrombase64chararray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/convertfrombase64string.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobase64chararray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobase64string1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobase64string2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoboolean8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttobyte8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttochar9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodecimal9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttodouble9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint16_9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint32_9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttoint64_9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosbyte9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttosingle17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring19.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring20.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring21.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring22.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring23.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring24.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring25.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring26.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring27.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring28.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring29.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring30.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring31.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring33.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttostring9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint161.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1610.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1611.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1612.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1613.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1614.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1615.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1616.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1617.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint1618.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint162.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint163.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint164.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint165.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint166.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint167.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint168.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint169.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint321.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3210.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3211.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3212.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3213.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3215.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3216.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3217.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3218.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint3219.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint322.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint323.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint324.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint325.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint326.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint327.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint328.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint329.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint641.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6410.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6411.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6412.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6413.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6414.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6415.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6416.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6417.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint6418.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint642.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint643.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint644.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint645.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint646.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint647.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint648.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/convert/converttouint649.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimecompare.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimecompareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimector3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimector4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimector6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimector7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimedate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimehour.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimemaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimemillisecond.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeminute.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimenow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparseexact1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparseexact2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeparseexact3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimesecond.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimespecifykind.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimesubtract1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimesubtract2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeticks.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetimeofday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetoday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetofiletime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetofiletimeutc.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetolocaltime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimetostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeutcnow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetimekind/datetimekindlocal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetimekind/datetimekindunspecified.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetimekind/datetimekindutc.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweekfriday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweekmonday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweeksaturday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweeksunday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweekthursday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweektuesday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dayofweek/dayofweekwednesday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimafloor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaladd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalcompare.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalctor8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaldivide.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalequals3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalgetbits.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalmaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalminusone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalmultiply.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalnegate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalparse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalparse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalparse4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalremainder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalsubtract.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltobyte1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltruncate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimaltryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/decimal/decimalzero.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegatecombine1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegatecombineimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegateequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegategethashcode1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegategetinvocationlist1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegateremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/delegateremoveimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/conditionalattribute/conditionalattributeconditionstring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/conditionalattribute/conditionalattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/debuggingmodes/debuggingmodesdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/debuggingmodes/debuggingmodesdisableoptimizations.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/debuggingmodes/debuggingmodesenableeditandcontinue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/debuggingmodes/debuggingmodesignoresymbolstoresequencepoints.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/diagnostics/debuggingmodes/debuggingmodesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dividebyzeroexception/dividebyzeroexceptionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dividebyzeroexception/dividebyzeroexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dividebyzeroexception/dividebyzeroexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dllnotfoundexception/dllnotfoundexception1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dllnotfoundexception/dllnotfoundexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/dllnotfoundexception/dllnotfoundexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublecompareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleepsilon.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleiconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleisinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleisnan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleisnegativeinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleispositiveinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublemaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublenan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublenegativeinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubleparse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doublepositiveinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubletostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubletostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubletostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubletostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/double/doubletryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumiconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumisdefined.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumtoobjectb.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumtostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/enum/enumtostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/environment/environmentnewline.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/environment/environmentprocessorcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/environment/environmentprocessorcount_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventargs/eventargsctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventhandler/eventhandlerinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventhandler_generic/eventhandlerctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventhandler_generic/eventhandlerinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/exception/exceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/exception/exceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/exception/exceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/exception/exceptiongetbaseexception.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/flagsattribute/flagsattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/formatexception/formatexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/formatexception/formatexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/formatexception/formatexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gccollect.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gcgettotalmemory.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gckeepalive.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gcmaxgeneration.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gcsuppressfinalize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gcwaitforpendingfinalizers.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/calendarweekrule/calendarweekrulefirstday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/calendarweekrule/calendarweekrulefirstfourdayweek.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/calendarweekrule/calendarweekrulefirstfullweek.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/charunicodeinfo/charunicodeinfogetnumericvalue1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/charunicodeinfo/charunicodeinfogetnumericvalue2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/charunicodeinfo/charunicodeinfogetunicodecategory1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/charunicodeinfo/charunicodeinfogetunicodecategory2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfocompare2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfoindexof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsignorecase.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsignorekanatype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsignorenonspace.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsignoresymbols.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsignorewidth.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsordinal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsordinaligorecase.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareoptions/compareoptionsstringsort.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfocompareinfo.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoconstructor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoenglishname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfogetcultureinfo2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfogethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoinvariantculture.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoisneutralculture.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfonativename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfoparent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinforeadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfotextinfo.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfotostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/cultureinfo/cultureinfotwoletterisolanguagename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfoclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfocurrentinfo.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetabbreviateddayname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetabbreviatedmonthname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetdayname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetformat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetinstance.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfogetmonthname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfoinvariantinfo.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfoisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinforeadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinforfc1123pattern.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfosortabledatetimepattern.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimeformatinfo/datetimeformatinfouniversalsortabledatetimepattern.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestyleallowinnerwhite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesadjusttouniversal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesallowleadingwhite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesallowtrailingwhite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesallowwhitespaces.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesassumelocal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesassumeuniversal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesnocurrentdatedefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/datetimestyles/datetimestylesroundtripkind.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfoclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfoctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfocurrencydecimalseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfocurrencygroupseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfogetformat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinfogetinstance.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberformatinfo/numberformatinforeadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowcurrencysymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowdecimalpoint.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowexponent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowhexspecifier.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowleadingsign.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowleadingwhite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowparentheses.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowthousands.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowtrailingsign.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesallowtrailingwhite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesany.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylescurrency.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesfloat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstyleshexnumber.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesinteger.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/numberstyles/numberstylesnumber.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfocurrencysymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfoequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfogethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfoismetric.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfoisocurrencysymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfoname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfotostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfotwoletterisoregionname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfoctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfoctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfoequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfogethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfogetnexttextelement2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfogettextelementenumerator1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfogettextelementenumerator2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfolengthintextelements.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfoparsecombiningcharacters.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/stringinfo/stringinfostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textelementenumerator/textelementenumeratorcurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textelementenumerator/textelementenumeratorelementindex.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textelementenumerator/textelementenumeratorgettextelement.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textelementenumerator/textelementenumeratormovenext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textelementenumerator/textelementenumeratorreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfoculturename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfoequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfogethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfoisreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfotostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfotoupper1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/textinfo/textinfotoupper2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryclosepunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryconnectorpunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorycontrol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorydashpunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorydecimaldigitnumber.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryenclosingmark.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryfinalquotepunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryformat.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryinitialquotepunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryletternumber.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorylineseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorylowercaseletter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorymathsymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorymodifierletter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorymodifiersymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorynonspacingmark.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryopenpunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryotherletter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryothernotassigned.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryothernumber.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryotherpunctuation.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryothersymbol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryparagraphseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryprivateuse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryspaceseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryspacingcombiningmark.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorysurrogate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategorytitlecaseletter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/unicodecategory/unicodecategoryuppercaseletter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidcompareto1_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidcompareto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidctor1_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidctor2_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidctor3_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidempty.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidequals1_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidequals2_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidequals3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidgethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidnewguid.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidtobytearray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/guid/guidtostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/icomparable/icomparablecompareto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/icomparable_generic/icomparable_genericcompareto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iconvertible/iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/idisposable/idisposabledispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/iformatable/iformatabletostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/indexoutofrangeexception/indexoutofrangeexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/indexoutofrangeexception/indexoutofrangeexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/indexoutofrangeexception/indexoutofrangeexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32compareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32equals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32equals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32maxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32minvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32parse4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32tostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32tostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32tostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int/int32tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16equals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16equals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16maxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16minvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16tostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int16/int16tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64compareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64equals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64equals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64maxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64minvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64tostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64tostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/int64/int64tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrctor_int32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrctor_int64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrctor_void.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrgethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrtoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrtoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrtopointer.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrtostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/intptr/intptrzero.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidcastexception/invalidcastexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidcastexception/invalidcastexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidcastexception/invalidcastexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidoperationexception/invalidoperationexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidoperationexception/invalidoperationexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidoperationexception/invalidoperationexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidprogramexception/invalidprogramexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidprogramexception/invalidprogramexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/invalidprogramexception/invalidprogramexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/binarywriter/binarywriteroutstream.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/directorynotfoundexception/directorynotfoundexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/directorynotfoundexception/directorynotfoundexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/endofstreamexception/endofstreamexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/endofstreamexception/endofstreamexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileaccess/fileaccessenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileaccess/fileaccessread.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileaccess/fileaccessreadwrite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileaccess/fileaccesswrite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesarchive.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributescompressed.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesdeivce.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesdirectory.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesencrypted.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributeshidden.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesnormal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesnotcontentindexed.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesoffline.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributesreparsepoint.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributessystem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileattributes/fileattributestemporary.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodeappend.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodecreate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodecreatenew.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodeenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodeopen.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodeopenorcreate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filemode/filemodetruncate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptionctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptiongetmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filenotfoundexception/filenotfoundexceptiontostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileshare/fileshareenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileshare/filesharenone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileshare/fileshareread.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileshare/filesharereadwrite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/fileshare/filesharewrite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/ioexception/ioexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/ioexception/ioexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/memorystream/memorystreamctor7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathaltdirectoryseparatorchar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathchangeextension.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathcombine.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathdirectoryseparatorchar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetdirectoryname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetextension.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetfilename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetfilenamewithoutextension.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetfullpath_extended.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathgetinvalidpathchars.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathhasextension.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathispathrooted.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathpathseparator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/path/pathvolumeseparatorchar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/pathtoolongexception/pathtoolongexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/pathtoolongexception/pathtoolongexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/seekorigin/seekoriginbegin.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/seekorigin/seekorigincurrent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/seekorigin/seekoriginend.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/seekorigin/seekoriginenum.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stream/streamdispose1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stream/streamdispose2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stream/streamnull.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stream/streamreadtimeout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stream/streamwritetimeout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/streamreader/streamreadernull.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/stringwriter/stringwriterencoding.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/textreader/textreadernull.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/textwriter/textwriternull.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathabs7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathceiling.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathcos.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathe.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathexp.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathfloor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathieeeremainder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathlog10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmax9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathmin9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathpi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathpow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathround1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathround2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathround3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathround4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsign7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsin.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsqrt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/memberaccessexception/memberaccessexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/memberaccessexception/memberaccessexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/memberaccessexception/memberaccessexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/methodaccessexception/methodaccessexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/methodaccessexception/methodaccessexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/methodaccessexception/methodaccessexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingfieldexception/missingfieldexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingfieldexception/missingfieldexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingfieldexception/missingfieldexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingfieldexception/missingfieldexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmemberexception/missingmemberexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmemberexception/missingmemberexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmemberexception/missingmemberexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmemberexception/missingmemberexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmethodexception/missingmethodexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmethodexception/missingmethodexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmethodexception/missingmethodexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/missingmethodexception/missingmethodexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notimplementedexception/notimplementedexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notimplementedexception/notimplementedexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notimplementedexception/notimplementedexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notsupportedexception/notsupportedexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notsupportedexception/notsupportedexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/notsupportedexception/notsupportedexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablecompare.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullableequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullableequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablegetunderlyingtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablegetvalueordefault1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablegetvalueordefault2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablehasvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullabletostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullable/nullablevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/nullreferenceexception/nullreferenceexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectfinalize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectgethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectmemberwiseclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objectreferenceequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/object/objecttostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/objectdisposedexception/objectdisposedexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/objectdisposedexception/objectdisposedexceptionobjectname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/obsoleteattribute/obsoleteattributector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/obsoleteattribute/obsoleteattributector2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/obsoleteattribute/obsoleteattributector3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/obsoleteattribute/obsoleteattributeiserror.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/obsoleteattribute/obsoleteattributemessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/outofmemoryexception/outofmemoryexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/outofmemoryexception/outofmemoryexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/outofmemoryexception/outofmemoryexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/overflowexception/overflowexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/overflowexception/overflowexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/overflowexception/overflowexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/paramarrayattribute/paramarrayattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/platformnotsupportedexception/platformnotsupportedexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/platformnotsupportedexception/platformnotsupportedexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/platformnotsupportedexception/platformnotsupportedexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/predicate/predicateinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomnext1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomnext2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomnext3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomnextbytes.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomnextdouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/random/randomsample.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/rankexception/rankexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/rankexception/rankexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/rankexception/rankexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/ambiguousmatchexception/ambiguousmatchexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/ambiguousmatchexception/ambiguousmatchexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/ambiguousmatchexception/ambiguousmatchexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyconfigurationattribute/assemblyconfigurationattributeconfiguration.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyconfigurationattribute/assemblyconfigurationattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydefaultaliasattribute/assemblydefaultaliasattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydefaultaliasattribute/assemblydefaultaliasattributedefaultalias.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydelaysignattribute/assemblydelaysignattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydelaysignattribute/assemblydelaysignattributedelaysign.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydescriptionattribute/assemblydescriptionattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblydescriptionattribute/assemblydescriptionattributedescription.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblykeyfileattribute/assemblykeyfileattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblykeyfileattribute/assemblykeyfileattributekeyfile.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblykeynameattribute/assemblykeynameattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblykeynameattribute/assemblykeynameattributekeyname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyname/assemblynamegetpublickey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyname/assemblynamegetpublickeytoken.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyname/assemblynamesetpublickey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyname/assemblynamesetpublickeytoken.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblyname/assemblynameversion.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblynameflags/assemblynameflagsenablejitcompileoptimizer.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblynameflags/assemblynameflagsenablejitcompiletracking.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblynameflags/assemblynameflagsnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblynameflags/assemblynameflagspublickey.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblynameflags/assemblynameflagsretargetable.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblytitleattribute/assemblytitleattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assemblytitleattribute/assemblytitleattributetitle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/callingconventions/callingconventionsany.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/callingconventions/callingconventionsexplicitthis.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/callingconventions/callingconventionshasthis.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/callingconventions/callingconventionsstandard.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/callingconventions/callingconventionsvarargs.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/constructorinfo/constructorinfoconstructorname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/constructorinfo/constructorinfotypeconstructorname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/defaultmemberattribute/defaultmemberattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/defaultmemberattribute/defaultmemberattributemembername.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolbranch.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolcall.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolcond_branch.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolmeta.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolnext.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolreturn.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/flowcontrol/flowcontrolthrow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeflowcontrol.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeopcodetype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeoperandtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesadd_ovf.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesadd_ovf_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesand.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesarglist.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbeq.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbeq_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbge.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbge_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbge_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbge_un_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbgt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbgt_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbgt_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbgt_un_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesble_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesble_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesble_un_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesblt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesblt_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesblt_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesblt_un_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbne_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbne_un_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbox.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbr.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbr_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbreak.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbrfalse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbrfalse_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbrtrue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesbrtrue_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescall.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescalli.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescallvirt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescastclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesceq.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescgt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescgt_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesckfinite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesclt.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesclt_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconstrained.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i1_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i2_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i4_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i8_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_i_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u1_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u2_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u4_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u8_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_ovf_u_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_r_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_u.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_u1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_u2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_u4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesconv_u8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescpblk.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodescpobj.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesdiv.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesdiv_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesdup.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesendfilter.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesendfinally.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesinitblk.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesinitobj.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesisinst.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesjmp.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg_0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarg_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarga.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldarga_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_m1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i4_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldc_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_ref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_u1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_u2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelem_u4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldelema.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldfld.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldflda.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldftn.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_ref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_u1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_u2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldind_u4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldlen.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc_0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloc_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloca.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldloca_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldnull.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldobj.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldsfld.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldsflda.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldstr.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldtoken.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesldvirtftn.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesleave.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesleave_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodeslocalloc.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesmkrefany.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesmul.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesmul_ovf.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesmul_ovf_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesneg.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesnewarr.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesnewobj.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesnop.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesnot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodespop.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefix7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesprefixref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesreadonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesrefanytype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesrefanyval.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesrem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesrem_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesret.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesrethrow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesshl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesshr.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesshr_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodessizeof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstarg.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstarg_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstelem_ref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstfld.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_i.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_i1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_i2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_i4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_i8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_r4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_r8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstind_ref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc_0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc_1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc_2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc_3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstloc_s.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstobj.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesstsfld.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodessub.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodessub_ovf.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodessub_ovf_un.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesswitch.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodestackbehaviourpop.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodestackbehaviourpush.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodestailcall.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodestakessinglebyteargument.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesthrow.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesunaligned.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesunbox.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesunbox_any.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesvolatile.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodesxor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodetostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodes/opcodevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodetype/opcodetypemacro.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodetype/opcodetypenternal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodetype/opcodetypeobjmodel.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodetype/opcodetypeprefix.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/opcodetype/opcodetypeprimitive.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinebrtarget.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinefield.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinei.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinei8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinemethod.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinenone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinliner.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinesig.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinestring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlineswitch.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinetok.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinetype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeinlinevar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeshortinlinebrtarget.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeshortinlinei.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeshortinliner.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/operandtype/operandtypeshortinlinevar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsize16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsize2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsize4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizesize1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizesize128.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizesize32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizesize64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizesize8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/packingsize/packingsizeunspecified.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpop0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpop1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpop1_pop1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_pop1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_popi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_popi8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_popi_popi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_popr4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopi_popr8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_pop1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_pop1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_popi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_popi8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_popr4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_popr8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpopref_popi_popref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpush0.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpush1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpush1_push1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpushi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpushi8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpushr4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpushr8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourpushref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourvarpop.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/emit/stackbehaviour/stackbehaviourvarpush.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/eventattributes/eventattributesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/eventattributes/eventattributesrtspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/eventattributes/eventattributesspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesfamandassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesfamily.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesfamorassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesfieldaccessmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributeshasdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributeshasfieldrva.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesinitonly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesliteral.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesnotserialized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributespinvokeimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesprivate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesprivatescope.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributespublic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesrtspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/fieldattributes/fieldattributesstatic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesabstract.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesfamandassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesfamily.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesfamorassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesfinal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributeshassecurity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributeshidebysig.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesmemberaccessmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesnewslot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributespinvokeimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesprivate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesprivatescope.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributespublic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesrequiresecobject.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesreuseslot.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesrtspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesstatic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesunmanagedexport.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesvirtual.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodattributes/methodattributesvtablelayoutmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributescodetypemask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesforwardref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesil.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesinternalcall.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesmanaged.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesmanagedmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesnative.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesnoinlining.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesoptil.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributespreservesig.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesruntime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributessynchronized.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/methodimplattributes/methodimplattributesunmanaged.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributeshasdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributesin.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributesoptional.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributesout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/parameterattributes/parameterattributesretval.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/propertyattributes/propertyattributeshasdefault.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/propertyattributes/propertyattributesnone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/propertyattributes/propertyattributesrtspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/propertyattributes/propertyattributesspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/targetinvocationexception/targetinvocationexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/targetinvocationexception/targetinvocationexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/targetparametercountexception/targetparametercountexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/targetparametercountexception/targetparametercountexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/targetparametercountexception/targetparametercountexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesabstract.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesansiclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesautoclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesautolayout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesbeforefieldinit.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesclasssemanticsmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesexplicitlayout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributeshassecurity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesimport.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesinterface.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributeslayoutmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedfamandassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedfamily.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedfamorassem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedprivate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesnestedpublic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributespublic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesrtspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributessealed.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributessequentiallayout.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesserializable.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesspecialname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesstringformatmask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesunicodeclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattributesvisibilitymask.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/typeattributes/typeattribytesnotpublic.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/missingmanifestresourceexception/missingmanifestresourceexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/missingmanifestresourceexception/missingmanifestresourceexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/missingmanifestresourceexception/missingmanifestresourceexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/neutralresourceslanguageattribute/neutralresourceslanguageattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/neutralresourceslanguageattribute/neutralresourceslanguageattributeculturename.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/satellitecontractversionattribute/satellitecontractversionattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/satellitecontractversionattribute/satellitecontractversionattributeversion.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/accessedthroughpropertyattribute/atpactor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/accessedthroughpropertyattribute/atpapropertyname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/compilationrelaxations/compilationrelaxationsattributector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/compilergeneratedattribute/compilergeneratedattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/customconstantattribute/customconstantattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/indexernameattribute/indexernameattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/internalsvisibletoattribute/internalsvisibletoattributeassemblyname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/internalsvisibletoattribute/internalsvisibletoattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/methodimploptions/methodimploptionsnoinlining.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/methodimploptions/methodimploptionspreservesig.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/runtimecompatibilityattribute/runtimecompatibilityattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/runtimecompatibilityattribute/runtimecompatibilityattributewrapnonexceptionthrows.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/runtimehelpers/gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/decimalconstantattribute/decimalconstantattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/decimalconstantattribute/decimalconstantattributevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/fixedbufferattribute/fixedbufferattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/fixedbufferattribute/fixedbufferattributeelementtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/fixedbufferattribute/fixedbufferattributelength.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/callingconvention/callingconventionwinapi.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/charset/charsetunicode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/fieldoffsetattribute/fieldoffsetattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/fieldoffsetattribute/fieldoffsetattributevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandle/gchandleaddrofpinnedobject.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandle/gchandlealloc1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandle/gchandlefree.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandle/gchandletarget.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandletype/gchandletypenormal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandletype/gchandletypepinned.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandletype/gchandletypeweak.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/gchandletype/gchandletypeweaktrackresurrection.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/inattribute/inattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/layoutkind/layoutkindauto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/layoutkind/layoutkindsequential.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshal/marshalgetlastwin32error.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshal/marshalreadint641.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshal/marshalsizeof1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributearraysubtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributector2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributemarshalcookie.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributemarshaltype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributemarshaltyperef.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributesizeconst.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributesizeparamindex.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshalasattribute/marshalasattributevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/outattribute/outattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/preservesigattribute/preservesigattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandlector_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandledangerousaddref.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandledangerousgethandle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandledangerousrelease.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandledispose1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandledispose2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandlehandle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandleisclosed.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandleisinvalid.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandlesethandle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/safehandle/safehandlesethandleasinvalid.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/structlayoutattribute/structlayoutattributecharset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/structlayoutattribute/structlayoutattributector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/structlayoutattribute/structlayoutattributepack.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/structlayoutattribute/structlayoutattributesize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/structlayoutattribute/structlayoutattributevalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/unmanagedtype/unmanagedtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimefieldhandle/runtimefieldhandleequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimefieldhandle/runtimefieldhandlegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimemethodhandle/runtimemethodhandleequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimemethodhandle/runtimemethodhanldegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimetypehandle/runtimetypehandleequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtimetypehandle/runtimetypehandlegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytecompareto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteiconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytemaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteparse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteparse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbyteparse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytetostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytetostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytetostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/sbyte/sbytetryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/security/securityexception/securityexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/security/securityexception/securityexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/security/securityexception/securityexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/security/securityexception/securityexceptiontostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleepsilon.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singlegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleisinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleisnan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleisnegativeinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleispositiveinfinity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singlemaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singlenan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleparse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singleparse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/single/singletryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringchars.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompare9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompareordinal1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompareordinal2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringconcat8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcopyto.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringctor5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringctorchar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringempty.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringequals6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringformat1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringformat2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringgetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringgethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringiconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringienumerablegetenumerator.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringindexof10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringinsert.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringisnullorempty.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringjoin.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringjoin1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringjoin2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringlength.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadleft.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadleft1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadleft2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadright.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadright1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringpadright2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringremove1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringremove2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringreplace1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringreplace2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringsplit1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringsubstring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringsubstring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtochararray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtrim1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtrim1b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtrim2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtrim3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringtrim4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcompare/stringcomparerctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparer/stringcomparercompare2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparer/stringcomparerequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparer/stringcomparerequals3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparer/stringcomparergettype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparison/stringcomparisoncurrentculture.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparison/stringcomparisoncurrentcultureignorecase.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparison/stringcomparisonordinal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/stringcomparison/stringcomparisonordinalignorecase.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/szarrayhelper/szarrayhelpersetitem.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/decoder/decoderctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/decoder/decoderreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoder/encoderctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingbigendianunicode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingclone.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingconvert1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingconvert2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytecount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytecount1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytecount2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytecount3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytes1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytes2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytes3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytes4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetbytes5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetcharcount1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetcharcount2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetchars1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetchars2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetchars3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetdecoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetencoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetencoding2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetmaxbytecount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetmaxcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetpreamble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodinggetstring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingunicode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingutf8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/encoding/encodingwebname.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend10.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend11.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend12.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend13.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend14.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend15.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend17.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend18.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend19.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend8.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderappend9.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuildercapacity.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuildercapacity_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderchars.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderctor6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderinsert.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderinsert3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderinsert4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderlength.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderlength_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderremove.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderreplace1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderreplace2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderreplace3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuilderreplace4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuildertostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/stringbuilder/stringbuildertostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodingctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodingequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetbytecount1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetbytecount2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetbytes2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetchars.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetdecoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetencoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetmaxbytecount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetmaxcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetpreamble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/unicodeencoding/unicodeencodinggetstring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodingctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodingctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodingctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodingequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetbytecount1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetbytecount2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetbytes1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetbytes2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetchars.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetdecoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetencoder.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetmaxbytecount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetmaxcharcount.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetpreamble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/text/utf8encoding/utf8encodinggetstring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/autoresetevent/autoreseteventctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/autoresetevent/autoreseteventreset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/autoresetevent/autoreseteventset.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedadd1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedadd2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedcompareexchange1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedcompareexchange5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedcompareexchange6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedcompareexchange7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockeddecrement1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockeddecrement2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedexchange1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedexchange5.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedexchange6.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedexchange7.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedincrement1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/interlocked/interlockedincrement2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/manualresetevent/manualreseteventctor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/timeout/timeoutinfinite.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/waithandle/waithandlector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/waithandle/waithandledispose1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/threading/waithandle/waithandledispose3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timeoutexception/timeoutexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timeoutexception/timeoutexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timeoutexception/timeoutexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanadd.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespancompare1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespancompareto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanduration.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanequals3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanfromticks.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespangethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanmaxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanminvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespannegate.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanticks.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanticksperday.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanticksperhour.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanticksperminute.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantickspersecond.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantotaldays.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantotalhours.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantotalmilliseconds.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantotalminutes.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantotalseconds.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespanzero.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typeequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typeequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegetarrayrank.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegetelementtype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegetgenerictypedefinition.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegettype1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegettype2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typegettypefromhandle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typehaselementtypeimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typeisbyrefimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typeispointerimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typemakearraytype1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typemakearraytype2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typemakebyreftype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typemakepointertype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/type/typetostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodebyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodechar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodedatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodedecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodedouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeempty.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeobject.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodesbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodesingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodestring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeuint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeuint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typecode/typecodeuint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typeloadexception/typeloadexceptionctor1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typeloadexception/typeloadexceptionctor2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typeloadexception/typeloadexceptionctor3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/typeloadexception/typeloadexceptionmessage.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16compareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16equals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16equals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16tostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16tostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16tostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint16/uint16tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32compareto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32equals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32equals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32maxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32minvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32tostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32tostring3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32tostring4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint32/uint32tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletoboolean.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletobyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletochar.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletodatetime.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletodecimal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletodouble.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletoint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletoint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletoint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletosbyte.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletosingle.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletotype.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletouint16.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64iconvertibletouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64maxvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64minvalue.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64parse1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64parse2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64parse3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64tostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64tostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uint64/uint64tryparse.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrctor_uint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrctor_uint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrctor_voidptr.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrgethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrsize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrtopointer.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrtostring.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrtouint32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrtouint64.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/uintptr/uintptrzero.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/valuetype/valuetypeequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/valuetype/valuetypeequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionbuild.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versioncompareto2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionctor4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versiongethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionmajor.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versionrevision.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versiontostring1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/version/versiontostring2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferencector1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferencector2b.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferenceisaliveb.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferencetrackresurrection_cti.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/buffer/asurt_99893.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/collections/generic/hashset/regression_dev10_609271.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/collections/generic/hashset/regression_dev10_624201.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/datetime/co7510parseexact_formatarray.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/generics/negativegenerics.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/miscellaneous/co6010delegateequalstwo.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/miscellaneous/co6031gethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/guid/guid_parsing.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/lazyt/lazyttf.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/text/encoding/shift_jis.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/version/version_parsing.cs

CORECLR_STRESSTEST_CS_SRC=	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/573277.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/MulDimJagAry.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/bestfit-finalize.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/ExpandHeap.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/PlugGaps.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/concurrentspin2.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/GCQueue.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/SingLinkStay.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/GCSimulator.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/StressAllocator.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/doubLinkStay.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/GCVariant.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/ThdTreeGrowingObj.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/allocationwithpins.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/pinstress.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LeakGenThrd.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/b115557.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/plug.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAllocPinned.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAlloc2.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAlloc4.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAlloc.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAlloc1.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/RedBlackTree.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/LargeObjectAlloc3.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Tests/DirectedGraph.cs

CORECLR_STRESSTEST_RUNNER_CS_SRC=	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityConfiguration.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityFramework.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityTest.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityTestSet.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityTestSet.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/RFLogging.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/DetourHelpers.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/LoaderClass.cs	\
	GCStressTests/AssemblyLoadContext.cs	\
	GCStressTests/AssemblyExtensions.cs

CORECLR_TESTLIBRARY_CS_SRC = 	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/TestFramework.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/Utilities.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/CalendarHelpers.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/Generator.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/EndianessChecker.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/GlobLocHelper.cs	\
	$(CORECLR_PATH)/tests/src/Common/CoreCLRTestLibrary/Logging.cs

# needs parameters:
CORECLR_DISABLED_TEST_CS_SRC = $(CORECLR_PATH)/tests/src/Loader/regressions/polyrec/polyrec.cs

# relies on env vars:
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/managed/Compilation/Compilation.cs	\
	$(CORECLR_PATH)/tests/src/Loader/NativeLibs/FromNativePaths.cs

# readytorun is a CoreCLR-specific feature:
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/readytorun/main.cs	\
	$(CORECLR_PATH)/tests/src/readytorun/test.cs
	
# relies on a referenced managed or native assembly, to complicated here:
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/Regressions/assemblyref/assem.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/assemblyref/test.cs		\
	$(CORECLR_PATH)/tests/src/Interop/ReversePInvoke/Marshalling/MarshalBoolArray.cs	\
	$(CORECLR_PATH)/tests/src/Interop/NativeCallable/NativeCallableTest.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructABI/StructABI.OSX.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructABI/StructABI.Windows.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructABI/StructABI.Unix.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/StructABI/StructABI.cs

# relies on a define:
CORECLR_DISABLED_TEST_CS_SRC += $(CORECLR_PATH)/tests/src/Exceptions/Finalization/Finalizer.cs

# exclude the CoreCLR GC stress framework for now, it needs special integration:
CORECLR_DISABLED_TEST_CS_SRC +=	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/RFLogging.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/DetourHelpers.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityTest.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityTestSet.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/LoaderClass.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityConfiguration.cs	\
	$(CORECLR_PATH)/tests/src/GC/Stress/Framework/ReliabilityFramework.cs

# exclude the CoreCLR SIMD tests for now:
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Mul.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/BoxUnbox.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Dup.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/CircleInConvex.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/BitwiseOperations.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/AbsGeneric.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/CreateGeneric.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/DivSignedUnsignedTest.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/StoreElement.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Ldfld.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/LdfldGeneric.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/BugWithAVX.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/SqrtGeneric.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Sums.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Vector4.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Ldind.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/MinMax.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/AddingSequence.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/AbsSqrt.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Ctors.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Vector3.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/CtorFromArray.cs	\
	$(CORECLR_PATH)/tests/src/JIT/SIMD/Haar-likeFeaturesGeneric.cs

# unused files
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/components/fileversioninfo/assembly1.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/regressions/17360/avhelper.cs	\
	$(CORECLR_PATH)/tests/src/reflection/regression/reflectionrepromasterforsl/helper.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/threadstatic/threadstatic04helper.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/hostedscenario/apunload/mgdhelper.cs	\
	$(CORECLR_PATH)/tests/src/Common/Coreclr.TestWrapper/CoreclrTestWrapperLib.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/resources/resourcemanager/customculture.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/resources/resourcemanager/customculture.cs

# Mono doesn't support ICastable
CORECLR_DISABLED_TEST_CS_SRC += $(CORECLR_PATH)/tests/src/Interop/ICastable/Castable.cs

# throws IndexOutOfRange exception even on .NET
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/compareexchange/compareexchangetclass.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/compareexchange/compareexchangetstring.cs

# relies on other .cs files or each other
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/stress/sudoku/isudokugenerator.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/stress/sudoku/isudokuboard.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/stress/sudoku/stack.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/stress/sudoku/isudokusolver.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0041/body_double.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0041/expl_double_1.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0433/assem.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0433/test.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/expl_double/body_double.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/expl_double/expl_double_1.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeym3.3/302680/data.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeym3.3/302680/302680.cs

# relies on mathtestlib.cs
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathtestlib.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathlog.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathatan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathtan.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathsinh.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathacos.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathcosh.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathtanh.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/math/mathatan2.cs

# relies on Trace.cs
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/innerfinally.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/trace.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/throwinfinally.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/baseclass.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/trycatchinfinally.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/rethrowandfinally.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/unittests/throwincatch.cs

# relies on GCUtil.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/GC/Features/HeapExpansion/GCUtil.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/HeapExpansion/Finalizer.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/HeapExpansion/Handles.cs

# relies on GCUtil.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/GCUtil.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedMany.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedHandle.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedMultiple.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedObject.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedCollect.cs	\
	$(CORECLR_PATH)/tests/src/GC/Features/Pinning/PinningOther/PinnedInt.cs

# relies on helper.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/testoverrides.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/testapis.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/testgc.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/compilerservices/dynamicobjectproperties/helper.cs

# relies on helper.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferencector2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/helper.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferenceisalive.cs

# relies on cfdatetimetools.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/cfdatetimetools.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimeisdaylightsavingtime.cs
	
# relies on delegatedefinitions.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/multicastdelegatector.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/multicastdelegategethashcode.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/multicastdelegategetinvocationlist.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/multicastdelegatecombineimpl.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/multicastdelegateequals.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/verificationagent.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/multicastdelegate/delegatedefinitions.cs

# relies on timespansupport.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespantostring_str.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/timespan/timespansupport.cs

# relies on common.cs helper
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/generics/ng_standard.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/generics/common.cs

# relies on a define
CORECLR_DISABLED_TEST_CS_SRC += $(CORECLR_PATH)/tests/src/baseservices/finalization/finalizer.cs

# requires a command line arg, don't bother with those for now
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartchar.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartdouble.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartfloat.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartshort.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartuint.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartneg1.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartnull.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartsbyte.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartbyte.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartneg4.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartdecimal.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartlong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartneg3.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartulong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartstring.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartushort.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartgenerics.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartcast.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartnull2.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartint.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartdelegate.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartbool.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartobject.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/paramthreadstart/threadstartoperations.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/compareexchange/compareexchangelong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/add/checkaddlong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/add/interlockedaddlong.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/add/checkaddint.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/add/interlockedaddint.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/add/interlockedaddlongwithsubtract.cs

# has no entrypoint or Main method
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/baseservices/visibility/target.cs	\
	$(CORECLR_PATH)/tests/src/GC/Scenarios/Boxing/doubLink.cs	\
	$(CORECLR_PATH)/tests/src/GC/Scenarios/DoublinkList/DoubLink.cs	\
	$(CORECLR_PATH)/tests/src/GC/Scenarios/FinalNStruct/strmap.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta2/485617/Managed.cs	\
	$(CORECLR_PATH)/tests/src/GC/Regressions/v2.0-beta2/476725/ManagedTest.cs	\
	$(CORECLR_PATH)/tests/src/GC/API/GCSettings/ILatencyTest.cs	\
	$(CORECLR_PATH)/tests/src/GC/API/GCSettings/InducedGen0GC.cs	\
	$(CORECLR_PATH)/tests/src/GC/API/GCSettings/InducedGen2GC.cs	\
	$(CORECLR_PATH)/tests/src/GC/API/GCSettings/InducedGen1GC.cs	\
	$(CORECLR_PATH)/tests/src/hosting/coreclr/activation/sxshost/usercases.cs	\
	$(CORECLR_PATH)/tests/src/hosting/coreclr/activation/sxshost/delegates.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/functional/threadpool/cs_support/fibonacci.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/functional/threadpool/cs_support/foo.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/hostedscenario/apunloadtwo/sample.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/regression/v1/threads/functional/thread/tculturedll.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0341/usercode.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0341/platformcode.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/1380/forwarder1.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0694/criticalcode.cs	\
	$(CORECLR_PATH)/tests/src/Regressions/coreclr/0149/sampleassembly.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/whidbeym3.3/293674/securedispatcher.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/v4.0/706099/managedcom.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/regressions/v4.0/640474/other2.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/ilasm_ildasm/regression/dd130885/xlib.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/ilasm_ildasm/regression/vswhidbey267905/267905.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/ilasm_ildasm/regression/vswhidbey395914/395914.cs	\
	$(CORECLR_PATH)/tests/src/baseservices/ilasm_ildasm/regression/vswhidbey305155/305155.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/runtimehelpers/platformassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/compilerservices/runtimehelpers/userassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/dllimportattribute/dllimporttest.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshal/oleaut32.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/delegate/testforotherassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assembly/testassembly1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/reflection/assembly/testtarget.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/reflection/assembly/testassembly.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/exception/data_helper.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/reflection/assembly/server4.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/reflection/assembly/server3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/reflection/assembly/server2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/reflection/assembly/server1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/miscellaneous/central.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/generics/nullabletypes.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/tests/critconstructorclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/tests/testclassframeworkinternal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/public/testclassframeworkinternal.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/public/testclass.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/tests/bindingtarget.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/threatmodel/tests/testclass.cs
	
# samples (should probably be removed upstream)
CORECLR_DISABLED_TEST_CS_SRC += 	\
	$(CORECLR_PATH)/tests/src/hosting/samples/hosting/usercode/usercode.cs	\
	$(CORECLR_PATH)/tests/src/hosting/samples/resolveevent/usercodedependency/usercodedependency.cs

# this test makes no sense, the expected pattern is the English one for all cultures
CORECLR_DISABLED_TEST_CS_SRC += $(CORECLR_PATH)/tests/src/Regressions/coreclr/0584/test584.cs

# Requires precise stack scanning
CORECLR_DISABLED_TEST_CS_SRC +=        \
       $(CORECLR_PATH)/tests/src/JIT/Directed/lifetime/lifetime2.cs

# Depends on small array behavior of .net. Mono supports objects > 2Gb on 64bits and the following tests verify for that
CORECLR_DISABLED_TEST_CS_SRC +=        \
       $(CORECLR_PATH)/tests/src/JIT/Directed/newarr/newarr.cs	\
	   $(CORECLR_PATH)/tests/src/baseservices/exceptions/sharedexceptions/emptystacktrace/oomexception01.cs

CORECLR_TEST_IL_SRC =			\
	$(CORECLR_PATH)/tests/src/JIT/BBT/Scenario4/Not-Int32.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Convert/implicitConv.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Convert/minopts_convu1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/ExcepFilters/excepobj/excepobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/ExcepFilters/fault/fault.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/ExcepFilters/mixed/mixed.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/FaultHandlers/CallOrder/CallOrder.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/FaultHandlers/Nesting/Nesting.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/FaultHandlers/Simple/simple.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/Tailcall/JitTailcall1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/Tailcall/Jittailcall2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/leave/leave2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/rethrow/rethrow1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/rethrow/rethrow2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Misc/SIDEEFFECTS/BadRegArgs.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Misc/SIDEEFFECTS/SideEffects.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/Misc/function_pointer/funcptrtest.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/Box_Unbox.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/Desktop/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/array_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/cpblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/field_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/fielda_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/initblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/initobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/ldind_stind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/ldloca.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/Box_Unbox.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/array_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/cpblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/field_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/fielda_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/initblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/initobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/ldind_stind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/ldloca.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/Box_Unbox.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/Desktop/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/array_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/cpblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/field_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/fielda_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/initblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/initobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/ldind_stind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/ldloca.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/Box_Unbox.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/Desktop/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/array_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/cpblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/field_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/fielda_tests.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/initblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/initobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/ldind_stind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/ldloca.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/RVAInit/oddsize.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/UnrollLoop/loop3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/array-il/simple3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/badendfinally.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/badtailcall.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/calli2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/ceeillegal.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/ldelemnullarr2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/ldfldstatic1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/ldfldunboxedvt.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/ldvirtftnsideeffect.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/nullsdarr.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/refanytype1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/stfldstatic1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/subovfun1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/volatilldind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/volatilstind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/arrgetlen.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/ldsshrstsfld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/ldvirtftncalli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/ovfldiv2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/ovflrem2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/stfldstatic1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/stfldstatic2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/switchdefaultonly1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/switchdefaultonly2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/switchdefaultonly3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/trashreg.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/volatilecpobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/zeroinit.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/catch1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/catch2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/catch3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/try1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/try2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/try3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/int8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/nativeint.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/shift/nativeuint.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/throwbox/fault.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/throwbox/filter.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/throwbox/finally.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/throwbox/rethrow.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/Dev10_863995.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_int32.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_int64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_struct.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_uint64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/tail.il	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/ConstrainedCall/vt3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Generics/regression/DDB148379/ddb148379.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Base/add.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/conv_ovf_i1_un.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_u1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_add_ovf_u8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_c_cpblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_c_initblk.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_c_nop.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_c_ret.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_c_switch.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ckfinite_r4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ckfinite_r8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_i4_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_i4_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_i4_u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_i8_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_i8_u8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u4_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u4_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u4_u1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u4_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u8_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_u8_u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_u1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_mul_ovf_u8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_neg_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_neg_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_r4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_r8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_ret_ref.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_u1.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_sub_ovf_u8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/lcs/lcs_ldlen.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/lengthm2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/selfref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/range/negIndexRngChkElim.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/boxunbox/array.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/boxunbox/chain.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/boxunbox/local.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/misc/enum.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Boxing/misc/tailjump.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Coverage/b39946.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Coverage/b518440.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Coverage/hole.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/conv_i8_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/conv_i8_u.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/convovf_i8_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/convovf_i8_u-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_conv.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_fld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_flood.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_flow.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_prop.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_qsort1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_qsort2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_ref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_seq.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/i_vfld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/ptr.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/qperm.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/sizeof-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_conv.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_fld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_flood.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_flow.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_prop.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_qsort1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_qsort2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_ref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_seq.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ELEMENT_TYPE_IU/u_vfld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/FPtrunc/convr4d.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/FPtrunc/convr8d.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param1c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param3c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfault.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfault_jmp.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfault_tail.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally_ind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally_jmp.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally_jmpind.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/SEH/catchfinally_tail.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/callvirt/test1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/callvirt/test2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/callvirt/test3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/ctor/val_cctor.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/ctor/val_ctor_newobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/deep/deep1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/deep/deep2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/ftn_t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/instftn.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/instftn_t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse_calli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse_jmp.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse_jmpi.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse_tail_call.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/recurse_tail_calli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/valftn.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/valftn_t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/virtftn.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/fptr/virtftn_t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/fr4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/fr8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/i4u4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/i8u8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/ii4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/iu4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/objref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/thiscall/thisnull.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/comp32.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/comp64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/cond32.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/NaN/cond64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/aa.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/calli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/dd.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/ee.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/jumper5.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/vtret.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/callconv/vtret2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/identity/accum.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/identity/livecall.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/VT/identity/volatile.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/castclass_catch.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/castclass_catch_neg.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/filter.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/isinst_catch.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/array/arrays.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/array/castclass_ldlen.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/array/isinst_ldlen.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_call.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_calli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_ldarg.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/castclass_ldloc.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_call.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_calli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_ldarg.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/isinst_ldloc.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/coverage/ldnull.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/iface/iface2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/ilseq/typeEqualOp.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/misc/deadlock.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/prefldinit1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/prefldinit2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/prefldinit4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_f4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_f8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_o.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refarg_s.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_i2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_o.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_o2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_r4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_r8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/basic/refloc_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/funcptr/expl_funcptr_gc.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/funcptr/expl_funcptr_val.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/funcptr/seq_funcptr_gc.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/funcptr/seq_funcptr_val.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/misc/refarg_box_val.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_double.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_float.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_objref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotarg_valref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotate_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/explicit/rotate/rotate_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug619534/ILStackAllocRepro.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/bug619534/twoEndFinallys.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug642944/GCMaskForGSCookie.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679053/cpblkInt32.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679053/flowgraph.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679955/indexMinusOne.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679955/volatileLocal1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/flowgraph/dev10_bug679955/volatileLocal2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/arrays/lcs_long.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/arrays/lcs_ulong.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/misc/binop.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/misc/box.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_addsub.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_div.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldc_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldfld_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldfld_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldsfld_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_ldsfld_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/signed/s_muldiv.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/superlong/superlong.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/addsub.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldc_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldc_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldfld_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldfld_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldsfld_mul.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/ldsfld_mulovf.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/unsigned/muldiv.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ldtoken/ldtoken.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ldtoken/ldtokena.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/ldtoken/ptr_types.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/localloc/verify/verify01_dynamic.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/localloc/verify/verify01_large.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/localloc/verify/verify01_small.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/localloc/zeroinit/zeroinit01_large.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/localloc/zeroinit/zeroinit01_small.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/generics2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/tailcall.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/nonvirtualcall/valuetype.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/array1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/native.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/seq.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/stress2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/u_native.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_enum.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_i2_bool.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_i4_i1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_i4_u.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_i_u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_obj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/compat_v.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_array.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_gc.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_inst.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_value.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_virt.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/gcval.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/gcval_nested.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/gcval_sideeffect.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/recurse_ep.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/reference_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_2a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_2b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_2c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_3b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_mutual_rec.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_switch.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/test_virt.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall_v4/smallFrame.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall_v4/tailcall_AV.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/varargs/callconv/gc_ctor.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/varargs/callconv/val_ctor.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/varargs/misc/Dev10_615402.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxblk/initblk3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_I.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_I8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_R4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_R8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_U2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/ldobj/ldobj_V.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/const.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/ldelema.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/mdarray.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/refanyval.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxobj/operand/unbox.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M09.5-PDC/b16935/b16935.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M11-Beta1/b45046/b45046.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M12-Beta2/b26323/b26323.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M12-Beta2/b35455/b35455.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b06440/b06440a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b06440/b06440b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b06440/b06440c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b07341/b07341.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b09495/b09495.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10665/b10665.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10666/b10666.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10894/b10894.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10897/b10897.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10939/b10939.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10940/b10940a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b10940/b10940b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b11021/b11021.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b11413/b11413.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b11949/b11949.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b12274/b12274.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b12487/b12487.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b13509/b13509.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b13522/b13522.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b13586/b13586.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b13738/b13738.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14067/b14067a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14067/b14067b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14068/b14068.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14070/b14070.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14135/b14135.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14197/b14197.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14199/b14199.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14202/b14202.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14264/b14264.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14294/b14294.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14325/b14325.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14326/b14326.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14329/b14329.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14350/b14350.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14431/b14431.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14591/b14591.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14769/b14769.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14770/b14770.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14777/b14777.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14927/b14927.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b14928/b14928.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b15222/b15222.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b15244/b15244.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b15299/b15299.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16039/b16039.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16049/b16049.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16071/b16071.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16241/b16241.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16295/b16295.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16498/b16498.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16499/b16499a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16499/b16499b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16500/b16500.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16503/b16503.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16554/b16554.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16881/b16881a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16881/b16881b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16886/b16886.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16896/b16896.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16922/b16922.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16928/b16928.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b18852/b18852.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b20079/b20079.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b20217/b20217.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b20249/b20249.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25458/b25458.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25463/b25463.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25468/b25468-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25474/b25474.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25491/b25491.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25507/b25507.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25701/b25701-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25739/b25739.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25813/b25813.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25815/b25815.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25833/b25833.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25835/b25835.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26020/b26020.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26153/b26153.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26155/b26155.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26332/b26332.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26512/b26512.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26748/b26748.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26888/b26888.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b26957/b26957.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27535/b27535.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27538/b27538.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27564/b27564.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27657/b27657.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27658/b27658.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27880/b27880.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28080/b28080.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28522/b28522.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28594/b28594.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28595/b28595.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28596/b28596.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28805/b28805.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28806/b28806.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28927/b28927.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b29583/b29583.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30792/b30792.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30799/b30799.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30838/b30838.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30862/b30862.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30864/b30864.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30869/b30869.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30892/b30892.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31102/b31102.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31273/b31273.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31321/b31321.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31343/b31343.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b31448/b31448.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32093/b32093.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32374/b32374.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32551/b32551a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b32551/b32551b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b34423/b34423.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b02043/b02043.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b02062/b02062.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b03995/b03995.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04083/b04083.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04250/b04250.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04257/b04257.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04306/b04306.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04345/b04345.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04384/b04384.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04538/b04538.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04574/b04574.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04583/b04583.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04612/b04612.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04639/b04639.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b04726/b04726.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05214/b05214.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05617/b05617.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05619/b05619.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05621/b05621.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05622/b05622.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05637/b05637.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05639/b05639.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05737/b05737.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05740/b05740.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05773/b05773.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05780/b05780.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05784/b05784.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b05933/b05933.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06435/b06435.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06436/b06436.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06730/b06730.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06754/b06754.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b07082/b07082.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b07411/b07411.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b07458/b07458.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b07704/b07704.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08109/b08109.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08672/b08672.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08797/b08797.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b09254/b09254.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b27873/b27873.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b29351/b29351.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b33759/b33759.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b33792/b33792.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b33888/b33888.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b33922/b33922.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b33928/b33928.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b35784/b35784.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b36030/b36030.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39381/b39381.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39397/b39397.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39417/b39417.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39455/b39455.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b39946/b39946.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40174/b40174.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40269/b40269.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40347/b40347.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40380/b40380.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40721/b40721.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40725/b40725.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41126/b41126.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41129/b41129.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41262/b41262.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41278/b41278.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41627/b41627.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42387/b42387.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b42732/b42732.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43040/b43040.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43069/b43069.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43115/b43115.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43121/b43121.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43160/b43160.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43378/b43378.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43714/b43714.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43963/b43963.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43994/b43994.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44020/b44020.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44204/b44204.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44224/b44224.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44723/b44723.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44724/b44724.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44861/b44861.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44879/b44879.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44946/b44946.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44983/b44983.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44984/b44984.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44985/b44985.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45439/b45439.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45541/b45541.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45956/b45956.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45984/b45984.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b45985/b45985.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46292/b46292.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46569/b46569.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46576/b46576.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46583/b46583.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b46897/b46897.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47022/b47022.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47080/b47080-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47093/b47093.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47610/b47610.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47885/b47885.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b47906/b47906.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48350/b48350.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48554/b48554a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48554/b48554b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b48614/b48614.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b49101/b49101.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b49984/b49984.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b16122/b16122.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b18857/b18857.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b28598/b28598.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b28949/b28949a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b30868/b30868.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31289/b31289.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31292/b31292.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31423/b31423.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31452/b31452.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31493/b31493.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31547/b31547.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31780/b31780.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31784/b31784.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b32613/b32613.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b32614/b32614.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33125/b33125.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33131/b33131.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33135/b33135.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33335/b33335.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33361/b33361.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33362/b33362.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33388/b33388.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33585/b33585.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b33586/b33586.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b34951/b34951.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b34952/b34952.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b34953/b34953.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35315/b35315.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35344/b35344.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35348/b35348.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35351/b35351.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35354/b35354.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35366/b35366.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35486/b35486.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35635/b35635.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b35779/b35779.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b36301/b36301.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b36302/b36302.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b36304/b36304.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b36975/b36975.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37214/b37214.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37215/b37215.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37238/b37238.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37256/b37256.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37578/b37578.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b37830/b37830.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b40006/b40006.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b40347/b40347.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b46566/b46566.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b47471/b47471.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b47886/b47886.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b49104/b49104.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b49142/b49142.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b49435/b49435-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50026/b50026.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50027/b50027.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b50033/b50033.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51420/b51420.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51515/b51515.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b51575/b51575.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53650/b53650.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53662/b53662.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53878/b53878.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53884/b53884.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53942/b53942a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53942/b53942b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53958/b53958.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53977/b53977.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53980/b53980.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53994/b53994.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b53995/b53995.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54565/b54565.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54566/b54566.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54611/b54611.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54971/b54971.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b55216/b55216.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b55875/b55875.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b55923/b55923.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56066/b56066.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56068/b56068.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56174/b56174.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56349/b56349.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b56780/b56780.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b57492/b57492.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b57493/b57493.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b57516/b57516.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b57518/b57518.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b57952/b57952.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b58358/b58358.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b58360/b58360.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b58689/b58689.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b58690/b58690.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b58866/b58866.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59319/b59319.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59320/b59320.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59337/b59337.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59477/b59477.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59478/b59478.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59508/b59508.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59554/b59554.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59647/b59647.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59782/b59782.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59822/b59822.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59857/b59857.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59858/b59858.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59947/b59947.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59948/b59948.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59949/b59949.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59952/b59952.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b59953/b59953.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b60127/b60127.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b60142/b60142.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b60194/b60194.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61025/b61025.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61185/b61185.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b61215/b61215.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b62145/b62145.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63552/b63552.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63725/b63725.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63726/b63726.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63730/b63730.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63732/b63732.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b63823/b63823.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b64026/b64026.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b64560/b64560.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b65087/b65087.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b65176/b65176.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b65407/b65407.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b66226/b66226.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b66425/b66425.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b66583/b66583.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b66620/b66620.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b66679/b66679.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b67351/b67351.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b67744/b67744.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b67819/b67819.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b67987/b67987.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b68028/b68028.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b68045/b68045.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b68872/b68872.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b69225/b69225.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b69227/b69227.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b69512/b69512.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b69528/b69528.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b69848/b69848.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70267/b70267.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70289/b70289.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70335/b70335.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70354/b70354.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70808/b70808.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70964/b70964.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70967/b70967.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70992/b70992.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70994/b70994.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71003/b71003.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71179/b71179.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71722/b71722.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71831/b71831.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71869/b71869.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71999/b71999.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72160/b72160.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72161/b72161.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72518/b72518.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72522/b72522.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72699/b72699.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b72828/b72828.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b73079/b73079.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b73207/b73207.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b73283/b73283.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b73786/b73786.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b74608/b74608.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b74937/b74937.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b74939/b74939.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b74976/b74976.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75888/b75888.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75890/b75890.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75944/b75944.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b75945/b75945.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b77304/b77304.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b77806/b77806.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b77950/b77950.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b79250/b79250.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b80043/b80043.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b80824/b80824.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b81938/b81938.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b82160/b82160.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b82247/b82247.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b82249/b82249.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b82715/b82715.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b84909/b84909.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b84916/b84916.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b84971/b84971.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b85316/b85316.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b101147/b101147.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b85477/b85477.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b86139/b86139.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89409/b89409.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b89546/b89546.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b90129/b90129.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91021/b91021.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91203/b91203.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91223/b91223.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b91359/b91359.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b92736/b92736.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b94306/b94306.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M13-RTM/b99667/b99667.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b147814/rembug.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b147816/loop.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/params-mixed.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/params-none.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/params-object.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/params-value.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/static-mixed.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/static-object.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.1-M1-Beta1/b139895/b139895.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.1-M1-Beta1/b140118/b140118.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b147147/samabo.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b147924/bigdat.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b180381/constrained2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b220968/1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b223924/bug2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b223932/bug3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-Beta1/b223936/bug4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b00722/b00722.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b04319/b04319.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b05623/b05623.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b06020/b06020.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b07369/b07369.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b07383/b07383.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b07947/b07947.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b13452/b13452.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b14617/b14617.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b15617/arrayDim.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M01/b18049/loop2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b102962/vc178279.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b118260/b118260.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b138117/ldsfldainitonlyvt.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b309555/x86-test-1084346006.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b323557/1087985874.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b353858/b353858.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b374944/helper.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b409617/b409617.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b415164/b415164.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b423755/Desktop/b423755.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b489329/b489329.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b518440/b518440.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b598031/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b598031/test2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/dev10/b464149/b464149.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b170362/b170362.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b174294/spill.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/b176032/b176032.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b173313/b173313.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b193264/b193264.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/b48850/b48850.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_b473131/b473131.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_b473131/b473131_byte.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_b473131/b473131_fld.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_b473131/b473131_intptr.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/DevDiv2_11321/DevDiv2_11321.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/External/Dev11_90434/UseUnalignedDouble.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b102759/b102759.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b102870/b102870.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b103838/c.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b106158/branchoutoftry.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b108366/bug.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b108908/b108908.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b109721/bug.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b109878/rem_r4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b112982/exceptobj.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b113286/array.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b114628/array.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b115103/b115103.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b141062/ericswitch.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b79852/b79852.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b79858/b79858.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b80365/b80365-ia64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b80373/b80373.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b80737/fbug5.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b80738/fbug6.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b81763/b81763.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b81764/b81764.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b81766/b81766.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84129/b84129.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84131/b84131.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84136/b84136.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84586/b84586.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84590/b84590.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84592/b84592.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84957/b84957.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84958/b84958.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84961/b84961.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b84962/b84962.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85314/b85314.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85315/b85315.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85316/f2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85317/b85317.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85564/b85564.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85565/b85565.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b85566/b85566.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b92713/b92713.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/M00/b92726/b92726.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b223862/bug1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-Beta1/b91953/2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b10802/repro.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b10841/repro_good.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b11131/bug2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b11878/test_07.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b12022/test_10.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b12263/nullref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b12343/test_04a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b12390/test_04a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b12425/test_17.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M01/b13691/init_byte.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b102518/hole.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b102844/tailcallcalli.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b14366/bug2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b14368/bug4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b14369/bug5.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b16198/decm010.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b16224/test_25.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b17023/test1a.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b17751/bug4.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b17904/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b22521/branch_06.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b22680/1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b28158/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b28158/test64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b29727/2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b309576/bug2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b333008/b333008.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b356258/b356258.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b431098/b431098.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-Beta2/b450688/b450688.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V2.0-RTM/b460385/b460385.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/clr-x64-JIT/v4.0/b602182/b602182.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/localloc/zeroinit/zeroinit01_large.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/localloc/zeroinit/zeroinit01_small.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/il/jmp.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cg/il/ldftn.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cprop/Dev10_884217_IL.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cprop/cprop002.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/inl/inl001.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/lim/lim_001.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/lur/lur_01.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/osr/osr015.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/bne.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/conv.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/div.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/mul1.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/mul_exception.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/223862/rem.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/228572/conv.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/481244/foo.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/regress/vswhidbey/481244/foo2.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ddb/118414/118414.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/ddb/127931/127931.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/102974/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/153682/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/266693/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/333007/test1.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/336666/test1.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/373472/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/404708/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/460412/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/534486/exchange.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/575343/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/575343/test2.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/606733/Bug606733.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/vsw/607586/607586.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/verif/sniff/fg/ver_fg_13.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/AssertionPropagation/CPropOverflow.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/DumpDisasm/JitMinOpts/BBCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/DumpDisasm/JitMinOpts/CodeSize1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/DumpDisasm/JitMinOpts/InstrCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/DumpDisasm/JitMinOpts/LVNumCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/DumpDisasm/JitMinOpts/LVRefCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/ETW/TailCallCases.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/BBCnt0.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/BBCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/CodeSize0.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/CodeSize1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/InstrCnt0.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/InstrCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/LVNumCnt0.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/LVNumCnt1.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/LVRefCnt0.il	\
	$(CORECLR_PATH)/tests/src/JIT/opt/JitMinOpts/Perf/LVRefCnt1.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault-struct01.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault-struct02.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault-struct03.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault01.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault02.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-fault03.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-filter-finally01.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-filter-finally02.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/generics/try-filter-struct02.il	\
	$(CORECLR_PATH)/tests/src/baseservices/exceptions/simple/fault.il	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/compareexchange/compareexchangetneg.il	\
	$(CORECLR_PATH)/tests/src/baseservices/threading/interlocked/exchange/exchangetneg.il

# throws syntax error when processing with Mono ilasm:
CORECLR_DISABLED_TEST_IL_SRC =			\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cprop/Dev10_844071.il		\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/initializearray_enum.il		\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/casts/SEH/isinst_catch_neg.il			\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40199/b40199.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b40411/b40411.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41002/b41002.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41149/b41149.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b41164/b41164.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b43033/b43033.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M11-Beta1/b44657/b44657.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b49335/b49335.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b54006/b54006.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b409748/b409748.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.2/ddb/b429039/b429039.il		\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/v2.1/DDB/B168384/LdfldaHack.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-QFE/b151440/params-varargs.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_468598/Test_HndIndex_10_Plain.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/External/Dev11_14131/VectorForwarder.il

# pinvokes to win32 api, will need to move to HOST_WIN32 specific section:
CORECLR_DISABLED_TEST_IL_SRC +=			\
	$(CORECLR_PATH)/tests/src/JIT/Directed/pinvoke/jump.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/pinvoke/sysinfo.il		\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/Desktop/callipinvoke.il		\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/callipinvoke.il				\
	$(CORECLR_PATH)/tests/src/JIT/Directed/IL/PInvokeTail/tailwinapi.il					\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28901/b28901.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/clr-x64-JIT/v2.1/b173569/b173569.il


# Bad test that tries an implicit cast from int32 to byref
CORECLR_DISABLED_TEST_IL_SRC +=	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/importer/byrefsubbyref1.il

# Bad test that tries to implicit cast from bytef to int32
CORECLR_DISABLED_TEST_IL_SRC +=	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/subbyref.il

# Bad test that tries to assign a byref to a class to a byref of an interface that class implements
# This is unsafe because the byref is mutable and would allow you to store the wrong type on that cell.
CORECLR_DISABLED_TEST_IL_SRC +=	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/coverage/oldtests/lcliimpl.il


# FIXME: these tests are baselined, i.e. we don't have time to investigate
# them right now but want to make sure we don't introduce new regressions
# in the rest of the tests
CORECLR_DISABLED_TEST_CS_SRC +=	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventhandler_generic/eventhandlerbegininvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/action/actioninvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/comparison/comparisonendinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/comparison/comparisonbegininvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/datetime/datetimekind.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/eventhandler_generic/eventhandlerendinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/gc/gcreregisterforfinalize.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfocompare.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfoindexof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfoisprefix.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfoissuffix.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/compareinfo/compareinfolastindexof.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/globalization/regioninfo/regioninfocurrentregion.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/io/filestream/filestreamdispose.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/predicate/predicateendinvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/predicate/predicatebegininvoke.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/runtime/interopservices/marshal/marshalsizeof2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringcompareto1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringequals1.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringequals2.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/string/stringequals3.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/cti/system/weakreference/weakreferencetargetb.cs	\
	$(CORECLR_PATH)/tests/src/CoreMangLib/system/delegate/regressions/devdivbugs/113347/ddb113347.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/misc/arrres.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b268908/vars2.cs	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/VS-ia64-JIT/V1.2-M02/b10828/redundant.cs	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/opt/cse/HugeField1.cs

CORECLR_DISABLED_TEST_IL_SRC +=	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/1/arglist64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/2/arglist64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/unaligned/4/arglist64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/PREFIX/volatile/1/arglist64.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/filter1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/filter2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/leave/filter3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/refbyref/byrefconvert.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_byte.il	\
	$(CORECLR_PATH)/tests/src/JIT/Directed/zeroinit/init_uint32.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_r8_i.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_r8_i4.il	\
	$(CORECLR_PATH)/tests/src/JIT/IL_Conformance/Old/Conformance_Base/ldc_conv_ovf_r8_i8.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Arrays/huge_struct.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param3b.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25paramMixed.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/i4u2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/ii1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/iu2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/implicit/ii2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/cctor/simple/Desktop/prefldinit3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/int64/arrays/hugedim.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/tailcall/deep_array_nz.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/array3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/refany/array2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/xxblk/cpblk3.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-EJIT/V1-M11-Beta1/b44018/b44018.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b16895/b16895.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b25459/b25459.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27883/b27883.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b27917/b27917.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b28597/b28597.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M09.5-PDC/b30125/b30125.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b08107/b08107.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M10/b06595/b06595.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b31283/b31283.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b70909/b70909.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1-M12-Beta2/b71318/b71318.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b102962/t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b102962/t2.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b115932/t.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V1.2-M02/b115932/t1.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-Beta2/b091942/nullref.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b471305/b471305.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/CLR-x86-JIT/V2.0-RTM/b475589/b475589.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_468598/Test_HndIndex_10_Reordered.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/Dev11/Dev11_b473131/b473131_struct.il	\
	$(CORECLR_PATH)/tests/src/JIT/Regression/v4/dev10_804810/dev10_804810.il	\
	$(CORECLR_PATH)/tests/src/JIT/jit64/regress/phoenix/62322/test.il	\
	$(CORECLR_PATH)/tests/src/JIT/Methodical/Invoke/25params/25param1b.il


# find all CoreCLR *.il test files that aren't mentioned in this file
CORECLR_DEFINED_IL_SRC = $(CORECLR_TEST_IL_SRC) $(CORECLR_DISABLED_TEST_IL_SRC)
CORECLR_UPSTREAM_IL_SRC=$(shell find "$(CORECLR_PATH)/tests" -iname "*.il")
CORECLR_IL_SRC_MISSING=$(filter-out $(CORECLR_DEFINED_IL_SRC),$(CORECLR_UPSTREAM_IL_SRC))

# find all CoreCLR *.cs test files that aren't mentioned in this file
CORECLR_DEFINED_CS_SRC = $(CORECLR_TEST_CS_SRC) $(CORECLR_COREMANGLIB_TEST_CS_SRC) $(CORECLR_TESTLIBRARY_CS_SRC) $(CORECLR_STRESSTEST_CS_SRC) $(CORECLR_DISABLED_TEST_CS_SRC)
CORECLR_UPSTREAM_CS_SRC=$(shell find "$(CORECLR_PATH)/tests" -iname "*.cs")
CORECLR_CS_SRC_MISSING=$(filter-out $(CORECLR_DEFINED_CS_SRC),$(CORECLR_UPSTREAM_CS_SRC))

# print the CoreCLR test files not defined in this file
# this is helpful when upstream adds new tests
coreclr-list-missing-tests:
	@echo
	@echo CoreCLR tests missing from Makefile.am:
	@echo $(CORECLR_IL_SRC_MISSING) | tr " " "\n"
	@echo $(CORECLR_CS_SRC_MISSING) | tr " " "\n"

CORECLR_TESTSI_CS=$(CORECLR_TEST_CS_SRC:.cs=.exe)
CORECLR_TESTSI_IL=$(CORECLR_TEST_IL_SRC:.il=_il.exe)

CORECLR_STRESSTESTSI_CS=$(CORECLR_STRESSTEST_CS_SRC:%.cs=%.exe)
CORECLR_COREMANGLIB_TESTSI_CS=$(CORECLR_COREMANGLIB_TEST_CS_SRC:.cs=.exe)

$(CORECLR_PATH)%_il.exe: $(CORECLR_PATH)%.il
	$(ILASM) -out:$@ $<

coreclr-testlibrary.dll: $(CORECLR_TESTLIBRARY_CS_SRC)
	$(MCS) -unsafe -debug:portable -target:library -d:WINCORESYS -d:MONO -out:$@ $(CORECLR_TESTLIBRARY_CS_SRC)

$(CORECLR_PATH)%.exe: $(CORECLR_PATH)%.cs coreclr-testlibrary.dll
	$(MCS) -unsafe -debug:portable -nowarn:0162 -nowarn:0168 -nowarn:0219 -nowarn:0414 -nowarn:0618 -nowarn:0169 -nowarn:1690 -nowarn:0649 -nowarn:0612 -nowarn:3021 -nowarn:0197 -r:coreclr-testlibrary.dll -d:MONO -out:$@ $<

test-runner.exe: $(top_srcdir)/mono/tests/test-runner.cs
	$(MCS) -debug:portable -r:Mono.Posix.dll -out:$@ $<

GCStressTests.exe: $(CORECLR_STRESSTEST_RUNNER_CS_SRC)
	$(MCS) -out:$@ -debug:portable -d:PROJECTK_BUILD $(CORECLR_STRESSTEST_RUNNER_CS_SRC)
