/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephObjectStoresGetter has a method to return a CephObjectStoreInterface.
// A group's client should implement this interface.
type CephObjectStoresGetter interface {
	CephObjectStores(namespace string) CephObjectStoreInterface
}

// CephObjectStoreInterface has methods to work with CephObjectStore resources.
type CephObjectStoreInterface interface {
	Create(*v1.CephObjectStore) (*v1.CephObjectStore, error)
	Update(*v1.CephObjectStore) (*v1.CephObjectStore, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephObjectStore, error)
	List(opts metav1.ListOptions) (*v1.CephObjectStoreList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectStore, err error)
	CephObjectStoreExpansion
}

// cephObjectStores implements CephObjectStoreInterface
type cephObjectStores struct {
	client rest.Interface
	ns     string
}

// newCephObjectStores returns a CephObjectStores
func newCephObjectStores(c *CephV1Client, namespace string) *cephObjectStores {
	return &cephObjectStores{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephObjectStore, and returns the corresponding cephObjectStore object, and an error if there is any.
func (c *cephObjectStores) Get(name string, options metav1.GetOptions) (result *v1.CephObjectStore, err error) {
	result = &v1.CephObjectStore{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectstores").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephObjectStores that match those selectors.
func (c *cephObjectStores) List(opts metav1.ListOptions) (result *v1.CephObjectStoreList, err error) {
	result = &v1.CephObjectStoreList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectstores").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephObjectStores.
func (c *cephObjectStores) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectstores").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a cephObjectStore and creates it.  Returns the server's representation of the cephObjectStore, and an error, if there is any.
func (c *cephObjectStores) Create(cephObjectStore *v1.CephObjectStore) (result *v1.CephObjectStore, err error) {
	result = &v1.CephObjectStore{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephobjectstores").
		Body(cephObjectStore).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephObjectStore and updates it. Returns the server's representation of the cephObjectStore, and an error, if there is any.
func (c *cephObjectStores) Update(cephObjectStore *v1.CephObjectStore) (result *v1.CephObjectStore, err error) {
	result = &v1.CephObjectStore{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephobjectstores").
		Name(cephObjectStore.Name).
		Body(cephObjectStore).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephObjectStore and deletes it. Returns an error if one occurs.
func (c *cephObjectStores) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectstores").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephObjectStores) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectstores").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephObjectStore.
func (c *cephObjectStores) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectStore, err error) {
	result = &v1.CephObjectStore{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephobjectstores").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
