/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1beta1"
	"github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	serializer "k8s.io/apimachinery/pkg/runtime/serializer"
	rest "k8s.io/client-go/rest"
)

type EdgefsV1beta1Interface interface {
	RESTClient() rest.Interface
	ClustersGetter
	ISCSIsGetter
	ISGWsGetter
	NFSsGetter
	S3sGetter
	S3XsGetter
	SWIFTsGetter
}

// EdgefsV1beta1Client is used to interact with features provided by the edgefs.rook.io group.
type EdgefsV1beta1Client struct {
	restClient rest.Interface
}

func (c *EdgefsV1beta1Client) Clusters(namespace string) ClusterInterface {
	return newClusters(c, namespace)
}

func (c *EdgefsV1beta1Client) ISCSIs(namespace string) ISCSIInterface {
	return newISCSIs(c, namespace)
}

func (c *EdgefsV1beta1Client) ISGWs(namespace string) ISGWInterface {
	return newISGWs(c, namespace)
}

func (c *EdgefsV1beta1Client) NFSs(namespace string) NFSInterface {
	return newNFSs(c, namespace)
}

func (c *EdgefsV1beta1Client) S3s(namespace string) S3Interface {
	return newS3s(c, namespace)
}

func (c *EdgefsV1beta1Client) S3Xs(namespace string) S3XInterface {
	return newS3Xs(c, namespace)
}

func (c *EdgefsV1beta1Client) SWIFTs(namespace string) SWIFTInterface {
	return newSWIFTs(c, namespace)
}

// NewForConfig creates a new EdgefsV1beta1Client for the given config.
func NewForConfig(c *rest.Config) (*EdgefsV1beta1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &EdgefsV1beta1Client{client}, nil
}

// NewForConfigOrDie creates a new EdgefsV1beta1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *EdgefsV1beta1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new EdgefsV1beta1Client for the given RESTClient.
func New(c rest.Interface) *EdgefsV1beta1Client {
	return &EdgefsV1beta1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = serializer.DirectCodecFactory{CodecFactory: scheme.Codecs}

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *EdgefsV1beta1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
