# System.IO.Compression

``` diff
 namespace System.IO.Compression {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct BrotliDecoder : IDisposable {
+        public OperationStatus Decompress(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesConsumed, out int bytesWritten);
+        public void Dispose();
+        public static bool TryDecompress(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct BrotliEncoder : IDisposable {
+        public BrotliEncoder(int quality, int window);
+        public OperationStatus Compress(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesConsumed, out int bytesWritten, bool isFinalBlock);
+        public void Dispose();
+        public OperationStatus Flush(Span<byte> destination, out int bytesWritten);
+        public static int GetMaxCompressedLength(int inputSize);
+        public static bool TryCompress(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static bool TryCompress(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten, int quality, int window);
+    }
+    public sealed class BrotliStream : Stream {
+        public BrotliStream(Stream stream, CompressionLevel compressionLevel);
+        public BrotliStream(Stream stream, CompressionLevel compressionLevel, bool leaveOpen);
+        public BrotliStream(Stream stream, CompressionMode mode);
+        public BrotliStream(Stream stream, CompressionMode mode, bool leaveOpen);
+        public Stream BaseStream { get; }
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
+        protected override void Dispose(bool disposing);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override int Read(byte[] array, int offset, int count);
+        public override Task<int> ReadAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] array, int offset, int count);
+        public override Task WriteAsync(byte[] array, int offset, int count, CancellationToken cancellationToken);
+    }
     public class ZipArchiveEntry {
+        public uint Crc32 { get; }
     }
 }
```

