package cli

import (
	"encoding/json"
	"io/ioutil"

	"github.com/pkg/errors"

	"github.com/strixeyecom/cli/domain/repository"
)

/*
	Created by aomerk at 5/20/21 for project strixeye
*/

/*
	Here we keep the necessary configuration of our cli.
*/

// global constants for file.
const ()

// global variables (not cool) for this file.
var ()

// Cli keeps needed information to run strixeye cli.
// It's usually kept under the same folder with strixeyed config file if there is one.
//
// It's usually kept in json format.
type Cli struct {

	// UserAPIToken is used for the authentication process to Strixeye User API.
	// This api is open to all our customers and feel free to check out the documentation.
	//
	// UserAPIToken is generally sent as Authentication Bearer token over https.
	UserAPIToken string `mapstructure:"USER_API_TOKEN" json:"user_api_token" flag:"user-api-token"`

	// strixeye cli is usually designed to be used for a single agent instance at once,
	// while not necessary, this field can be use to save user preference.
	//
	// However, most functions are agent id dependent.
	AgentID string `mapstructure:"AGENT_ID" json:"agent_id" flag:"agent-id"`

	// DO NOT EDIT
	// APIDomain is almost always dashboard.strixeye.com or api.strixeye.com. However,
	// this is needed for testing purposes
	APIDomain      string `mapstructure:"API_DOMAIN" json:"api_domain" flag:"api-domain"`
	DownloadDomain string `mapstructure:"DOWNLOAD_DOMAIN" json:"download_domain" flag:"download-domain"`
	DockerRegistry string `mapstructure:"DOCKER_REGISTRY" json:"docker_registry" flag:"docker-registry"`

	// 	DB can be removed in the future, however it is something user might want to override.
	// 	I'm not sure if this will cause a vuln for now, however even I need this for myself. Because:
	// normally, database host is known only inside stack network like docker-compose network or kubernetes
	// network, but StrixEye CLI is not part of that network, and won't be.
	repository.Database `mapstructure:"DATABASE" flag:"database"`

	PrettyOutput bool `json:"pretty_output" yaml:"pretty_output" mapstructure:"PRETTY_OUTPUT" flag:"pretty-output"`

	Interactive bool `json:"-" yaml:"-" mapstructure:"INTERACTIVE" flag:"interactive"`
}

// Save stores current cli config to given file in json format.
func (c *Cli) Save(filePath string) error {
	data, err := json.Marshal(c)
	if err != nil {
		return errors.Wrap(err, "can not save cli config to file")
	}

	// using rw|rw|rw for permission.
	// #nosec
	return ioutil.WriteFile(filePath, data, 0644)
}

// Validate checks for bad/empty input inside config instances. Ids and Tokens are mostly generated by uuids.
func (c *Cli) Validate() error {
	var (
	// err error
	)

	// TODO add validation support
	if c.UserAPIToken == "" || c.AgentID == "" {
		return errors.New("cli config has empty field")
	}

	return nil
}
