package io.quarkus.arc.test.injection.staticmethod;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

import java.util.concurrent.atomic.AtomicInteger;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.arc.Arc;
import io.quarkus.arc.test.ArcTestContainer;

public class StaticMethodInjectionTest {

    @RegisterExtension
    public ArcTestContainer container = new ArcTestContainer(Head.class, CombineHarvester.class);

    @Test
    public void testInjection() {
        assertNotNull(Arc.container().instance(CombineHarvester.class).get());
        assertNotNull(CombineHarvester.head);
        assertEquals(1, Head.COUNTER.get());
    }

    @Dependent
    static class Head {

        static final AtomicInteger COUNTER = new AtomicInteger(0);

        public Head() {
            COUNTER.incrementAndGet();
        }

    }

    @Dependent
    static class CombineHarvester {

        static Head head;

        // The parameter is injected
        CombineHarvester(Head head) {
            CombineHarvester.head = head;
        }

        // This one is ignored
        @Inject
        static void init(Head head) {
            CombineHarvester.head = head;
        }

    }
}
