package com.keylesspalace.tusky.util

import android.view.View

fun View.show() {
    this.visibility = View.VISIBLE
}

fun View.hide() {
    this.visibility = View.GONE
}

fun View.visible(visible: Boolean) {
    this.visibility = if(visible) {
        View.VISIBLE
    } else {
        View.GONE
    }
}