---
title: Announcing Contour v1.12.0
excerpt: This blog post covers local rate limiting support in Contour 1.12.
author_name: Steve Kriss
author_avatar: /img/contributors/steve-kriss.png
categories: [kubernetes]
tags: ['Contour Team', 'Steve Kriss']
---

Contour continues to add new features to help you better manage ingress operations in a cluster.
Our latest feature release, Contour 1.12.0, adds support for local rate limiting on `HTTPProxy` virtual hosts and routes, dynamic request headers, and header hash load balancing.

## Local Rate Limiting
Rate limiting is a means of protecting backend services against unwanted traffic.
This can be useful for a variety of different scenarios:
- Protecting against denial-of-service (DoS) attacks by malicious actors
- Protecting against DoS incidents due to bugs in client applications/services
- Enforcing usage quotas for different classes of clients, e.g. free vs. paid tiers
- Controlling resource consumption/cost

Envoy supports two different types of rate limiting: _local_ and _global_.
In local rate limiting, a rate limit is applied to traffic by each individual Envoy process/pod, without sharing information across multiple instances of Envoy.
In global rate limiting, all Envoy instances communicate with an external Rate Limit Service (RLS) via gRPC to make rate limit decisions.

Contour 1.12.0 adds support for Envoy's _local_ rate limiting.
This enables Contour users to protect their backend services by defining simple limits for how much traffic each Envoy process/pod should proxy to them.
Local rate limits can be defined for an entire virtual host, or for individual routes.
Here's an example of an `HTTPProxy` that allows 100 requests per second from each Envoy pod to reach a backend service:

```yaml
apiVersion: projectcontour.io/v1
kind: HTTPProxy
metadata:
  name: ratelimited-route
spec:
  virtualhost:
    fqdn: ratelimit.projectcontour.io
  routes:
  - conditions:
    - prefix: /ratelimited-service
    services:
    - name: s1
      port: 80
    rateLimitPolicy:
      local:
        requests: 100
        unit: second
```

Requests above the 100-per-second limit will receive a `429 (Too Many Requests)` response by default.
The response code can also be customized.

For more information, see:
- the [Contour Rate Limiting documentation](https://projectcontour.io/docs/v1.12.0/config/rate-limiting/)
- the [HTTPProxy API reference](https://projectcontour.io/docs/v1.12.0/config/api/#projectcontour.io/v1.LocalRateLimitPolicy)
- Envoy's [HTTP local rate limit filter documentation](https://www.envoyproxy.io/docs/envoy/v1.17.0/configuration/http/http_filters/local_rate_limit_filter#config-http-filters-local-rate-limit)

For users with more advanced rate-limiting needs, Contour will also be adding _global_ rate limiting support in an upcoming release.

## Dynamic Request Headers
Contour 1.12 also adds support for including dynamic values in configured request and response headers.
Almost all [variables supported by Envoy](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_conn_man/headers#custom-request-response-headers) are allowed.
This feature can be used to set headers containing information such as the host name of where the Envoy pod is running, the TLS version, etc.

For more information, including a full list of supported variables, see the [Contour documentation](https://projectcontour.io/docs/v1.12.0/config/request-rewriting/#dynamic-header-values).

A big thanks to [@erwbgy](https://github.com/erwbgy) for designing and implementing this feature!

## Header Hash Load Balancing
Contour 1.12 now supports the `RequestHash` load balancing strategy, which enables load balancing based on request headers.
An upstream Endpoint is selected based on the hash of an HTTP request header.
Requests that contain a consistent value in a request header will be routed to the same upstream Endpoint.

For more information, including an example `HTTPProxy` definition, see the [Contour documentation](https://projectcontour.io/docs/v1.12.0/config/request-routing/#load-balancing-strategy).

## Community Thanks!
We’re immensely grateful for all the community contributions that help make Contour even better! For version 1.12, special thanks go out to the following contributors:
- [@danehans](https://github.com/danehans)
- [@erwbgy](https://github.com/erwbgy)
- [@nak3](https://github.com/nak3)
- [@tsaarni](https://github.com/tsaarni)
