# Lock: Internationalization

You can call instantiate the widget with the `dict` option:

```javascript
var lock = new Auth0Lock('dsa7d77dsa7d7', 'mine.auth0.com');

lock.show({
  dict: 'es'
});
```

Where dict can be a string matching the name of the file in the `i18n` folder or it could be an object literal as follows:

```javascript
var lock = new Auth0Lock('dsa7d77dsa7d7', 'mine.auth0.com');

lock.show({
  dict: {
    "loadingTitle": "loading...",
    "close": "close",
    "signin": {
    .. //same as in i18n json files
  }
});
```

Finally you can also make changes to an existing dictionary by merging a new dictionary in an existing one (this sample uses [underscore.js](http://underscorejs.org/)):

```javascript
lock.show({
  dict: _.merge(lock.$dicts.en, {
    "signup:headerText": "Hi there, please enter your email and password"
  })
})
```

![][i18n-image]

> Note: Most of the translations are machine generated, please help us to move this forward.

[i18n-image]: https://cloudup.com/cBqDKv0PKKM+
