/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.netflix.servo.tag.Tag;
import com.netflix.servo.util.Strings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallTagMap
implements Iterable<Tag> {
    public static final int MAX_TAGS = 32;
    public static final int INITIAL_TAG_SIZE = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(SmallTagMap.class);
    private volatile Set<Tag> entrySet;
    private int cachedHashCode = 0;
    private final Object[] data;
    private final int dataLength;

    public static Builder builder() {
        return new Builder(8);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new SmallTagIterator();
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"}, justification="Only used from the builder")
    SmallTagMap(Object[] data, int dataLength) {
        this.data = data;
        this.dataLength = dataLength;
    }

    private int hash(String k) {
        int capacity = this.data.length / 2;
        long posHashcode = Math.abs((long)k.hashCode());
        return (int)(posHashcode % (long)capacity);
    }

    public Tag get(String key) {
        int capacity = this.data.length / 2;
        int pos = this.hash(key);
        int i = pos;
        if (!key.equals(this.data[i * 2])) {
            i = (i + 1) % capacity;
            while (!key.equals(this.data[i * 2]) && i != pos) {
                i = (i + 1) % capacity;
            }
        }
        return key.equals(this.data[i * 2]) ? (Tag)this.data[i * 2 + 1] : null;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int hc = 0;
            for (int i = 1; i < this.data.length; i += 2) {
                Object o = this.data[i];
                if (o == null) continue;
                hc += o.hashCode();
            }
            this.cachedHashCode = hc;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "SmallTagMap{" + Strings.join(",", this.iterator()) + "}";
    }

    public boolean containsKey(String k) {
        return this.get(k) != null;
    }

    public boolean isEmpty() {
        return this.dataLength == 0;
    }

    public int size() {
        return this.dataLength;
    }

    public Set<Tag> tagSet() {
        if (this.entrySet == null) {
            this.entrySet = new HashSet<Tag>(this.dataLength);
            for (int i = 1; i < this.data.length; i += 2) {
                Object o = this.data[i];
                if (o == null) continue;
                this.entrySet.add((Tag)o);
            }
        }
        return this.entrySet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SmallTagMap)) {
            return false;
        }
        SmallTagMap that = (SmallTagMap)obj;
        return that.dataLength == this.dataLength && this.tagSet().equals(that.tagSet());
    }

    private class SmallTagIterator
    implements Iterator<Tag> {
        private int i = 0;
        private int pos = 0;

        private SmallTagIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < SmallTagMap.this.dataLength;
        }

        @Override
        public Tag next() {
            while (this.pos < SmallTagMap.this.data.length && SmallTagMap.this.data[this.pos] == null) {
                this.pos += 2;
            }
            if (this.pos >= SmallTagMap.this.data.length) {
                throw new NoSuchElementException();
            }
            Tag result = (Tag)SmallTagMap.this.data[this.pos + 1];
            this.pos += 2;
            ++this.i;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SmallTagMaps are immutable");
        }
    }

    public static class Builder {
        private int actualSize = 0;
        private int size;
        private Object[] buf;

        private void init(int size) {
            this.size = size;
            this.buf = new Object[size * 2];
            this.actualSize = 0;
        }

        public Builder(int size) {
            this.init(size);
        }

        public int size() {
            return this.actualSize;
        }

        public boolean isEmpty() {
            return this.actualSize == 0;
        }

        private void resizeIfPossible(Tag tag) {
            if (this.size < 32) {
                Object[] prevBuf = this.buf;
                this.init(this.size * 2);
                for (int i = 1; i < prevBuf.length; i += 2) {
                    Tag t = (Tag)prevBuf[i];
                    if (t == null) continue;
                    this.add(t);
                }
                this.add(tag);
            } else {
                String msg = String.format("Cannot add Tag %s - Maximum number of tags (%d) reached.", tag, 32);
                LOGGER.error(msg);
            }
        }

        public Builder add(Tag tag) {
            int pos;
            String k = tag.getKey();
            int i = pos = (int)(Math.abs((long)k.hashCode()) % (long)this.size);
            Object ki = this.buf[i * 2];
            while (ki != null && !ki.equals(k)) {
                if ((i = (i + 1) % this.size) == pos) {
                    this.resizeIfPossible(tag);
                    return this;
                }
                ki = this.buf[i * 2];
            }
            if (ki != null) {
                this.buf[i * 2] = k;
                this.buf[i * 2 + 1] = tag;
            } else {
                if (this.buf[i * 2] != null) {
                    throw new IllegalStateException("position has already been filled");
                }
                this.buf[i * 2] = k;
                this.buf[i * 2 + 1] = tag;
                ++this.actualSize;
            }
            return this;
        }

        public Builder addAll(Iterable<Tag> tags) {
            for (Tag tag : tags) {
                this.add(tag);
            }
            return this;
        }

        public SmallTagMap result() {
            return new SmallTagMap(this.buf, this.actualSize);
        }
    }
}

