# Generated by Django 4.0.5 on 2022-09-27 23:01

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0022_remove_plancomponent_cost_per_metric_and_more"),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name="billablemetric",
            name="unique_with_property_name",
        ),
        migrations.RemoveConstraint(
            model_name="billablemetric",
            name="unique_without_property_name",
        ),
        migrations.RenameField(
            model_name="plancomponent",
            old_name="free_metric_quantity",
            new_name="free_metric_units",
        ),
        migrations.RemoveField(
            model_name="billablemetric",
            name="carries_over",
        ),
        migrations.RemoveField(
            model_name="billablemetric",
            name="stateful_freq_num",
        ),
        migrations.RemoveField(
            model_name="billablemetric",
            name="stateful_freq_unit",
        ),
        migrations.AddField(
            model_name="billablemetric",
            name="stateful_aggregation_period",
            field=models.CharField(
                blank=True,
                choices=[("day", "Day"), ("hour", "Hour")],
                max_length=20,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="billablemetric",
            name="aggregation_type",
            field=models.CharField(
                choices=[
                    ("count", "Count"),
                    ("sum", "Sum"),
                    ("max", "Max"),
                    ("unique", "Unique"),
                    ("last", "Last"),
                ],
                default="count",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="billablemetric",
            name="billable_metric_name",
            field=models.CharField(blank=True, default="", max_length=200),
        ),
        migrations.AddConstraint(
            model_name="billablemetric",
            constraint=models.UniqueConstraint(
                fields=(
                    "organization",
                    "event_name",
                    "aggregation_type",
                    "property_name",
                    "event_type",
                    "stateful_aggregation_period",
                ),
                name="unique_with_property_name_and_sap",
            ),
        ),
        migrations.AddConstraint(
            model_name="billablemetric",
            constraint=models.UniqueConstraint(
                condition=models.Q(("property_name", None)),
                fields=(
                    "organization",
                    "event_name",
                    "aggregation_type",
                    "event_type",
                    "stateful_aggregation_period",
                ),
                name="unique_without_property_name_with_sap",
            ),
        ),
        migrations.AddConstraint(
            model_name="billablemetric",
            constraint=models.UniqueConstraint(
                condition=models.Q(("stateful_aggregation_period", None)),
                fields=(
                    "organization",
                    "event_name",
                    "aggregation_type",
                    "event_type",
                    "property_name",
                ),
                name="unique_with_property_name_without_sap",
            ),
        ),
        migrations.AddConstraint(
            model_name="billablemetric",
            constraint=models.UniqueConstraint(
                condition=models.Q(
                    ("stateful_aggregation_period", None), ("property_name", None)
                ),
                fields=("organization", "event_name", "aggregation_type", "event_type"),
                name="unique_without_property_name_without_sap",
            ),
        ),
    ]
