# Generated by Django 4.0.5 on 2022-10-13 03:34

import datetime
import uuid

import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        (
            "metering_billing",
            "0041_rename_payment_provider_ids_customer_payment_providers_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="Backtest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("backtest_name", models.CharField(max_length=100)),
                ("start_date", models.DateField()),
                ("end_date", models.DateField()),
                ("time_created", models.DateTimeField(default=datetime.datetime.now)),
                (
                    "backtest_id",
                    models.CharField(
                        blank=True, default=uuid.uuid4, max_length=100, unique=True
                    ),
                ),
                ("kpis", models.JSONField(default=list)),
                (
                    "backtest_results",
                    models.JSONField(blank=True, default=dict, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("running", "Running"), ("completed", "Completed")],
                        default="running",
                        max_length=40,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="backtests",
                        to="metering_billing.organization",
                    ),
                ),
            ],
        ),
        migrations.RemoveField(
            model_name="customer",
            name="billing_address",
        ),
        migrations.RemoveField(
            model_name="historicalcustomer",
            name="billing_address",
        ),
        migrations.AlterField(
            model_name="alert",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alerts",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="billablemetric",
            name="aggregation_type",
            field=models.CharField(
                choices=[
                    ("count", "Count"),
                    ("sum", "Sum"),
                    ("max", "Max"),
                    ("min", "Min"),
                    ("unique", "Unique"),
                    ("latest", "Latest"),
                    ("average", "Average"),
                ],
                default="count",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="billablemetric",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="billable_metrics",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="billingplan",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="billing_plans",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="customer_id",
            field=models.CharField(blank=True, default=uuid.uuid4, max_length=40),
        ),
        migrations.AlterField(
            model_name="customer",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="customers",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="customer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="features",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbillablemetric",
            name="aggregation_type",
            field=models.CharField(
                choices=[
                    ("count", "Count"),
                    ("sum", "Sum"),
                    ("max", "Max"),
                    ("min", "Min"),
                    ("unique", "Unique"),
                    ("latest", "Latest"),
                    ("average", "Average"),
                ],
                default="count",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_id",
            field=models.CharField(blank=True, default=uuid.uuid4, max_length=40),
        ),
        migrations.AlterField(
            model_name="plancomponent",
            name="billable_metric",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.billablemetric",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="auto_renew_billing_plan",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.billingplan",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="billing_plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscriptions",
                to="metering_billing.billingplan",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="customer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscriptions",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscriptions",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="users",
                to="metering_billing.organization",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalBacktestSubstitution",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "backtest",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.backtest",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "new_plan",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.billingplan",
                    ),
                ),
                (
                    "old_plan",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.billingplan",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical backtest substitution",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBacktest",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("backtest_name", models.CharField(max_length=100)),
                ("start_date", models.DateField()),
                ("end_date", models.DateField()),
                ("time_created", models.DateTimeField(default=datetime.datetime.now)),
                (
                    "backtest_id",
                    models.CharField(
                        blank=True, db_index=True, default=uuid.uuid4, max_length=100
                    ),
                ),
                ("kpis", models.JSONField(default=list)),
                (
                    "backtest_results",
                    models.JSONField(blank=True, default=dict, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("running", "Running"), ("completed", "Completed")],
                        default="running",
                        max_length=40,
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical backtest",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="BacktestSubstitution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "backtest",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="substitutions",
                        to="metering_billing.backtest",
                    ),
                ),
                (
                    "new_plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="metering_billing.billingplan",
                    ),
                ),
                (
                    "old_plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="metering_billing.billingplan",
                    ),
                ),
            ],
        ),
    ]
