# Generated by Django 4.0.5 on 2022-11-03 03:35

import uuid

import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0060_rename_name_customer_customer_name_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="OrganizationSetting",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "setting_id",
                    models.CharField(default=uuid.uuid4, max_length=100, unique=True),
                ),
                ("setting_name", models.CharField(max_length=100)),
                ("setting_value", models.CharField(max_length=100)),
                (
                    "setting_group",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="org_settings",
                        to="metering_billing.organization",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalOrganizationSetting",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "setting_id",
                    models.CharField(db_index=True, default=uuid.uuid4, max_length=100),
                ),
                ("setting_name", models.CharField(max_length=100)),
                ("setting_value", models.CharField(max_length=100)),
                (
                    "setting_group",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical organization setting",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="ExternalPlanLink",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "source",
                    models.CharField(choices=[("stripe", "Stripe")], max_length=40),
                ),
                ("external_plan_id", models.CharField(max_length=100)),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="org_external_plan_links",
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="external_links",
                        to="metering_billing.plan",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="organizationsetting",
            constraint=models.UniqueConstraint(
                fields=("organization", "setting_name", "setting_group"),
                name="unique_with_group",
            ),
        ),
        migrations.AddConstraint(
            model_name="organizationsetting",
            constraint=models.UniqueConstraint(
                condition=models.Q(("setting_group", None)),
                fields=("organization", "setting_name"),
                name="unique_without_group",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="organizationsetting",
            unique_together={("organization", "setting_name")},
        ),
        migrations.AlterUniqueTogether(
            name="externalplanlink",
            unique_together={("organization", "source", "external_plan_id")},
        ),
    ]
