# Generated by Django 4.0.5 on 2022-11-29 04:59

import django.db.models.deletion
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0089_alter_metric_unique_together"),
    ]

    operations = [
        migrations.CreateModel(
            name="WebhookEndpoint",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "webhook_endpoint_id",
                    models.CharField(
                        default=metering_billing.utils.utils.webhook_endpoint_uuid,
                        max_length=100,
                        unique=True,
                    ),
                ),
                ("name", models.CharField(default=" ", max_length=100)),
                ("webhook_url", models.CharField(max_length=300)),
                (
                    "webhook_secret",
                    models.CharField(
                        default=metering_billing.utils.utils.webhook_secret_uuid,
                        max_length=100,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="org_alerts",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "unique_together": {("organization", "webhook_url")},
            },
        ),
        migrations.CreateModel(
            name="WebhookTrigger",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "trigger_name",
                    models.CharField(
                        choices=[("invoice.created", "invoice.created")], max_length=40
                    ),
                ),
                (
                    "webhook_endpoint",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="triggers",
                        to="metering_billing.webhookendpoint",
                    ),
                ),
            ],
        ),
        migrations.RemoveField(
            model_name="historicalalert",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalalert",
            name="organization",
        ),
        migrations.DeleteModel(
            name="Alert",
        ),
        migrations.DeleteModel(
            name="HistoricalAlert",
        ),
    ]
