# Generated by Django 4.0.5 on 2022-12-14 21:05

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0118_alter_pricingunit_unique_together_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="customer",
            name="customer_id",
            field=models.CharField(
                default=metering_billing.utils.utils.customer_uuid,
                help_text="The id provided when creating the customer, we suggest matching with your internal customer id in your backend",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="customer_name",
            field=models.CharField(
                blank=True,
                help_text="The display name of the customer",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="default_currency",
            field=models.ForeignKey(
                blank=True,
                help_text="The currency the customer will be invoiced in",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="email",
            field=models.EmailField(
                blank=True,
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata for the customer",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="customerbalanceadjustment",
            name="pricing_unit",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="event_name",
            field=models.CharField(
                help_text="String name of the event, corresponds to definition in metrics",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="idempotency_id",
            field=models.CharField(
                default=metering_billing.utils.utils.event_uuid,
                help_text="A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. You can use the same idempotency_id again after 7 days",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="time_created",
            field=models.DateTimeField(
                help_text="The time that the event occured, represented as a datetime in ISO 8601 in the UTC timezome."
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_id",
            field=models.CharField(
                default=metering_billing.utils.utils.customer_uuid,
                help_text="The id provided when creating the customer, we suggest matching with your internal customer id in your backend",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_name",
            field=models.CharField(
                blank=True,
                help_text="The display name of the customer",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="default_currency",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The currency the customer will be invoiced in",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="email",
            field=models.EmailField(
                blank=True,
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata for the customer",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="subscription",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="invoices",
                to="metering_billing.subscription",
            ),
        ),
        migrations.AlterField(
            model_name="invoicelineitem",
            name="associated_subscription_record",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="line_items",
                to="metering_billing.subscriptionrecord",
            ),
        ),
        migrations.AlterField(
            model_name="invoicelineitem",
            name="pricing_unit",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="default_currency",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="created_plans",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="display_version",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="parent_plan",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="child_plans",
                to="metering_billing.plan",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="target_customer",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="custom_plans",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="plancomponent",
            name="pricing_unit",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="created_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="created_plan_versions",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="price_adjustment",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="metering_billing.priceadjustment",
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="pricing_unit",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="replace_with",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="transition_to",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="transition_from",
                to="metering_billing.plan",
            ),
        ),
    ]
