# Generated by Django 4.0.5 on 2022-12-19 20:08

from decimal import Decimal

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0129_auto_20221219_2004"),
    ]

    operations = [
        migrations.RemoveConstraint(
            model_name="customer",
            name="unique_email",
        ),
        migrations.RemoveConstraint(
            model_name="metric",
            name="unique_org_billable_metric_name",
        ),
        migrations.AlterField(
            model_name="backtest",
            name="backtest_id",
            field=models.CharField(
                default=metering_billing.utils.utils.backtest_uuid,
                max_length=100,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="backtest",
            name="backtest_results",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name="customer",
            name="email",
            field=models.EmailField(
                default="test@email.com",
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="customer",
            name="integrations",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name="customer",
            name="properties",
            field=models.JSONField(
                default=dict, help_text="Extra metadata for the customer", null=True
            ),
        ),
        migrations.AlterField(
            model_name="custompricingunitconversion",
            name="from_qty",
            field=models.DecimalField(
                decimal_places=10,
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="custompricingunitconversion",
            name="to_qty",
            field=models.DecimalField(
                decimal_places=10,
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="feature_description",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="feature",
            name="feature_name",
            field=models.CharField(max_length=50),
        ),
        migrations.AlterField(
            model_name="historicalbacktest",
            name="backtest_id",
            field=models.CharField(
                db_index=True,
                default=metering_billing.utils.utils.backtest_uuid,
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="historicalbacktest",
            name="backtest_results",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="email",
            field=models.EmailField(
                default="test@email.com",
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="integrations",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="properties",
            field=models.JSONField(
                default=dict, help_text="Extra metadata for the customer", null=True
            ),
        ),
        migrations.AlterField(
            model_name="historicalinvoice",
            name="cost_due",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="historicalinvoice",
            name="external_payment_obj_id",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name="historicalinvoice",
            name="invoice_number",
            field=models.CharField(max_length=13),
        ),
        migrations.AlterField(
            model_name="historicalinvoice",
            name="payment_status",
            field=models.CharField(
                choices=[
                    ("draft", "Draft"),
                    ("voided", "Voided"),
                    ("paid", "Paid"),
                    ("unpaid", "Unpaid"),
                ],
                default="unpaid",
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="billable_metric_name",
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="event_name",
            field=models.CharField(
                help_text="Name of the event that this metric is tracking.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="event_type",
            field=models.CharField(
                blank=True,
                choices=[("delta", "Delta"), ("total", "Total")],
                default="total",
                help_text="Used only for metrics of type 'continuous'. Please refer to our documentation for an explanation of the different types.",
                max_length=20,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="granularity",
            field=models.CharField(
                blank=True,
                choices=[
                    ("seconds", "Second"),
                    ("minutes", "Minute"),
                    ("hours", "Hour"),
                    ("days", "Day"),
                    ("months", "Month"),
                    ("quarters", "Quarter"),
                    ("years", "Year"),
                    ("total", "Total"),
                ],
                default="total",
                help_text="The granularity of the metric. Only applies to metrics of type 'continuous' or 'rate'.",
                max_length=10,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="is_cost_metric",
            field=models.BooleanField(
                default=False,
                help_text="Whether or not this metric is a cost metric (used to track costs to your business).",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="metric_id",
            field=models.CharField(
                default=metering_billing.utils.utils.metric_uuid, max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="metric_type",
            field=models.CharField(
                choices=[
                    ("counter", "Counter"),
                    ("stateful", "Stateful"),
                    ("rate", "Rate"),
                ],
                default="counter",
                help_text="The type of metric that this is. Please refer to our documentation for an explanation of the different types.",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="property_name",
            field=models.CharField(
                blank=True,
                help_text="The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count.",
                max_length=50,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="usage_aggregation_type",
            field=models.CharField(
                choices=[
                    ("count", "Count"),
                    ("sum", "Sum"),
                    ("max", "Max"),
                    ("unique", "Unique"),
                    ("latest", "Latest"),
                    ("average", "Average"),
                ],
                default="count",
                help_text="The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="display_version",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The currently active version of the plan. Customers that get signed up for this plan will be assigned this version.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="parent_plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="If you are using our plan templating feature to create a new plan, this field will be set to the plan that you are using as a template.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.plan",
            ),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="parent_product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The product that this plan belongs to",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.product",
            ),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="plan_duration",
            field=models.CharField(
                choices=[
                    ("monthly", "Monthly"),
                    ("quarterly", "Quarterly"),
                    ("yearly", "Yearly"),
                ],
                help_text="Duration of the plan",
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="plan_name",
            field=models.CharField(help_text="Name of the plan", max_length=100),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="target_customer",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="If you are using our plan templating feature to create a new plan, this field will be set to the customer for which this plan is designed for. Keep in mind that this field and the parent_plan field are mutually necessary.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="historicalplanversion",
            name="description",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="historicalplanversion",
            name="flat_rate",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="auto_renew",
            field=models.BooleanField(
                default=True,
                help_text="Whether the subscription automatically renews. Defaults to true.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="billing_plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The plan associated with this subscription.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                related_query_name="subscription_record",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="customer",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The customer object associated with this subscription.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="end_date",
            field=models.DateTimeField(
                help_text="The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time."
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="fully_billed",
            field=models.BooleanField(
                default=False,
                help_text="Whether the subscription has been fully billed and finalized.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="is_new",
            field=models.BooleanField(
                default=True,
                help_text="Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="start_date",
            field=models.DateTimeField(
                help_text="The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time."
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="subscription_record_id",
            field=models.CharField(
                default=metering_billing.utils.utils.subscription_record_uuid,
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="cost_due",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="external_payment_obj_id",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="invoice_number",
            field=models.CharField(max_length=13),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="payment_status",
            field=models.CharField(
                choices=[
                    ("draft", "Draft"),
                    ("voided", "Voided"),
                    ("paid", "Paid"),
                    ("unpaid", "Unpaid"),
                ],
                default="unpaid",
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="invoicelineitem",
            name="name",
            field=models.CharField(max_length=100),
        ),
        migrations.AlterField(
            model_name="invoicelineitem",
            name="quantity",
            field=models.DecimalField(
                blank=True,
                decimal_places=10,
                max_digits=20,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="billable_metric_name",
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AlterField(
            model_name="metric",
            name="event_name",
            field=models.CharField(
                help_text="Name of the event that this metric is tracking.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="event_type",
            field=models.CharField(
                blank=True,
                choices=[("delta", "Delta"), ("total", "Total")],
                default="total",
                help_text="Used only for metrics of type 'continuous'. Please refer to our documentation for an explanation of the different types.",
                max_length=20,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="granularity",
            field=models.CharField(
                blank=True,
                choices=[
                    ("seconds", "Second"),
                    ("minutes", "Minute"),
                    ("hours", "Hour"),
                    ("days", "Day"),
                    ("months", "Month"),
                    ("quarters", "Quarter"),
                    ("years", "Year"),
                    ("total", "Total"),
                ],
                default="total",
                help_text="The granularity of the metric. Only applies to metrics of type 'continuous' or 'rate'.",
                max_length=10,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="is_cost_metric",
            field=models.BooleanField(
                default=False,
                help_text="Whether or not this metric is a cost metric (used to track costs to your business).",
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="metric_id",
            field=models.CharField(
                default=metering_billing.utils.utils.metric_uuid, max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="metric_type",
            field=models.CharField(
                choices=[
                    ("counter", "Counter"),
                    ("stateful", "Stateful"),
                    ("rate", "Rate"),
                ],
                default="counter",
                help_text="The type of metric that this is. Please refer to our documentation for an explanation of the different types.",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="property_name",
            field=models.CharField(
                blank=True,
                help_text="The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count.",
                max_length=50,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="metric",
            name="usage_aggregation_type",
            field=models.CharField(
                choices=[
                    ("count", "Count"),
                    ("sum", "Sum"),
                    ("max", "Max"),
                    ("unique", "Unique"),
                    ("latest", "Latest"),
                    ("average", "Average"),
                ],
                default="count",
                help_text="The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="display_version",
            field=models.ForeignKey(
                blank=True,
                help_text="The currently active version of the plan. Customers that get signed up for this plan will be assigned this version.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="parent_plan",
            field=models.ForeignKey(
                blank=True,
                help_text="If you are using our plan templating feature to create a new plan, this field will be set to the plan that you are using as a template.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="child_plans",
                to="metering_billing.plan",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="parent_product",
            field=models.ForeignKey(
                blank=True,
                help_text="The product that this plan belongs to",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="product_plans",
                to="metering_billing.product",
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="plan_duration",
            field=models.CharField(
                choices=[
                    ("monthly", "Monthly"),
                    ("quarterly", "Quarterly"),
                    ("yearly", "Yearly"),
                ],
                help_text="Duration of the plan",
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="plan",
            name="plan_name",
            field=models.CharField(help_text="Name of the plan", max_length=100),
        ),
        migrations.AlterField(
            model_name="plan",
            name="target_customer",
            field=models.ForeignKey(
                blank=True,
                help_text="If you are using our plan templating feature to create a new plan, this field will be set to the customer for which this plan is designed for. Keep in mind that this field and the parent_plan field are mutually necessary.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="custom_plans",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="description",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="planversion",
            name="flat_rate",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="priceadjustment",
            name="price_adjustment_description",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="priceadjustment",
            name="price_adjustment_name",
            field=models.CharField(max_length=100),
        ),
        migrations.AlterField(
            model_name="pricetier",
            name="cost_per_batch",
            field=models.DecimalField(
                blank=True,
                decimal_places=10,
                max_digits=20,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="pricetier",
            name="metric_units_per_batch",
            field=models.DecimalField(
                blank=True,
                decimal_places=10,
                default=1.0,
                max_digits=20,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="pricetier",
            name="range_end",
            field=models.DecimalField(
                blank=True,
                decimal_places=10,
                max_digits=20,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="pricetier",
            name="range_start",
            field=models.DecimalField(
                decimal_places=10,
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="pricingunit",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="pricing_units",
                to="metering_billing.organization",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="subscription_id",
            field=models.CharField(
                default=metering_billing.utils.utils.subscription_uuid, max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="auto_renew",
            field=models.BooleanField(
                default=True,
                help_text="Whether the subscription automatically renews. Defaults to true.",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="billing_plan",
            field=models.ForeignKey(
                help_text="The plan associated with this subscription.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscription_records",
                related_query_name="subscription_record",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="customer",
            field=models.ForeignKey(
                help_text="The customer object associated with this subscription.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscription_records",
                to="metering_billing.customer",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="end_date",
            field=models.DateTimeField(
                help_text="The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time."
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="filters",
            field=models.ManyToManyField(
                blank=True,
                help_text="Add filter key, value pairs that define which events will be applied to this plan subscription.",
                to="metering_billing.categoricalfilter",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="fully_billed",
            field=models.BooleanField(
                default=False,
                help_text="Whether the subscription has been fully billed and finalized.",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="is_new",
            field=models.BooleanField(
                default=True,
                help_text="Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.",
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="start_date",
            field=models.DateTimeField(
                help_text="The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time."
            ),
        ),
        migrations.AlterField(
            model_name="subscriptionrecord",
            name="subscription_record_id",
            field=models.CharField(
                default=metering_billing.utils.utils.subscription_record_uuid,
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="webhookendpoint",
            name="name",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name="webhookendpoint",
            name="webhook_url",
            field=models.CharField(max_length=100),
        ),
    ]
