# Generated by Django 4.0.5 on 2023-01-08 04:48

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0140_alter_externalplanlink_unique_together_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="Team",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name="TeamInviteToken",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email", models.EmailField(max_length=254)),
                ("token", models.SlugField(default=uuid.uuid4, max_length=250)),
                (
                    "expire_at",
                    models.DateTimeField(
                        default=metering_billing.utils.utils.now_plus_day
                    ),
                ),
                (
                    "team",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="team_invite_token",
                        to="metering_billing.team",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_invite_token",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.RemoveField(
            model_name="historicalorganization",
            name="is_demo",
        ),
        migrations.RemoveField(
            model_name="organization",
            name="is_demo",
        ),
        migrations.AddField(
            model_name="historicalorganization",
            name="organization_type",
            field=models.PositiveSmallIntegerField(
                choices=[
                    (1, "Production"),
                    (2, "Development"),
                    (3, "Demo"),
                    (4, "Internal Demo"),
                ],
                default=2,
            ),
        ),
        migrations.AddField(
            model_name="organization",
            name="organization_type",
            field=models.PositiveSmallIntegerField(
                choices=[
                    (1, "Production"),
                    (2, "Development"),
                    (3, "Demo"),
                    (4, "Internal Demo"),
                ],
                default=2,
            ),
        ),
        migrations.DeleteModel(
            name="OrganizationInviteToken",
        ),
        migrations.AddField(
            model_name="historicalorganization",
            name="team",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.team",
            ),
        ),
        migrations.AddField(
            model_name="historicaluser",
            name="team",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.team",
            ),
        ),
        migrations.AddField(
            model_name="organization",
            name="team",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="organizations",
                to="metering_billing.team",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="team",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="users",
                to="metering_billing.team",
            ),
        ),
    ]
