# Generated by Django 4.0.5 on 2023-01-08 20:18

from django.db import migrations


def transfer_component_granularity_to_metric(apps, schema_editor):
    Metric = apps.get_model("metering_billing", "Metric")
    for metric in Metric.objects.all():
        if metric.metric_type == "stateful":
            metric.metric_type = "gauge"
            metric.save()


def reverse_transfer_component_granularity_to_metric(apps, schema_editor):
    Metric = apps.get_model("metering_billing", "Metric")
    for metric in Metric.objects.all():
        if metric.metric_type == "gauge":
            metric.metric_type = "stateful"
            metric.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0142_alter_historicalmetric_event_type_and_more"),
    ]

    operations = [
        migrations.RunPython(
            transfer_component_granularity_to_metric,
            reverse_transfer_component_granularity_to_metric,
        ),
    ]
