# Generated by Django 4.0.5 on 2023-01-09 19:57

import django.db.models.deletion
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        (
            "metering_billing",
            "0145_remove_historicalorganizationsetting_setting_value_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="UsageAlert",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "usage_alert_id",
                    models.SlugField(
                        default=metering_billing.utils.utils.usage_alert_uuid
                    ),
                ),
                ("threshold", models.DecimalField(decimal_places=10, max_digits=20)),
                (
                    "metric",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usage_alerts",
                        to="metering_billing.metric",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usage_alerts",
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "plan_version",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usage_alerts",
                        to="metering_billing.planversion",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="webhooktrigger",
            name="trigger_name",
            field=models.CharField(
                choices=[
                    ("invoice.created", "invoice.created"),
                    ("invoice.paid", "invoice.paid"),
                    ("usage_alert.triggered", "usage_alert.triggered"),
                ],
                max_length=40,
            ),
        ),
        migrations.CreateModel(
            name="UsageAlertResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "last_run_value",
                    models.DecimalField(decimal_places=10, max_digits=20),
                ),
                (
                    "last_run_timestamp",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                ("triggered_count", models.PositiveIntegerField(default=0)),
                (
                    "alert",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alert_results",
                        to="metering_billing.usagealert",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alert_results",
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "subscription_record",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alert_results",
                        to="metering_billing.subscriptionrecord",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="usagealertresult",
            constraint=models.UniqueConstraint(
                fields=("organization", "alert", "subscription_record"),
                name="unique_alert_result_per_org",
            ),
        ),
        migrations.AddConstraint(
            model_name="usagealert",
            constraint=models.UniqueConstraint(
                fields=("organization", "usage_alert_id"),
                name="unique_alert_id_per_org",
            ),
        ),
    ]
