---
title: Getting started with .NET Core
description: Getting started with .NET Core
keywords: .NET, .NET Core
author: mairaw
manager: wpickett
ms.date: 06/20/2016
ms.topic: article
ms.prod: .net-core
ms.technology: .net-core-technologies
ms.devlang: dotnet
ms.assetid: d1453a0d-317c-4da6-b68e-422a2c0bfe49
---

# Getting started with .NET Core

.NET Core runs on [Windows](#windows), [Linux](#linux), and [macOS / OS X](#macos)

## Windows

Install .NET Core on [Windows](https://www.microsoft.com/net/core#windows). 

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Getting started with .NET Core on Windows, using Visual Studio 2015](tutorials/using-on-windows.md) - Use [Visual Studio](https://www.visualstudio.com/), the full-featured integrated development environment (IDE) for Windows.  
* [Getting started with .NET Core on macOS, using Visual Studio Code](tutorials/using-on-macos.md) - Use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor. This tutorial is written for macOS, but Visual Studio Code also works on Windows.
* [Getting started with .NET Core using the command line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).

.NET Core is supported by the following versions of Windows (both 32-bit and 64-bit):

* Windows 7 SP1
* Windows 8.1
* Windows 10
* Windows Server 2008 R2 SP1 (Full Server or Server Core)
* Windows Server 2012 SP1 (Full Server or Server Core)
* Windows Server 2012 R2 SP1 (Full Server or Server Core)
* Windows Server 2016 (Full Server, Server Core or Nano Server)

## Linux

Install Linux on your distribution/version:

* [Red Hat Enterprise Linux 7 Server](https://www.microsoft.com/net/core#redhat)
* [Ubuntu 14.04, 16.04 & Linux Mint 17](https://www.microsoft.com/net/core#ubuntu)
* [Debian 8.2](https://www.microsoft.com/net/core#debian)
* [Fedora 23](https://www.microsoft.com/net/core#fedora)
* [CentOS 7.1 & Oracle Linux 7.1](https://www.microsoft.com/net/core#centos)
* [openSUSE 13.2](https://www.microsoft.com/net/core#opensuse)

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Getting started with .NET Core on macOS, using Visual Studio Code](tutorials/using-on-macos.md) - Use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor. This tutorial is written for macOS, but Visual Studio Code also works on Linux. 
* [Getting started with .NET Core using the command line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).

.NET Core is supported by the Linux distributions and versions listed above in the installation links.

<a name="macos"></a>
## OS X / macOS

Install .NET Core for [Mac OS X 10.11](https://www.microsoft.com/net/core#macos).

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Getting started with .NET Core on macOS, using Visual Studio Code](tutorials/using-on-macos.md) - Use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor.  
* [Getting started with .NET Core using the command line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).

.NET Core is supported by 64-bit OS X 10.11 (El Capitan). It isn't yet supported by macOS Sierra, but will be soon.
