---
title: Arithmetic Operators (F#)
description: Arithmetic Operators (F#)
keywords: visual f#, f#, functional programming
author: dend
manager: danielfe
ms.date: 05/16/2016
ms.topic: language-reference
ms.prod: visual-studio-dev14
ms.technology: devlang-fsharp
ms.assetid: 75ddcfa3-564e-4382-80a3-f9da73d0f0ea 
---

# Arithmetic Operators

This topic describes arithmetic operators that are available in the F# language.

## Summary of Binary Arithmetic Operators
The following table summarizes the binary arithmetic operators that are available for unboxed integral and floating-point types.

|Binary operator|Notes|
|---------------|-----|
|`+` (addition, plus)|Unchecked. Possible overflow condition when numbers are added together and the sum exceeds the maximum absolute value supported by the type.|
|`-` (subtraction, minus)|Unchecked. Possible underflow condition when unsigned types are subtracted, or when floating-point values are too small to be represented by the type.|
|`*` (multiplication, times)|Unchecked. Possible overflow condition when numbers are multiplied and the product exceeds the maximum absolute value supported by the type.|
|`/` (division, divided by)|Division by zero causes a [DivideByZeroException](https://msdn.microsoft.com/library/system.dividebyzeroexception.aspx) for integral types. For floating-point types, division by zero gives you the special floating-point values `+Infinity` or `-Infinity`. There is also a possible underflow condition when a floating-point number is too small to be represented by the type.|
|`%` (modulus, mod)|Returns the remainder of a division operation. The sign of the result is the same as the sign of the first operand.|
|`**` (exponentiation, to the power of)|Possible overflow condition when the result exceeds the maximum absolute value for the type.<br /><br />The exponentiation operator works only with floating-point types.|

## Summary of Unary Arithmetic Operators
The following table summarizes the unary arithmetic operators that are available for integral and floating-point types.


|Unary operator|Notes|
|--------------|-----|
|`+` (positive)|Can be applied to any arithmetic expression. Does not change the sign of the value.|
|`-` (negation, negative)|Can be applied to any arithmetic expression. Changes the sign of the value.|
The behavior at overflow or underflow for integral types is to wrap around. This causes an incorrect result. Integer overflow is a potentially serious problem that can contribute to security issues when software is not written to account for it. If this is a concern for your application, consider using the checked operators in `Microsoft.FSharp.Core.Operators.Checked`.


## Summary of Binary Comparison Operators
The following table shows the binary comparison operators that are available for integral and floating-point types. These operators return values of type `bool`.

Floating-point numbers should never be directly compared for equality, because the IEEE floating-point representation does not support an exact equality operation. Two numbers that you can easily verify to be equal by inspecting the code might actually have different bit representations.



|Operator|Notes|
|--------|-----|
|`=` (equality, equals)|This is not an assignment operator. It is used only for comparison. This is a generic operator.|
|`>` (greater than)|This is a generic operator.|
|`<` (less than)|This is a generic operator.|
|`>=` (greater than or equals)|This is a generic operator.|
|`<=` (less than or equals)|This is a generic operator.|
|`<>` (not equal)|This is a generic operator.|

## Overloaded and Generic Operators
All of the operators discussed in this topic are defined in the **Microsoft.FSharp.Core.Operators** namespace. Some of the operators are defined by using statically resolved type parameters. This means that there are individual definitions for each specific type that works with that operator. All of the unary and binary arithmetic and bitwise operators are in this category. The comparison operators are generic and therefore work with any type, not just primitive arithmetic types. Discriminated union and record types have their own custom implementations that are generated by the F# compiler. Class types use the method [Equals](https://msdn.microsoft.com/library/bsc2ak47.aspx).

The generic operators are customizable. To customize the comparison functions, override [Equals](https://msdn.microsoft.com/library/bsc2ak47.aspx) to provide your own custom equality comparison, and then implement [IComparable](https://msdn.microsoft.com/library/system.icomparable.aspx). The [System.IComparable](https://msdn.microsoft.com/library/system.icomparable.aspx) interface has a single method, the [CompareTo](https://msdn.microsoft.com/library/system.icomparable.compareto.aspx) method.


## Operators and Type Inference
The use of an operator in an expression constrains type inference on that operator. Also, the use of operators prevents automatic generalization, because the use of operators implies an arithmetic type. In the absence of any other information, the F# compiler infers `int` as the type of arithmetic expressions. You can override this behavior by specifying another type. Thus the argument types and return type of `function1` in the following code are inferred to be `int`, but the types for `function2` are inferred to be `float`.

[!code-fsharp[Main](../../../../samples/snippets/fsharp/lang-ref-1/snippet3501.fs)]
    
## See Also
[Symbol and Operator Reference](index.md)

[Operator Overloading](../operator-overloading.md)

[Bitwise Operators](bitwise-operators.md)

[Boolean Operators](boolean-operators.md)