Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.InheritBaseModel("2b131234-7959-458d-834f-2dc0769ce683"), Microsoft.VisualStudio.Modeling.InheritBaseModel("be20b98c-bf95-4e41-96a9-f8f38b7e0c35"), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuidString, "DesignerDefinitionObjectModel")>
	Partial Public Class DesignerDefinitionObjectModel
		Inherits Microsoft.VisualStudio.Modeling.SubStore
		#Region "DesignerDefinitionObjectModel's Generated MetaClass Code"
		''' <summary>
		''' MetaModel Guid String
		''' </summary>
		Public Const MetaModelGuidString As System.String = "d6d72f16-7925-493b-b393-5b60c29c589d"
		''' <summary>
		''' MetaModel Guid
		''' </summary>
		Public Shared ReadOnly MetaModelGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuidString)
		''' <summary>
		''' Default Constructor called by the IMS -- do not call directly
		''' </summary>
		Public Sub New()
			MyBase.New()
		End Sub
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store)
			MyBase.New(store.DefaultPartition, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuid)
		End Sub
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition)
			MyBase.New(partition, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.MetaModelGuid)
		End Sub
		#End Region

	End Class
	#Region "DesignerDefinitionObjectModel's ResourceManager Code"
	Partial Public Class DesignerDefinitionObjectModel
'INSTANT VB NOTE: The variable resourceManager was renamed since Visual Basic does not allow class members with the same name:
		Private Shared resourceManager_Renamed As System.Resources.ResourceManager = Nothing
		''' <summary>
		''' The base name of this models resources.
		''' </summary>
		Public Const ResourceBaseName As String = "Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel"
		''' <summary>
		''' Returns the SubStore's ResourceManager. If the ResourceManager does not already exist, then it is created.
		''' </summary>
		Public Overrides ReadOnly Property ResourceManager() As System.Resources.ResourceManager
			Get
				Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.SingletonResourceManager
			End Get
		End Property
		''' <summary>
		''' A internal object used for synchronization.
		''' </summary>
'INSTANT VB NOTE: The variable internalSyncObject was renamed since Visual Basic does not allow class members with the same name:
		Private Shared internalSyncObject_Renamed As Object
		''' <summary>
		''' Gets the internal object used for synchronization.
		''' </summary>
		Private Shared ReadOnly Property InternalSyncObject() As Object
			Get
				If internalSyncObject_Renamed Is Nothing Then
					Dim o As New Object()
					System.Threading.Interlocked.CompareExchange(internalSyncObject_Renamed, o, Nothing)
				End If
				Return internalSyncObject_Renamed
			End Get
		End Property
		''' <summary>
		''' Gets the Singleton ResourceManager for this SubStore
		''' </summary>
		Public Shared ReadOnly Property SingletonResourceManager() As System.Resources.ResourceManager
			Get
				If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager Is Nothing Then
					SyncLock Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.InternalSyncObject
						If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager Is Nothing Then
							Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager = New System.Resources.ResourceManager(ResourceBaseName, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel).Assembly)
						End If
					End SyncLock
				End If
				Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.resourceManager
			End Get
		End Property
	End Class
	#End Region
	''' <summary>
	''' Copy closure visitor filter
	''' </summary>
	<System.CLSCompliant(True), System.Serializable>
	Public NotInheritable Class ExampleACopyClosure
		Implements Microsoft.VisualStudio.Modeling.IElementVisitorFilter
		''' <summary>
		''' MetaRoles
		''' </summary>
		Private metaRolesMember As System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
'			#Region "Initialize MetaData Table"
'			#End Region
		End Sub
		''' <summary>
		''' Called to ask the filter if a particular relationship from a source element should be included in the traversal
		''' </summary>
		''' <param name="walker">ElementWalker traversing the model</param>
		''' <param name="sourceElement">Model Element playing the source role</param>
		''' <param name="sourceRoleInfo">MetaRoleInfo of the role that the source element is playing in the relationship</param>
		''' <param name="metaRelationshipInfo">MetaRelationshipInfo for the ElementLink in question</param>
		''' <param name="targetRelationship">Relationship in question</param>
		''' <returns>Yes if the relationship should be traversed</returns>
		Public Function ShouldVisitRelationship(ByVal walker As Microsoft.VisualStudio.Modeling.ElementWalker, ByVal sourceElement As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceRoleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo, ByVal metaRelationshipInfo As Microsoft.VisualStudio.Modeling.MetaRelationshipInfo, ByVal targetRelationship As Microsoft.VisualStudio.Modeling.ElementLink) As Microsoft.VisualStudio.Modeling.VisitorFilterResult
			Return If(Me.MetaRoles.ContainsKey(sourceRoleInfo.Id), Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes, Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare)
		End Function
		''' <summary>
		''' Called to ask the filter if a particular role player should be Visited during traversal
		''' </summary>
		''' <param name="walker">ElementWalker traversing the model</param>
		''' <param name="sourceElement">Model Element playing the source role</param>
		''' <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
		''' <param name="targetRoleInfo">MetaRoleInfo of the target role</param>
		''' <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
		''' <returns></returns>
		Public Function ShouldVisitRolePlayer(ByVal walker As Microsoft.VisualStudio.Modeling.ElementWalker, ByVal sourceElement As Microsoft.VisualStudio.Modeling.ModelElement, ByVal elementLink As Microsoft.VisualStudio.Modeling.ElementLink, ByVal targetRoleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo, ByVal targetRolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) As Microsoft.VisualStudio.Modeling.VisitorFilterResult
			For Each metaRoleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo In elementLink.MetaRelationship.MetaRoles
				If metaRoleInfo IsNot targetRoleInfo AndAlso Me.MetaRoles.ContainsKey(metaRoleInfo.Id) Then
					Return Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes
				End If
			Next metaRoleInfo
			Return Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare
		End Function
		''' <summary>
		''' MetaRoles
		''' </summary>
		Private ReadOnly Property MetaRoles() As System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)
			Get
				If Me.metaRolesMember Is Nothing Then
					Me.metaRolesMember = New System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)()
				End If
				Return Me.metaRolesMember
			End Get
		End Property

	End Class
	''' <summary>
	''' Remove closure visitor filter
	''' </summary>
	<System.CLSCompliant(True), System.Serializable>
	Public NotInheritable Class ExampleARemoveClosure
		Implements Microsoft.VisualStudio.Modeling.IElementVisitorFilter
		''' <summary>
		''' MetaRoles
		''' </summary>
		Private metaRolesMember As System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
'			#Region "Initialize MetaData Table"
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid)
			MetaRoles.Add(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid)
'			#End Region
		End Sub
		''' <summary>
		''' Called to ask the filter if a particular relationship from a source element should be included in the traversal
		''' </summary>
		''' <param name="walker">ElementWalker that is traversing the model</param>
		''' <param name="sourceElement">Model Element playing the source role</param>
		''' <param name="sourceRoleInfo">MetaRoleInfo of the role that the source element is playing in the relationship</param>
		''' <param name="metaRelationshipInfo">MetaRelationshipInfo for the ElementLink in question</param>
		''' <param name="targetRelationship">Relationship in question</param>
		''' <returns>Yes if the relationship should be traversed</returns>
		Public Function ShouldVisitRelationship(ByVal walker As Microsoft.VisualStudio.Modeling.ElementWalker, ByVal sourceElement As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceRoleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo, ByVal metaRelationshipInfo As Microsoft.VisualStudio.Modeling.MetaRelationshipInfo, ByVal targetRelationship As Microsoft.VisualStudio.Modeling.ElementLink) As Microsoft.VisualStudio.Modeling.VisitorFilterResult
			Return Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes
		End Function
		''' <summary>
		''' Called to ask the filter if a particular role player should be Visited during traversal
		''' </summary>
		''' <param name="walker">ElementWalker that is traversing the model</param>
		''' <param name="sourceElement">Model Element playing the source role</param>
		''' <param name="elementLink">Element Link that forms the relationship to the role player in question</param>
		''' <param name="targetRoleInfo">MetaRoleInfo of the target role</param>
		''' <param name="targetRolePlayer">Model Element that plays the target role in the relationship</param>
		''' <returns></returns>
		Public Function ShouldVisitRolePlayer(ByVal walker As Microsoft.VisualStudio.Modeling.ElementWalker, ByVal sourceElement As Microsoft.VisualStudio.Modeling.ModelElement, ByVal elementLink As Microsoft.VisualStudio.Modeling.ElementLink, ByVal targetRoleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo, ByVal targetRolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) As Microsoft.VisualStudio.Modeling.VisitorFilterResult
			Return If(Me.MetaRoles.ContainsKey(targetRoleInfo.Id), Microsoft.VisualStudio.Modeling.VisitorFilterResult.Yes, Microsoft.VisualStudio.Modeling.VisitorFilterResult.DoNotCare)
		End Function
		''' <summary>
		''' MetaRoles
		''' </summary>
		Private ReadOnly Property MetaRoles() As System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)
			Get
				If Me.metaRolesMember Is Nothing Then
					Me.metaRolesMember = New System.Collections.Generic.Dictionary(Of System.Guid, System.Guid)()
				End If
				Return Me.metaRolesMember
			End Get
		End Property

	End Class
	#Region "DesignerDefinitionObjectModel's Generated Closure Code"
	Partial Public Class DesignerDefinitionObjectModel
		''' <summary>
		''' CopyClosure cache
		''' </summary>
		Private Shared copyClosureMember As Microsoft.VisualStudio.Modeling.IElementVisitorFilter
		''' <summary>
		''' RemoveClosure cache
		''' </summary>
		Private Shared removeClosureMember As Microsoft.VisualStudio.Modeling.IElementVisitorFilter
		''' <summary>
		''' Returns an IElementVisitorFilter that corresponds to the ClosureType.
		''' </summary>
		''' <param name="type">closure type</param>
		''' <param name="rootElements">collection of root elements</param>
		''' <returns>IElementVisitorFilter or null</returns>
		Public Overrides Function GetClosureFilter(ByVal type As Microsoft.VisualStudio.Modeling.ClosureType, ByVal rootElements As System.Collections.ICollection) As Microsoft.VisualStudio.Modeling.IElementVisitorFilter
			Select Case type
				Case Microsoft.VisualStudio.Modeling.ClosureType.CopyClosure
					Return DesignerDefinitionObjectModel.CopyClosure
				Case Microsoft.VisualStudio.Modeling.ClosureType.RemoveClosure
					Return DesignerDefinitionObjectModel.RemoveClosure
			End Select
			Return MyBase.GetClosureFilter(type, rootElements)
		End Function
		''' <summary>
		''' CopyClosure cache
		''' </summary>
		Private Shared ReadOnly Property CopyClosure() As Microsoft.VisualStudio.Modeling.IElementVisitorFilter
			Get
				If DesignerDefinitionObjectModel.copyClosureMember Is Nothing Then
					DesignerDefinitionObjectModel.copyClosureMember = New ExampleACopyClosure()
				End If
				Return DesignerDefinitionObjectModel.copyClosureMember
			End Get
		End Property
		''' <summary>
		''' RemoveClosure cache
		''' </summary>
		Private Shared ReadOnly Property RemoveClosure() As Microsoft.VisualStudio.Modeling.IElementVisitorFilter
			Get
				If DesignerDefinitionObjectModel.removeClosureMember Is Nothing Then
					DesignerDefinitionObjectModel.removeClosureMember = New ExampleARemoveClosure()
				End If
				Return DesignerDefinitionObjectModel.removeClosureMember
			End Get
		End Property
	End Class
	#End Region
	''' <summary>
	''' 
	''' </summary>
	Partial Public Class DesignerDefinitionObjectModel
		Inherits Microsoft.VisualStudio.Modeling.SubStore
		#Region "DesignerDefinitionObjectModel's AllGeneratedMetaModelTypes Code"
		''' <summary>
		''' Virtual method that returns a collection of all types for metamodel 
		''' </summary>
		Protected NotOverridable Overrides Function AllGeneratedMetaModelTypes() As System.Type()
			Dim typeArray() As System.Type = { GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNodeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetailsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetailsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapseElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetailsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartmentElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationBooleanExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationBooleanExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotationElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorerElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindowElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehaviorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapesElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectorsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolboxElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItemsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagramElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModelElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecoratorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRootsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollectionsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortPropertyElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSetElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptionsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplayElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroupsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroupsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroupsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodesElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRenderingElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartmentsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnectorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecoratorsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartmentElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnectorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecoratorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMapElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTargetElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShapeElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEndElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValuePropertyElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRoleElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRolePropertiesElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplayElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClassElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModelElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyleElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecoratorsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteralElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIconElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValuePropertyElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMapsElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartmentElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpressionElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColorElementFactoryCreator), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationElementFactoryCreator) }
			Return typeArray
		End Function
		#End Region
	End Class
	''' <summary>
	''' 
	''' </summary>
	Partial Public Class DesignerDefinitionObjectModel
		Inherits Microsoft.VisualStudio.Modeling.SubStore
		#Region "DesignerDefinitionObjectModel's GeneratedReflectedMetaAttributes Code"
		''' <summary>
		''' Virtual method that returns a collection of all fields for all types in metamodel DesignerDefinitionObjectModel
		''' </summary>
		Protected NotOverridable Overrides Function GeneratedReflectedMetaAttributes() As Microsoft.VisualStudio.Modeling.MetaFieldInfo()
			Dim typeArray() As Microsoft.VisualStudio.Modeling.MetaFieldInfo = { New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "Namespace", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionNamespaceFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "DslName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionDslNameFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "CompanyName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionCompanyNameFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "ProductName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionProductNameFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "PackageName", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionPackageNameFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "FileExtension", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionFileExtensionFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition), "ProductVersion", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DesignerDefinitionProductVersionFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram), "MayUseAsRoot", Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.DiagramMayUseAsRootFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemCaptionIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemIconIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "Order", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemOrderFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem), "ContextSensitiveHelpId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ToolboxItemContextSensitiveHelpIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode), "StructureAsXmlFromHere", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.ExplorerNodeStructureAsXmlFromHereFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode), "UseDefaultRendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.ElementNodeUseDefaultRenderingFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode), "SortOrder", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.CollectionNodeSortOrderFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode), "RenderCollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.CollectionNodeRenderCollectionNodeFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails), "Variability", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.DiagramElementDetailsVariabilityFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails), "Color", Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorDetailsColorFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator), "Position", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.ShapeDecoratorPositionFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText), "DefaultTextId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.ShapeTextDefaultTextIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.ShapeIconIconIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator), "Position", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.ConnectorDecoratorPositionFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText), "DefaultTextId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.ConnectorTextDefaultTextIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.ConnectorIconIconIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails), "DashStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleDetailsDashStyleFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering), "IconId", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.NodeRenderingIconIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering), "AppendClassNameToCaption", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.ClassNodeRenderingAppendClassNameToCaptionFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CollectionNodeRenderingCaptionIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape), "InitialWidth", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.OutlinedShapeInitialWidthFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape), "InitialHeight", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.OutlinedShapeInitialHeightFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape), "Geometry", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.CompartmentShapeGeometryFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape), "IsSingleCompartmentHeaderVisible", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape), "Geometry", Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryShapeGeometryFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape), "Path", Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathShapePathFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape), "ImageId", Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageShapeImageIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment), "CaptionId", Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CompartmentCaptionIdFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd), "ArrowStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ArrowStyleMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd.ConnectorEndArrowStyleFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel), "FileName", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.FileNameMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModel.ObjectModelFileNameFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression), "ModelXPath", Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression.ModelXPathMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathValueExpression.XPathValueExpressionModelXPathFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression), "ModelXPath", Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression.ModelXPathMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.XPathMelCollectionExpression.XPathMelCollectionExpressionModelXPathFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty), "ReadWriteState", Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty.ReadWriteStateMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RoleProperty.RolePropertyReadWriteStateFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Open", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.OpenMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationOpenFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Save", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.SaveMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationSaveFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Menu", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.MenuMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationMenuFieldHandler)), New Microsoft.VisualStudio.Modeling.MetaFieldInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation), "Custom", Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.CustomMetaAttributeGuid, GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation.ValidationCustomFieldHandler)) }
			Return typeArray
		End Function
		#End Region
	End Class
	''' <summary>
	''' 
	''' </summary>
	Partial Public Class DesignerDefinitionObjectModel
		Inherits Microsoft.VisualStudio.Modeling.SubStore
		#Region "DesignerDefinitionObjectModel's GeneratedReflectedMetaRoleAttributes Code"
		''' <summary>
		''' Virtual method that returns a collection of all fields for all types in metamodel DesignerDefinitionObjectModel
		''' </summary>
		Protected NotOverridable Overrides Function GeneratedReflectedMetaRoles() As Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo()
			Dim typeArray() As Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo = { New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), "PropertiesWindow", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams), "Diagrams", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.NotationMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes), "Shapes", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.DiagramMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors), "Connectors", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.DiagramMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), "Toolbox", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems), "Items", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems), "Toolbox", Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ToolboxMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps), "DiagramMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps), "Notation", Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.NotationMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), "Diagram", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel), "ObjectModels", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.ObjectModelsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.DesignerDefinitionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps), "ShapeMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.DiagramMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps), "TextMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps), "ShapeMapClass", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.ShapeMapClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), "TextDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), "TextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), "FillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots), "Roots", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.ExplorerMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), "ClassNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections), "ChildCollections", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections), "NodeType", Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.NodeTypeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), "SortProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet), "PropertySets", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet), "PropertiesWindow", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertiesWindowMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), "PropertiesSet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions), "ValuePropertiesToExclude", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.ValuePropertiesToExcludeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions), "PropertiesSet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.PropertiesSetMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay), "Role", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay.RoleMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay), "RoleProperties", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesRolesToDisplay.RolePropertiesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups), "ContextMenuGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ContextMenuGroupsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ValidationBehaviorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups), "LoadGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.LoadGroupsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.ValidationBehaviorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups), "SaveGroups", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.SaveGroupsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups), "ValidationBehavior", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.ValidationBehaviorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), "Rendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), "ClassNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), "Rendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes), "ChildNodes", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.CollectionNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering), "DefaultRenderings", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering), "Explorer", Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.ExplorerMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments), "Compartments", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments), "CompartmentShape", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps), "ConnectorMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.DiagramMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps), "TextMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps), "IconMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.ShapeMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators), "Decorators", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), "ShapeTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), "TextCompartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), "CompartmentTextTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), "ConnectorTool", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), "OutlineColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), "OutlinedShape", Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), "TextDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), "ConnectorTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps), "IconMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), "SourceMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), "TargetMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), "ConnectorMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), "Target", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape), "PermittedShapes", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.PermittedShapesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape), "ConnectorEnd", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEndHasShape.ConnectorEndMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), "Source", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty), "ValueProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty.ValuePropertyMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty), "ModelValuePropertyExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelValuePropertyExpressionHasModelValueProperty.ModelValuePropertyExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole), "Role", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole.RoleMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole), "ModelRoleExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelRoleExpressionHasModelRole.ModelRoleExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), "CollectionNode", Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), "ModelNavigationExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression), "SourceMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), "ModelNavigationExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression), "TargetMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMapHasModelNavigationExpression.TargetMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), "ShapeTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties), "RoleProperties", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties), "PropertySet", Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.PropertySetMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay), "StringToDisplay", Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.StringToDisplayMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay), "RoleProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyHasStringToDisplay.RolePropertyMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), "DiagramMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), "Class", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), "ClassNodeRendering", Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), "Model", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ModelMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel), "ObjectModel", Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelHasModel.ObjectModelMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), "DashStyle", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), "Color", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), "Connector", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), "ConnectorTextMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators), "Decorators", Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators), "Shape", Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.ShapeMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral), "Choices", Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.ChoicesMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral), "EnumerationLiteralChoice", Microsoft.VisualStudio.Modeling.DesignerDefinition.EnumerationLiteralChoiceHasCdlEnumerationLiteral.EnumerationLiteralChoiceMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), "IconDecorator", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), "IconMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty), "ValueProperty", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty), "ValuePropertyBooleanExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ValuePropertyBooleanExpressionHasCdlValueProperty.ValuePropertyBooleanExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), "VisibilityExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), "ShapeIconMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps), "CompartmentMaps", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps), "ShapeMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.ShapeMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment.CompartmentMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapReferencesCompartment.CompartmentMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression), "MelCollectionExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasMelCollectionExpression.CompartmentMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression), "ValueExpression", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.ValueExpressionMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression), "CompartmentMap", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapHasValueExpression.CompartmentMapMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), "CompartmentFillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), "TitleFillColor", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), "Compartment", Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), "Validation", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid), New Microsoft.VisualStudio.Modeling.MetaRolePlayerInfo(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), "DesignerDefinition", Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid) }
			Return typeArray
		End Function
		#End Region
	End Class
End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.MetaClassGuidString, "DesignerDefinition")>
	Partial Public Class DesignerDefinition
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "DesignerDefinition's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "2ff5dcec-a1e3-45ce-aae1-dc61407dc27d"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.MetaClassGuidString)
		#End Region

		#Region "Namespace's Generated  Field Code"
		#Region "Namespace's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const NamespaceMetaAttributeGuidString As System.String = "04772add-693d-47ad-b8dd-994a145091b2"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly NamespaceMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuidString)
		#End Region

		#Region "Namespace's Generated Property Code"

		Private namespacePropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionNamespaceFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuidString, "DesignerDefinition.Namespace")>
		Public Property [Namespace]() As System.String
			Get
				Return namespacePropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionNamespaceFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionNamespaceFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.Namespace field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionNamespaceFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionNamespaceFieldHandler_Renamed As DesignerDefinitionNamespaceFieldHandler = DesignerDefinitionNamespaceFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.Namespace
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionNamespaceFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.Namespace field handler
			''' </summary>
			''' <value>DesignerDefinitionNamespaceFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionNamespaceFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionNamespaceFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionNamespaceFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.Namespace field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.NamespaceMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.namespacePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.namespacePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.namespacePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "DslName's Generated  Field Code"
		#Region "DslName's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const DslNameMetaAttributeGuidString As System.String = "06fd2c60-d69d-41bd-b609-9febe42ede1e"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly DslNameMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuidString)
		#End Region

		#Region "DslName's Generated Property Code"

		Private dslNamePropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionDslNameFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuidString, "DesignerDefinition.DslName")>
		Public Property DslName() As System.String
			Get
				Return dslNamePropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionDslNameFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionDslNameFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.DslName field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionDslNameFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionDslNameFieldHandler_Renamed As DesignerDefinitionDslNameFieldHandler = DesignerDefinitionDslNameFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.DslName
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionDslNameFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.DslName field handler
			''' </summary>
			''' <value>DesignerDefinitionDslNameFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionDslNameFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionDslNameFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionDslNameFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.DslName field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.DslNameMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.dslNamePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.dslNamePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.dslNamePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "CompanyName's Generated  Field Code"
		#Region "CompanyName's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const CompanyNameMetaAttributeGuidString As System.String = "c40a207c-7f79-4c43-9de6-b6375071a603"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly CompanyNameMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuidString)
		#End Region

		#Region "CompanyName's Generated Property Code"

		Private companyNamePropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionCompanyNameFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuidString, "DesignerDefinition.CompanyName")>
		Public Property CompanyName() As System.String
			Get
				Return companyNamePropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionCompanyNameFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionCompanyNameFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.CompanyName field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionCompanyNameFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionCompanyNameFieldHandler_Renamed As DesignerDefinitionCompanyNameFieldHandler = DesignerDefinitionCompanyNameFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.CompanyName
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionCompanyNameFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.CompanyName field handler
			''' </summary>
			''' <value>DesignerDefinitionCompanyNameFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionCompanyNameFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionCompanyNameFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionCompanyNameFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.CompanyName field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.CompanyNameMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.companyNamePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.companyNamePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.companyNamePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "ProductName's Generated  Field Code"
		#Region "ProductName's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const ProductNameMetaAttributeGuidString As System.String = "5154d9e9-9fb4-453f-802f-3f62e38f5461"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly ProductNameMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuidString)
		#End Region

		#Region "ProductName's Generated Property Code"

		Private productNamePropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionProductNameFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuidString, "DesignerDefinition.ProductName")>
		Public Property ProductName() As System.String
			Get
				Return productNamePropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionProductNameFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionProductNameFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.ProductName field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionProductNameFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionProductNameFieldHandler_Renamed As DesignerDefinitionProductNameFieldHandler = DesignerDefinitionProductNameFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.ProductName
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionProductNameFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.ProductName field handler
			''' </summary>
			''' <value>DesignerDefinitionProductNameFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionProductNameFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductNameFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionProductNameFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.ProductName field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductNameMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.productNamePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.productNamePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.productNamePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "PackageName's Generated  Field Code"
		#Region "PackageName's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const PackageNameMetaAttributeGuidString As System.String = "5b72fb5b-07f6-4573-aa4e-df0b6c39cac2"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly PackageNameMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuidString)
		#End Region

		#Region "PackageName's Generated Property Code"

		Private packageNamePropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionPackageNameFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuidString, "DesignerDefinition.PackageName")>
		Public Property PackageName() As System.String
			Get
				Return packageNamePropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionPackageNameFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionPackageNameFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.PackageName field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionPackageNameFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionPackageNameFieldHandler_Renamed As DesignerDefinitionPackageNameFieldHandler = DesignerDefinitionPackageNameFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.PackageName
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionPackageNameFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.PackageName field handler
			''' </summary>
			''' <value>DesignerDefinitionPackageNameFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionPackageNameFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionPackageNameFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionPackageNameFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.PackageName field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.PackageNameMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.packageNamePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.packageNamePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.packageNamePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "FileExtension's Generated  Field Code"
		#Region "FileExtension's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const FileExtensionMetaAttributeGuidString As System.String = "18a27c6f-7b87-46ba-916c-8818fcd72aca"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly FileExtensionMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuidString)
		#End Region

		#Region "FileExtension's Generated Property Code"

		Private fileExtensionPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionFileExtensionFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuidString, "DesignerDefinition.FileExtension")>
		Public Property FileExtension() As System.String
			Get
				Return fileExtensionPropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionFileExtensionFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionFileExtensionFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.FileExtension field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionFileExtensionFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionFileExtensionFieldHandler_Renamed As DesignerDefinitionFileExtensionFieldHandler = DesignerDefinitionFileExtensionFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.FileExtension
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionFileExtensionFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.FileExtension field handler
			''' </summary>
			''' <value>DesignerDefinitionFileExtensionFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionFileExtensionFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionFileExtensionFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionFileExtensionFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.FileExtension field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.FileExtensionMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.fileExtensionPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.fileExtensionPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.fileExtensionPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "ProductVersion's Generated  Field Code"
		#Region "ProductVersion's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const ProductVersionMetaAttributeGuidString As System.String = "45388f23-d1f3-4c9f-a60a-84ee9dea0cae"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly ProductVersionMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuidString)
		#End Region

		#Region "ProductVersion's Generated Property Code"

		Private productVersionPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DesignerDefinitionProductVersionFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuidString, "DesignerDefinition.ProductVersion")>
		Public Property ProductVersion() As System.String
			Get
				Return productVersionPropertyStorage
			End Get

			Set(ByVal value As System.String)
				designerDefinitionProductVersionFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DesignerDefinitionProductVersionFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DesignerDefinition.ProductVersion field
		''' </summary>
'INSTANT VB NOTE: The variable designerDefinitionProductVersionFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared designerDefinitionProductVersionFieldHandler_Renamed As DesignerDefinitionProductVersionFieldHandler = DesignerDefinitionProductVersionFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DesignerDefinition.ProductVersion
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DesignerDefinitionProductVersionFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DesignerDefinition.ProductVersion field handler
			''' </summary>
			''' <value>DesignerDefinitionProductVersionFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DesignerDefinitionProductVersionFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler
					Else
						' The static constructor in DesignerDefinition will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.designerDefinitionProductVersionFieldHandler, so just instantiate one and return it
						Return New DesignerDefinitionProductVersionFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DesignerDefinition.ProductVersion field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition.ProductVersionMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DesignerDefinition</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition) As System.String
				Return element.productVersionPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.productVersionPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.productVersionPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Notation's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Notation() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.NotationMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation.DesignerDefinitionMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasNotation), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Explorer's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Explorer() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.ExplorerMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer.DesignerDefinitionMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasExplorer), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "PropertiesWindow's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property PropertiesWindow() As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.PropertiesWindowMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow.DesignerDefinitionMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasPropertiesWindow), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ValidationBehavior's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property ValidationBehavior() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.ValidationBehaviorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior.DesignerDefinitionMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidationBehavior), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ObjectModels's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ObjectModels() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ObjectModelMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionReferencesObjectModel.ObjectModelsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Validation's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Validation() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Validation)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.ValidationMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation.DesignerDefinitionMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionHasValidation), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "DesignerDefinition's Generated Constructor Code"
	Partial Public Class DesignerDefinition
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDesignerDefinition(ByVal store As Microsoft.VisualStudio.Modeling.Store) As DesignerDefinition
			Return CreateDesignerDefinition(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDesignerDefinition(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DesignerDefinition
			Return CreateAndInitializeDesignerDefinition(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDesignerDefinition(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As DesignerDefinition
			Return CType(partition.ElementFactory.CreateElement(GetType(DesignerDefinition)), DesignerDefinition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDesignerDefinition(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DesignerDefinition
			Return CType(partition.ElementFactory.CreateElement(GetType(DesignerDefinition), assignments), DesignerDefinition)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for DesignerDefinition"
	''' <summary>
	''' DesignerDefinition Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition))>
	Public NotInheritable Class DesignerDefinitionElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinition(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As DesignerDefinitionElementFactoryCreator
			Get
				Return New DesignerDefinitionElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation.MetaClassGuidString, "Notation")>
	Partial Public Class Notation
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Notation's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "eacaf516-4d26-4db4-8d0c-4ca057965032"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation.MetaClassGuidString)
		#End Region

		#Region "Diagrams's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Diagrams() As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagrams.DiagramsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "DiagramMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property DiagramMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.NotationMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NotationHasDiagramMaps.DiagramMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Notation's Generated Constructor Code"
	Partial Public Class Notation
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateNotation(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Notation
			Return CreateNotation(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeNotation(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Notation
			Return CreateAndInitializeNotation(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateNotation(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Notation
			Return CType(partition.ElementFactory.CreateElement(GetType(Notation)), Notation)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeNotation(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Notation
			Return CType(partition.ElementFactory.CreateElement(GetType(Notation), assignments), Notation)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Notation"
	''' <summary>
	''' Notation Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation))>
	Public NotInheritable Class NotationElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Notation(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As NotationElementFactoryCreator
			Get
				Return New NotationElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer.MetaClassGuidString, "Explorer")>
	Partial Public Class Explorer
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Explorer's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "ecb5fb7e-a561-417a-8109-c3db1c951f3b"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer.MetaClassGuidString)
		#End Region

		#Region "Roots's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Roots() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasRoots.RootsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "DefaultRenderings's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property DefaultRenderings() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.ExplorerMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerHasDefaultRendering.DefaultRenderingsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Explorer's Generated Constructor Code"
	Partial Public Class Explorer
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExplorer(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Explorer
			Return CreateExplorer(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExplorer(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Explorer
			Return CreateAndInitializeExplorer(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExplorer(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Explorer
			Return CType(partition.ElementFactory.CreateElement(GetType(Explorer)), Explorer)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExplorer(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Explorer
			Return CType(partition.ElementFactory.CreateElement(GetType(Explorer), assignments), Explorer)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Explorer"
	''' <summary>
	''' Explorer Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer))>
	Public NotInheritable Class ExplorerElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Explorer(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ExplorerElementFactoryCreator
			Get
				Return New ExplorerElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow.MetaClassGuidString, "PropertiesWindow")>
	Partial Public Class PropertiesWindow
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "PropertiesWindow's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "519599a6-b3fa-4f36-8ab0-66bd3f404c02"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow.MetaClassGuidString)
		#End Region

		#Region "PropertySets's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property PropertySets() As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertiesWindowMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindowHasPropertiesSet.PropertySetsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "PropertiesWindow's Generated Constructor Code"
	Partial Public Class PropertiesWindow
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePropertiesWindow(ByVal store As Microsoft.VisualStudio.Modeling.Store) As PropertiesWindow
			Return CreatePropertiesWindow(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePropertiesWindow(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PropertiesWindow
			Return CreateAndInitializePropertiesWindow(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePropertiesWindow(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As PropertiesWindow
			Return CType(partition.ElementFactory.CreateElement(GetType(PropertiesWindow)), PropertiesWindow)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePropertiesWindow(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PropertiesWindow
			Return CType(partition.ElementFactory.CreateElement(GetType(PropertiesWindow), assignments), PropertiesWindow)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for PropertiesWindow"
	''' <summary>
	''' PropertiesWindow Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow))>
	Public NotInheritable Class PropertiesWindowElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesWindow(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As PropertiesWindowElementFactoryCreator
			Get
				Return New PropertiesWindowElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior.MetaClassGuidString, "ValidationBehavior")>
	Partial Public Class ValidationBehavior
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ValidationBehavior's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "f3b20760-d336-4d03-9654-9c14bdfc3b70"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior.MetaClassGuidString)
		#End Region

		#Region "ContextMenuGroups's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ContextMenuGroups() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection
			Get
				Return New Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesContextMenuGroups.ContextMenuGroupsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "LoadGroups's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property LoadGroups() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection
			Get
				Return New Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesLoadGroups.LoadGroupsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "SaveGroups's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property SaveGroups() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection
			Get
				Return New Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.ModelConstraintGroupMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.ValidationBehaviorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehaviorReferencesSaveGroups.SaveGroupsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ValidationBehavior"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ValidationBehaviorMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ValidationBehavior's Generated Constructor Code"
	Partial Public Class ValidationBehavior
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateValidationBehavior(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ValidationBehavior
			Return CreateValidationBehavior(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeValidationBehavior(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ValidationBehavior
			Return CreateAndInitializeValidationBehavior(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateValidationBehavior(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ValidationBehavior
			Return CType(partition.ElementFactory.CreateElement(GetType(ValidationBehavior)), ValidationBehavior)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeValidationBehavior(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ValidationBehavior
			Return CType(partition.ElementFactory.CreateElement(GetType(ValidationBehavior), assignments), ValidationBehavior)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ValidationBehavior"
	''' <summary>
	''' ValidationBehavior Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior))>
	Public NotInheritable Class ValidationBehaviorElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ValidationBehavior(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ValidationBehaviorElementFactoryCreator
			Get
				Return New ValidationBehaviorElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MetaClassGuidString, "Diagram")>
	Partial Public Class Diagram
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Diagram's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "a90d74fc-204f-449c-acb2-d12bf9ad74c6"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MetaClassGuidString)
		#End Region

		#Region "MayUseAsRoot's Generated  Field Code"
		#Region "MayUseAsRoot's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const MayUseAsRootMetaAttributeGuidString As System.String = "755d1580-bbaf-4eb5-956a-4fe535062d1e"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly MayUseAsRootMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuidString)
		#End Region

		#Region "MayUseAsRoot's Generated Property Code"

		Private mayUseAsRootPropertyStorage As System.Boolean = False

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=False), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DiagramMayUseAsRootFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuidString, "Diagram.MayUseAsRoot")>
		Public Property MayUseAsRoot() As System.Boolean
			Get
				Return mayUseAsRootPropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				diagramMayUseAsRootFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DiagramMayUseAsRootFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for Diagram.MayUseAsRoot field
		''' </summary>
'INSTANT VB NOTE: The variable diagramMayUseAsRootFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared diagramMayUseAsRootFieldHandler_Renamed As DiagramMayUseAsRootFieldHandler = DiagramMayUseAsRootFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for Diagram.MayUseAsRoot
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DiagramMayUseAsRootFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the Diagram.MayUseAsRoot field handler
			''' </summary>
			''' <value>DiagramMayUseAsRootFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DiagramMayUseAsRootFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler
					Else
						' The static constructor in Diagram will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.diagramMayUseAsRootFieldHandler, so just instantiate one and return it
						Return New DiagramMayUseAsRootFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the Diagram.MayUseAsRoot field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram.MayUseAsRootMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the Diagram</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) As System.Boolean
				Return element.mayUseAsRootPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.mayUseAsRootPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.mayUseAsRootPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Shapes's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Shapes() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasShapes.ShapesMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Connectors's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Connectors() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasConnectors.ConnectorsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Toolbox's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Toolbox() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.ToolboxMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox.DiagramMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramHasToolbox), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for Diagram"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class DiagramMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "Diagram's Generated Constructor Code"
	Partial Public Class Diagram
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagram(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Diagram
			Return CreateDiagram(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagram(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Diagram
			Return CreateAndInitializeDiagram(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagram(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Diagram
			Return CType(partition.ElementFactory.CreateElement(GetType(Diagram)), Diagram)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagram(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Diagram
			Return CType(partition.ElementFactory.CreateElement(GetType(Diagram), assignments), Diagram)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Diagram"
	''' <summary>
	''' Diagram Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram))>
	Public NotInheritable Class DiagramElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As DiagramElementFactoryCreator
			Get
				Return New DiagramElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector.MetaClassGuidString, "Connector")>
	Partial Public Class Connector
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Connector's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "73315d51-3fc7-4436-aee2-16f6c51fc500"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector.MetaClassGuidString)
		#End Region

		#Region "Decorators's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Decorators() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDecorators.DecoratorsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Target's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Target() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.TargetMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget.ConnectorMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasTarget), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Source's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Source() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorEnd)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.SourceMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd.ConnectorMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasConnectorEnd), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "DashStyle's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property DashStyle() As Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.DashStyleMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle.ConnectorMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasDashStyle), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Color's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Color() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ColorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor.ConnectorMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorHasColor), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for Connector"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "Connector's Generated Constructor Code"
	Partial Public Class Connector
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnector(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Connector
			Return CreateConnector(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnector(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Connector
			Return CreateAndInitializeConnector(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnector(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Connector
			Return CType(partition.ElementFactory.CreateElement(GetType(Connector)), Connector)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnector(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Connector
			Return CType(partition.ElementFactory.CreateElement(GetType(Connector), assignments), Connector)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Connector"
	''' <summary>
	''' Connector Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector))>
	Public NotInheritable Class ConnectorElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorElementFactoryCreator
			Get
				Return New ConnectorElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox.MetaClassGuidString, "Toolbox")>
	Partial Public Class Toolbox
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Toolbox's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "0f088991-551a-4545-969d-aa1f934caad5"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox.MetaClassGuidString)
		#End Region

		#Region "Items's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Items() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItemMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ToolboxMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxHasItems.ItemsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Toolbox's Generated Constructor Code"
	Partial Public Class Toolbox
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateToolbox(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Toolbox
			Return CreateToolbox(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeToolbox(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Toolbox
			Return CreateAndInitializeToolbox(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateToolbox(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Toolbox
			Return CType(partition.ElementFactory.CreateElement(GetType(Toolbox)), Toolbox)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeToolbox(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Toolbox
			Return CType(partition.ElementFactory.CreateElement(GetType(Toolbox), assignments), Toolbox)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Toolbox"
	''' <summary>
	''' Toolbox Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox))>
	Public NotInheritable Class ToolboxElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Toolbox(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ToolboxElementFactoryCreator
			Get
				Return New ToolboxElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.MetaClassGuidString, "ToolboxItem")>
	Partial Public Class ToolboxItem
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ToolboxItem's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "2bff4b99-9dd8-48f1-b4a2-48e117613499"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.MetaClassGuidString)
		#End Region

		#Region "CaptionId's Generated  Field Code"
		#Region "CaptionId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const CaptionIdMetaAttributeGuidString As System.String = "c98b44b7-d1b9-44f6-95db-cee348110ee0"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly CaptionIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuidString)
		#End Region

		#Region "CaptionId's Generated Property Code"

		Private captionIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ToolboxItemCaptionIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuidString, "ToolboxItem.CaptionId")>
		Public Property CaptionId() As System.String
			Get
				Return captionIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				toolboxItemCaptionIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ToolboxItemCaptionIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ToolboxItem.CaptionId field
		''' </summary>
'INSTANT VB NOTE: The variable toolboxItemCaptionIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared toolboxItemCaptionIdFieldHandler_Renamed As ToolboxItemCaptionIdFieldHandler = ToolboxItemCaptionIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ToolboxItem.CaptionId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ToolboxItemCaptionIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ToolboxItem.CaptionId field handler
			''' </summary>
			''' <value>ToolboxItemCaptionIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ToolboxItemCaptionIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler
					Else
						' The static constructor in ToolboxItem will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemCaptionIdFieldHandler, so just instantiate one and return it
						Return New ToolboxItemCaptionIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ToolboxItem.CaptionId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.CaptionIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ToolboxItem</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.String
				Return element.captionIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.captionIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.captionIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "IconId's Generated  Field Code"
		#Region "IconId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const IconIdMetaAttributeGuidString As System.String = "45b2cedf-deee-403b-8887-a3ee828b86df"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly IconIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuidString)
		#End Region

		#Region "IconId's Generated Property Code"

		Private iconIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ToolboxItemIconIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuidString, "ToolboxItem.IconId")>
		Public Property IconId() As System.String
			Get
				Return iconIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				toolboxItemIconIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ToolboxItemIconIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ToolboxItem.IconId field
		''' </summary>
'INSTANT VB NOTE: The variable toolboxItemIconIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared toolboxItemIconIdFieldHandler_Renamed As ToolboxItemIconIdFieldHandler = ToolboxItemIconIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ToolboxItem.IconId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ToolboxItemIconIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ToolboxItem.IconId field handler
			''' </summary>
			''' <value>ToolboxItemIconIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ToolboxItemIconIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler
					Else
						' The static constructor in ToolboxItem will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemIconIdFieldHandler, so just instantiate one and return it
						Return New ToolboxItemIconIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ToolboxItem.IconId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.IconIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ToolboxItem</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.String
				Return element.iconIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.iconIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.iconIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Order's Generated  Field Code"
		#Region "Order's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const OrderMetaAttributeGuidString As System.String = "cc7f9f59-a4aa-4801-ae85-43b4347fe995"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly OrderMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuidString)
		#End Region

		#Region "Order's Generated Property Code"

		Private orderPropertyStorage As System.Int32 = 0

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.IntegerDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ToolboxItemOrderFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuidString, "ToolboxItem.Order")>
		Public Property Order() As System.Int32
			Get
				Return orderPropertyStorage
			End Get

			Set(ByVal value As System.Int32)
				toolboxItemOrderFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ToolboxItemOrderFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ToolboxItem.Order field
		''' </summary>
'INSTANT VB NOTE: The variable toolboxItemOrderFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared toolboxItemOrderFieldHandler_Renamed As ToolboxItemOrderFieldHandler = ToolboxItemOrderFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ToolboxItem.Order
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ToolboxItemOrderFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.Int32)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ToolboxItem.Order field handler
			''' </summary>
			''' <value>ToolboxItemOrderFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ToolboxItemOrderFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler
					Else
						' The static constructor in ToolboxItem will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemOrderFieldHandler, so just instantiate one and return it
						Return New ToolboxItemOrderFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ToolboxItem.Order field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.OrderMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ToolboxItem</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.Int32
				Return element.orderPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal value As System.Int32, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Int32) As Boolean
				oldValue = element.orderPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.orderPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "ContextSensitiveHelpId's Generated  Field Code"
		#Region "ContextSensitiveHelpId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const ContextSensitiveHelpIdMetaAttributeGuidString As System.String = "b761485c-ba69-406b-99b1-52a38b368b11"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly ContextSensitiveHelpIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuidString)
		#End Region

		#Region "ContextSensitiveHelpId's Generated Property Code"

		Private contextSensitiveHelpIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ToolboxItemContextSensitiveHelpIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuidString, "ToolboxItem.ContextSensitiveHelpId")>
		Public Property ContextSensitiveHelpId() As System.String
			Get
				Return contextSensitiveHelpIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				toolboxItemContextSensitiveHelpIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ToolboxItemContextSensitiveHelpIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ToolboxItem.ContextSensitiveHelpId field
		''' </summary>
'INSTANT VB NOTE: The variable toolboxItemContextSensitiveHelpIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared toolboxItemContextSensitiveHelpIdFieldHandler_Renamed As ToolboxItemContextSensitiveHelpIdFieldHandler = ToolboxItemContextSensitiveHelpIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ToolboxItem.ContextSensitiveHelpId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ToolboxItemContextSensitiveHelpIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ToolboxItem.ContextSensitiveHelpId field handler
			''' </summary>
			''' <value>ToolboxItemContextSensitiveHelpIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ToolboxItemContextSensitiveHelpIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler
					Else
						' The static constructor in ToolboxItem will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.toolboxItemContextSensitiveHelpIdFieldHandler, so just instantiate one and return it
						Return New ToolboxItemContextSensitiveHelpIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ToolboxItem.ContextSensitiveHelpId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem.ContextSensitiveHelpIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ToolboxItem</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.String
				Return element.contextSensitiveHelpIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.contextSensitiveHelpIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.contextSensitiveHelpIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "Collection Classes for ToolboxItem"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ToolboxItemMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ToolboxItem's Generated Constructor Code"
	Partial Public Class ToolboxItem
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateToolboxItem(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ToolboxItem
			Return CreateToolboxItem(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeToolboxItem(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ToolboxItem
			Return CreateAndInitializeToolboxItem(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateToolboxItem(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ToolboxItem
			Return CType(partition.ElementFactory.CreateElement(GetType(ToolboxItem)), ToolboxItem)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeToolboxItem(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ToolboxItem
			Return CType(partition.ElementFactory.CreateElement(GetType(ToolboxItem), assignments), ToolboxItem)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ToolboxItem"
	''' <summary>
	''' ToolboxItem Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem))>
	Public NotInheritable Class ToolboxItemElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ToolboxItemElementFactoryCreator
			Get
				Return New ToolboxItemElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool.MetaClassGuidString, "ShapeTool")>
	Partial Public Class ShapeTool
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
		#Region "ShapeTool's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "4dab8cfc-47de-441f-b81a-a3dec52650ed"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool.MetaClassGuidString)
		#End Region

		#Region "Shape's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Shape() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape.ShapeToolMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeToolReferencesShape), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ShapeTool"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeToolMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ShapeTool's Generated Constructor Code"
	Partial Public Class ShapeTool
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeTool(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeTool
			Return CreateShapeTool(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeTool(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeTool
			Return CreateAndInitializeShapeTool(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeTool
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeTool)), ShapeTool)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeTool
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeTool), assignments), ShapeTool)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeTool"
	''' <summary>
	''' ShapeTool Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool))>
	Public NotInheritable Class ShapeToolElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTool(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeToolElementFactoryCreator
			Get
				Return New ShapeToolElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool.MetaClassGuidString, "ConnectorTool")>
	Partial Public Class ConnectorTool
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
		#Region "ConnectorTool's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "1025fcea-8bad-47d2-b672-f16003031567"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool.MetaClassGuidString)
		#End Region

		#Region "Connector's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Connector() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector.ConnectorToolMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorToolReferencesConnector), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ConnectorTool"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorToolMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ConnectorTool's Generated Constructor Code"
	Partial Public Class ConnectorTool
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorTool(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorTool
			Return CreateConnectorTool(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorTool(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorTool
			Return CreateAndInitializeConnectorTool(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorTool
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorTool)), ConnectorTool)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorTool
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorTool), assignments), ConnectorTool)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorTool"
	''' <summary>
	''' ConnectorTool Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool))>
	Public NotInheritable Class ConnectorToolElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTool(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorToolElementFactoryCreator
			Get
				Return New ConnectorToolElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool.MetaClassGuidString, "CompartmentTextTool")>
	Partial Public Class CompartmentTextTool
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ToolboxItem
		#Region "CompartmentTextTool's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "bc57e168-0c77-47f1-ad42-92930bde0313"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool.MetaClassGuidString)
		#End Region

		#Region "TextCompartment's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property TextCompartment() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.TextCompartmentMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment.CompartmentTextToolMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextToolReferencesTextCompartment), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for CompartmentTextTool"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class CompartmentTextToolMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "CompartmentTextTool's Generated Constructor Code"
	Partial Public Class CompartmentTextTool
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartmentTextTool(ByVal store As Microsoft.VisualStudio.Modeling.Store) As CompartmentTextTool
			Return CreateCompartmentTextTool(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartmentTextTool(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CompartmentTextTool
			Return CreateAndInitializeCompartmentTextTool(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartmentTextTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As CompartmentTextTool
			Return CType(partition.ElementFactory.CreateElement(GetType(CompartmentTextTool)), CompartmentTextTool)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartmentTextTool(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CompartmentTextTool
			Return CType(partition.ElementFactory.CreateElement(GetType(CompartmentTextTool), assignments), CompartmentTextTool)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for CompartmentTextTool"
	''' <summary>
	''' CompartmentTextTool Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool))>
	Public NotInheritable Class CompartmentTextToolElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentTextTool(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As CompartmentTextToolElementFactoryCreator
			Get
				Return New CompartmentTextToolElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap.MetaClassGuidString, "DiagramMap")>
	Partial Public Class DiagramMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "DiagramMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "2090ffe3-f004-4400-8d28-1e6969a8fb8a"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap.MetaClassGuidString)
		#End Region

		#Region "Diagram's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Diagram() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Diagram)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram.DiagramMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesDiagram), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ShapeMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ShapeMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasShapeMaps.ShapeMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "ConnectorMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ConnectorMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapHasConnectorMaps.ConnectorMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass.DiagramMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMapReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for DiagramMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class DiagramMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "DiagramMap's Generated Constructor Code"
	Partial Public Class DiagramMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagramMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As DiagramMap
			Return CreateDiagramMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagramMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DiagramMap
			Return CreateAndInitializeDiagramMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagramMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As DiagramMap
			Return CType(partition.ElementFactory.CreateElement(GetType(DiagramMap)), DiagramMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagramMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DiagramMap
			Return CType(partition.ElementFactory.CreateElement(GetType(DiagramMap), assignments), DiagramMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for DiagramMap"
	''' <summary>
	''' DiagramMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap))>
	Public NotInheritable Class DiagramMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As DiagramMapElementFactoryCreator
			Get
				Return New DiagramMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap.MetaClassGuidString, "ShapeMap")>
	Partial Public Class ShapeMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ShapeMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "4eaeb35e-8e1f-4cc8-8ad9-d59eeec97596"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap.MetaClassGuidString)
		#End Region

		#Region "TextMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property TextMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.ShapeMapClassMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasTextMaps.TextMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Shape's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Shape() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape.ShapeMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesShape), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "IconMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property IconMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasIconMaps.IconMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "MelCollectionExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property MelCollectionExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.MelCollectionExpressionMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression.ShapeMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasModelNavigationExpression), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass.ShapeMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "CompartmentMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property CompartmentMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.ShapeMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMapHasCompartmentMaps.CompartmentMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ShapeMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ShapeMap's Generated Constructor Code"
	Partial Public Class ShapeMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeMap
			Return CreateShapeMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeMap
			Return CreateAndInitializeShapeMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeMap)), ShapeMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeMap), assignments), ShapeMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeMap"
	''' <summary>
	''' ShapeMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap))>
	Public NotInheritable Class ShapeMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeMapElementFactoryCreator
			Get
				Return New ShapeMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap.MetaClassGuidString, "ShapeTextMap")>
	Partial Public Class ShapeTextMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ShapeTextMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "1b25b523-20b5-45ba-9aeb-b0d939ff61e1"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap.MetaClassGuidString)
		#End Region

		#Region "TextDecorator's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property TextDecorator() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextDecoratorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator.TextMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.TextMapHasTextDecorator), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ValueExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property ValueExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ValueExpression)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ValueExpressionMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression.ShapeTextMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMapHasValueExpression), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ShapeTextMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeTextMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ShapeTextMap's Generated Constructor Code"
	Partial Public Class ShapeTextMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeTextMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeTextMap
			Return CreateShapeTextMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeTextMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeTextMap
			Return CreateAndInitializeShapeTextMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeTextMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeTextMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeTextMap)), ShapeTextMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeTextMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeTextMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeTextMap), assignments), ShapeTextMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeTextMap"
	''' <summary>
	''' ShapeTextMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap))>
	Public NotInheritable Class ShapeTextMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeTextMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeTextMapElementFactoryCreator
			Get
				Return New ShapeTextMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.MetaClassGuidString, "ExplorerNode")>
	Partial Public Class ExplorerNode
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ExplorerNode's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "0952a8e9-577d-4032-aec5-2519b3566ed7"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.MetaClassGuidString)
		#End Region

		#Region "StructureAsXmlFromHere's Generated  Field Code"
		#Region "StructureAsXmlFromHere's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const StructureAsXmlFromHereMetaAttributeGuidString As System.String = "09a1d4bf-4702-4d14-8f94-e4b5613f51d9"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly StructureAsXmlFromHereMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuidString)
		#End Region

		#Region "StructureAsXmlFromHere's Generated Property Code"

		Private structureAsXmlFromHerePropertyStorage As System.Boolean = False

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=False), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ExplorerNodeStructureAsXmlFromHereFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuidString, "ExplorerNode.StructureAsXmlFromHere")>
		Public Property StructureAsXmlFromHere() As System.Boolean
			Get
				Return structureAsXmlFromHerePropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				explorerNodeStructureAsXmlFromHereFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ExplorerNodeStructureAsXmlFromHereFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ExplorerNode.StructureAsXmlFromHere field
		''' </summary>
'INSTANT VB NOTE: The variable explorerNodeStructureAsXmlFromHereFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared explorerNodeStructureAsXmlFromHereFieldHandler_Renamed As ExplorerNodeStructureAsXmlFromHereFieldHandler = ExplorerNodeStructureAsXmlFromHereFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ExplorerNode.StructureAsXmlFromHere
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ExplorerNodeStructureAsXmlFromHereFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ExplorerNode.StructureAsXmlFromHere field handler
			''' </summary>
			''' <value>ExplorerNodeStructureAsXmlFromHereFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ExplorerNodeStructureAsXmlFromHereFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler
					Else
						' The static constructor in ExplorerNode will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.explorerNodeStructureAsXmlFromHereFieldHandler, so just instantiate one and return it
						Return New ExplorerNodeStructureAsXmlFromHereFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ExplorerNode.StructureAsXmlFromHere field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode.StructureAsXmlFromHereMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ExplorerNode</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode) As System.Boolean
				Return element.structureAsXmlFromHerePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.structureAsXmlFromHerePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.structureAsXmlFromHerePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ExplorerNode's Generated Constructor Code"
	Partial Public Class ExplorerNode
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExplorerNode(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ExplorerNode
			Return CreateExplorerNode(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExplorerNode(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ExplorerNode
			Return CreateAndInitializeExplorerNode(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExplorerNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ExplorerNode
			Return CType(partition.ElementFactory.CreateElement(GetType(ExplorerNode)), ExplorerNode)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExplorerNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ExplorerNode
			Return CType(partition.ElementFactory.CreateElement(GetType(ExplorerNode), assignments), ExplorerNode)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ExplorerNode"
	''' <summary>
	''' ExplorerNode Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode))>
	Public NotInheritable Class ExplorerNodeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ExplorerNodeElementFactoryCreator
			Get
				Return New ExplorerNodeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.MetaClassGuidString, "ElementNode")>
	Partial Public Class ElementNode
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode
		#Region "ElementNode's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "ae9bab28-935c-4608-a5d6-abbf04cbb685"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.MetaClassGuidString)
		#End Region

		#Region "UseDefaultRendering's Generated  Field Code"
		#Region "UseDefaultRendering's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const UseDefaultRenderingMetaAttributeGuidString As System.String = "3e3cac93-b417-4b82-8a57-dae268177a21"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly UseDefaultRenderingMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuidString)
		#End Region

		#Region "UseDefaultRendering's Generated Property Code"

		Private useDefaultRenderingPropertyStorage As System.Boolean = False

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=False), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ElementNodeUseDefaultRenderingFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuidString, "ElementNode.UseDefaultRendering")>
		Public Property UseDefaultRendering() As System.Boolean
			Get
				Return useDefaultRenderingPropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				elementNodeUseDefaultRenderingFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ElementNodeUseDefaultRenderingFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ElementNode.UseDefaultRendering field
		''' </summary>
'INSTANT VB NOTE: The variable elementNodeUseDefaultRenderingFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared elementNodeUseDefaultRenderingFieldHandler_Renamed As ElementNodeUseDefaultRenderingFieldHandler = ElementNodeUseDefaultRenderingFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ElementNode.UseDefaultRendering
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ElementNodeUseDefaultRenderingFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ElementNode.UseDefaultRendering field handler
			''' </summary>
			''' <value>ElementNodeUseDefaultRenderingFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ElementNodeUseDefaultRenderingFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler
					Else
						' The static constructor in ElementNode will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.elementNodeUseDefaultRenderingFieldHandler, so just instantiate one and return it
						Return New ElementNodeUseDefaultRenderingFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ElementNode.UseDefaultRendering field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode.UseDefaultRenderingMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ElementNode</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) As System.Boolean
				Return element.useDefaultRenderingPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.useDefaultRenderingPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.useDefaultRenderingPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass.ClassNodeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ChildCollections's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ChildCollections() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.NodeTypeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeTypeHasChildCollections.ChildCollectionsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Rendering's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Rendering() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.RenderingMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering.ClassNodeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeHasRendering), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ElementNode"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ElementNodeMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ElementNode's Generated Constructor Code"
	Partial Public Class ElementNode
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateElementNode(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ElementNode
			Return CreateElementNode(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeElementNode(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ElementNode
			Return CreateAndInitializeElementNode(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateElementNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ElementNode
			Return CType(partition.ElementFactory.CreateElement(GetType(ElementNode)), ElementNode)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeElementNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ElementNode
			Return CType(partition.ElementFactory.CreateElement(GetType(ElementNode), assignments), ElementNode)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ElementNode"
	''' <summary>
	''' ElementNode Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode))>
	Public NotInheritable Class ElementNodeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNode(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ElementNodeElementFactoryCreator
			Get
				Return New ElementNodeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.MetaClassGuidString, "CollectionNode")>
	Partial Public Class CollectionNode
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ExplorerNode
		#Region "CollectionNode's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "4e880f9d-751d-4cf9-a7c8-a3b781bc6be8"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.MetaClassGuidString)
		#End Region

		#Region "SortOrder's Generated  Field Code"
		#Region "SortOrder's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const SortOrderMetaAttributeGuidString As System.String = "c52fa124-9672-4279-b734-85eb6a06b3a5"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly SortOrderMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuidString)
		#End Region

		#Region "SortOrder's Generated Property Code"

		Private sortOrderPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder = Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder.Ascending

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder),DefaultEnumerationValueName:="Ascending"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CollectionNodeSortOrderFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuidString, "CollectionNode.SortOrder")>
		Public Property SortOrder() As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder
			Get
				Return sortOrderPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder)
				collectionNodeSortOrderFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CollectionNodeSortOrderFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for CollectionNode.SortOrder field
		''' </summary>
'INSTANT VB NOTE: The variable collectionNodeSortOrderFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared collectionNodeSortOrderFieldHandler_Renamed As CollectionNodeSortOrderFieldHandler = CollectionNodeSortOrderFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for CollectionNode.SortOrder
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CollectionNodeSortOrderFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode,Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the CollectionNode.SortOrder field handler
			''' </summary>
			''' <value>CollectionNodeSortOrderFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CollectionNodeSortOrderFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler
					Else
						' The static constructor in CollectionNode will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeSortOrderFieldHandler, so just instantiate one and return it
						Return New CollectionNodeSortOrderFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the CollectionNode.SortOrder field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.SortOrderMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the CollectionNode</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder
				Return element.sortOrderPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.SortOrder) As Boolean
				oldValue = element.sortOrderPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.sortOrderPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "RenderCollectionNode's Generated  Field Code"
		#Region "RenderCollectionNode's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const RenderCollectionNodeMetaAttributeGuidString As System.String = "cf1e93c2-1aed-4e71-9027-a35e3a6e2930"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly RenderCollectionNodeMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuidString)
		#End Region

		#Region "RenderCollectionNode's Generated Property Code"

		Private renderCollectionNodePropertyStorage As System.Boolean = False

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=False), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CollectionNodeRenderCollectionNodeFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuidString, "CollectionNode.RenderCollectionNode")>
		Public Property RenderCollectionNode() As System.Boolean
			Get
				Return renderCollectionNodePropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				collectionNodeRenderCollectionNodeFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CollectionNodeRenderCollectionNodeFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for CollectionNode.RenderCollectionNode field
		''' </summary>
'INSTANT VB NOTE: The variable collectionNodeRenderCollectionNodeFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared collectionNodeRenderCollectionNodeFieldHandler_Renamed As CollectionNodeRenderCollectionNodeFieldHandler = CollectionNodeRenderCollectionNodeFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for CollectionNode.RenderCollectionNode
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CollectionNodeRenderCollectionNodeFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the CollectionNode.RenderCollectionNode field handler
			''' </summary>
			''' <value>CollectionNodeRenderCollectionNodeFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CollectionNodeRenderCollectionNodeFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler
					Else
						' The static constructor in CollectionNode will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.collectionNodeRenderCollectionNodeFieldHandler, so just instantiate one and return it
						Return New CollectionNodeRenderCollectionNodeFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the CollectionNode.RenderCollectionNode field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode.RenderCollectionNodeMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the CollectionNode</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) As System.Boolean
				Return element.renderCollectionNodePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.renderCollectionNodePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.renderCollectionNodePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "SortProperty's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property SortProperty() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValueProperty)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.SortPropertyMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty.CollectionNodeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeReferencesSortProperty), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Rendering's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Rendering() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.RenderingMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering.CollectionNodeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasRendering), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ChildNodes's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ChildNodes() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ElementNodeMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasChildNodes.ChildNodesMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "MelCollectionExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property MelCollectionExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.MelCollectionExpression)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.MelCollectionExpressionMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression.CollectionNodeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeHasMelCollectionExpression), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for CollectionNode"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class CollectionNodeMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "CollectionNode's Generated Constructor Code"
	Partial Public Class CollectionNode
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCollectionNode(ByVal store As Microsoft.VisualStudio.Modeling.Store) As CollectionNode
			Return CreateCollectionNode(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCollectionNode(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CollectionNode
			Return CreateAndInitializeCollectionNode(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCollectionNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As CollectionNode
			Return CType(partition.ElementFactory.CreateElement(GetType(CollectionNode)), CollectionNode)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCollectionNode(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CollectionNode
			Return CType(partition.ElementFactory.CreateElement(GetType(CollectionNode), assignments), CollectionNode)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for CollectionNode"
	''' <summary>
	''' CollectionNode Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode))>
	Public NotInheritable Class CollectionNodeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNode(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As CollectionNodeElementFactoryCreator
			Get
				Return New CollectionNodeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet.MetaClassGuidString, "PropertySet")>
	Partial Public Class PropertySet
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "PropertySet's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "6b79526d-08d3-4dc6-9da3-304f391d993d"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet.MetaClassGuidString)
		#End Region

		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass.PropertiesSetMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ValuePropertiesToExclude's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property ValuePropertiesToExclude() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValuePropertyMoveableCollection
			Get
				Return New Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlValuePropertyMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.PropertiesSetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertiesSetReferencesValuePropertyExceptions.ValuePropertiesToExcludeMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "RoleProperties's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property RoleProperties() As Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.RolePropertyMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.PropertySetMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySetHasRoleProperties.RolePropertiesMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Collection Classes for PropertySet"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class PropertySetMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "PropertySet's Generated Constructor Code"
	Partial Public Class PropertySet
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePropertySet(ByVal store As Microsoft.VisualStudio.Modeling.Store) As PropertySet
			Return CreatePropertySet(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePropertySet(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PropertySet
			Return CreateAndInitializePropertySet(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePropertySet(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As PropertySet
			Return CType(partition.ElementFactory.CreateElement(GetType(PropertySet)), PropertySet)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePropertySet(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PropertySet
			Return CType(partition.ElementFactory.CreateElement(GetType(PropertySet), assignments), PropertySet)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for PropertySet"
	''' <summary>
	''' PropertySet Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet))>
	Public NotInheritable Class PropertySetElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.PropertySet(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As PropertySetElementFactoryCreator
			Get
				Return New PropertySetElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.MetaClassGuidString, "DiagramElementDetails")>
	Partial Public Class DiagramElementDetails
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "DiagramElementDetails's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "c00d63fe-07c7-4048-8905-d700bc1947c0"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.MetaClassGuidString)
		#End Region

		#Region "Variability's Generated  Field Code"
		#Region "Variability's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const VariabilityMetaAttributeGuidString As System.String = "4972614f-e669-4090-b7aa-cac2e3b73527"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly VariabilityMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuidString)
		#End Region

		#Region "Variability's Generated Property Code"

		Private variabilityPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability = Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability.Fixed

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability),DefaultEnumerationValueName:="Fixed"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(DiagramElementDetailsVariabilityFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuidString, "DiagramElementDetails.Variability")>
		Public Property Variability() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability
			Get
				Return variabilityPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability)
				diagramElementDetailsVariabilityFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DiagramElementDetailsVariabilityFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DiagramElementDetails.Variability field
		''' </summary>
'INSTANT VB NOTE: The variable diagramElementDetailsVariabilityFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared diagramElementDetailsVariabilityFieldHandler_Renamed As DiagramElementDetailsVariabilityFieldHandler = DiagramElementDetailsVariabilityFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DiagramElementDetails.Variability
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DiagramElementDetailsVariabilityFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails,Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DiagramElementDetails.Variability field handler
			''' </summary>
			''' <value>DiagramElementDetailsVariabilityFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DiagramElementDetailsVariabilityFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler
					Else
						' The static constructor in DiagramElementDetails will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.diagramElementDetailsVariabilityFieldHandler, so just instantiate one and return it
						Return New DiagramElementDetailsVariabilityFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DiagramElementDetails.Variability field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails.VariabilityMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the DiagramElementDetails</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails) As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability
				Return element.variabilityPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.Variability) As Boolean
				oldValue = element.variabilityPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.variabilityPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "DiagramElementDetails's Generated Constructor Code"
	Partial Public Class DiagramElementDetails
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagramElementDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store) As DiagramElementDetails
			Return CreateDiagramElementDetails(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagramElementDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DiagramElementDetails
			Return CreateAndInitializeDiagramElementDetails(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDiagramElementDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As DiagramElementDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(DiagramElementDetails)), DiagramElementDetails)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDiagramElementDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DiagramElementDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(DiagramElementDetails), assignments), DiagramElementDetails)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for DiagramElementDetails"
	''' <summary>
	''' DiagramElementDetails Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails))>
	Public NotInheritable Class DiagramElementDetailsElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As DiagramElementDetailsElementFactoryCreator
			Get
				Return New DiagramElementDetailsElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.MetaClassGuidString, "ColorDetails")>
	Partial Public Class ColorDetails
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
		#Region "ColorDetails's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "adf78b62-0fc3-4fa7-93a0-9e713193beb1"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.MetaClassGuidString)
		#End Region

		#Region "Color's Generated  Field Code"
		#Region "Color's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const ColorMetaAttributeGuidString As System.String = "e698fac4-70c2-4a24-b4ce-109689163f16"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly ColorMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuidString)
		#End Region

		#Region "Color's Generated Property Code"

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(CustomStorage:=True, FieldHandlerType:=GetType(ColorDetailsColorFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuidString, "ColorDetails.Color")>
		Public Property Color() As System.Drawing.Color
			Get
				Return colorDetailsColorFieldHandler_Renamed.GetFieldValue(Me)
			End Get

			Set(ByVal value As System.Drawing.Color)
				colorDetailsColorFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ColorDetailsColorFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ColorDetails.Color field
		''' </summary>
'INSTANT VB NOTE: The variable colorDetailsColorFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared colorDetailsColorFieldHandler_Renamed As ColorDetailsColorFieldHandler = ColorDetailsColorFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ColorDetails.Color
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ColorDetailsColorFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementCustomStoredFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails,System.Drawing.Color)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ColorDetails.Color field handler
			''' </summary>
			''' <value>ColorDetailsColorFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ColorDetailsColorFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler
					Else
						' The static constructor in ColorDetails will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.colorDetailsColorFieldHandler, so just instantiate one and return it
						Return New ColorDetailsColorFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ColorDetails.Color field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails.ColorMetaAttributeGuid
				End Get
			End Property
		End Class
		#End Region
		#End Region

	End Class
	#Region "ColorDetails's Generated Constructor Code"
	Partial Public Class ColorDetails
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateColorDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ColorDetails
			Return CreateColorDetails(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeColorDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ColorDetails
			Return CreateAndInitializeColorDetails(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateColorDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ColorDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(ColorDetails)), ColorDetails)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeColorDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ColorDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(ColorDetails), assignments), ColorDetails)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ColorDetails"
	''' <summary>
	''' ColorDetails Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails))>
	Public NotInheritable Class ColorDetailsElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ColorDetailsElementFactoryCreator
			Get
				Return New ColorDetailsElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.MetaClassGuidString, "ShapeDecorator")>
	Partial Public Class ShapeDecorator
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
		#Region "ShapeDecorator's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "7f690600-d53e-48c1-a0e6-b7683cd1082d"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.MetaClassGuidString)
		#End Region

		#Region "Position's Generated  Field Code"
		#Region "Position's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const PositionMetaAttributeGuidString As System.String = "537b7e3d-274f-4861-8657-14e3357d49dd"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly PositionMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuidString)
		#End Region

		#Region "Position's Generated Property Code"

		Private positionPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition = Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition.Center

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition),DefaultEnumerationValueName:="Center"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ShapeDecoratorPositionFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuidString, "ShapeDecorator.Position")>
		Public Property Position() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition
			Get
				Return positionPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition)
				shapeDecoratorPositionFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ShapeDecoratorPositionFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ShapeDecorator.Position field
		''' </summary>
'INSTANT VB NOTE: The variable shapeDecoratorPositionFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared shapeDecoratorPositionFieldHandler_Renamed As ShapeDecoratorPositionFieldHandler = ShapeDecoratorPositionFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ShapeDecorator.Position
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ShapeDecoratorPositionFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator,Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ShapeDecorator.Position field handler
			''' </summary>
			''' <value>ShapeDecoratorPositionFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ShapeDecoratorPositionFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler
					Else
						' The static constructor in ShapeDecorator will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.shapeDecoratorPositionFieldHandler, so just instantiate one and return it
						Return New ShapeDecoratorPositionFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ShapeDecorator.Position field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator.PositionMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ShapeDecorator</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition
				Return element.positionPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorPosition) As Boolean
				oldValue = element.positionPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.positionPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "Collection Classes for ShapeDecorator"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeDecoratorMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ShapeDecorator's Generated Constructor Code"
	Partial Public Class ShapeDecorator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeDecorator(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeDecorator
			Return CreateShapeDecorator(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeDecorator(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeDecorator
			Return CreateAndInitializeShapeDecorator(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeDecorator(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeDecorator
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeDecorator)), ShapeDecorator)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeDecorator(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeDecorator
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeDecorator), assignments), ShapeDecorator)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeDecorator"
	''' <summary>
	''' ShapeDecorator Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator))>
	Public NotInheritable Class ShapeDecoratorElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeDecoratorElementFactoryCreator
			Get
				Return New ShapeDecoratorElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.MetaClassGuidString, "ShapeText")>
	Partial Public Class ShapeText
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
		#Region "ShapeText's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "99272c48-c486-47ff-b057-93a91703ba93"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.MetaClassGuidString)
		#End Region

		#Region "DefaultTextId's Generated  Field Code"
		#Region "DefaultTextId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const DefaultTextIdMetaAttributeGuidString As System.String = "9f9e55ea-4cdb-49f6-ba74-908d2e614895"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly DefaultTextIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuidString)
		#End Region

		#Region "DefaultTextId's Generated Property Code"

		Private defaultTextIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ShapeTextDefaultTextIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuidString, "ShapeText.DefaultTextId")>
		Public Property DefaultTextId() As System.String
			Get
				Return defaultTextIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				shapeTextDefaultTextIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ShapeTextDefaultTextIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ShapeText.DefaultTextId field
		''' </summary>
'INSTANT VB NOTE: The variable shapeTextDefaultTextIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared shapeTextDefaultTextIdFieldHandler_Renamed As ShapeTextDefaultTextIdFieldHandler = ShapeTextDefaultTextIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ShapeText.DefaultTextId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ShapeTextDefaultTextIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ShapeText.DefaultTextId field handler
			''' </summary>
			''' <value>ShapeTextDefaultTextIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ShapeTextDefaultTextIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler
					Else
						' The static constructor in ShapeText will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.shapeTextDefaultTextIdFieldHandler, so just instantiate one and return it
						Return New ShapeTextDefaultTextIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ShapeText.DefaultTextId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText.DefaultTextIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ShapeText</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText) As System.String
				Return element.defaultTextIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.defaultTextIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.defaultTextIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ShapeText's Generated Constructor Code"
	Partial Public Class ShapeText
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeText(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeText
			Return CreateShapeText(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeText(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeText
			Return CreateAndInitializeShapeText(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeText(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeText
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeText)), ShapeText)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeText(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeText
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeText), assignments), ShapeText)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeText"
	''' <summary>
	''' ShapeText Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText))>
	Public NotInheritable Class ShapeTextElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeText(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeTextElementFactoryCreator
			Get
				Return New ShapeTextElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.MetaClassGuidString, "ShapeIcon")>
	Partial Public Class ShapeIcon
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
		#Region "ShapeIcon's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "c67fc6bc-c353-40e3-af24-f6bb35b5441c"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.MetaClassGuidString)
		#End Region

		#Region "IconId's Generated  Field Code"
		#Region "IconId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const IconIdMetaAttributeGuidString As System.String = "cbf105bc-36a0-4f21-bbbd-f09cdbbdc932"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly IconIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuidString)
		#End Region

		#Region "IconId's Generated Property Code"

		Private iconIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ShapeIconIconIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuidString, "ShapeIcon.IconId")>
		Public Property IconId() As System.String
			Get
				Return iconIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				shapeIconIconIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ShapeIconIconIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ShapeIcon.IconId field
		''' </summary>
'INSTANT VB NOTE: The variable shapeIconIconIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared shapeIconIconIdFieldHandler_Renamed As ShapeIconIconIdFieldHandler = ShapeIconIconIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ShapeIcon.IconId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ShapeIconIconIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ShapeIcon.IconId field handler
			''' </summary>
			''' <value>ShapeIconIconIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ShapeIconIconIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler
					Else
						' The static constructor in ShapeIcon will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.shapeIconIconIdFieldHandler, so just instantiate one and return it
						Return New ShapeIconIconIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ShapeIcon.IconId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon.IconIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ShapeIcon</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon) As System.String
				Return element.iconIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.iconIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.iconIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ShapeIcon's Generated Constructor Code"
	Partial Public Class ShapeIcon
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeIcon(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeIcon
			Return CreateShapeIcon(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeIcon(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeIcon
			Return CreateAndInitializeShapeIcon(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeIcon(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeIcon
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeIcon)), ShapeIcon)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeIcon(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeIcon
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeIcon), assignments), ShapeIcon)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeIcon"
	''' <summary>
	''' ShapeIcon Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon))>
	Public NotInheritable Class ShapeIconElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeIconElementFactoryCreator
			Get
				Return New ShapeIconElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse.MetaClassGuidString, "ExpandCollapse")>
	Partial Public Class ExpandCollapse
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecorator
		#Region "ExpandCollapse's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "7bd3c359-babd-4843-9a80-239fe5b50f92"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse.MetaClassGuidString)
		#End Region

	End Class
	#Region "ExpandCollapse's Generated Constructor Code"
	Partial Public Class ExpandCollapse
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExpandCollapse(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ExpandCollapse
			Return CreateExpandCollapse(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExpandCollapse(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ExpandCollapse
			Return CreateAndInitializeExpandCollapse(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateExpandCollapse(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ExpandCollapse
			Return CType(partition.ElementFactory.CreateElement(GetType(ExpandCollapse)), ExpandCollapse)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeExpandCollapse(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ExpandCollapse
			Return CType(partition.ElementFactory.CreateElement(GetType(ExpandCollapse), assignments), ExpandCollapse)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ExpandCollapse"
	''' <summary>
	''' ExpandCollapse Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse))>
	Public NotInheritable Class ExpandCollapseElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ExpandCollapse(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ExpandCollapseElementFactoryCreator
			Get
				Return New ExpandCollapseElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.MetaClassGuidString, "ConnectorDecorator")>
	Partial Public Class ConnectorDecorator
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
		#Region "ConnectorDecorator's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "2a56ecc0-172f-47aa-99ed-e9bdb09ba1ea"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.MetaClassGuidString)
		#End Region

		#Region "Position's Generated  Field Code"
		#Region "Position's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const PositionMetaAttributeGuidString As System.String = "6ce604ef-1e7c-47f3-82db-821381ce129a"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly PositionMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuidString)
		#End Region

		#Region "Position's Generated Property Code"

		Private positionPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition = Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition.CenterTop

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition),DefaultEnumerationValueName:="CenterTop"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ConnectorDecoratorPositionFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuidString, "ConnectorDecorator.Position")>
		Public Property Position() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition
			Get
				Return positionPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition)
				connectorDecoratorPositionFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ConnectorDecoratorPositionFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ConnectorDecorator.Position field
		''' </summary>
'INSTANT VB NOTE: The variable connectorDecoratorPositionFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared connectorDecoratorPositionFieldHandler_Renamed As ConnectorDecoratorPositionFieldHandler = ConnectorDecoratorPositionFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ConnectorDecorator.Position
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ConnectorDecoratorPositionFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator,Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ConnectorDecorator.Position field handler
			''' </summary>
			''' <value>ConnectorDecoratorPositionFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ConnectorDecoratorPositionFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler
					Else
						' The static constructor in ConnectorDecorator will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.connectorDecoratorPositionFieldHandler, so just instantiate one and return it
						Return New ConnectorDecoratorPositionFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ConnectorDecorator.Position field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator.PositionMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ConnectorDecorator</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition
				Return element.positionPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecoratorPosition) As Boolean
				oldValue = element.positionPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.positionPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "Collection Classes for ConnectorDecorator"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorDecoratorMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ConnectorDecorator's Generated Constructor Code"
	Partial Public Class ConnectorDecorator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorDecorator(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorDecorator
			Return CreateConnectorDecorator(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorDecorator(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorDecorator
			Return CreateAndInitializeConnectorDecorator(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorDecorator(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorDecorator
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorDecorator)), ConnectorDecorator)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorDecorator(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorDecorator
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorDecorator), assignments), ConnectorDecorator)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorDecorator"
	''' <summary>
	''' ConnectorDecorator Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator))>
	Public NotInheritable Class ConnectorDecoratorElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorDecoratorElementFactoryCreator
			Get
				Return New ConnectorDecoratorElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.MetaClassGuidString, "ConnectorText")>
	Partial Public Class ConnectorText
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator
		#Region "ConnectorText's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "dd5cabab-3edf-45df-ab78-b3c108d301c6"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.MetaClassGuidString)
		#End Region

		#Region "DefaultTextId's Generated  Field Code"
		#Region "DefaultTextId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const DefaultTextIdMetaAttributeGuidString As System.String = "d4c00aad-f864-4e4c-ba54-8b9bab0ed8d9"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly DefaultTextIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuidString)
		#End Region

		#Region "DefaultTextId's Generated Property Code"

		Private defaultTextIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ConnectorTextDefaultTextIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuidString, "ConnectorText.DefaultTextId")>
		Public Property DefaultTextId() As System.String
			Get
				Return defaultTextIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				connectorTextDefaultTextIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ConnectorTextDefaultTextIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ConnectorText.DefaultTextId field
		''' </summary>
'INSTANT VB NOTE: The variable connectorTextDefaultTextIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared connectorTextDefaultTextIdFieldHandler_Renamed As ConnectorTextDefaultTextIdFieldHandler = ConnectorTextDefaultTextIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ConnectorText.DefaultTextId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ConnectorTextDefaultTextIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ConnectorText.DefaultTextId field handler
			''' </summary>
			''' <value>ConnectorTextDefaultTextIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ConnectorTextDefaultTextIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler
					Else
						' The static constructor in ConnectorText will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.connectorTextDefaultTextIdFieldHandler, so just instantiate one and return it
						Return New ConnectorTextDefaultTextIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ConnectorText.DefaultTextId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText.DefaultTextIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ConnectorText</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText) As System.String
				Return element.defaultTextIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.defaultTextIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.defaultTextIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ConnectorText's Generated Constructor Code"
	Partial Public Class ConnectorText
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorText(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorText
			Return CreateConnectorText(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorText(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorText
			Return CreateAndInitializeConnectorText(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorText(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorText
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorText)), ConnectorText)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorText(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorText
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorText), assignments), ConnectorText)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorText"
	''' <summary>
	''' ConnectorText Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText))>
	Public NotInheritable Class ConnectorTextElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorTextElementFactoryCreator
			Get
				Return New ConnectorTextElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.MetaClassGuidString, "ConnectorIcon")>
	Partial Public Class ConnectorIcon
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorDecorator
		#Region "ConnectorIcon's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "c932c24c-58e7-413f-92f8-84a8a37d61b6"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.MetaClassGuidString)
		#End Region

		#Region "IconId's Generated  Field Code"
		#Region "IconId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const IconIdMetaAttributeGuidString As System.String = "160f03a2-3594-4a00-aadb-f4f7542015ee"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly IconIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuidString)
		#End Region

		#Region "IconId's Generated Property Code"

		Private iconIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ConnectorIconIconIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuidString, "ConnectorIcon.IconId")>
		Public Property IconId() As System.String
			Get
				Return iconIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				connectorIconIconIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ConnectorIconIconIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ConnectorIcon.IconId field
		''' </summary>
'INSTANT VB NOTE: The variable connectorIconIconIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared connectorIconIconIdFieldHandler_Renamed As ConnectorIconIconIdFieldHandler = ConnectorIconIconIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ConnectorIcon.IconId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ConnectorIconIconIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ConnectorIcon.IconId field handler
			''' </summary>
			''' <value>ConnectorIconIconIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ConnectorIconIconIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler
					Else
						' The static constructor in ConnectorIcon will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.connectorIconIconIdFieldHandler, so just instantiate one and return it
						Return New ConnectorIconIconIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ConnectorIcon.IconId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon.IconIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ConnectorIcon</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon) As System.String
				Return element.iconIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.iconIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.iconIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ConnectorIcon's Generated Constructor Code"
	Partial Public Class ConnectorIcon
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorIcon(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorIcon
			Return CreateConnectorIcon(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorIcon(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorIcon
			Return CreateAndInitializeConnectorIcon(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorIcon(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorIcon
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorIcon)), ConnectorIcon)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorIcon(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorIcon
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorIcon), assignments), ConnectorIcon)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorIcon"
	''' <summary>
	''' ConnectorIcon Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon))>
	Public NotInheritable Class ConnectorIconElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIcon(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorIconElementFactoryCreator
			Get
				Return New ConnectorIconElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.MetaClassGuidString, "DashStyleDetails")>
	Partial Public Class DashStyleDetails
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.DiagramElementDetails
		#Region "DashStyleDetails's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "c1329e93-f6f4-4d1b-95ce-4654e4c79427"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.MetaClassGuidString)
		#End Region

		#Region "DashStyle's Generated  Field Code"
		#Region "DashStyle's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const DashStyleMetaAttributeGuidString As System.String = "e98d5806-842b-4c87-85f8-2a7cd965389b"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly DashStyleMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuidString)
		#End Region

		#Region "DashStyle's Generated Property Code"

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(CustomStorage:=True, FieldHandlerType:=GetType(DashStyleDetailsDashStyleFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuidString, "DashStyleDetails.DashStyle")>
		Public Property DashStyle() As System.Drawing.Drawing2D.DashStyle
			Get
				Return dashStyleDetailsDashStyleFieldHandler_Renamed.GetFieldValue(Me)
			End Get

			Set(ByVal value As System.Drawing.Drawing2D.DashStyle)
				dashStyleDetailsDashStyleFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "DashStyleDetailsDashStyleFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for DashStyleDetails.DashStyle field
		''' </summary>
'INSTANT VB NOTE: The variable dashStyleDetailsDashStyleFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared dashStyleDetailsDashStyleFieldHandler_Renamed As DashStyleDetailsDashStyleFieldHandler = DashStyleDetailsDashStyleFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for DashStyleDetails.DashStyle
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class DashStyleDetailsDashStyleFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementCustomStoredFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails,System.Drawing.Drawing2D.DashStyle)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the DashStyleDetails.DashStyle field handler
			''' </summary>
			''' <value>DashStyleDetailsDashStyleFieldHandler</value>
			Public Shared ReadOnly Property Instance() As DashStyleDetailsDashStyleFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler
					Else
						' The static constructor in DashStyleDetails will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.dashStyleDetailsDashStyleFieldHandler, so just instantiate one and return it
						Return New DashStyleDetailsDashStyleFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the DashStyleDetails.DashStyle field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails.DashStyleMetaAttributeGuid
				End Get
			End Property
		End Class
		#End Region
		#End Region

	End Class
	#Region "DashStyleDetails's Generated Constructor Code"
	Partial Public Class DashStyleDetails
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDashStyleDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store) As DashStyleDetails
			Return CreateDashStyleDetails(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDashStyleDetails(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DashStyleDetails
			Return CreateAndInitializeDashStyleDetails(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateDashStyleDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As DashStyleDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(DashStyleDetails)), DashStyleDetails)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeDashStyleDetails(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As DashStyleDetails
			Return CType(partition.ElementFactory.CreateElement(GetType(DashStyleDetails), assignments), DashStyleDetails)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for DashStyleDetails"
	''' <summary>
	''' DashStyleDetails Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails))>
	Public NotInheritable Class DashStyleDetailsElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.DashStyleDetails(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As DashStyleDetailsElementFactoryCreator
			Get
				Return New DashStyleDetailsElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.MetaClassGuidString, "NodeRendering")>
	Partial Public Class NodeRendering
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "NodeRendering's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "bc1d4e0c-65a8-4fad-a5a6-afa8d934cdba"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.MetaClassGuidString)
		#End Region

		#Region "IconId's Generated  Field Code"
		#Region "IconId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const IconIdMetaAttributeGuidString As System.String = "e989b98b-76cd-46a4-9888-670fd75a520d"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly IconIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuidString)
		#End Region

		#Region "IconId's Generated Property Code"

		Private iconIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(NodeRenderingIconIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuidString, "NodeRendering.IconId")>
		Public Property IconId() As System.String
			Get
				Return iconIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				nodeRenderingIconIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "NodeRenderingIconIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for NodeRendering.IconId field
		''' </summary>
'INSTANT VB NOTE: The variable nodeRenderingIconIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared nodeRenderingIconIdFieldHandler_Renamed As NodeRenderingIconIdFieldHandler = NodeRenderingIconIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for NodeRendering.IconId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class NodeRenderingIconIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the NodeRendering.IconId field handler
			''' </summary>
			''' <value>NodeRenderingIconIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As NodeRenderingIconIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler
					Else
						' The static constructor in NodeRendering will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.nodeRenderingIconIdFieldHandler, so just instantiate one and return it
						Return New NodeRenderingIconIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the NodeRendering.IconId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering.IconIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the NodeRendering</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering) As System.String
				Return element.iconIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.iconIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.iconIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "NodeRendering's Generated Constructor Code"
	Partial Public Class NodeRendering
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store) As NodeRendering
			Return CreateNodeRendering(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As NodeRendering
			Return CreateAndInitializeNodeRendering(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As NodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(NodeRendering)), NodeRendering)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As NodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(NodeRendering), assignments), NodeRendering)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for NodeRendering"
	''' <summary>
	''' NodeRendering Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering))>
	Public NotInheritable Class NodeRenderingElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As NodeRenderingElementFactoryCreator
			Get
				Return New NodeRenderingElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.MetaClassGuidString, "ClassNodeRendering")>
	Partial Public Class ClassNodeRendering
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering
		#Region "ClassNodeRendering's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "effbaccc-31a5-428a-ac2f-4cd6fbcac0be"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.MetaClassGuidString)
		#End Region

		#Region "AppendClassNameToCaption's Generated  Field Code"
		#Region "AppendClassNameToCaption's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const AppendClassNameToCaptionMetaAttributeGuidString As System.String = "2627af4e-9795-4f28-9a12-3df4295cca4b"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly AppendClassNameToCaptionMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuidString)
		#End Region

		#Region "AppendClassNameToCaption's Generated Property Code"

		Private appendClassNameToCaptionPropertyStorage As System.Boolean = False

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=False), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ClassNodeRenderingAppendClassNameToCaptionFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuidString, "ClassNodeRendering.AppendClassNameToCaption")>
		Public Property AppendClassNameToCaption() As System.Boolean
			Get
				Return appendClassNameToCaptionPropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				classNodeRenderingAppendClassNameToCaptionFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ClassNodeRenderingAppendClassNameToCaptionFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ClassNodeRendering.AppendClassNameToCaption field
		''' </summary>
'INSTANT VB NOTE: The variable classNodeRenderingAppendClassNameToCaptionFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared classNodeRenderingAppendClassNameToCaptionFieldHandler_Renamed As ClassNodeRenderingAppendClassNameToCaptionFieldHandler = ClassNodeRenderingAppendClassNameToCaptionFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ClassNodeRendering.AppendClassNameToCaption
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ClassNodeRenderingAppendClassNameToCaptionFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ClassNodeRendering.AppendClassNameToCaption field handler
			''' </summary>
			''' <value>ClassNodeRenderingAppendClassNameToCaptionFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ClassNodeRenderingAppendClassNameToCaptionFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler
					Else
						' The static constructor in ClassNodeRendering will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.classNodeRenderingAppendClassNameToCaptionFieldHandler, so just instantiate one and return it
						Return New ClassNodeRenderingAppendClassNameToCaptionFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ClassNodeRendering.AppendClassNameToCaption field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering.AppendClassNameToCaptionMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ClassNodeRendering</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) As System.Boolean
				Return element.appendClassNameToCaptionPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.appendClassNameToCaptionPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.appendClassNameToCaptionPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlConcept)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass.ClassNodeRenderingMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRenderingReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ClassNodeRendering"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ClassNodeRenderingMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ClassNodeRendering's Generated Constructor Code"
	Partial Public Class ClassNodeRendering
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateClassNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ClassNodeRendering
			Return CreateClassNodeRendering(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeClassNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ClassNodeRendering
			Return CreateAndInitializeClassNodeRendering(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateClassNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ClassNodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(ClassNodeRendering)), ClassNodeRendering)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeClassNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ClassNodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(ClassNodeRendering), assignments), ClassNodeRendering)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ClassNodeRendering"
	''' <summary>
	''' ClassNodeRendering Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering))>
	Public NotInheritable Class ClassNodeRenderingElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ClassNodeRendering(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ClassNodeRenderingElementFactoryCreator
			Get
				Return New ClassNodeRenderingElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Description("CollectionNodeRenderingDescription", GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel), Microsoft.VisualStudio.Modeling.DesignerDefinition.DesignerDefinitionObjectModel.ResourceBaseName), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.MetaClassGuidString, "CollectionNodeRendering")>
	Partial Public Class CollectionNodeRendering
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.NodeRendering
		#Region "CollectionNodeRendering's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "ae94a1bd-e622-493b-b1dd-1a3a9f87c8af"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.MetaClassGuidString)
		#End Region

		#Region "CaptionId's Generated  Field Code"
		#Region "CaptionId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const CaptionIdMetaAttributeGuidString As System.String = "a9ec4fe4-81a7-4dfb-af13-d6aa335021bc"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly CaptionIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuidString)
		#End Region

		#Region "CaptionId's Generated Property Code"

		Private captionIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CollectionNodeRenderingCaptionIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuidString, "CollectionNodeRendering.CaptionId")>
		Public Property CaptionId() As System.String
			Get
				Return captionIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				collectionNodeRenderingCaptionIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CollectionNodeRenderingCaptionIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for CollectionNodeRendering.CaptionId field
		''' </summary>
'INSTANT VB NOTE: The variable collectionNodeRenderingCaptionIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared collectionNodeRenderingCaptionIdFieldHandler_Renamed As CollectionNodeRenderingCaptionIdFieldHandler = CollectionNodeRenderingCaptionIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for CollectionNodeRendering.CaptionId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CollectionNodeRenderingCaptionIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the CollectionNodeRendering.CaptionId field handler
			''' </summary>
			''' <value>CollectionNodeRenderingCaptionIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CollectionNodeRenderingCaptionIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler
					Else
						' The static constructor in CollectionNodeRendering will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.collectionNodeRenderingCaptionIdFieldHandler, so just instantiate one and return it
						Return New CollectionNodeRenderingCaptionIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the CollectionNodeRendering.CaptionId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering.CaptionIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the CollectionNodeRendering</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering) As System.String
				Return element.captionIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.captionIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.captionIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "CollectionNodeRendering's Generated Constructor Code"
	Partial Public Class CollectionNodeRendering
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCollectionNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store) As CollectionNodeRendering
			Return CreateCollectionNodeRendering(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCollectionNodeRendering(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CollectionNodeRendering
			Return CreateAndInitializeCollectionNodeRendering(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCollectionNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As CollectionNodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(CollectionNodeRendering)), CollectionNodeRendering)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCollectionNodeRendering(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CollectionNodeRendering
			Return CType(partition.ElementFactory.CreateElement(GetType(CollectionNodeRendering), assignments), CollectionNodeRendering)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for CollectionNodeRendering"
	''' <summary>
	''' CollectionNodeRendering Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering))>
	Public NotInheritable Class CollectionNodeRenderingElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CollectionNodeRendering(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As CollectionNodeRenderingElementFactoryCreator
			Get
				Return New CollectionNodeRenderingElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape.MetaClassGuidString, "Shape")>
	Partial Public Class Shape
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Shape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "e34e57c8-719f-496c-9816-4e6b8141e9e2"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape.MetaClassGuidString)
		#End Region

		#Region "Decorators's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Decorators() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeDecoratorMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.ShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.DecoratedShapeHasDecorators.DecoratorsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "Collection Classes for Shape"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "Shape's Generated Constructor Code"
	Partial Public Class Shape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Shape
			Return CreateShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Shape
			Return CreateAndInitializeShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Shape
			Return CType(partition.ElementFactory.CreateElement(GetType(Shape)), Shape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Shape
			Return CType(partition.ElementFactory.CreateElement(GetType(Shape), assignments), Shape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Shape"
	''' <summary>
	''' Shape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape))>
	Public NotInheritable Class ShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeElementFactoryCreator
			Get
				Return New ShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.MetaClassGuidString, "OutlinedShape")>
	Partial Public Class OutlinedShape
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
		#Region "OutlinedShape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "7ee2c579-be66-4d3b-a73d-e955d01da083"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.MetaClassGuidString)
		#End Region

		#Region "InitialWidth's Generated  Field Code"
		#Region "InitialWidth's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const InitialWidthMetaAttributeGuidString As System.String = "7b894222-bdd9-4c0a-b325-3c2ca060c25b"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly InitialWidthMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuidString)
		#End Region

		#Region "InitialWidth's Generated Property Code"

		Private initialWidthPropertyStorage As System.Double = 0

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.DoubleDomainAttribute(MinValue:=-1.79769313486232E+307,MaxValue:=1.79769313486232E+307), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(OutlinedShapeInitialWidthFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuidString, "OutlinedShape.InitialWidth")>
		Public Property InitialWidth() As System.Double
			Get
				Return initialWidthPropertyStorage
			End Get

			Set(ByVal value As System.Double)
				outlinedShapeInitialWidthFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "OutlinedShapeInitialWidthFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for OutlinedShape.InitialWidth field
		''' </summary>
'INSTANT VB NOTE: The variable outlinedShapeInitialWidthFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared outlinedShapeInitialWidthFieldHandler_Renamed As OutlinedShapeInitialWidthFieldHandler = OutlinedShapeInitialWidthFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for OutlinedShape.InitialWidth
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class OutlinedShapeInitialWidthFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape,System.Double)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the OutlinedShape.InitialWidth field handler
			''' </summary>
			''' <value>OutlinedShapeInitialWidthFieldHandler</value>
			Public Shared ReadOnly Property Instance() As OutlinedShapeInitialWidthFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler
					Else
						' The static constructor in OutlinedShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialWidthFieldHandler, so just instantiate one and return it
						Return New OutlinedShapeInitialWidthFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the OutlinedShape.InitialWidth field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialWidthMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the OutlinedShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape) As System.Double
				Return element.initialWidthPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape, ByVal value As System.Double, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Double) As Boolean
				oldValue = element.initialWidthPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.initialWidthPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "InitialHeight's Generated  Field Code"
		#Region "InitialHeight's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const InitialHeightMetaAttributeGuidString As System.String = "58a1f843-ab41-43b7-826c-9af13e5a22b9"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly InitialHeightMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuidString)
		#End Region

		#Region "InitialHeight's Generated Property Code"

		Private initialHeightPropertyStorage As System.Double = 0

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.DoubleDomainAttribute(MinValue:=-1.79769313486232E+307,MaxValue:=1.79769313486232E+307), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(OutlinedShapeInitialHeightFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuidString, "OutlinedShape.InitialHeight")>
		Public Property InitialHeight() As System.Double
			Get
				Return initialHeightPropertyStorage
			End Get

			Set(ByVal value As System.Double)
				outlinedShapeInitialHeightFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "OutlinedShapeInitialHeightFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for OutlinedShape.InitialHeight field
		''' </summary>
'INSTANT VB NOTE: The variable outlinedShapeInitialHeightFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared outlinedShapeInitialHeightFieldHandler_Renamed As OutlinedShapeInitialHeightFieldHandler = OutlinedShapeInitialHeightFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for OutlinedShape.InitialHeight
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class OutlinedShapeInitialHeightFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape,System.Double)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the OutlinedShape.InitialHeight field handler
			''' </summary>
			''' <value>OutlinedShapeInitialHeightFieldHandler</value>
			Public Shared ReadOnly Property Instance() As OutlinedShapeInitialHeightFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler
					Else
						' The static constructor in OutlinedShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.outlinedShapeInitialHeightFieldHandler, so just instantiate one and return it
						Return New OutlinedShapeInitialHeightFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the OutlinedShape.InitialHeight field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape.InitialHeightMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the OutlinedShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape) As System.Double
				Return element.initialHeightPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape, ByVal value As System.Double, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Double) As Boolean
				oldValue = element.initialHeightPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.initialHeightPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "FillColor's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property FillColor() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.FillColorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor.ShapeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeHasFillColor), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "OutlineColor's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property OutlineColor() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlineColorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor.OutlinedShapeMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShapeHasOutlineColor), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "OutlinedShape's Generated Constructor Code"
	Partial Public Class OutlinedShape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateOutlinedShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As OutlinedShape
			Return CreateOutlinedShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeOutlinedShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As OutlinedShape
			Return CreateAndInitializeOutlinedShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateOutlinedShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As OutlinedShape
			Return CType(partition.ElementFactory.CreateElement(GetType(OutlinedShape)), OutlinedShape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeOutlinedShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As OutlinedShape
			Return CType(partition.ElementFactory.CreateElement(GetType(OutlinedShape), assignments), OutlinedShape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for OutlinedShape"
	''' <summary>
	''' OutlinedShape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape))>
	Public NotInheritable Class OutlinedShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As OutlinedShapeElementFactoryCreator
			Get
				Return New OutlinedShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.MetaClassGuidString, "CompartmentShape")>
	Partial Public Class CompartmentShape
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
		#Region "CompartmentShape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "c2e8313e-721e-4b5e-a6ff-edd28913d277"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.MetaClassGuidString)
		#End Region

		#Region "Geometry's Generated  Field Code"
		#Region "Geometry's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const GeometryMetaAttributeGuidString As System.String = "e36d34b4-e96e-465c-b6f1-18530b47e975"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly GeometryMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuidString)
		#End Region

		#Region "Geometry's Generated Property Code"

		Private geometryPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry = Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry.Rectangle

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry),DefaultEnumerationValueName:="Rectangle"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CompartmentShapeGeometryFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuidString, "CompartmentShape.Geometry")>
		Public Property Geometry() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry
			Get
				Return geometryPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry)
				compartmentShapeGeometryFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CompartmentShapeGeometryFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for CompartmentShape.Geometry field
		''' </summary>
'INSTANT VB NOTE: The variable compartmentShapeGeometryFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared compartmentShapeGeometryFieldHandler_Renamed As CompartmentShapeGeometryFieldHandler = CompartmentShapeGeometryFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for CompartmentShape.Geometry
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CompartmentShapeGeometryFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape,Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the CompartmentShape.Geometry field handler
			''' </summary>
			''' <value>CompartmentShapeGeometryFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CompartmentShapeGeometryFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler
					Else
						' The static constructor in CompartmentShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeGeometryFieldHandler, so just instantiate one and return it
						Return New CompartmentShapeGeometryFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the CompartmentShape.Geometry field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.GeometryMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the CompartmentShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape) As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry
				Return element.geometryPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeGeometry) As Boolean
				oldValue = element.geometryPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.geometryPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "IsSingleCompartmentHeaderVisible's Generated  Field Code"
		#Region "IsSingleCompartmentHeaderVisible's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const IsSingleCompartmentHeaderVisibleMetaAttributeGuidString As System.String = "70776980-d542-46a9-8f48-9b9627fa4457"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly IsSingleCompartmentHeaderVisibleMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuidString)
		#End Region

		#Region "IsSingleCompartmentHeaderVisible's Generated Property Code"

		Private isSingleCompartmentHeaderVisiblePropertyStorage As System.Boolean = True

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.BooleanDomainAttribute(DefaultBoolean:=True), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuidString, "CompartmentShape.IsSingleCompartmentHeaderVisible")>
		Public Property IsSingleCompartmentHeaderVisible() As System.Boolean
			Get
				Return isSingleCompartmentHeaderVisiblePropertyStorage
			End Get

			Set(ByVal value As System.Boolean)
				compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for CompartmentShape.IsSingleCompartmentHeaderVisible field
		''' </summary>
'INSTANT VB NOTE: The variable compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler_Renamed As CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler = CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for CompartmentShape.IsSingleCompartmentHeaderVisible
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape,System.Boolean)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the CompartmentShape.IsSingleCompartmentHeaderVisible field handler
			''' </summary>
			''' <value>CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler
					Else
						' The static constructor in CompartmentShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.compartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler, so just instantiate one and return it
						Return New CompartmentShapeIsSingleCompartmentHeaderVisibleFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the CompartmentShape.IsSingleCompartmentHeaderVisible field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape.IsSingleCompartmentHeaderVisibleMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the CompartmentShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape) As System.Boolean
				Return element.isSingleCompartmentHeaderVisiblePropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape, ByVal value As System.Boolean, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.Boolean) As Boolean
				oldValue = element.isSingleCompartmentHeaderVisiblePropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.isSingleCompartmentHeaderVisiblePropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "Compartments's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property Compartments() As Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentShapeMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShapeHasCompartments.CompartmentsMetaRoleGuid)
			End Get
		End Property
		#End Region
	End Class
	#Region "CompartmentShape's Generated Constructor Code"
	Partial Public Class CompartmentShape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartmentShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As CompartmentShape
			Return CreateCompartmentShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartmentShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CompartmentShape
			Return CreateAndInitializeCompartmentShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartmentShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As CompartmentShape
			Return CType(partition.ElementFactory.CreateElement(GetType(CompartmentShape)), CompartmentShape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartmentShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As CompartmentShape
			Return CType(partition.ElementFactory.CreateElement(GetType(CompartmentShape), assignments), CompartmentShape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for CompartmentShape"
	''' <summary>
	''' CompartmentShape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape))>
	Public NotInheritable Class CompartmentShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentShape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As CompartmentShapeElementFactoryCreator
			Get
				Return New CompartmentShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.MetaClassGuidString, "GeometryShape")>
	Partial Public Class GeometryShape
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
		#Region "GeometryShape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "d55a03a6-9ff7-43f4-a43a-a92b01ca9a59"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.MetaClassGuidString)
		#End Region

		#Region "Geometry's Generated  Field Code"
		#Region "Geometry's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const GeometryMetaAttributeGuidString As System.String = "c5313341-3475-4076-bf06-9debff59f5c7"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly GeometryMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuidString)
		#End Region

		#Region "Geometry's Generated Property Code"

		Private geometryPropertyStorage As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry = Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry.Rectangle

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.EnumerationDomainAttribute(EnumerationType:=GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry),DefaultEnumerationValueName:="Rectangle"), Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(GeometryShapeGeometryFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuidString, "GeometryShape.Geometry")>
		Public Property Geometry() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry
			Get
				Return geometryPropertyStorage
			End Get

			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry)
				geometryShapeGeometryFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "GeometryShapeGeometryFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for GeometryShape.Geometry field
		''' </summary>
'INSTANT VB NOTE: The variable geometryShapeGeometryFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared geometryShapeGeometryFieldHandler_Renamed As GeometryShapeGeometryFieldHandler = GeometryShapeGeometryFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for GeometryShape.Geometry
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class GeometryShapeGeometryFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape,Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the GeometryShape.Geometry field handler
			''' </summary>
			''' <value>GeometryShapeGeometryFieldHandler</value>
			Public Shared ReadOnly Property Instance() As GeometryShapeGeometryFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler
					Else
						' The static constructor in GeometryShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.geometryShapeGeometryFieldHandler, so just instantiate one and return it
						Return New GeometryShapeGeometryFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the GeometryShape.Geometry field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape.GeometryMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the GeometryShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry
				Return element.geometryPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeGeometry) As Boolean
				oldValue = element.geometryPropertyStorage
				If allowDuplicates OrElse oldValue IsNot value Then
					OnValueChanging(element, oldValue, value)
					element.geometryPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "GeometryShape's Generated Constructor Code"
	Partial Public Class GeometryShape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateGeometryShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As GeometryShape
			Return CreateGeometryShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeGeometryShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As GeometryShape
			Return CreateAndInitializeGeometryShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateGeometryShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As GeometryShape
			Return CType(partition.ElementFactory.CreateElement(GetType(GeometryShape)), GeometryShape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeGeometryShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As GeometryShape
			Return CType(partition.ElementFactory.CreateElement(GetType(GeometryShape), assignments), GeometryShape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for GeometryShape"
	''' <summary>
	''' GeometryShape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape))>
	Public NotInheritable Class GeometryShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.GeometryShape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As GeometryShapeElementFactoryCreator
			Get
				Return New GeometryShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.MetaClassGuidString, "PathShape")>
	Partial Public Class PathShape
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.OutlinedShape
		#Region "PathShape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "88fa85a2-8823-4f9a-960e-9bdeb3ec32b9"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.MetaClassGuidString)
		#End Region

		#Region "Path's Generated  Field Code"
		#Region "Path's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const PathMetaAttributeGuidString As System.String = "540ac62e-2348-4335-b52c-3dd2d4dd6f5d"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly PathMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuidString)
		#End Region

		#Region "Path's Generated Property Code"

		Private pathPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(PathShapePathFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuidString, "PathShape.Path")>
		Public Property Path() As System.String
			Get
				Return pathPropertyStorage
			End Get

			Set(ByVal value As System.String)
				pathShapePathFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "PathShapePathFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for PathShape.Path field
		''' </summary>
'INSTANT VB NOTE: The variable pathShapePathFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared pathShapePathFieldHandler_Renamed As PathShapePathFieldHandler = PathShapePathFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for PathShape.Path
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class PathShapePathFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the PathShape.Path field handler
			''' </summary>
			''' <value>PathShapePathFieldHandler</value>
			Public Shared ReadOnly Property Instance() As PathShapePathFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler
					Else
						' The static constructor in PathShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.pathShapePathFieldHandler, so just instantiate one and return it
						Return New PathShapePathFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the PathShape.Path field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape.PathMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the PathShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape) As System.String
				Return element.pathPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.pathPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.pathPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "PathShape's Generated Constructor Code"
	Partial Public Class PathShape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePathShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As PathShape
			Return CreatePathShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePathShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PathShape
			Return CreateAndInitializePathShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreatePathShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As PathShape
			Return CType(partition.ElementFactory.CreateElement(GetType(PathShape)), PathShape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializePathShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As PathShape
			Return CType(partition.ElementFactory.CreateElement(GetType(PathShape), assignments), PathShape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for PathShape"
	''' <summary>
	''' PathShape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape))>
	Public NotInheritable Class PathShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.PathShape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As PathShapeElementFactoryCreator
			Get
				Return New PathShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.MetaClassGuidString, "ImageShape")>
	Partial Public Class ImageShape
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.Shape
		#Region "ImageShape's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "2fd998d7-a283-488c-b419-36fb9499ea6d"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.MetaClassGuidString)
		#End Region

		#Region "ImageId's Generated  Field Code"
		#Region "ImageId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const ImageIdMetaAttributeGuidString As System.String = "80af3308-7aee-49a4-8988-62c0fde35266"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly ImageIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuidString)
		#End Region

		#Region "ImageId's Generated Property Code"

		Private imageIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(ImageShapeImageIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuidString, "ImageShape.ImageId")>
		Public Property ImageId() As System.String
			Get
				Return imageIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				imageShapeImageIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "ImageShapeImageIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for ImageShape.ImageId field
		''' </summary>
'INSTANT VB NOTE: The variable imageShapeImageIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared imageShapeImageIdFieldHandler_Renamed As ImageShapeImageIdFieldHandler = ImageShapeImageIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for ImageShape.ImageId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class ImageShapeImageIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the ImageShape.ImageId field handler
			''' </summary>
			''' <value>ImageShapeImageIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As ImageShapeImageIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler
					Else
						' The static constructor in ImageShape will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.imageShapeImageIdFieldHandler, so just instantiate one and return it
						Return New ImageShapeImageIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the ImageShape.ImageId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape.ImageIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the ImageShape</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape) As System.String
				Return element.imageIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.imageIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.imageIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

	End Class
	#Region "ImageShape's Generated Constructor Code"
	Partial Public Class ImageShape
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateImageShape(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ImageShape
			Return CreateImageShape(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeImageShape(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ImageShape
			Return CreateAndInitializeImageShape(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateImageShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ImageShape
			Return CType(partition.ElementFactory.CreateElement(GetType(ImageShape)), ImageShape)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeImageShape(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ImageShape
			Return CType(partition.ElementFactory.CreateElement(GetType(ImageShape), assignments), ImageShape)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ImageShape"
	''' <summary>
	''' ImageShape Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape))>
	Public NotInheritable Class ImageShapeElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ImageShape(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ImageShapeElementFactoryCreator
			Get
				Return New ImageShapeElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.MetaClassGuidString, "Compartment")>
	Partial Public Class Compartment
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "Compartment's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "847c56b8-80a4-48e5-ba45-191742b3951f"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.MetaClassGuidString)
		#End Region

		#Region "CaptionId's Generated  Field Code"
		#Region "CaptionId's Generated  MetaAttribute Code"
		''' <summary>
		''' MetaAttribute Guid String
		''' </summary>
		Public Const CaptionIdMetaAttributeGuidString As System.String = "d3b8d6da-f6e8-4a43-8c86-9c9c1f20d076"

		''' <summary>
		''' MetaAttribute Guid
		''' </summary>
		Public Shared ReadOnly CaptionIdMetaAttributeGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuidString)
		#End Region

		#Region "CaptionId's Generated Property Code"

		Private captionIdPropertyStorage As System.String = String.Empty

		''' <summary>
		''' 
		''' </summary>
		<Microsoft.VisualStudio.Modeling.StringDomainAttribute, Microsoft.VisualStudio.Modeling.MetaAttributeAttribute(FieldHandlerType:=GetType(CompartmentCaptionIdFieldHandler)), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuidString, "Compartment.CaptionId")>
		Public Property CaptionId() As System.String
			Get
				Return captionIdPropertyStorage
			End Get

			Set(ByVal value As System.String)
				compartmentCaptionIdFieldHandler_Renamed.SetFieldValue(Me, value, False, Microsoft.VisualStudio.Modeling.TransactionManager.CommandFactory)
			End Set
		End Property
		#End Region

		#Region "CompartmentCaptionIdFieldHandler Generated Code"
		''' <summary>
		''' FieldHandler for Compartment.CaptionId field
		''' </summary>
'INSTANT VB NOTE: The variable compartmentCaptionIdFieldHandler was renamed since Visual Basic does not handle variables named the same as their type well:
		Private Shared compartmentCaptionIdFieldHandler_Renamed As CompartmentCaptionIdFieldHandler = CompartmentCaptionIdFieldHandler.Instance

		''' <summary>
		''' Implement the field handler for Compartment.CaptionId
		''' </summary>
		<System.CLSCompliant(False)>
		Public NotInheritable Partial Class CompartmentCaptionIdFieldHandler
			Inherits Microsoft.VisualStudio.Modeling.TypedModelElementInlineFieldHandler(Of Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment,System.String)
			''' <summary>
			''' Constructor
			''' </summary>
			Private Sub New()
			End Sub

			''' <summary>
			''' Returns the singleton instance of the Compartment.CaptionId field handler
			''' </summary>
			''' <value>CompartmentCaptionIdFieldHandler</value>
			Public Shared ReadOnly Property Instance() As CompartmentCaptionIdFieldHandler
				Get
					If Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler IsNot Nothing Then
						Return Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler
					Else
						' The static constructor in Compartment will assign this value to
						' Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.compartmentCaptionIdFieldHandler, so just instantiate one and return it
						Return New CompartmentCaptionIdFieldHandler()
					End If
				End Get
			End Property

			''' <summary>
			''' Returns the meta attribute id for the Compartment.CaptionId field handler
			''' </summary>
			''' <value>Guid</value>
			Public NotOverridable Overrides ReadOnly Property Id() As System.Guid
				Get
					Return Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment.CaptionIdMetaAttributeGuid
				End Get
			End Property
			''' <summary>
			''' Gets the value of the attribute as it exists in the element
			''' </summary>
			''' <param name="element">the Compartment</param>
			Protected NotOverridable Overrides Function GetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) As System.String
				Return element.captionIdPropertyStorage
			End Function

			''' <summary>
			''' Sets the value into the element
			''' </summary>
			''' <param name="element">the element</param>
			''' <param name="value">new value</param>
			''' <param name="commandFactory">the command factory for this change</param>
			''' <param name="allowDuplicates">allow duplicate value to continue to fire rules and events</param>
			''' <param name="oldValue">the old value before the change</param>
			''' <returns>true if the value actually changed</returns>
			Protected NotOverridable Overrides Function SetValue(ByVal element As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment, ByVal value As System.String, ByVal commandFactory As Microsoft.VisualStudio.Modeling.CommandFactory, ByVal allowDuplicates As Boolean, ByRef oldValue As System.String) As Boolean
				oldValue = element.captionIdPropertyStorage
				If allowDuplicates OrElse oldValue <> value Then
					OnValueChanging(element, oldValue, value)
					element.captionIdPropertyStorage = value
					OnValueChanged(element, oldValue, value)
					Return True
				End If
				Return False
			End Function

		End Class
		#End Region
		#End Region

		#Region "CompartmentFillColor's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property CompartmentFillColor() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentFillColorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor.CompartmentMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasCompartmentFillColor), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "TitleFillColor's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property TitleFillColor() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ColorDetails)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.TitleFillColorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor.CompartmentMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.CompartmentHasTitleFillColor), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for Compartment"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class CompartmentMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "Compartment's Generated Constructor Code"
	Partial Public Class Compartment
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartment(ByVal store As Microsoft.VisualStudio.Modeling.Store) As Compartment
			Return CreateCompartment(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartment(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Compartment
			Return CreateAndInitializeCompartment(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateCompartment(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As Compartment
			Return CType(partition.ElementFactory.CreateElement(GetType(Compartment)), Compartment)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeCompartment(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As Compartment
			Return CType(partition.ElementFactory.CreateElement(GetType(Compartment), assignments), Compartment)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for Compartment"
	''' <summary>
	''' Compartment Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment))>
	Public NotInheritable Class CompartmentElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As CompartmentElementFactoryCreator
			Get
				Return New CompartmentElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment.MetaClassGuidString, "ListCompartment")>
	Partial Public Class ListCompartment
		Inherits Microsoft.VisualStudio.Modeling.DesignerDefinition.Compartment
		#Region "ListCompartment's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "fb230165-ac1f-43f9-a772-4988121a105e"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment.MetaClassGuidString)
		#End Region

	End Class
	#Region "ListCompartment's Generated Constructor Code"
	Partial Public Class ListCompartment
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateListCompartment(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ListCompartment
			Return CreateListCompartment(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeListCompartment(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ListCompartment
			Return CreateAndInitializeListCompartment(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateListCompartment(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ListCompartment
			Return CType(partition.ElementFactory.CreateElement(GetType(ListCompartment)), ListCompartment)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeListCompartment(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ListCompartment
			Return CType(partition.ElementFactory.CreateElement(GetType(ListCompartment), assignments), ListCompartment)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ListCompartment"
	''' <summary>
	''' ListCompartment Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment))>
	Public NotInheritable Class ListCompartmentElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ListCompartment(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ListCompartmentElementFactoryCreator
			Get
				Return New ListCompartmentElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap.MetaClassGuidString, "ConnectorMap")>
	Partial Public Class ConnectorMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ConnectorMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "bbb28f3c-7285-4019-9fd7-7846debc14fd"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap.MetaClassGuidString)
		#End Region

		#Region "TextMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property TextMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTextMaps.TextMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "Class's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property [Class]() As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid, False), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.EnterpriseTools.Corona.Concepts.CdlReferenceType)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ClassMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass.ConnectorMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapReferencesClass), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "Connector's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property Connector() As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.Connector)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector.ConnectorMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasConnector), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "IconMaps's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public ReadOnly Property IconMaps() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapMoveableCollection
			Get
				Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMapMoveableCollection(Me, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasIconMaps.IconMapsMetaRoleGuid)
			End Get
		End Property
		#End Region
		#Region "SourceMap's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property SourceMap() As Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.SourceMapMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap.ConnectorMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasSourceMap), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "TargetMap's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property TargetMap() As Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.TargetMap)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.TargetMapMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap.ConnectorMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMapHasTargetMap), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ConnectorMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ConnectorMap's Generated Constructor Code"
	Partial Public Class ConnectorMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorMap
			Return CreateConnectorMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorMap
			Return CreateAndInitializeConnectorMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorMap)), ConnectorMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorMap), assignments), ConnectorMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorMap"
	''' <summary>
	''' ConnectorMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap))>
	Public NotInheritable Class ConnectorMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorMapElementFactoryCreator
			Get
				Return New ConnectorMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap.MetaClassGuidString, "ShapeIconMap")>
	Partial Public Class ShapeIconMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ShapeIconMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "e5e016c5-3ecc-472f-b2a7-9f157cf301b6"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap.MetaClassGuidString)
		#End Region

		#Region "IconDecorator's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property IconDecorator() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIcon)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconDecoratorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon.IconMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasShapeIcon), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "VisibilityExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property VisibilityExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.BooleanExpression)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.VisibilityExpressionMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression.ShapeIconMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMapHasVisibilityExpression), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ShapeIconMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ShapeIconMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ShapeIconMap's Generated Constructor Code"
	Partial Public Class ShapeIconMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeIconMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ShapeIconMap
			Return CreateShapeIconMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeIconMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeIconMap
			Return CreateAndInitializeShapeIconMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateShapeIconMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ShapeIconMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeIconMap)), ShapeIconMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeShapeIconMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ShapeIconMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ShapeIconMap), assignments), ShapeIconMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ShapeIconMap"
	''' <summary>
	''' ShapeIconMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap))>
	Public NotInheritable Class ShapeIconMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ShapeIconMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ShapeIconMapElementFactoryCreator
			Get
				Return New ShapeIconMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<Microsoft.VisualStudio.Modeling.Validation.ValidationState(Microsoft.VisualStudio.Modeling.Validation.ValidationState.Enabled), System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap.MetaClassGuidString, "ConnectorTextMap")>
	Partial Public Class ConnectorTextMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ConnectorTextMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "a5316d6a-41e7-4805-ace6-d7d4ad1cf84d"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap.MetaClassGuidString)
		#End Region

		#Region "TextDecorator's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property TextDecorator() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorText)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.TextDecoratorMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator.ConnectorTextMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapReferencesTextDecorator), newRoles)
				End If
			End Set
		End Property
		#End Region
		#Region "ValueExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property ValueExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid)
				If links.Count > 0 Then
					System.Diagnostics.Debug.Assert(1 = links.Count)
					Dim roleInfo As Microsoft.VisualStudio.Modeling.MetaRoleInfo = Me.Partition.MetaDataDirectory.FindMetaRole(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid)
					For Each link As Microsoft.VisualStudio.Modeling.ElementLink In links
						If Not link.IsRemoved Then
							Dim counterpart As Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression = TryCast(link.GetRolePlayer(roleInfo), Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression)
							If counterpart IsNot Nothing AndAlso Object.ReferenceEquals(counterpart, value) Then
								sameRolePlayer = True
							Else
								link.Remove()
							End If
							Exit For
						End If
					Next link
				End If
				If ((Not sameRolePlayer)) AndAlso (value IsNot Nothing) Then
					Dim newRoles(1) As Microsoft.VisualStudio.Modeling.RoleAssignment
					newRoles(0) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ValueExpressionMetaRoleGuid, value)
					newRoles(1) = New Microsoft.VisualStudio.Modeling.RoleAssignment(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression.ConnectorTextMapMetaRoleGuid, Me)
					Me.Partition.ElementFactory.CreateElementLink(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMapHasValueExpression), newRoles)
				End If
			End Set
		End Property
		#End Region
	End Class
	#Region "Collection Classes for ConnectorTextMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorTextMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ConnectorTextMap's Generated Constructor Code"
	Partial Public Class ConnectorTextMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorTextMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorTextMap
			Return CreateConnectorTextMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorTextMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorTextMap
			Return CreateAndInitializeConnectorTextMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorTextMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorTextMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorTextMap)), ConnectorTextMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorTextMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorTextMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorTextMap), assignments), ConnectorTextMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorTextMap"
	''' <summary>
	''' ConnectorTextMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap))>
	Public NotInheritable Class ConnectorTextMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorTextMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorTextMapElementFactoryCreator
			Get
				Return New ConnectorTextMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap.MetaClassGuidString, "ConnectorIconMap")>
	Partial Public Class ConnectorIconMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "ConnectorIconMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "9092849f-6f1b-4d4d-aa4d-7b4ae5fe4ea7"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap.MetaClassGuidString)
		#End Region

	End Class
	#Region "Collection Classes for ConnectorIconMap"
	''' <summary>
	''' Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap Collection class, strongly-typed collection
	''' </summary>
	<System.CLSCompliant(True)>
	Public NotInheritable Partial Class ConnectorIconMapMoveableCollection
		Implements Microsoft.VisualStudio.Modeling.IMoveableCollection
		Private counterpartMember As Microsoft.VisualStudio.Modeling.ModelElement
		Private sourceRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		Private targetRoleMember As Microsoft.VisualStudio.Modeling.MetaRoleInfo
		''' <summary>
		''' Counterpart
		''' </summary>
		Public ReadOnly Property Counterpart() As Microsoft.VisualStudio.Modeling.ModelElement
			Get
				Return Me.counterpartMember
			End Get
		End Property
		''' <summary>
		''' Source Role
		''' </summary>
		Public ReadOnly Property SourceRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.sourceRoleMember
			End Get
		End Property
		''' <summary>
		''' Target Role
		''' </summary>
		Public ReadOnly Property TargetRole() As Microsoft.VisualStudio.Modeling.MetaRoleInfo
			Get
				Return Me.targetRoleMember
			End Get
		End Property
		''' <summary>
		''' Constructor
		''' </summary>
		''' <param name="counterpart">Counterpart to create relationship with</param>
		''' <param name="sourceMetaRoleGuid">Source's meta role in this relationship</param>
		''' <param name="targetMetaRoleGuid">Target's meta role in this relationship</param>
		Public Sub New(ByVal counterpart As Microsoft.VisualStudio.Modeling.ModelElement, ByVal sourceMetaRoleGuid As System.Guid, ByVal targetMetaRoleGuid As System.Guid)
			Me.counterpartMember = counterpart
			Me.sourceRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(sourceMetaRoleGuid)
			Me.targetRoleMember = counterpart.Partition.MetaDataDirectory.FindMetaRole(targetMetaRoleGuid)
		End Sub
		''' <summary>
		''' Returns an enumerator that can iterate through a collection
		''' </summary>
		''' <returns>Enumerator</returns>
		Private Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).GetEnumerator()
		End Function
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Private Sub ICollection_CopyTo(ByVal array As System.Array, ByVal index As System.Int32) Implements System.Collections.ICollection.CopyTo
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).CopyTo(array, index)
		End Sub
		''' <summary>
		''' When implemented by a class, gets the number of elements contained in the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property ICollection_Count() As System.Int32 Implements System.Collections.ICollection.Count
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Count
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether access to the System.Collections.ICollection is synchronized (thread-safe)
		''' </summary>
		Private ReadOnly Property IsSynchronized() As System.Boolean Implements System.Collections.ICollection.IsSynchronized
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsSynchronized
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets an object that can be used to synchronize access to the System.Collections.ICollection
		''' </summary>
		Private ReadOnly Property SyncRoot() As System.Object Implements System.Collections.ICollection.SyncRoot
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).SyncRoot
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList has a fixed size
		''' </summary>
		Private ReadOnly Property IsFixedSize() As System.Boolean Implements System.Collections.IList.IsFixedSize
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsFixedSize
			End Get
		End Property
		''' <summary>
		''' When implemented by a class, gets a value indicating whether the System.Collections.IList is read-only
		''' </summary>
		Private ReadOnly Property IList_IsReadOnly() As System.Boolean Implements System.Collections.IList.IsReadOnly
			Get
				Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>object at that index</returns>
		Public Property IList_Item(ByVal index As System.Int32) As System.Object Implements System.Collections.IList.Item
			Get
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				Return list(index)
			End Get
			Set(ByVal value As System.Object)
				If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
					Throw New System.InvalidCastException()
				End If
				Dim list As Microsoft.VisualStudio.Modeling.IMoveableCollection = Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole)
				list(index) = value
			End Set
		End Property
		''' <summary>
		''' When implemented by a class, adds an item to the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to add to the System.Collections.IList</param>
		''' <returns>index where object was added</returns>
		Private Function IList_Add(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.Add
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Add(value)
		End Function
		''' <summary>
		''' When implemented by a class, removes all items from the System.Collections.IList
		''' </summary>
		Private Sub IList_Clear() Implements System.Collections.IList.Clear
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Clear()
		End Sub
		''' <summary>
		''' When implemented by a class, determines whether the System.Collections.IList has a specific value
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Private Function IList_Contains(ByVal value As System.Object) As System.Boolean Implements System.Collections.IList.Contains
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Contains(value)
		End Function
		''' <summary>
		''' When implemented by a class, determines the index of a specific item in the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to locate in the System.Collections.IList</param>
		''' <returns>index of object</returns>
		Private Function IList_IndexOf(ByVal value As System.Object) As System.Int32 Implements System.Collections.IList.IndexOf
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Return Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).IndexOf(value)
		End Function
		''' <summary>
		''' When implemented by a class, inserts an item to the System.Collections.IList at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The System.Object to insert into the System.Collections.IList</param>
		Private Sub IList_Insert(ByVal index As System.Int32, ByVal value As System.Object) Implements System.Collections.IList.Insert
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Insert(index, value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the first occurrence of a specific object from the System.Collections.IList
		''' </summary>
		''' <param name="value">The System.Object to remove from the System.Collections.IList</param>
		Private Sub IList_Remove(ByVal value As System.Object) Implements System.Collections.IList.Remove
			If value Is Nothing OrElse (value.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not value.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Remove(value)
		End Sub
		''' <summary>
		''' When implemented by a class, removes the System.Collections.IList item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Private Sub IList_RemoveAt(ByVal index As System.Int32) Implements System.Collections.IList.RemoveAt
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Private Sub IMoveableCollection_Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(rolePlayer, newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Private Sub IMoveableCollection_Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.Move
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Private Sub IMoveableCollection_ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.ModelElement) Implements Microsoft.VisualStudio.Modeling.IMoveableCollection.ReplaceAt
			If rolePlayer Is Nothing OrElse (rolePlayer.GetType() IsNot GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) AndAlso (Not rolePlayer.GetType().IsSubclassOf(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)))) Then
				Throw New System.InvalidCastException()
			End If
			Me.Counterpart.GetMoveableRolePlayers(Me.SourceRole, Me.TargetRole).ReplaceAt(position, rolePlayer)
		End Sub
		''' <summary>
		''' When implemented by a class, copies the elements of the System.Collection.ICollections to an System.Array, starting at a particular System.Array index
		''' </summary>
		''' <param name="array">The one-dimensional System.Array that is the destination of the elements copied from System.Collections.ICollection.  The System.Array must have zero-based indexing</param>
		''' <param name="index">The zero-based index in array at which copying begins</param>
		Public Sub CopyTo(ByVal array() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap, ByVal index As System.Int32)
			CType(Me, System.Collections.ICollection).CopyTo(array, index)
		End Sub
		''' <summary>
		''' Gets the number of elements contained in the collection
		''' </summary>
		Public ReadOnly Property Count() As System.Int32
			Get
				Return (CType(Me, System.Collections.ICollection)).Count
			End Get
		End Property
		''' <summary>
		''' Gets a value indicating whether the list is read-only
		''' </summary>
		Public ReadOnly Property IsReadOnly() As System.Boolean
			Get
				Return (CType(Me, System.Collections.IList)).IsReadOnly
			End Get
		End Property
		''' <summary>
		''' Indexed accessor
		''' </summary>
		''' <param name="index">Index to access</param>
		''' <returns>Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap at that index</returns>
		Default Public Property Item(ByVal index As System.Int32) As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap
			Get
				Return CType((CType(Me, System.Collections.IList))(index), Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)
				CType(Me, System.Collections.IList)(index) = TryCast(value, System.Object)
			End Set
		End Property
		''' <summary>
		''' Adds an item to the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to add to the list</param>
		''' <returns>index where object was added</returns>
		Public Function Add(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).Add(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Removes all items from the list
		''' </summary>
		Public Sub Clear()
			CType(Me, System.Collections.IList).Clear()
		End Sub
		''' <summary>
		''' Determines whether the list has a specific value
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to locate in the list</param>
		''' <returns>true if object is contained, false otherwise</returns>
		Public Function Contains(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) As System.Boolean
			Return (CType(Me, System.Collections.IList)).Contains(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Determines the index of a specific item in the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to locate in the list</param>
		''' <returns>index of object</returns>
		Public Function IndexOf(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap) As System.Int32
			Return (CType(Me, System.Collections.IList)).IndexOf(TryCast(value, System.Object))
		End Function
		''' <summary>
		''' Inserts an item to the list at the specified position
		''' </summary>
		''' <param name="index">The zero-based index at which the value should be inserted</param>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to insert into the list</param>
		Public Sub Insert(ByVal index As System.Int32, ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)
			CType(Me, System.Collections.IList).Insert(index, TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the first occurrence of a specific object from the list
		''' </summary>
		''' <param name="value">The Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap to remove from the list</param>
		Public Sub Remove(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)
			CType(Me, System.Collections.IList).Remove(TryCast(value, System.Object))
		End Sub
		''' <summary>
		''' Removes the list item at the specified index
		''' </summary>
		''' <param name="index">The zero-based index of the item to remove</param>
		Public Sub RemoveAt(ByVal index As System.Int32)
			CType(Me, System.Collections.IList).RemoveAt(index)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="rolePlayer">The role player to move</param>
		''' <param name="newPosition">The position to move to</param>
		Public Sub Move(ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement), newPosition)
		End Sub
		''' <summary>
		''' Move the roleplayer to the new position in the collection
		''' </summary>
		''' <param name="oldPosition">The position of the role player to move from</param>
		''' <param name="newPosition">The position of the role player to move to</param>
		Public Sub Move(ByVal oldPosition As System.Int32, ByVal newPosition As System.Int32)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).Move(oldPosition, newPosition)
		End Sub
		''' <summary>
		''' Insert a roleplayer in the specified location
		''' </summary>
		''' <param name="position">The index of the roleplayer that needs to be replaced</param>
		''' <param name="rolePlayer">The role player that will be inserted</param>
		Public Sub ReplaceAt(ByVal position As System.Int32, ByVal rolePlayer As Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap)
			CType(Me, Microsoft.VisualStudio.Modeling.IMoveableCollection).ReplaceAt(position, TryCast(rolePlayer, Microsoft.VisualStudio.Modeling.ModelElement))
		End Sub

	End Class
	#End Region

	#Region "ConnectorIconMap's Generated Constructor Code"
	Partial Public Class ConnectorIconMap
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(store.DefaultPartition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorIconMap(ByVal store As Microsoft.VisualStudio.Modeling.Store) As ConnectorIconMap
			Return CreateConnectorIconMap(store.DefaultPartition)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorIconMap(ByVal store As Microsoft.VisualStudio.Modeling.Store, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorIconMap
			Return CreateAndInitializeConnectorIconMap(store.DefaultPartition, assignments)
		End Function
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag)
			MyBase.New(partition, bag)
		End Sub
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateConnectorIconMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition) As ConnectorIconMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorIconMap)), ConnectorIconMap)
		End Function
		''' <summary>
		''' Class Factory
		''' </summary>
		Public Shared Function CreateAndInitializeConnectorIconMap(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal assignments() As Microsoft.VisualStudio.Modeling.AttributeAssignment) As ConnectorIconMap
			Return CType(partition.ElementFactory.CreateElement(GetType(ConnectorIconMap), assignments), ConnectorIconMap)
		End Function
	End Class
	#End Region
	#Region "Class Factory Creator for ConnectorIconMap"
	''' <summary>
	''' ConnectorIconMap Class Factory Creator
	''' </summary>
	<Microsoft.VisualStudio.Modeling.ElementFactoryCreatorFor(GetType(Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap))>
	Public NotInheritable Class ConnectorIconMapElementFactoryCreator
		Inherits Microsoft.VisualStudio.Modeling.ElementFactoryCreator
		''' <summary>
		''' Constructor
		''' </summary>
		Public Sub New()
		End Sub
		''' <summary>
		''' Class Factory Create Method
		''' </summary>
		Public Overrides Function Create(ByVal partition As Microsoft.VisualStudio.Modeling.Partition, ByVal bag As Microsoft.VisualStudio.Modeling.ModelDataBag) As Microsoft.VisualStudio.Modeling.ModelElement
			Return New Microsoft.VisualStudio.Modeling.DesignerDefinition.ConnectorIconMap(partition, bag)
		End Function
		''' <summary>
		''' Create an instance of the createor object
		''' </summary>
		Public Shared ReadOnly Property Instance() As ConnectorIconMapElementFactoryCreator
			Get
				Return New ConnectorIconMapElementFactoryCreator()
			End Get
		End Property
	End Class
	#End Region

End Namespace
Namespace Microsoft.VisualStudio.Modeling.DesignerDefinition
	''' <summary>
	''' 
	''' </summary>
	<System.CLSCompliant(True), System.Serializable, Microsoft.VisualStudio.Modeling.MetaClass("d6d72f16-7925-493b-b393-5b60c29c589d"), Microsoft.VisualStudio.Modeling.MetaObject(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap.MetaClassGuidString, "SourceMap")>
	Partial Public Class SourceMap
		Inherits Microsoft.VisualStudio.Modeling.NamedElement
		#Region "SourceMap's Generated MetaClass Code"
		''' <summary>
		''' MetaClass Guid String
		''' </summary>
		Public Shadows Const MetaClassGuidString As System.String = "bf110281-98d4-4efb-a119-340b6c10bc90"
		''' <summary>
		''' MetaClass Guid
		''' </summary>
		Public Shared ReadOnly Shadows MetaClassGuid As New System.Guid(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMap.MetaClassGuidString)
		#End Region

		#Region "ModelNavigationExpression's Generated Accessor Code"
		''' <summary>
		''' 
		''' </summary>
		Public Property ModelNavigationExpression() As Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression
			Get
				Return TryCast(Me.GetCounterpartRolePlayer(Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.SourceMapMetaRoleGuid, Microsoft.VisualStudio.Modeling.DesignerDefinition.SourceMapHasModelNavigationExpression.ModelNavigationExpressionMetaRoleGuid, False), Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression)
			End Get
			Set(ByVal value As Microsoft.VisualStudio.Modeling.DesignerDefinition.ModelNavigationExpression)
				Dim sameRolePlayer As Boolean = False
				Dim links As System.Collections.IList = Me.GetElementLinks(Microsoft.VisualStudio.Modelin