// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using System.Runtime.InteropServices;
using Microsoft.VisualStudio.LanguageServices.Implementation.Interop;
using Microsoft.VisualStudio.LanguageServices.Implementation.Utilities;

namespace Microsoft.VisualStudio.LanguageServices.Implementation.CodeModel.InternalElements
{
    [ComVisible(true)]
    [ComDefaultInterface(typeof(EnvDTE.CodeEnum))]
    public sealed partial class CodeEnum : AbstractCodeType, EnvDTE.CodeEnum
    {
        internal static EnvDTE.CodeEnum Create(
            CodeModelState state,
            FileCodeModel fileCodeModel,
            SyntaxNodeKey nodeKey,
            int? nodeKind)
        {
            var element = new CodeEnum(state, fileCodeModel, nodeKey, nodeKind);
            var result = (EnvDTE.CodeEnum)ComAggregate.CreateAggregatedObject(element);

            fileCodeModel.OnElementCreated(nodeKey, (EnvDTE.CodeElement)result);

            return result;
        }

        internal static EnvDTE.CodeEnum CreateUnknown(
            CodeModelState state,
            FileCodeModel fileCodeModel,
            int nodeKind,
            string name)
        {
            var element = new CodeEnum(state, fileCodeModel, nodeKind, name);
            return (EnvDTE.CodeEnum)ComAggregate.CreateAggregatedObject(element);
        }

        private CodeEnum(
            CodeModelState state,
            FileCodeModel fileCodeModel,
            SyntaxNodeKey nodeKey,
            int? nodeKind)
            : base(state, fileCodeModel, nodeKey, nodeKind)
        {
        }

        private CodeEnum(
            CodeModelState state,
            FileCodeModel fileCodeModel,
            int nodeKind,
            string name)
            : base(state, fileCodeModel, nodeKind, name)
        {
        }

        public override EnvDTE.vsCMElement Kind
        {
            get { return EnvDTE.vsCMElement.vsCMElementEnum; }
        }

        public EnvDTE.CodeVariable AddMember(string name, object value, object position)
        {
            return FileCodeModel.EnsureEditor(() =>
            {
                return FileCodeModel.AddEnumMember(LookupNode(), name, value, position);
            });
        }
    }
}
