﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Specifies whether an object or text is aligned to
    ///  the left or
    ///  right of a reference point.
    /// </summary>
    public enum LeftRightAlignment
    {
        /// <summary>
        ///  The object or text is aligned to the left of the reference point.
        /// </summary>
        Left = 0,

        /// <summary>
        ///  The object or text is aligned to the right of the reference point.
        /// </summary>
        Right = 1,
    }
}
