// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/image_service.proto

package compute // import "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetImageRequest struct {
	// ID of the Image resource to return.
	// To get the image ID, use a [ImageService.List] request.
	ImageId              string   `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetImageRequest) Reset()         { *m = GetImageRequest{} }
func (m *GetImageRequest) String() string { return proto.CompactTextString(m) }
func (*GetImageRequest) ProtoMessage()    {}
func (*GetImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{0}
}
func (m *GetImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetImageRequest.Unmarshal(m, b)
}
func (m *GetImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetImageRequest.Marshal(b, m, deterministic)
}
func (dst *GetImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageRequest.Merge(dst, src)
}
func (m *GetImageRequest) XXX_Size() int {
	return xxx_messageInfo_GetImageRequest.Size(m)
}
func (m *GetImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageRequest proto.InternalMessageInfo

func (m *GetImageRequest) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type GetImageLatestByFamilyRequest struct {
	// ID of the folder to get the image from.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the image family to search for.
	Family               string   `protobuf:"bytes,2,opt,name=family,proto3" json:"family,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetImageLatestByFamilyRequest) Reset()         { *m = GetImageLatestByFamilyRequest{} }
func (m *GetImageLatestByFamilyRequest) String() string { return proto.CompactTextString(m) }
func (*GetImageLatestByFamilyRequest) ProtoMessage()    {}
func (*GetImageLatestByFamilyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{1}
}
func (m *GetImageLatestByFamilyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetImageLatestByFamilyRequest.Unmarshal(m, b)
}
func (m *GetImageLatestByFamilyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetImageLatestByFamilyRequest.Marshal(b, m, deterministic)
}
func (dst *GetImageLatestByFamilyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageLatestByFamilyRequest.Merge(dst, src)
}
func (m *GetImageLatestByFamilyRequest) XXX_Size() int {
	return xxx_messageInfo_GetImageLatestByFamilyRequest.Size(m)
}
func (m *GetImageLatestByFamilyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageLatestByFamilyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageLatestByFamilyRequest proto.InternalMessageInfo

func (m *GetImageLatestByFamilyRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *GetImageLatestByFamilyRequest) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

type ListImagesRequest struct {
	// ID of the folder to list images in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListImagesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListImagesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Image.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z]([-a-z0-9]{,61}[a-z0-9])?$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImagesRequest) Reset()         { *m = ListImagesRequest{} }
func (m *ListImagesRequest) String() string { return proto.CompactTextString(m) }
func (*ListImagesRequest) ProtoMessage()    {}
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{2}
}
func (m *ListImagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImagesRequest.Unmarshal(m, b)
}
func (m *ListImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImagesRequest.Marshal(b, m, deterministic)
}
func (dst *ListImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImagesRequest.Merge(dst, src)
}
func (m *ListImagesRequest) XXX_Size() int {
	return xxx_messageInfo_ListImagesRequest.Size(m)
}
func (m *ListImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListImagesRequest proto.InternalMessageInfo

func (m *ListImagesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListImagesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListImagesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListImagesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListImagesResponse struct {
	// List of images.
	Images []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListSnapshotsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImagesResponse) Reset()         { *m = ListImagesResponse{} }
func (m *ListImagesResponse) String() string { return proto.CompactTextString(m) }
func (*ListImagesResponse) ProtoMessage()    {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{3}
}
func (m *ListImagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImagesResponse.Unmarshal(m, b)
}
func (m *ListImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImagesResponse.Marshal(b, m, deterministic)
}
func (dst *ListImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImagesResponse.Merge(dst, src)
}
func (m *ListImagesResponse) XXX_Size() int {
	return xxx_messageInfo_ListImagesResponse.Size(m)
}
func (m *ListImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListImagesResponse proto.InternalMessageInfo

func (m *ListImagesResponse) GetImages() []*Image {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *ListImagesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateImageRequest struct {
	// ID of the folder to create an image in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the image.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the image.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the image family to which this image belongs.
	// To get information about the most recent image from a family, use a [ImageService.GetLatestByFamily] request.
	Family string `protobuf:"bytes,5,opt,name=family,proto3" json:"family,omitempty"`
	// Minimum size of the disk that will be created from this image.
	// Specified in bytes. Should be more than the volume of source data.
	MinDiskSize int64 `protobuf:"varint,6,opt,name=min_disk_size,json=minDiskSize,proto3" json:"min_disk_size,omitempty"`
	// License IDs that indicate which licenses are attached to this resource.
	// License IDs are used to calculate additional charges for the use of the virtual machine.
	//
	// The correct license ID is generated by Yandex.Cloud. IDs are inherited by new resources created from this resource.
	//
	// If you know the license IDs, specify them when you create the image.
	// For example, if you create a disk image using a third-party utility and load it into Yandex Object Storage, the license IDs will be lost.
	// You can specify them in this request.
	ProductIds []string `protobuf:"bytes,7,rep,name=product_ids,json=productIds,proto3" json:"product_ids,omitempty"`
	// Types that are valid to be assigned to Source:
	//	*CreateImageRequest_ImageId
	//	*CreateImageRequest_DiskId
	//	*CreateImageRequest_SnapshotId
	//	*CreateImageRequest_Uri
	Source isCreateImageRequest_Source `protobuf_oneof:"source"`
	// Operating system that is contained in the image.
	Os                   *Os      `protobuf:"bytes,12,opt,name=os,proto3" json:"os,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateImageRequest) Reset()         { *m = CreateImageRequest{} }
func (m *CreateImageRequest) String() string { return proto.CompactTextString(m) }
func (*CreateImageRequest) ProtoMessage()    {}
func (*CreateImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{4}
}
func (m *CreateImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateImageRequest.Unmarshal(m, b)
}
func (m *CreateImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateImageRequest.Marshal(b, m, deterministic)
}
func (dst *CreateImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateImageRequest.Merge(dst, src)
}
func (m *CreateImageRequest) XXX_Size() int {
	return xxx_messageInfo_CreateImageRequest.Size(m)
}
func (m *CreateImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateImageRequest proto.InternalMessageInfo

func (m *CreateImageRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateImageRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateImageRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateImageRequest) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

func (m *CreateImageRequest) GetMinDiskSize() int64 {
	if m != nil {
		return m.MinDiskSize
	}
	return 0
}

func (m *CreateImageRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type isCreateImageRequest_Source interface {
	isCreateImageRequest_Source()
}

type CreateImageRequest_ImageId struct {
	ImageId string `protobuf:"bytes,8,opt,name=image_id,json=imageId,proto3,oneof"`
}

type CreateImageRequest_DiskId struct {
	DiskId string `protobuf:"bytes,9,opt,name=disk_id,json=diskId,proto3,oneof"`
}

type CreateImageRequest_SnapshotId struct {
	SnapshotId string `protobuf:"bytes,10,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

type CreateImageRequest_Uri struct {
	Uri string `protobuf:"bytes,11,opt,name=uri,proto3,oneof"`
}

func (*CreateImageRequest_ImageId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_DiskId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_SnapshotId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_Uri) isCreateImageRequest_Source() {}

func (m *CreateImageRequest) GetSource() isCreateImageRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *CreateImageRequest) GetImageId() string {
	if x, ok := m.GetSource().(*CreateImageRequest_ImageId); ok {
		return x.ImageId
	}
	return ""
}

func (m *CreateImageRequest) GetDiskId() string {
	if x, ok := m.GetSource().(*CreateImageRequest_DiskId); ok {
		return x.DiskId
	}
	return ""
}

func (m *CreateImageRequest) GetSnapshotId() string {
	if x, ok := m.GetSource().(*CreateImageRequest_SnapshotId); ok {
		return x.SnapshotId
	}
	return ""
}

func (m *CreateImageRequest) GetUri() string {
	if x, ok := m.GetSource().(*CreateImageRequest_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *CreateImageRequest) GetOs() *Os {
	if m != nil {
		return m.Os
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CreateImageRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CreateImageRequest_OneofMarshaler, _CreateImageRequest_OneofUnmarshaler, _CreateImageRequest_OneofSizer, []interface{}{
		(*CreateImageRequest_ImageId)(nil),
		(*CreateImageRequest_DiskId)(nil),
		(*CreateImageRequest_SnapshotId)(nil),
		(*CreateImageRequest_Uri)(nil),
	}
}

func _CreateImageRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CreateImageRequest)
	// source
	switch x := m.Source.(type) {
	case *CreateImageRequest_ImageId:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ImageId)
	case *CreateImageRequest_DiskId:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.DiskId)
	case *CreateImageRequest_SnapshotId:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SnapshotId)
	case *CreateImageRequest_Uri:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Uri)
	case nil:
	default:
		return fmt.Errorf("CreateImageRequest.Source has unexpected type %T", x)
	}
	return nil
}

func _CreateImageRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CreateImageRequest)
	switch tag {
	case 8: // source.image_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateImageRequest_ImageId{x}
		return true, err
	case 9: // source.disk_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateImageRequest_DiskId{x}
		return true, err
	case 10: // source.snapshot_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateImageRequest_SnapshotId{x}
		return true, err
	case 11: // source.uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &CreateImageRequest_Uri{x}
		return true, err
	default:
		return false, nil
	}
}

func _CreateImageRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CreateImageRequest)
	// source
	switch x := m.Source.(type) {
	case *CreateImageRequest_ImageId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ImageId)))
		n += len(x.ImageId)
	case *CreateImageRequest_DiskId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.DiskId)))
		n += len(x.DiskId)
	case *CreateImageRequest_SnapshotId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SnapshotId)))
		n += len(x.SnapshotId)
	case *CreateImageRequest_Uri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Uri)))
		n += len(x.Uri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CreateImageMetadata struct {
	// ID of the image that is being created.
	ImageId              string   `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateImageMetadata) Reset()         { *m = CreateImageMetadata{} }
func (m *CreateImageMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateImageMetadata) ProtoMessage()    {}
func (*CreateImageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{5}
}
func (m *CreateImageMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateImageMetadata.Unmarshal(m, b)
}
func (m *CreateImageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateImageMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateImageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateImageMetadata.Merge(dst, src)
}
func (m *CreateImageMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateImageMetadata.Size(m)
}
func (m *CreateImageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateImageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateImageMetadata proto.InternalMessageInfo

func (m *CreateImageMetadata) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type UpdateImageRequest struct {
	// ID of the Image resource to update.
	// To get the image ID, use a [ImageService.List] request.
	ImageId string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// Field mask that specifies which fields of the Image resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the image.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the image.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Minimum size of the disk that can be created from this image.
	// Specified in bytes. Should be more than the volume of source data and more than the virtual disk size.
	MinDiskSize int64 `protobuf:"varint,5,opt,name=min_disk_size,json=minDiskSize,proto3" json:"min_disk_size,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels               map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateImageRequest) Reset()         { *m = UpdateImageRequest{} }
func (m *UpdateImageRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateImageRequest) ProtoMessage()    {}
func (*UpdateImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{6}
}
func (m *UpdateImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateImageRequest.Unmarshal(m, b)
}
func (m *UpdateImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateImageRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateImageRequest.Merge(dst, src)
}
func (m *UpdateImageRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateImageRequest.Size(m)
}
func (m *UpdateImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateImageRequest proto.InternalMessageInfo

func (m *UpdateImageRequest) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

func (m *UpdateImageRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateImageRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateImageRequest) GetMinDiskSize() int64 {
	if m != nil {
		return m.MinDiskSize
	}
	return 0
}

func (m *UpdateImageRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateImageMetadata struct {
	// ID of the Image resource that is being updated.
	ImageId              string   `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateImageMetadata) Reset()         { *m = UpdateImageMetadata{} }
func (m *UpdateImageMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateImageMetadata) ProtoMessage()    {}
func (*UpdateImageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{7}
}
func (m *UpdateImageMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateImageMetadata.Unmarshal(m, b)
}
func (m *UpdateImageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateImageMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateImageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateImageMetadata.Merge(dst, src)
}
func (m *UpdateImageMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateImageMetadata.Size(m)
}
func (m *UpdateImageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateImageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateImageMetadata proto.InternalMessageInfo

func (m *UpdateImageMetadata) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type DeleteImageRequest struct {
	// ID of the image to delete.
	// To get the image ID, use a [ImageService.List] request.
	ImageId              string   `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteImageRequest) Reset()         { *m = DeleteImageRequest{} }
func (m *DeleteImageRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteImageRequest) ProtoMessage()    {}
func (*DeleteImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{8}
}
func (m *DeleteImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteImageRequest.Unmarshal(m, b)
}
func (m *DeleteImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteImageRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteImageRequest.Merge(dst, src)
}
func (m *DeleteImageRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteImageRequest.Size(m)
}
func (m *DeleteImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteImageRequest proto.InternalMessageInfo

func (m *DeleteImageRequest) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type DeleteImageMetadata struct {
	// ID of the image that is being deleted.
	ImageId              string   `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteImageMetadata) Reset()         { *m = DeleteImageMetadata{} }
func (m *DeleteImageMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteImageMetadata) ProtoMessage()    {}
func (*DeleteImageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{9}
}
func (m *DeleteImageMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteImageMetadata.Unmarshal(m, b)
}
func (m *DeleteImageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteImageMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteImageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteImageMetadata.Merge(dst, src)
}
func (m *DeleteImageMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteImageMetadata.Size(m)
}
func (m *DeleteImageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteImageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteImageMetadata proto.InternalMessageInfo

func (m *DeleteImageMetadata) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type ListImageOperationsRequest struct {
	// ID of the Image resource to list operations for.
	ImageId string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListImageOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListImageOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImageOperationsRequest) Reset()         { *m = ListImageOperationsRequest{} }
func (m *ListImageOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListImageOperationsRequest) ProtoMessage()    {}
func (*ListImageOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{10}
}
func (m *ListImageOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImageOperationsRequest.Unmarshal(m, b)
}
func (m *ListImageOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImageOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListImageOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImageOperationsRequest.Merge(dst, src)
}
func (m *ListImageOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListImageOperationsRequest.Size(m)
}
func (m *ListImageOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImageOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListImageOperationsRequest proto.InternalMessageInfo

func (m *ListImageOperationsRequest) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

func (m *ListImageOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListImageOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListImageOperationsResponse struct {
	// List of operations for the specified image.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListImageOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListImageOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImageOperationsResponse) Reset()         { *m = ListImageOperationsResponse{} }
func (m *ListImageOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListImageOperationsResponse) ProtoMessage()    {}
func (*ListImageOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_image_service_bc437c5b9fae1fa8, []int{11}
}
func (m *ListImageOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImageOperationsResponse.Unmarshal(m, b)
}
func (m *ListImageOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImageOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListImageOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImageOperationsResponse.Merge(dst, src)
}
func (m *ListImageOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListImageOperationsResponse.Size(m)
}
func (m *ListImageOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImageOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListImageOperationsResponse proto.InternalMessageInfo

func (m *ListImageOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListImageOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetImageRequest)(nil), "yandex.cloud.compute.v1.GetImageRequest")
	proto.RegisterType((*GetImageLatestByFamilyRequest)(nil), "yandex.cloud.compute.v1.GetImageLatestByFamilyRequest")
	proto.RegisterType((*ListImagesRequest)(nil), "yandex.cloud.compute.v1.ListImagesRequest")
	proto.RegisterType((*ListImagesResponse)(nil), "yandex.cloud.compute.v1.ListImagesResponse")
	proto.RegisterType((*CreateImageRequest)(nil), "yandex.cloud.compute.v1.CreateImageRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.CreateImageRequest.LabelsEntry")
	proto.RegisterType((*CreateImageMetadata)(nil), "yandex.cloud.compute.v1.CreateImageMetadata")
	proto.RegisterType((*UpdateImageRequest)(nil), "yandex.cloud.compute.v1.UpdateImageRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateImageRequest.LabelsEntry")
	proto.RegisterType((*UpdateImageMetadata)(nil), "yandex.cloud.compute.v1.UpdateImageMetadata")
	proto.RegisterType((*DeleteImageRequest)(nil), "yandex.cloud.compute.v1.DeleteImageRequest")
	proto.RegisterType((*DeleteImageMetadata)(nil), "yandex.cloud.compute.v1.DeleteImageMetadata")
	proto.RegisterType((*ListImageOperationsRequest)(nil), "yandex.cloud.compute.v1.ListImageOperationsRequest")
	proto.RegisterType((*ListImageOperationsResponse)(nil), "yandex.cloud.compute.v1.ListImageOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ImageServiceClient is the client API for ImageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageServiceClient interface {
	// Returns the specified Image resource.
	//
	// To get the list of available Image resources, make a [List] request.
	Get(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error)
	// Returns the latest image that is part of an image family.
	GetLatestByFamily(ctx context.Context, in *GetImageLatestByFamilyRequest, opts ...grpc.CallOption) (*Image, error)
	// Retrieves the list of Image resources in the specified folder.
	List(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// Creates an image in the specified folder.
	//
	// You can create an image from a disk, snapshot, other image or URI.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateImageRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified image.
	Update(ctx context.Context, in *UpdateImageRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified image.
	//
	// Deleting an image removes its data permanently and is irreversible.
	Delete(ctx context.Context, in *DeleteImageRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified image.
	ListOperations(ctx context.Context, in *ListImageOperationsRequest, opts ...grpc.CallOption) (*ListImageOperationsResponse, error)
}

type imageServiceClient struct {
	cc *grpc.ClientConn
}

func NewImageServiceClient(cc *grpc.ClientConn) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) Get(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error) {
	out := new(Image)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) GetLatestByFamily(ctx context.Context, in *GetImageLatestByFamilyRequest, opts ...grpc.CallOption) (*Image, error) {
	out := new(Image)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/GetLatestByFamily", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) List(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) Create(ctx context.Context, in *CreateImageRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) Update(ctx context.Context, in *UpdateImageRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) Delete(ctx context.Context, in *DeleteImageRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ListOperations(ctx context.Context, in *ListImageOperationsRequest, opts ...grpc.CallOption) (*ListImageOperationsResponse, error) {
	out := new(ListImageOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ImageService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageServiceServer is the server API for ImageService service.
type ImageServiceServer interface {
	// Returns the specified Image resource.
	//
	// To get the list of available Image resources, make a [List] request.
	Get(context.Context, *GetImageRequest) (*Image, error)
	// Returns the latest image that is part of an image family.
	GetLatestByFamily(context.Context, *GetImageLatestByFamilyRequest) (*Image, error)
	// Retrieves the list of Image resources in the specified folder.
	List(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// Creates an image in the specified folder.
	//
	// You can create an image from a disk, snapshot, other image or URI.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateImageRequest) (*operation.Operation, error)
	// Updates the specified image.
	Update(context.Context, *UpdateImageRequest) (*operation.Operation, error)
	// Deletes the specified image.
	//
	// Deleting an image removes its data permanently and is irreversible.
	Delete(context.Context, *DeleteImageRequest) (*operation.Operation, error)
	// Lists operations for the specified image.
	ListOperations(context.Context, *ListImageOperationsRequest) (*ListImageOperationsResponse, error)
}

func RegisterImageServiceServer(s *grpc.Server, srv ImageServiceServer) {
	s.RegisterService(&_ImageService_serviceDesc, srv)
}

func _ImageService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).Get(ctx, req.(*GetImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_GetLatestByFamily_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageLatestByFamilyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).GetLatestByFamily(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/GetLatestByFamily",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).GetLatestByFamily(ctx, req.(*GetImageLatestByFamilyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).List(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).Create(ctx, req.(*CreateImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).Update(ctx, req.(*UpdateImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).Delete(ctx, req.(*DeleteImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImageOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ImageService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ListOperations(ctx, req.(*ListImageOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ImageService_Get_Handler,
		},
		{
			MethodName: "GetLatestByFamily",
			Handler:    _ImageService_GetLatestByFamily_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ImageService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ImageService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ImageService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ImageService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ImageService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/image_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/image_service.proto", fileDescriptor_image_service_bc437c5b9fae1fa8)
}

var fileDescriptor_image_service_bc437c5b9fae1fa8 = []byte{
	// 1209 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xbf, 0x6f, 0xdb, 0xd6,
	0x13, 0x0f, 0x2d, 0x89, 0x96, 0x4e, 0xce, 0xaf, 0xf7, 0x4d, 0x10, 0x85, 0x89, 0xbf, 0xb5, 0x69,
	0x24, 0x91, 0xe5, 0x48, 0x22, 0x65, 0x59, 0x8d, 0x9c, 0x18, 0x45, 0x95, 0x38, 0xb6, 0x00, 0x07,
	0x29, 0x98, 0x66, 0xa9, 0x11, 0x08, 0xb4, 0xf8, 0xac, 0x10, 0xa2, 0x48, 0x96, 0x8f, 0x12, 0x22,
	0xbb, 0x59, 0x02, 0x14, 0x28, 0x3c, 0x15, 0x28, 0xd0, 0x76, 0xee, 0x5e, 0x14, 0x30, 0xd0, 0xb1,
	0x40, 0x3b, 0xd9, 0x73, 0xfa, 0x0f, 0x74, 0xe8, 0x50, 0xa0, 0x5b, 0xc6, 0x4c, 0x05, 0x1f, 0x29,
	0x99, 0x32, 0xf5, 0x33, 0x69, 0x37, 0x52, 0xf7, 0xb9, 0x7b, 0x1f, 0xde, 0x7d, 0xee, 0xee, 0x09,
	0x96, 0xda, 0xb2, 0xae, 0xe0, 0x17, 0xd9, 0xaa, 0x66, 0x34, 0x95, 0x6c, 0xd5, 0x68, 0x98, 0x4d,
	0x1b, 0x67, 0x5b, 0x62, 0x56, 0x6d, 0xc8, 0x35, 0x5c, 0x21, 0xd8, 0x6a, 0xa9, 0x55, 0x9c, 0x31,
	0x2d, 0xc3, 0x36, 0xd0, 0x15, 0x17, 0x9c, 0xa1, 0xe0, 0x8c, 0x07, 0xce, 0xb4, 0x44, 0xee, 0x7a,
	0xcd, 0x30, 0x6a, 0x1a, 0xce, 0xca, 0xa6, 0x9a, 0x95, 0x75, 0xdd, 0xb0, 0x65, 0x5b, 0x35, 0x74,
	0xe2, 0xba, 0x71, 0x73, 0x9e, 0x95, 0xbe, 0xed, 0x34, 0x77, 0xb3, 0xbb, 0x2a, 0xd6, 0x94, 0x4a,
	0x43, 0x26, 0x75, 0x0f, 0xc1, 0x79, 0x2c, 0x1c, 0x7f, 0xc3, 0xc4, 0x16, 0x75, 0xf7, 0x6c, 0x0b,
	0x43, 0x19, 0x7a, 0xa0, 0x9b, 0x3d, 0xa0, 0x6e, 0x88, 0x40, 0xb0, 0xd9, 0x1e, 0x5c, 0x4b, 0xd6,
	0x54, 0xc5, 0x67, 0xe6, 0x57, 0xe1, 0xfc, 0x06, 0xb6, 0xcb, 0x4e, 0x60, 0x09, 0x7f, 0xde, 0xc4,
	0xc4, 0x46, 0xb7, 0x20, 0xea, 0xa6, 0x42, 0x55, 0x12, 0xcc, 0x1c, 0x93, 0x8c, 0x95, 0x66, 0xfe,
	0x3a, 0x12, 0x99, 0x83, 0x63, 0x31, 0x7c, 0x6f, 0x6d, 0x45, 0x90, 0xa6, 0xa9, 0xb5, 0xac, 0xf0,
	0x5f, 0x32, 0x30, 0xdb, 0x71, 0xde, 0x92, 0x6d, 0x4c, 0xec, 0x52, 0xfb, 0xa1, 0xdc, 0x50, 0xb5,
	0x76, 0x27, 0xd4, 0x22, 0xc4, 0x76, 0x0d, 0x4d, 0xc1, 0xd6, 0xa0, 0x58, 0x51, 0xd7, 0x5c, 0x56,
	0x50, 0x11, 0xd8, 0x5d, 0xea, 0x9b, 0x98, 0xa2, 0xb8, 0xf9, 0x37, 0x47, 0xe2, 0xec, 0x17, 0xdb,
	0x72, 0x7a, 0xef, 0xd9, 0x76, 0x5a, 0x4e, 0xef, 0x09, 0xe9, 0xe2, 0xb3, 0x7d, 0xf1, 0x76, 0x41,
	0x7c, 0xb9, 0xed, 0xbd, 0x49, 0x9e, 0x03, 0xff, 0x33, 0x03, 0x17, 0xb7, 0x54, 0xe2, 0x12, 0x21,
	0xef, 0x70, 0xf6, 0x2d, 0x88, 0x99, 0xb4, 0xf6, 0xea, 0x1e, 0xa6, 0xc7, 0x87, 0x4a, 0xf0, 0xf6,
	0x48, 0x64, 0xef, 0xad, 0x89, 0x82, 0x20, 0x48, 0x51, 0xc7, 0xf8, 0x44, 0xdd, 0xc3, 0x28, 0x09,
	0x40, 0x81, 0xb6, 0x51, 0xc7, 0x7a, 0x22, 0x44, 0x83, 0xc6, 0x0e, 0x8e, 0xc5, 0x08, 0x45, 0x4a,
	0x34, 0xca, 0xa7, 0x8e, 0x0d, 0xf1, 0xc0, 0xee, 0xaa, 0x9a, 0x8d, 0xad, 0x44, 0x98, 0xa2, 0xe0,
	0xe0, 0xb8, 0x1b, 0xcf, 0xb3, 0xf0, 0x36, 0x20, 0x3f, 0x6d, 0x62, 0x1a, 0x3a, 0xc1, 0xa8, 0x00,
	0x2c, 0x4d, 0x30, 0x49, 0x30, 0x73, 0xa1, 0x64, 0x3c, 0xf7, 0xff, 0xcc, 0x00, 0x0d, 0x66, 0xdc,
	0xaa, 0x79, 0x68, 0x74, 0x13, 0xce, 0xeb, 0xf8, 0x85, 0x5d, 0xf1, 0x11, 0xa4, 0x99, 0x94, 0xce,
	0x3a, 0x3f, 0x7f, 0xd2, 0x61, 0xc6, 0xff, 0x11, 0x01, 0x74, 0xdf, 0xc2, 0xb2, 0x8d, 0x7b, 0xaa,
	0x3e, 0x41, 0xba, 0x56, 0x20, 0xac, 0xcb, 0x0d, 0x3c, 0x7e, 0xa1, 0x28, 0x1c, 0x2d, 0x41, 0x5c,
	0xc1, 0xa4, 0x6a, 0xa9, 0xa6, 0xa3, 0xbf, 0xde, 0xec, 0xe5, 0x56, 0x0a, 0x92, 0xdf, 0x8a, 0xbe,
	0x66, 0x80, 0xd5, 0xe4, 0x1d, 0xac, 0x91, 0x44, 0x98, 0xa6, 0xe1, 0xc3, 0x81, 0x69, 0x08, 0x7e,
	0x4c, 0x66, 0x8b, 0x7a, 0xae, 0xeb, 0xb6, 0xd5, 0x2e, 0x7d, 0xf4, 0xe6, 0x48, 0x8c, 0x6f, 0xa7,
	0x2b, 0x42, 0xba, 0xe8, 0x70, 0x4c, 0xbd, 0xa2, 0x1f, 0x54, 0xc8, 0xbb, 0x1f, 0x56, 0x58, 0x3e,
	0x3c, 0x16, 0x59, 0x2e, 0x2c, 0xa6, 0xe9, 0x13, 0x42, 0x17, 0xbc, 0x2f, 0xe9, 0xe2, 0x25, 0x8f,
	0x87, 0x4f, 0xa1, 0x91, 0x09, 0x15, 0x8a, 0xd6, 0xe0, 0x6c, 0x43, 0xd5, 0x2b, 0x8a, 0x4a, 0xea,
	0xae, 0xc8, 0x58, 0x2a, 0xb2, 0xab, 0x6f, 0x8f, 0xc4, 0xcb, 0x79, 0xb1, 0x98, 0x5f, 0x16, 0xf2,
	0xe9, 0xfc, 0x72, 0xf1, 0x8e, 0x90, 0x2f, 0xac, 0x88, 0xa2, 0x28, 0xe4, 0xa5, 0x78, 0x43, 0xd5,
	0x1f, 0xa8, 0xa4, 0x4e, 0x65, 0xb7, 0x08, 0x71, 0xd3, 0x32, 0x94, 0x66, 0xd5, 0xae, 0xa8, 0x0a,
	0x49, 0x4c, 0xcf, 0x85, 0x92, 0xb1, 0x52, 0xb4, 0x5b, 0x19, 0xf0, 0x8c, 0x65, 0x85, 0xa0, 0x1b,
	0xbe, 0xe6, 0x8d, 0x52, 0x9a, 0x5d, 0xdc, 0xe6, 0x99, 0x6e, 0xeb, 0xa2, 0x05, 0x98, 0xa6, 0x64,
	0x54, 0x25, 0x11, 0x0b, 0xa0, 0x58, 0xc7, 0x54, 0x56, 0x9c, 0x82, 0x11, 0x5d, 0x36, 0xc9, 0x73,
	0xc3, 0x39, 0x37, 0x01, 0x01, 0x20, 0x74, 0xcc, 0x65, 0x05, 0x21, 0x08, 0x35, 0x2d, 0x35, 0x11,
	0x77, 0x40, 0x9b, 0x67, 0x24, 0xe7, 0x05, 0x2d, 0xc1, 0x94, 0x41, 0x12, 0x33, 0x73, 0x4c, 0x32,
	0x9e, 0xbb, 0x36, 0xb0, 0x7e, 0x8f, 0x89, 0x34, 0x65, 0x10, 0xae, 0x08, 0x71, 0x5f, 0xd9, 0xd0,
	0x05, 0x08, 0xd5, 0x71, 0xdb, 0x55, 0xa2, 0xe4, 0x3c, 0xa2, 0x4b, 0x10, 0x69, 0xc9, 0x5a, 0xd3,
	0xd3, 0x9d, 0xe4, 0xbe, 0xac, 0x4e, 0xdd, 0x61, 0x4a, 0xe7, 0x80, 0x25, 0x46, 0xd3, 0xaa, 0x62,
	0x14, 0xfe, 0xf5, 0x37, 0x91, 0xe1, 0x05, 0xf8, 0x9f, 0x4f, 0x14, 0x8f, 0xb0, 0x2d, 0x2b, 0xb2,
	0x2d, 0xa3, 0xab, 0xa7, 0x07, 0xdb, 0xc9, 0x28, 0xfb, 0x3b, 0x04, 0xe8, 0xa9, 0xa9, 0x9c, 0x6e,
	0x8a, 0x71, 0x47, 0x21, 0xba, 0x0b, 0xf1, 0x26, 0x75, 0xa7, 0x33, 0x9e, 0x32, 0x8c, 0xe7, 0xb8,
	0x8c, 0xbb, 0x06, 0x32, 0x9d, 0x35, 0x90, 0x79, 0xe8, 0xac, 0x81, 0x47, 0x32, 0xa9, 0x4b, 0xe0,
	0xc2, 0x9d, 0xe7, 0x6e, 0x3f, 0x85, 0xde, 0xab, 0x9f, 0xc2, 0x43, 0xfb, 0x29, 0xa0, 0xc0, 0xc8,
	0x44, 0x0a, 0xf4, 0xb5, 0x23, 0x3b, 0xa2, 0x1d, 0x83, 0x69, 0xfc, 0x4f, 0xda, 0xf1, 0x3d, 0xf4,
	0xe2, 0xe8, 0xc3, 0xc7, 0x72, 0x1c, 0x7d, 0xac, 0x01, 0x7a, 0x80, 0x35, 0xfc, 0x8e, 0xf2, 0x70,
	0x0e, 0xf4, 0xb9, 0x8f, 0x73, 0xe0, 0xf7, 0x0c, 0x70, 0xdd, 0xe5, 0xf0, 0xb8, 0xb3, 0xd3, 0xc9,
	0xc4, 0xc2, 0xfc, 0xf7, 0x57, 0x1b, 0xff, 0x15, 0x03, 0xd7, 0xfa, 0x52, 0xf3, 0x16, 0xd8, 0xc7,
	0x00, 0xdd, 0x4b, 0x48, 0x67, 0x89, 0xcd, 0xf7, 0xca, 0xe5, 0xe4, 0x92, 0xd2, 0xf5, 0x97, 0x7c,
	0x4e, 0xe3, 0xee, 0xb2, 0xdc, 0x2f, 0x51, 0x98, 0xa1, 0x34, 0x9e, 0xb8, 0xb7, 0x36, 0xd4, 0x82,
	0xd0, 0x06, 0xb6, 0x51, 0x72, 0xa0, 0x3a, 0x4f, 0x5d, 0x76, 0xb8, 0x11, 0xdb, 0x95, 0xbf, 0xf1,
	0xea, 0xf7, 0x3f, 0xbf, 0x99, 0xfa, 0x00, 0xcd, 0x06, 0xee, 0x61, 0x24, 0xbb, 0xdf, 0x29, 0xc1,
	0x4b, 0xf4, 0x2d, 0x03, 0x17, 0x37, 0xb0, 0xdd, 0x7b, 0x0b, 0x42, 0x85, 0x91, 0x34, 0xfa, 0x5e,
	0x9b, 0x46, 0x92, 0x5a, 0xa4, 0xa4, 0x16, 0xd0, 0x7c, 0x90, 0xd4, 0xaa, 0xd6, 0x4b, 0x61, 0x1f,
	0xc2, 0x4e, 0xad, 0x50, 0x6a, 0x60, 0xc8, 0xc0, 0xcd, 0x89, 0x5b, 0x1a, 0x0b, 0xeb, 0x56, 0x9b,
	0xe7, 0x28, 0x97, 0x4b, 0x08, 0x05, 0xb9, 0xa0, 0xef, 0x18, 0x60, 0xdd, 0x41, 0x8c, 0x96, 0x26,
	0x58, 0xdf, 0xdc, 0x68, 0xb5, 0xf0, 0x6b, 0x87, 0xaf, 0x53, 0xd7, 0xfb, 0x8f, 0xf9, 0x08, 0x7d,
	0xa5, 0xb4, 0xae, 0xf0, 0x7d, 0x68, 0xad, 0x32, 0x29, 0xf4, 0x03, 0x03, 0xac, 0x3b, 0x02, 0x86,
	0x30, 0x0b, 0x4e, 0xb2, 0x71, 0x98, 0x6d, 0xba, 0xcc, 0xfa, 0x0d, 0x18, 0x1f, 0x33, 0x3e, 0x37,
	0x5c, 0x51, 0x0e, 0xc9, 0x9f, 0x18, 0x60, 0xdd, 0xb1, 0x31, 0x84, 0x64, 0x70, 0x2c, 0x8d, 0x43,
	0xf2, 0xe9, 0xe1, 0xeb, 0xd4, 0xed, 0xfe, 0x43, 0xe9, 0xf2, 0xe9, 0xa5, 0xb5, 0xde, 0x30, 0xed,
	0xb6, 0xdb, 0x06, 0xa9, 0x11, 0x6d, 0xf0, 0x23, 0x03, 0xe7, 0x1c, 0x8d, 0x9c, 0x4c, 0x05, 0xb4,
	0x3c, 0x5a, 0x4c, 0x81, 0xf1, 0xc6, 0xe5, 0x27, 0x73, 0xf2, 0xa4, 0x28, 0x50, 0x92, 0x29, 0x94,
	0x1c, 0x4a, 0xf2, 0xe4, 0x1f, 0x12, 0x29, 0xad, 0x7f, 0x76, 0xbf, 0xa6, 0xda, 0xcf, 0x9b, 0x3b,
	0xce, 0x11, 0x59, 0xf7, 0xcc, 0xb4, 0xfb, 0x4f, 0xa9, 0x66, 0xa4, 0x6b, 0x58, 0xa7, 0x49, 0xc8,
	0x0e, 0xf8, 0x3f, 0x76, 0xd7, 0x7b, 0xdc, 0x61, 0x29, 0x6c, 0xf9, 0x9f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xad, 0x67, 0x8e, 0x3a, 0x5b, 0x0e, 0x00, 0x00,
}
