// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/instance_service.proto

package compute // import "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type InstanceView int32

const (
	// Doesn't include the metadata field in the server response.
	InstanceView_BASIC InstanceView = 0
	// Returns the full representation of the instance in the server response, including metadata.
	InstanceView_FULL InstanceView = 1
)

var InstanceView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}
var InstanceView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x InstanceView) String() string {
	return proto.EnumName(InstanceView_name, int32(x))
}
func (InstanceView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{0}
}

type AttachedDiskSpec_Mode int32

const (
	AttachedDiskSpec_MODE_UNSPECIFIED AttachedDiskSpec_Mode = 0
	// Read-only access.
	AttachedDiskSpec_READ_ONLY AttachedDiskSpec_Mode = 1
	// Read/Write access. Default value.
	AttachedDiskSpec_READ_WRITE AttachedDiskSpec_Mode = 2
)

var AttachedDiskSpec_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "READ_ONLY",
	2: "READ_WRITE",
}
var AttachedDiskSpec_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED": 0,
	"READ_ONLY":        1,
	"READ_WRITE":       2,
}

func (x AttachedDiskSpec_Mode) String() string {
	return proto.EnumName(AttachedDiskSpec_Mode_name, int32(x))
}
func (AttachedDiskSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{26, 0}
}

type GetInstanceRequest struct {
	// ID of the Instance resource to return.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Defines which information about the Instance resource should be returned in the server response.
	View                 InstanceView `protobuf:"varint,2,opt,name=view,proto3,enum=yandex.cloud.compute.v1.InstanceView" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{0}
}
func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(dst, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *GetInstanceRequest) GetView() InstanceView {
	if m != nil {
		return m.View
	}
	return InstanceView_BASIC
}

type ListInstancesRequest struct {
	// ID of the Folder to list instances in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListInstancesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results,
	// set [page_token] to the [ListInstancesResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Instance.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z]([-a-z0-9]{,61}[a-z0-9])?$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{1}
}
func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(dst, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstancesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListInstancesResponse struct {
	// List of Instance resources.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListInstancesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListInstancesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{2}
}
func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(dst, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateInstanceRequest struct {
	// ID of the folder to create an instance in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the instance.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the availability zone where the instance resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request
	ZoneId string `protobuf:"bytes,5,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the hardware platform configuration for the instance.
	// This field affects the available values in [resources_spec] field.
	//
	// Currently only one platform is available - `standard-v1`. This platform is suitable for most tasks.
	// This platform allows you to create various types of instances: with a large amount of memory,
	// with a large number of cores, with a burstable performance.
	PlatformId string `protobuf:"bytes,6,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance, such as the amount of memory and number of cores.
	// To get a list of available values, see [Computing resources](/docs/compute/concepts/vm-types).
	ResourcesSpec *ResourcesSpec `protobuf:"bytes,7,opt,name=resources_spec,json=resourcesSpec,proto3" json:"resources_spec,omitempty"`
	// The metadata `key:value` pairs that will be assigned to this instance. This includes custom metadata and predefined keys.
	// The total size of all keys and values must be less than 512 KB.
	//
	// Values are free-form strings, and only have meaning as interpreted by the programs which configure the instance.
	// The only restriction placed on values is that their size must be 256 KB or less.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,8,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boot disk to attach to the instance.
	BootDiskSpec *AttachedDiskSpec `protobuf:"bytes,9,opt,name=boot_disk_spec,json=bootDiskSpec,proto3" json:"boot_disk_spec,omitempty"`
	// Array of secondary disks to attach to the instance.
	SecondaryDiskSpecs []*AttachedDiskSpec `protobuf:"bytes,10,rep,name=secondary_disk_specs,json=secondaryDiskSpecs,proto3" json:"secondary_disk_specs,omitempty"`
	// Network configuration for the instance. Specifies how the network interface is configured
	// to interact with other services on the internal network and on the internet.
	// Currently only one network interface is supported per instance.
	NetworkInterfaceSpecs []*NetworkInterfaceSpec `protobuf:"bytes,11,rep,name=network_interface_specs,json=networkInterfaceSpecs,proto3" json:"network_interface_specs,omitempty"`
	// Host name for the instance.
	// This field is used to generate the [yandex.cloud.compute.v1.Instance.fqdn] value.
	// The host name must be unique within the network and region.
	// If not specified, the host name will be equal to [yandex.cloud.compute.v1.Instance.id] of the instance
	// and FQDN will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.
	Hostname string `protobuf:"bytes,12,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Scheduling policy configuration.
	SchedulingPolicy     *SchedulingPolicy `protobuf:"bytes,13,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	ServiceAccountId     string            `protobuf:"bytes,14,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{3}
}
func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(dst, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateInstanceRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateInstanceRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateInstanceRequest) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *CreateInstanceRequest) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *CreateInstanceRequest) GetResourcesSpec() *ResourcesSpec {
	if m != nil {
		return m.ResourcesSpec
	}
	return nil
}

func (m *CreateInstanceRequest) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CreateInstanceRequest) GetBootDiskSpec() *AttachedDiskSpec {
	if m != nil {
		return m.BootDiskSpec
	}
	return nil
}

func (m *CreateInstanceRequest) GetSecondaryDiskSpecs() []*AttachedDiskSpec {
	if m != nil {
		return m.SecondaryDiskSpecs
	}
	return nil
}

func (m *CreateInstanceRequest) GetNetworkInterfaceSpecs() []*NetworkInterfaceSpec {
	if m != nil {
		return m.NetworkInterfaceSpecs
	}
	return nil
}

func (m *CreateInstanceRequest) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *CreateInstanceRequest) GetSchedulingPolicy() *SchedulingPolicy {
	if m != nil {
		return m.SchedulingPolicy
	}
	return nil
}

func (m *CreateInstanceRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type CreateInstanceMetadata struct {
	// ID of the instance that is being created.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateInstanceMetadata) Reset()         { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()    {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{4}
}
func (m *CreateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceMetadata.Unmarshal(m, b)
}
func (m *CreateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceMetadata.Merge(dst, src)
}
func (m *CreateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceMetadata.Size(m)
}
func (m *CreateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceMetadata proto.InternalMessageInfo

func (m *CreateInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type UpdateInstanceRequest struct {
	// ID of the Instance resource to update.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Field mask that specifies which fields of the Instance resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the instance.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the hardware platform configuration for the instance.
	// This field affects the available values in [resources_spec] field.
	//
	// Currently only one platform is available - `standard-v1`. This platform is suitable for most tasks.
	// This platform allows you to create various types of instances: with a large amount of memory,
	// with a large number of cores, with a burstable performance.
	PlatformId string `protobuf:"bytes,6,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance, such as the amount of memory and number of cores.
	// To get a list of available values, see [Computing resources](/docs/compute/concepts/vm-types).
	ResourcesSpec *ResourcesSpec `protobuf:"bytes,7,opt,name=resources_spec,json=resourcesSpec,proto3" json:"resources_spec,omitempty"`
	// The metadata `key:value` pairs that will be assigned to this instance. This includes custom metadata and predefined keys.
	// The total size of all keys and values must be less than 512 KB.
	//
	// Existing set of `metadata` is completely replaced by the provided set.
	//
	// Values are free-form strings, and only have meaning as interpreted by the programs which configure the instance.
	// The only restriction placed on values is that their size must be 256 KB or less.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata             map[string]string `protobuf:"bytes,8,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{5}
}
func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(dst, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateInstanceRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateInstanceRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateInstanceRequest) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *UpdateInstanceRequest) GetResourcesSpec() *ResourcesSpec {
	if m != nil {
		return m.ResourcesSpec
	}
	return nil
}

func (m *UpdateInstanceRequest) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type UpdateInstanceMetadata struct {
	// ID of the Instance resource that is being updated.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInstanceMetadata) Reset()         { *m = UpdateInstanceMetadata{} }
func (m *UpdateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadata) ProtoMessage()    {}
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{6}
}
func (m *UpdateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceMetadata.Unmarshal(m, b)
}
func (m *UpdateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceMetadata.Merge(dst, src)
}
func (m *UpdateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceMetadata.Size(m)
}
func (m *UpdateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceMetadata proto.InternalMessageInfo

func (m *UpdateInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type DeleteInstanceRequest struct {
	// ID of the instance to delete.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{7}
}
func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(dst, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type DeleteInstanceMetadata struct {
	// ID of the instance that is being deleted.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceMetadata) Reset()         { *m = DeleteInstanceMetadata{} }
func (m *DeleteInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceMetadata) ProtoMessage()    {}
func (*DeleteInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{8}
}
func (m *DeleteInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceMetadata.Unmarshal(m, b)
}
func (m *DeleteInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceMetadata.Merge(dst, src)
}
func (m *DeleteInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceMetadata.Size(m)
}
func (m *DeleteInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceMetadata proto.InternalMessageInfo

func (m *DeleteInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type UpdateInstanceMetadataRequest struct {
	// ID of the instance that is being updated.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// List of keys to be deleted.
	Delete []string `protobuf:"bytes,2,rep,name=delete,proto3" json:"delete,omitempty"`
	// The metadata `key:value` pairs that will be added or updated to this instance.
	Upsert               map[string]string `protobuf:"bytes,3,rep,name=upsert,proto3" json:"upsert,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateInstanceMetadataRequest) Reset()         { *m = UpdateInstanceMetadataRequest{} }
func (m *UpdateInstanceMetadataRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadataRequest) ProtoMessage()    {}
func (*UpdateInstanceMetadataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{9}
}
func (m *UpdateInstanceMetadataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceMetadataRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceMetadataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceMetadataRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceMetadataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceMetadataRequest.Merge(dst, src)
}
func (m *UpdateInstanceMetadataRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceMetadataRequest.Size(m)
}
func (m *UpdateInstanceMetadataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceMetadataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceMetadataRequest proto.InternalMessageInfo

func (m *UpdateInstanceMetadataRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *UpdateInstanceMetadataRequest) GetDelete() []string {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *UpdateInstanceMetadataRequest) GetUpsert() map[string]string {
	if m != nil {
		return m.Upsert
	}
	return nil
}

type UpdateInstanceMetadataMetadata struct {
	// ID of the instance that is being updated.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInstanceMetadataMetadata) Reset()         { *m = UpdateInstanceMetadataMetadata{} }
func (m *UpdateInstanceMetadataMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadataMetadata) ProtoMessage()    {}
func (*UpdateInstanceMetadataMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{10}
}
func (m *UpdateInstanceMetadataMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceMetadataMetadata.Unmarshal(m, b)
}
func (m *UpdateInstanceMetadataMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceMetadataMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateInstanceMetadataMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceMetadataMetadata.Merge(dst, src)
}
func (m *UpdateInstanceMetadataMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceMetadataMetadata.Size(m)
}
func (m *UpdateInstanceMetadataMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceMetadataMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceMetadataMetadata proto.InternalMessageInfo

func (m *UpdateInstanceMetadataMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type GetInstanceSerialPortOutputRequest struct {
	// ID of the instance to return the serial port output for.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceSerialPortOutputRequest) Reset()         { *m = GetInstanceSerialPortOutputRequest{} }
func (m *GetInstanceSerialPortOutputRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceSerialPortOutputRequest) ProtoMessage()    {}
func (*GetInstanceSerialPortOutputRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{11}
}
func (m *GetInstanceSerialPortOutputRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceSerialPortOutputRequest.Unmarshal(m, b)
}
func (m *GetInstanceSerialPortOutputRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceSerialPortOutputRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstanceSerialPortOutputRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceSerialPortOutputRequest.Merge(dst, src)
}
func (m *GetInstanceSerialPortOutputRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceSerialPortOutputRequest.Size(m)
}
func (m *GetInstanceSerialPortOutputRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceSerialPortOutputRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceSerialPortOutputRequest proto.InternalMessageInfo

func (m *GetInstanceSerialPortOutputRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type GetInstanceSerialPortOutputResponse struct {
	// The contents of the serial port output, starting from the time when the instance
	// started to boot.
	Contents             string   `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceSerialPortOutputResponse) Reset()         { *m = GetInstanceSerialPortOutputResponse{} }
func (m *GetInstanceSerialPortOutputResponse) String() string { return proto.CompactTextString(m) }
func (*GetInstanceSerialPortOutputResponse) ProtoMessage()    {}
func (*GetInstanceSerialPortOutputResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{12}
}
func (m *GetInstanceSerialPortOutputResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceSerialPortOutputResponse.Unmarshal(m, b)
}
func (m *GetInstanceSerialPortOutputResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceSerialPortOutputResponse.Marshal(b, m, deterministic)
}
func (dst *GetInstanceSerialPortOutputResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceSerialPortOutputResponse.Merge(dst, src)
}
func (m *GetInstanceSerialPortOutputResponse) XXX_Size() int {
	return xxx_messageInfo_GetInstanceSerialPortOutputResponse.Size(m)
}
func (m *GetInstanceSerialPortOutputResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceSerialPortOutputResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceSerialPortOutputResponse proto.InternalMessageInfo

func (m *GetInstanceSerialPortOutputResponse) GetContents() string {
	if m != nil {
		return m.Contents
	}
	return ""
}

type StopInstanceRequest struct {
	// ID of the instance to stop.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopInstanceRequest) Reset()         { *m = StopInstanceRequest{} }
func (m *StopInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*StopInstanceRequest) ProtoMessage()    {}
func (*StopInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{13}
}
func (m *StopInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopInstanceRequest.Unmarshal(m, b)
}
func (m *StopInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *StopInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopInstanceRequest.Merge(dst, src)
}
func (m *StopInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_StopInstanceRequest.Size(m)
}
func (m *StopInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopInstanceRequest proto.InternalMessageInfo

func (m *StopInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type StopInstanceMetadata struct {
	// ID of the instance that is being deleted.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopInstanceMetadata) Reset()         { *m = StopInstanceMetadata{} }
func (m *StopInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*StopInstanceMetadata) ProtoMessage()    {}
func (*StopInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{14}
}
func (m *StopInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopInstanceMetadata.Unmarshal(m, b)
}
func (m *StopInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *StopInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopInstanceMetadata.Merge(dst, src)
}
func (m *StopInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_StopInstanceMetadata.Size(m)
}
func (m *StopInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopInstanceMetadata proto.InternalMessageInfo

func (m *StopInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type StartInstanceRequest struct {
	// ID of the instance to start.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartInstanceRequest) Reset()         { *m = StartInstanceRequest{} }
func (m *StartInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*StartInstanceRequest) ProtoMessage()    {}
func (*StartInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{15}
}
func (m *StartInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartInstanceRequest.Unmarshal(m, b)
}
func (m *StartInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *StartInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartInstanceRequest.Merge(dst, src)
}
func (m *StartInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_StartInstanceRequest.Size(m)
}
func (m *StartInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartInstanceRequest proto.InternalMessageInfo

func (m *StartInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type StartInstanceMetadata struct {
	// ID of the instance.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartInstanceMetadata) Reset()         { *m = StartInstanceMetadata{} }
func (m *StartInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*StartInstanceMetadata) ProtoMessage()    {}
func (*StartInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{16}
}
func (m *StartInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartInstanceMetadata.Unmarshal(m, b)
}
func (m *StartInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *StartInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartInstanceMetadata.Merge(dst, src)
}
func (m *StartInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_StartInstanceMetadata.Size(m)
}
func (m *StartInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartInstanceMetadata proto.InternalMessageInfo

func (m *StartInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type RestartInstanceRequest struct {
	// ID of the instance to restart.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestartInstanceRequest) Reset()         { *m = RestartInstanceRequest{} }
func (m *RestartInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*RestartInstanceRequest) ProtoMessage()    {}
func (*RestartInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{17}
}
func (m *RestartInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestartInstanceRequest.Unmarshal(m, b)
}
func (m *RestartInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestartInstanceRequest.Marshal(b, m, deterministic)
}
func (dst *RestartInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestartInstanceRequest.Merge(dst, src)
}
func (m *RestartInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_RestartInstanceRequest.Size(m)
}
func (m *RestartInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestartInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestartInstanceRequest proto.InternalMessageInfo

func (m *RestartInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type RestartInstanceMetadata struct {
	// ID of the instance.
	InstanceId           string   `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestartInstanceMetadata) Reset()         { *m = RestartInstanceMetadata{} }
func (m *RestartInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*RestartInstanceMetadata) ProtoMessage()    {}
func (*RestartInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{18}
}
func (m *RestartInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestartInstanceMetadata.Unmarshal(m, b)
}
func (m *RestartInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestartInstanceMetadata.Marshal(b, m, deterministic)
}
func (dst *RestartInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestartInstanceMetadata.Merge(dst, src)
}
func (m *RestartInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_RestartInstanceMetadata.Size(m)
}
func (m *RestartInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestartInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestartInstanceMetadata proto.InternalMessageInfo

func (m *RestartInstanceMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type AttachInstanceDiskRequest struct {
	// ID of the instance to attach the disk to.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Disk that should be attached.
	AttachedDiskSpec     *AttachedDiskSpec `protobuf:"bytes,2,opt,name=attached_disk_spec,json=attachedDiskSpec,proto3" json:"attached_disk_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AttachInstanceDiskRequest) Reset()         { *m = AttachInstanceDiskRequest{} }
func (m *AttachInstanceDiskRequest) String() string { return proto.CompactTextString(m) }
func (*AttachInstanceDiskRequest) ProtoMessage()    {}
func (*AttachInstanceDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{19}
}
func (m *AttachInstanceDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachInstanceDiskRequest.Unmarshal(m, b)
}
func (m *AttachInstanceDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachInstanceDiskRequest.Marshal(b, m, deterministic)
}
func (dst *AttachInstanceDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachInstanceDiskRequest.Merge(dst, src)
}
func (m *AttachInstanceDiskRequest) XXX_Size() int {
	return xxx_messageInfo_AttachInstanceDiskRequest.Size(m)
}
func (m *AttachInstanceDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachInstanceDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttachInstanceDiskRequest proto.InternalMessageInfo

func (m *AttachInstanceDiskRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *AttachInstanceDiskRequest) GetAttachedDiskSpec() *AttachedDiskSpec {
	if m != nil {
		return m.AttachedDiskSpec
	}
	return nil
}

type AttachInstanceDiskMetadata struct {
	// ID of the instance.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// ID of the disk.
	DiskId               string   `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachInstanceDiskMetadata) Reset()         { *m = AttachInstanceDiskMetadata{} }
func (m *AttachInstanceDiskMetadata) String() string { return proto.CompactTextString(m) }
func (*AttachInstanceDiskMetadata) ProtoMessage()    {}
func (*AttachInstanceDiskMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{20}
}
func (m *AttachInstanceDiskMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachInstanceDiskMetadata.Unmarshal(m, b)
}
func (m *AttachInstanceDiskMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachInstanceDiskMetadata.Marshal(b, m, deterministic)
}
func (dst *AttachInstanceDiskMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachInstanceDiskMetadata.Merge(dst, src)
}
func (m *AttachInstanceDiskMetadata) XXX_Size() int {
	return xxx_messageInfo_AttachInstanceDiskMetadata.Size(m)
}
func (m *AttachInstanceDiskMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachInstanceDiskMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AttachInstanceDiskMetadata proto.InternalMessageInfo

func (m *AttachInstanceDiskMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *AttachInstanceDiskMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type DetachInstanceDiskRequest struct {
	// ID of the instance to detach the disk from.
	// To get the instance ID, use a [InstanceService.List] request.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Types that are valid to be assigned to Disk:
	//	*DetachInstanceDiskRequest_DiskId
	//	*DetachInstanceDiskRequest_DeviceName
	Disk                 isDetachInstanceDiskRequest_Disk `protobuf_oneof:"disk"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *DetachInstanceDiskRequest) Reset()         { *m = DetachInstanceDiskRequest{} }
func (m *DetachInstanceDiskRequest) String() string { return proto.CompactTextString(m) }
func (*DetachInstanceDiskRequest) ProtoMessage()    {}
func (*DetachInstanceDiskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{21}
}
func (m *DetachInstanceDiskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetachInstanceDiskRequest.Unmarshal(m, b)
}
func (m *DetachInstanceDiskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetachInstanceDiskRequest.Marshal(b, m, deterministic)
}
func (dst *DetachInstanceDiskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetachInstanceDiskRequest.Merge(dst, src)
}
func (m *DetachInstanceDiskRequest) XXX_Size() int {
	return xxx_messageInfo_DetachInstanceDiskRequest.Size(m)
}
func (m *DetachInstanceDiskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetachInstanceDiskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetachInstanceDiskRequest proto.InternalMessageInfo

func (m *DetachInstanceDiskRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type isDetachInstanceDiskRequest_Disk interface {
	isDetachInstanceDiskRequest_Disk()
}

type DetachInstanceDiskRequest_DiskId struct {
	DiskId string `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3,oneof"`
}

type DetachInstanceDiskRequest_DeviceName struct {
	DeviceName string `protobuf:"bytes,3,opt,name=device_name,json=deviceName,proto3,oneof"`
}

func (*DetachInstanceDiskRequest_DiskId) isDetachInstanceDiskRequest_Disk() {}

func (*DetachInstanceDiskRequest_DeviceName) isDetachInstanceDiskRequest_Disk() {}

func (m *DetachInstanceDiskRequest) GetDisk() isDetachInstanceDiskRequest_Disk {
	if m != nil {
		return m.Disk
	}
	return nil
}

func (m *DetachInstanceDiskRequest) GetDiskId() string {
	if x, ok := m.GetDisk().(*DetachInstanceDiskRequest_DiskId); ok {
		return x.DiskId
	}
	return ""
}

func (m *DetachInstanceDiskRequest) GetDeviceName() string {
	if x, ok := m.GetDisk().(*DetachInstanceDiskRequest_DeviceName); ok {
		return x.DeviceName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DetachInstanceDiskRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DetachInstanceDiskRequest_OneofMarshaler, _DetachInstanceDiskRequest_OneofUnmarshaler, _DetachInstanceDiskRequest_OneofSizer, []interface{}{
		(*DetachInstanceDiskRequest_DiskId)(nil),
		(*DetachInstanceDiskRequest_DeviceName)(nil),
	}
}

func _DetachInstanceDiskRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DetachInstanceDiskRequest)
	// disk
	switch x := m.Disk.(type) {
	case *DetachInstanceDiskRequest_DiskId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.DiskId)
	case *DetachInstanceDiskRequest_DeviceName:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.DeviceName)
	case nil:
	default:
		return fmt.Errorf("DetachInstanceDiskRequest.Disk has unexpected type %T", x)
	}
	return nil
}

func _DetachInstanceDiskRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DetachInstanceDiskRequest)
	switch tag {
	case 2: // disk.disk_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Disk = &DetachInstanceDiskRequest_DiskId{x}
		return true, err
	case 3: // disk.device_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Disk = &DetachInstanceDiskRequest_DeviceName{x}
		return true, err
	default:
		return false, nil
	}
}

func _DetachInstanceDiskRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DetachInstanceDiskRequest)
	// disk
	switch x := m.Disk.(type) {
	case *DetachInstanceDiskRequest_DiskId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.DiskId)))
		n += len(x.DiskId)
	case *DetachInstanceDiskRequest_DeviceName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.DeviceName)))
		n += len(x.DeviceName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type DetachInstanceDiskMetadata struct {
	// ID of the instance.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// ID of the disk.
	DiskId               string   `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetachInstanceDiskMetadata) Reset()         { *m = DetachInstanceDiskMetadata{} }
func (m *DetachInstanceDiskMetadata) String() string { return proto.CompactTextString(m) }
func (*DetachInstanceDiskMetadata) ProtoMessage()    {}
func (*DetachInstanceDiskMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{22}
}
func (m *DetachInstanceDiskMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetachInstanceDiskMetadata.Unmarshal(m, b)
}
func (m *DetachInstanceDiskMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetachInstanceDiskMetadata.Marshal(b, m, deterministic)
}
func (dst *DetachInstanceDiskMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetachInstanceDiskMetadata.Merge(dst, src)
}
func (m *DetachInstanceDiskMetadata) XXX_Size() int {
	return xxx_messageInfo_DetachInstanceDiskMetadata.Size(m)
}
func (m *DetachInstanceDiskMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DetachInstanceDiskMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DetachInstanceDiskMetadata proto.InternalMessageInfo

func (m *DetachInstanceDiskMetadata) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *DetachInstanceDiskMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type ListInstanceOperationsRequest struct {
	// ID of the Instance resource to list operations for.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListInstanceOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListInstanceOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceOperationsRequest) Reset()         { *m = ListInstanceOperationsRequest{} }
func (m *ListInstanceOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstanceOperationsRequest) ProtoMessage()    {}
func (*ListInstanceOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{23}
}
func (m *ListInstanceOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceOperationsRequest.Unmarshal(m, b)
}
func (m *ListInstanceOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstanceOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceOperationsRequest.Merge(dst, src)
}
func (m *ListInstanceOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstanceOperationsRequest.Size(m)
}
func (m *ListInstanceOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceOperationsRequest proto.InternalMessageInfo

func (m *ListInstanceOperationsRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *ListInstanceOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListInstanceOperationsResponse struct {
	// List of operations for the specified instance.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListInstanceOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListInstanceOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstanceOperationsResponse) Reset()         { *m = ListInstanceOperationsResponse{} }
func (m *ListInstanceOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstanceOperationsResponse) ProtoMessage()    {}
func (*ListInstanceOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{24}
}
func (m *ListInstanceOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstanceOperationsResponse.Unmarshal(m, b)
}
func (m *ListInstanceOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstanceOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstanceOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstanceOperationsResponse.Merge(dst, src)
}
func (m *ListInstanceOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstanceOperationsResponse.Size(m)
}
func (m *ListInstanceOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstanceOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstanceOperationsResponse proto.InternalMessageInfo

func (m *ListInstanceOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListInstanceOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ResourcesSpec struct {
	// The amount of memory available to the instance, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The number of cores available to the instance.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the ability to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	//
	// For example, if you need only 5% of the CPU performance, you can set core_fraction=5.
	// For more information, see [documentation](/docs/compute/concepts/vm-types#light-vms).
	CoreFraction         int64    `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourcesSpec) Reset()         { *m = ResourcesSpec{} }
func (m *ResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*ResourcesSpec) ProtoMessage()    {}
func (*ResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{25}
}
func (m *ResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourcesSpec.Unmarshal(m, b)
}
func (m *ResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourcesSpec.Marshal(b, m, deterministic)
}
func (dst *ResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourcesSpec.Merge(dst, src)
}
func (m *ResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_ResourcesSpec.Size(m)
}
func (m *ResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ResourcesSpec proto.InternalMessageInfo

func (m *ResourcesSpec) GetMemory() int64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourcesSpec) GetCores() int64 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *ResourcesSpec) GetCoreFraction() int64 {
	if m != nil {
		return m.CoreFraction
	}
	return 0
}

type AttachedDiskSpec struct {
	// The mode in which to attach this disk.
	Mode AttachedDiskSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.compute.v1.AttachedDiskSpec_Mode" json:"mode,omitempty"`
	// Specifies a unique serial number of your choice that is reflected into the /dev/disk/by-id/ tree
	// of a Linux operating system running within the instance.
	//
	// This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
	// If not specified, a random value will be generated.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Specifies whether the disk will be auto-deleted when the instance is deleted.
	AutoDelete bool `protobuf:"varint,3,opt,name=auto_delete,json=autoDelete,proto3" json:"auto_delete,omitempty"`
	// Types that are valid to be assigned to Disk:
	//	*AttachedDiskSpec_DiskSpec_
	//	*AttachedDiskSpec_DiskId
	Disk                 isAttachedDiskSpec_Disk `protobuf_oneof:"disk"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AttachedDiskSpec) Reset()         { *m = AttachedDiskSpec{} }
func (m *AttachedDiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{26}
}
func (m *AttachedDiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec.Marshal(b, m, deterministic)
}
func (dst *AttachedDiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec.Merge(dst, src)
}
func (m *AttachedDiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec.Size(m)
}
func (m *AttachedDiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec) GetMode() AttachedDiskSpec_Mode {
	if m != nil {
		return m.Mode
	}
	return AttachedDiskSpec_MODE_UNSPECIFIED
}

func (m *AttachedDiskSpec) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *AttachedDiskSpec) GetAutoDelete() bool {
	if m != nil {
		return m.AutoDelete
	}
	return false
}

type isAttachedDiskSpec_Disk interface {
	isAttachedDiskSpec_Disk()
}

type AttachedDiskSpec_DiskSpec_ struct {
	DiskSpec *AttachedDiskSpec_DiskSpec `protobuf:"bytes,4,opt,name=disk_spec,json=diskSpec,proto3,oneof"`
}

type AttachedDiskSpec_DiskId struct {
	DiskId string `protobuf:"bytes,5,opt,name=disk_id,json=diskId,proto3,oneof"`
}

func (*AttachedDiskSpec_DiskSpec_) isAttachedDiskSpec_Disk() {}

func (*AttachedDiskSpec_DiskId) isAttachedDiskSpec_Disk() {}

func (m *AttachedDiskSpec) GetDisk() isAttachedDiskSpec_Disk {
	if m != nil {
		return m.Disk
	}
	return nil
}

func (m *AttachedDiskSpec) GetDiskSpec() *AttachedDiskSpec_DiskSpec {
	if x, ok := m.GetDisk().(*AttachedDiskSpec_DiskSpec_); ok {
		return x.DiskSpec
	}
	return nil
}

func (m *AttachedDiskSpec) GetDiskId() string {
	if x, ok := m.GetDisk().(*AttachedDiskSpec_DiskId); ok {
		return x.DiskId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttachedDiskSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttachedDiskSpec_OneofMarshaler, _AttachedDiskSpec_OneofUnmarshaler, _AttachedDiskSpec_OneofSizer, []interface{}{
		(*AttachedDiskSpec_DiskSpec_)(nil),
		(*AttachedDiskSpec_DiskId)(nil),
	}
}

func _AttachedDiskSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttachedDiskSpec)
	// disk
	switch x := m.Disk.(type) {
	case *AttachedDiskSpec_DiskSpec_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DiskSpec); err != nil {
			return err
		}
	case *AttachedDiskSpec_DiskId:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.DiskId)
	case nil:
	default:
		return fmt.Errorf("AttachedDiskSpec.Disk has unexpected type %T", x)
	}
	return nil
}

func _AttachedDiskSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttachedDiskSpec)
	switch tag {
	case 4: // disk.disk_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AttachedDiskSpec_DiskSpec)
		err := b.DecodeMessage(msg)
		m.Disk = &AttachedDiskSpec_DiskSpec_{msg}
		return true, err
	case 5: // disk.disk_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Disk = &AttachedDiskSpec_DiskId{x}
		return true, err
	default:
		return false, nil
	}
}

func _AttachedDiskSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttachedDiskSpec)
	// disk
	switch x := m.Disk.(type) {
	case *AttachedDiskSpec_DiskSpec_:
		s := proto.Size(x.DiskSpec)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AttachedDiskSpec_DiskId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.DiskId)))
		n += len(x.DiskId)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type AttachedDiskSpec_DiskSpec struct {
	// Name of the disk.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the disk.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the disk type.
	// To get a list of available disk types, use the [yandex.cloud.compute.v1.DiskTypeService.List] request.
	TypeId string `protobuf:"bytes,3,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// Size of the disk, specified in bytes.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// Types that are valid to be assigned to Source:
	//	*AttachedDiskSpec_DiskSpec_ImageId
	//	*AttachedDiskSpec_DiskSpec_SnapshotId
	Source               isAttachedDiskSpec_DiskSpec_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *AttachedDiskSpec_DiskSpec) Reset()         { *m = AttachedDiskSpec_DiskSpec{} }
func (m *AttachedDiskSpec_DiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec_DiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec_DiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{26, 0}
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Marshal(b, m, deterministic)
}
func (dst *AttachedDiskSpec_DiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.Merge(dst, src)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Size(m)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec_DiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec_DiskSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetTypeId() string {
	if m != nil {
		return m.TypeId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type isAttachedDiskSpec_DiskSpec_Source interface {
	isAttachedDiskSpec_DiskSpec_Source()
}

type AttachedDiskSpec_DiskSpec_ImageId struct {
	ImageId string `protobuf:"bytes,5,opt,name=image_id,json=imageId,proto3,oneof"`
}

type AttachedDiskSpec_DiskSpec_SnapshotId struct {
	SnapshotId string `protobuf:"bytes,6,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

func (*AttachedDiskSpec_DiskSpec_ImageId) isAttachedDiskSpec_DiskSpec_Source() {}

func (*AttachedDiskSpec_DiskSpec_SnapshotId) isAttachedDiskSpec_DiskSpec_Source() {}

func (m *AttachedDiskSpec_DiskSpec) GetSource() isAttachedDiskSpec_DiskSpec_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *AttachedDiskSpec_DiskSpec) GetImageId() string {
	if x, ok := m.GetSource().(*AttachedDiskSpec_DiskSpec_ImageId); ok {
		return x.ImageId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSnapshotId() string {
	if x, ok := m.GetSource().(*AttachedDiskSpec_DiskSpec_SnapshotId); ok {
		return x.SnapshotId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AttachedDiskSpec_DiskSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AttachedDiskSpec_DiskSpec_OneofMarshaler, _AttachedDiskSpec_DiskSpec_OneofUnmarshaler, _AttachedDiskSpec_DiskSpec_OneofSizer, []interface{}{
		(*AttachedDiskSpec_DiskSpec_ImageId)(nil),
		(*AttachedDiskSpec_DiskSpec_SnapshotId)(nil),
	}
}

func _AttachedDiskSpec_DiskSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AttachedDiskSpec_DiskSpec)
	// source
	switch x := m.Source.(type) {
	case *AttachedDiskSpec_DiskSpec_ImageId:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ImageId)
	case *AttachedDiskSpec_DiskSpec_SnapshotId:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SnapshotId)
	case nil:
	default:
		return fmt.Errorf("AttachedDiskSpec_DiskSpec.Source has unexpected type %T", x)
	}
	return nil
}

func _AttachedDiskSpec_DiskSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AttachedDiskSpec_DiskSpec)
	switch tag {
	case 5: // source.image_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &AttachedDiskSpec_DiskSpec_ImageId{x}
		return true, err
	case 6: // source.snapshot_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &AttachedDiskSpec_DiskSpec_SnapshotId{x}
		return true, err
	default:
		return false, nil
	}
}

func _AttachedDiskSpec_DiskSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AttachedDiskSpec_DiskSpec)
	// source
	switch x := m.Source.(type) {
	case *AttachedDiskSpec_DiskSpec_ImageId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ImageId)))
		n += len(x.ImageId)
	case *AttachedDiskSpec_DiskSpec_SnapshotId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SnapshotId)))
		n += len(x.SnapshotId)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type NetworkInterfaceSpec struct {
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Primary IPv4 address that will be assigned to the instance for this network interface.
	PrimaryV4AddressSpec *PrimaryAddressSpec `protobuf:"bytes,2,opt,name=primary_v4_address_spec,json=primaryV4AddressSpec,proto3" json:"primary_v4_address_spec,omitempty"`
	// Primary IPv6 address that will be assigned to the instance for this network interface. IPv6 not available yet.
	PrimaryV6AddressSpec *PrimaryAddressSpec `protobuf:"bytes,3,opt,name=primary_v6_address_spec,json=primaryV6AddressSpec,proto3" json:"primary_v6_address_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NetworkInterfaceSpec) Reset()         { *m = NetworkInterfaceSpec{} }
func (m *NetworkInterfaceSpec) String() string { return proto.CompactTextString(m) }
func (*NetworkInterfaceSpec) ProtoMessage()    {}
func (*NetworkInterfaceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{27}
}
func (m *NetworkInterfaceSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterfaceSpec.Unmarshal(m, b)
}
func (m *NetworkInterfaceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterfaceSpec.Marshal(b, m, deterministic)
}
func (dst *NetworkInterfaceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterfaceSpec.Merge(dst, src)
}
func (m *NetworkInterfaceSpec) XXX_Size() int {
	return xxx_messageInfo_NetworkInterfaceSpec.Size(m)
}
func (m *NetworkInterfaceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterfaceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterfaceSpec proto.InternalMessageInfo

func (m *NetworkInterfaceSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *NetworkInterfaceSpec) GetPrimaryV4AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV4AddressSpec
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetPrimaryV6AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV6AddressSpec
	}
	return nil
}

type PrimaryAddressSpec struct {
	// An IPv4 internal network address that is assigned to the instance for this network interface.
	// If not specified by the user, an unused internal IP is assigned by the system.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// An external IP address configuration.
	// If not specified, then this instance will have no external internet access.
	OneToOneNatSpec      *OneToOneNatSpec `protobuf:"bytes,2,opt,name=one_to_one_nat_spec,json=oneToOneNatSpec,proto3" json:"one_to_one_nat_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PrimaryAddressSpec) Reset()         { *m = PrimaryAddressSpec{} }
func (m *PrimaryAddressSpec) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddressSpec) ProtoMessage()    {}
func (*PrimaryAddressSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{28}
}
func (m *PrimaryAddressSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddressSpec.Unmarshal(m, b)
}
func (m *PrimaryAddressSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddressSpec.Marshal(b, m, deterministic)
}
func (dst *PrimaryAddressSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddressSpec.Merge(dst, src)
}
func (m *PrimaryAddressSpec) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddressSpec.Size(m)
}
func (m *PrimaryAddressSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddressSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddressSpec proto.InternalMessageInfo

func (m *PrimaryAddressSpec) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PrimaryAddressSpec) GetOneToOneNatSpec() *OneToOneNatSpec {
	if m != nil {
		return m.OneToOneNatSpec
	}
	return nil
}

type OneToOneNatSpec struct {
	// External IP address version.
	IpVersion            IpVersion `protobuf:"varint,1,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNatSpec) Reset()         { *m = OneToOneNatSpec{} }
func (m *OneToOneNatSpec) String() string { return proto.CompactTextString(m) }
func (*OneToOneNatSpec) ProtoMessage()    {}
func (*OneToOneNatSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_service_0205831efb8574f1, []int{29}
}
func (m *OneToOneNatSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNatSpec.Unmarshal(m, b)
}
func (m *OneToOneNatSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNatSpec.Marshal(b, m, deterministic)
}
func (dst *OneToOneNatSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNatSpec.Merge(dst, src)
}
func (m *OneToOneNatSpec) XXX_Size() int {
	return xxx_messageInfo_OneToOneNatSpec.Size(m)
}
func (m *OneToOneNatSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNatSpec.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNatSpec proto.InternalMessageInfo

func (m *OneToOneNatSpec) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

func init() {
	proto.RegisterType((*GetInstanceRequest)(nil), "yandex.cloud.compute.v1.GetInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "yandex.cloud.compute.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "yandex.cloud.compute.v1.ListInstancesResponse")
	proto.RegisterType((*CreateInstanceRequest)(nil), "yandex.cloud.compute.v1.CreateInstanceRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.CreateInstanceRequest.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.CreateInstanceRequest.MetadataEntry")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "yandex.cloud.compute.v1.CreateInstanceMetadata")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "yandex.cloud.compute.v1.UpdateInstanceRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateInstanceRequest.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateInstanceRequest.MetadataEntry")
	proto.RegisterType((*UpdateInstanceMetadata)(nil), "yandex.cloud.compute.v1.UpdateInstanceMetadata")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "yandex.cloud.compute.v1.DeleteInstanceRequest")
	proto.RegisterType((*DeleteInstanceMetadata)(nil), "yandex.cloud.compute.v1.DeleteInstanceMetadata")
	proto.RegisterType((*UpdateInstanceMetadataRequest)(nil), "yandex.cloud.compute.v1.UpdateInstanceMetadataRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateInstanceMetadataRequest.UpsertEntry")
	proto.RegisterType((*UpdateInstanceMetadataMetadata)(nil), "yandex.cloud.compute.v1.UpdateInstanceMetadataMetadata")
	proto.RegisterType((*GetInstanceSerialPortOutputRequest)(nil), "yandex.cloud.compute.v1.GetInstanceSerialPortOutputRequest")
	proto.RegisterType((*GetInstanceSerialPortOutputResponse)(nil), "yandex.cloud.compute.v1.GetInstanceSerialPortOutputResponse")
	proto.RegisterType((*StopInstanceRequest)(nil), "yandex.cloud.compute.v1.StopInstanceRequest")
	proto.RegisterType((*StopInstanceMetadata)(nil), "yandex.cloud.compute.v1.StopInstanceMetadata")
	proto.RegisterType((*StartInstanceRequest)(nil), "yandex.cloud.compute.v1.StartInstanceRequest")
	proto.RegisterType((*StartInstanceMetadata)(nil), "yandex.cloud.compute.v1.StartInstanceMetadata")
	proto.RegisterType((*RestartInstanceRequest)(nil), "yandex.cloud.compute.v1.RestartInstanceRequest")
	proto.RegisterType((*RestartInstanceMetadata)(nil), "yandex.cloud.compute.v1.RestartInstanceMetadata")
	proto.RegisterType((*AttachInstanceDiskRequest)(nil), "yandex.cloud.compute.v1.AttachInstanceDiskRequest")
	proto.RegisterType((*AttachInstanceDiskMetadata)(nil), "yandex.cloud.compute.v1.AttachInstanceDiskMetadata")
	proto.RegisterType((*DetachInstanceDiskRequest)(nil), "yandex.cloud.compute.v1.DetachInstanceDiskRequest")
	proto.RegisterType((*DetachInstanceDiskMetadata)(nil), "yandex.cloud.compute.v1.DetachInstanceDiskMetadata")
	proto.RegisterType((*ListInstanceOperationsRequest)(nil), "yandex.cloud.compute.v1.ListInstanceOperationsRequest")
	proto.RegisterType((*ListInstanceOperationsResponse)(nil), "yandex.cloud.compute.v1.ListInstanceOperationsResponse")
	proto.RegisterType((*ResourcesSpec)(nil), "yandex.cloud.compute.v1.ResourcesSpec")
	proto.RegisterType((*AttachedDiskSpec)(nil), "yandex.cloud.compute.v1.AttachedDiskSpec")
	proto.RegisterType((*AttachedDiskSpec_DiskSpec)(nil), "yandex.cloud.compute.v1.AttachedDiskSpec.DiskSpec")
	proto.RegisterType((*NetworkInterfaceSpec)(nil), "yandex.cloud.compute.v1.NetworkInterfaceSpec")
	proto.RegisterType((*PrimaryAddressSpec)(nil), "yandex.cloud.compute.v1.PrimaryAddressSpec")
	proto.RegisterType((*OneToOneNatSpec)(nil), "yandex.cloud.compute.v1.OneToOneNatSpec")
	proto.RegisterEnum("yandex.cloud.compute.v1.InstanceView", InstanceView_name, InstanceView_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.AttachedDiskSpec_Mode", AttachedDiskSpec_Mode_name, AttachedDiskSpec_Mode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// InstanceServiceClient is the client API for InstanceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InstanceServiceClient interface {
	// Returns the specified Instance resource.
	//
	// To get the list of available Instance resources, make a [List] request.
	Get(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Retrieves the list of Instance resources in the specified folder.
	List(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Creates an instance in the specified folder.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified instance.
	Update(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified instance.
	Delete(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the metadata of the specified instance.
	UpdateMetadata(ctx context.Context, in *UpdateInstanceMetadataRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the serial port output of the specified Instance resource.
	GetSerialPortOutput(ctx context.Context, in *GetInstanceSerialPortOutputRequest, opts ...grpc.CallOption) (*GetInstanceSerialPortOutputResponse, error)
	// Stops the running instance.
	//
	// You can start the instance later using the [InstanceService.Start] method.
	Stop(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Starts the stopped instance.
	Start(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Restarts the running instance.
	Restart(ctx context.Context, in *RestartInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Attaches the disk to the instance.
	AttachDisk(ctx context.Context, in *AttachInstanceDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Detaches the disk from the instance.
	DetachDisk(ctx context.Context, in *DetachInstanceDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified instance.
	ListOperations(ctx context.Context, in *ListInstanceOperationsRequest, opts ...grpc.CallOption) (*ListInstanceOperationsResponse, error)
}

type instanceServiceClient struct {
	cc *grpc.ClientConn
}

func NewInstanceServiceClient(cc *grpc.ClientConn) InstanceServiceClient {
	return &instanceServiceClient{cc}
}

func (c *instanceServiceClient) Get(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) List(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Create(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Update(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Delete(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) UpdateMetadata(ctx context.Context, in *UpdateInstanceMetadataRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/UpdateMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) GetSerialPortOutput(ctx context.Context, in *GetInstanceSerialPortOutputRequest, opts ...grpc.CallOption) (*GetInstanceSerialPortOutputResponse, error) {
	out := new(GetInstanceSerialPortOutputResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/GetSerialPortOutput", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Stop(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Start(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) Restart(ctx context.Context, in *RestartInstanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/Restart", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) AttachDisk(ctx context.Context, in *AttachInstanceDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/AttachDisk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) DetachDisk(ctx context.Context, in *DetachInstanceDiskRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/DetachDisk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceServiceClient) ListOperations(ctx context.Context, in *ListInstanceOperationsRequest, opts ...grpc.CallOption) (*ListInstanceOperationsResponse, error) {
	out := new(ListInstanceOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.InstanceService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceServiceServer is the server API for InstanceService service.
type InstanceServiceServer interface {
	// Returns the specified Instance resource.
	//
	// To get the list of available Instance resources, make a [List] request.
	Get(context.Context, *GetInstanceRequest) (*Instance, error)
	// Retrieves the list of Instance resources in the specified folder.
	List(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Creates an instance in the specified folder.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateInstanceRequest) (*operation.Operation, error)
	// Updates the specified instance.
	Update(context.Context, *UpdateInstanceRequest) (*operation.Operation, error)
	// Deletes the specified instance.
	Delete(context.Context, *DeleteInstanceRequest) (*operation.Operation, error)
	// Updates the metadata of the specified instance.
	UpdateMetadata(context.Context, *UpdateInstanceMetadataRequest) (*operation.Operation, error)
	// Returns the serial port output of the specified Instance resource.
	GetSerialPortOutput(context.Context, *GetInstanceSerialPortOutputRequest) (*GetInstanceSerialPortOutputResponse, error)
	// Stops the running instance.
	//
	// You can start the instance later using the [InstanceService.Start] method.
	Stop(context.Context, *StopInstanceRequest) (*operation.Operation, error)
	// Starts the stopped instance.
	Start(context.Context, *StartInstanceRequest) (*operation.Operation, error)
	// Restarts the running instance.
	Restart(context.Context, *RestartInstanceRequest) (*operation.Operation, error)
	// Attaches the disk to the instance.
	AttachDisk(context.Context, *AttachInstanceDiskRequest) (*operation.Operation, error)
	// Detaches the disk from the instance.
	DetachDisk(context.Context, *DetachInstanceDiskRequest) (*operation.Operation, error)
	// Lists operations for the specified instance.
	ListOperations(context.Context, *ListInstanceOperationsRequest) (*ListInstanceOperationsResponse, error)
}

func RegisterInstanceServiceServer(s *grpc.Server, srv InstanceServiceServer) {
	s.RegisterService(&_InstanceService_serviceDesc, srv)
}

func _InstanceService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Get(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).List(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Create(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Update(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Delete(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_UpdateMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).UpdateMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/UpdateMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).UpdateMetadata(ctx, req.(*UpdateInstanceMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_GetSerialPortOutput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceSerialPortOutputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).GetSerialPortOutput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/GetSerialPortOutput",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).GetSerialPortOutput(ctx, req.(*GetInstanceSerialPortOutputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Stop(ctx, req.(*StopInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Start(ctx, req.(*StartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_Restart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).Restart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/Restart",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).Restart(ctx, req.(*RestartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_AttachDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachInstanceDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).AttachDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/AttachDisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).AttachDisk(ctx, req.(*AttachInstanceDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_DetachDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachInstanceDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).DetachDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/DetachDisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).DetachDisk(ctx, req.(*DetachInstanceDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.InstanceService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceServiceServer).ListOperations(ctx, req.(*ListInstanceOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.InstanceService",
	HandlerType: (*InstanceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _InstanceService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _InstanceService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _InstanceService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceService_Delete_Handler,
		},
		{
			MethodName: "UpdateMetadata",
			Handler:    _InstanceService_UpdateMetadata_Handler,
		},
		{
			MethodName: "GetSerialPortOutput",
			Handler:    _InstanceService_GetSerialPortOutput_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _InstanceService_Stop_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _InstanceService_Start_Handler,
		},
		{
			MethodName: "Restart",
			Handler:    _InstanceService_Restart_Handler,
		},
		{
			MethodName: "AttachDisk",
			Handler:    _InstanceService_AttachDisk_Handler,
		},
		{
			MethodName: "DetachDisk",
			Handler:    _InstanceService_DetachDisk_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _InstanceService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/instance_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/instance_service.proto", fileDescriptor_instance_service_0205831efb8574f1)
}

var fileDescriptor_instance_service_0205831efb8574f1 = []byte{
	// 2359 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0xcd, 0x4f, 0x1b, 0xdb,
	0x15, 0xcf, 0xe0, 0x0f, 0xec, 0x63, 0x20, 0xee, 0x0d, 0x04, 0x3f, 0xab, 0xbc, 0x92, 0x89, 0x92,
	0x12, 0x67, 0xfc, 0x31, 0xc6, 0x18, 0x9c, 0x10, 0x3d, 0xe1, 0x00, 0x89, 0xd5, 0x24, 0xa4, 0x43,
	0x42, 0xdb, 0x44, 0xa9, 0x35, 0x78, 0x2e, 0x64, 0x84, 0x3d, 0x33, 0x9d, 0x19, 0x93, 0x47, 0xd2,
	0x54, 0x15, 0xaa, 0x2a, 0x35, 0x5d, 0xbe, 0x5d, 0x77, 0x6d, 0x57, 0xdd, 0xb5, 0xac, 0xda, 0x57,
	0xe9, 0xa9, 0xdd, 0x14, 0x56, 0x55, 0x45, 0x37, 0xfd, 0x03, 0xba, 0xe8, 0xae, 0x52, 0x96, 0x59,
	0x55, 0xf7, 0xce, 0x8c, 0x19, 0x9b, 0x19, 0x33, 0x40, 0xaa, 0xb7, 0x8a, 0xe7, 0xde, 0x73, 0xce,
	0xfd, 0x9d, 0x73, 0xcf, 0xe7, 0x0d, 0x90, 0xdb, 0x11, 0x15, 0x09, 0x7f, 0x9e, 0x6f, 0x34, 0xd5,
	0xb6, 0x94, 0x6f, 0xa8, 0x2d, 0xad, 0x6d, 0xe2, 0xfc, 0x36, 0x9f, 0x97, 0x15, 0xc3, 0x14, 0x95,
	0x06, 0xae, 0x1b, 0x58, 0xdf, 0x96, 0x1b, 0x38, 0xa7, 0xe9, 0xaa, 0xa9, 0xa2, 0x71, 0x8b, 0x3e,
	0x47, 0xe9, 0x73, 0x36, 0x7d, 0x6e, 0x9b, 0x4f, 0x7f, 0x73, 0x53, 0x55, 0x37, 0x9b, 0x38, 0x2f,
	0x6a, 0x72, 0x5e, 0x54, 0x14, 0xd5, 0x14, 0x4d, 0x59, 0x55, 0x0c, 0x8b, 0x2d, 0x3d, 0x69, 0xef,
	0xd2, 0xaf, 0xf5, 0xf6, 0x46, 0x7e, 0x43, 0xc6, 0x4d, 0xa9, 0xde, 0x12, 0x8d, 0x2d, 0x9b, 0x22,
	0x6d, 0x03, 0x21, 0xfc, 0xaa, 0x86, 0x75, 0xca, 0x6e, 0xef, 0x5d, 0x3f, 0x09, 0xa4, 0x27, 0x5d,
	0x47, 0xca, 0x31, 0x79, 0x13, 0x5d, 0x74, 0xdb, 0x62, 0x53, 0x96, 0x5c, 0xdb, 0xec, 0x4f, 0x00,
	0xdd, 0xc3, 0x66, 0xcd, 0x96, 0x2d, 0xe0, 0x1f, 0xb5, 0xb1, 0x61, 0xa2, 0x2c, 0x24, 0x3a, 0x36,
	0x91, 0xa5, 0x14, 0x33, 0xc9, 0x4c, 0xc5, 0xab, 0x43, 0xff, 0xd9, 0xe7, 0x99, 0x77, 0x07, 0x7c,
	0x78, 0xfe, 0xce, 0x4c, 0x41, 0x00, 0x87, 0xa0, 0x26, 0xa1, 0x0a, 0x84, 0xb7, 0x65, 0xfc, 0x2a,
	0x35, 0x30, 0xc9, 0x4c, 0x8d, 0x14, 0xaf, 0xe5, 0x7c, 0xec, 0x96, 0x73, 0x8e, 0x59, 0x93, 0xf1,
	0x2b, 0x81, 0xb2, 0xb0, 0x7f, 0x64, 0x60, 0xf4, 0x81, 0x6c, 0x74, 0x10, 0x18, 0x0e, 0x84, 0x1b,
	0x10, 0xdf, 0x50, 0x9b, 0x12, 0xd6, 0xfd, 0x00, 0xc4, 0xac, 0xed, 0x9a, 0x84, 0xbe, 0x0d, 0x71,
	0x4d, 0xdc, 0xc4, 0x75, 0x43, 0x7e, 0x8d, 0x29, 0x86, 0x50, 0x15, 0x3e, 0xec, 0xf3, 0xd1, 0xf9,
	0x3b, 0x7c, 0xa1, 0x50, 0x10, 0x62, 0x64, 0x73, 0x55, 0x7e, 0x8d, 0xd1, 0x14, 0x00, 0x25, 0x34,
	0xd5, 0x2d, 0xac, 0xa4, 0x42, 0x54, 0x68, 0xfc, 0xdd, 0x01, 0x1f, 0xa1, 0x94, 0x02, 0x95, 0xf2,
	0x84, 0xec, 0x21, 0x16, 0xa2, 0x1b, 0x72, 0xd3, 0xc4, 0x7a, 0x2a, 0x4c, 0xa9, 0xe0, 0xdd, 0x41,
	0x47, 0x9e, 0xbd, 0xc3, 0xfe, 0x94, 0x81, 0xb1, 0x1e, 0xe8, 0x86, 0xa6, 0x2a, 0x06, 0x46, 0x9f,
	0x41, 0xdc, 0xb1, 0x8e, 0x91, 0x62, 0x26, 0x43, 0x53, 0x89, 0xe2, 0x95, 0x13, 0x8d, 0x22, 0x1c,
	0xf1, 0xa0, 0xeb, 0x70, 0x51, 0xc1, 0x9f, 0x9b, 0x75, 0x17, 0x5a, 0xa2, 0x57, 0x5c, 0x18, 0x26,
	0xcb, 0x8f, 0x1d, 0x98, 0xec, 0xef, 0xe3, 0x30, 0x76, 0x57, 0xc7, 0xa2, 0x89, 0x7b, 0x6f, 0xf0,
	0x14, 0xe6, 0x9b, 0x81, 0xb0, 0x22, 0xb6, 0x2c, 0xcb, 0xc5, 0xab, 0x57, 0xde, 0xef, 0xf3, 0x13,
	0x3f, 0x7e, 0x2e, 0x66, 0x5f, 0xbf, 0x78, 0x9e, 0x15, 0xb3, 0xaf, 0x0b, 0xd9, 0xca, 0x8b, 0x37,
	0x3c, 0x57, 0xe6, 0xdf, 0x3e, 0xb7, 0xbf, 0x04, 0x4a, 0x8e, 0x6e, 0x42, 0x42, 0xc2, 0x46, 0x43,
	0x97, 0x35, 0xe2, 0x4e, 0xdd, 0xd6, 0x2c, 0xce, 0x94, 0x05, 0xf7, 0x2e, 0xfa, 0x82, 0x81, 0x68,
	0x53, 0x5c, 0xc7, 0x4d, 0x23, 0x15, 0xa6, 0xf6, 0xb8, 0xe5, 0x6b, 0x0f, 0x4f, 0x7d, 0x72, 0x0f,
	0x28, 0xf3, 0x92, 0x62, 0xea, 0x3b, 0xd5, 0xcf, 0xde, 0xef, 0xf3, 0x89, 0xe7, 0xd9, 0x7a, 0x21,
	0x5b, 0x21, 0x30, 0x33, 0xbb, 0x54, 0xa7, 0x72, 0xc9, 0xd2, 0xad, 0x3c, 0xbd, 0x77, 0xc0, 0x47,
	0xd3, 0x61, 0x3e, 0x4b, 0x7f, 0x21, 0x94, 0xb4, 0x95, 0xe9, 0xd0, 0x0b, 0x36, 0x14, 0x74, 0x0d,
	0x06, 0x5f, 0xab, 0x0a, 0x75, 0xf1, 0x88, 0x87, 0x89, 0xa2, 0x64, 0xb3, 0x26, 0xa1, 0x12, 0x24,
	0xb4, 0xa6, 0x68, 0x6e, 0xa8, 0x7a, 0x8b, 0x90, 0x46, 0x29, 0xe9, 0x25, 0x42, 0x4a, 0x80, 0x10,
	0x9c, 0x92, 0xa8, 0x4b, 0xd9, 0x6d, 0x5e, 0x00, 0x87, 0xae, 0x26, 0xa1, 0x55, 0x18, 0xd1, 0xb1,
	0xa1, 0xb6, 0xf5, 0x06, 0x36, 0xea, 0x86, 0x86, 0x1b, 0xa9, 0xc1, 0x49, 0x66, 0x2a, 0x51, 0xbc,
	0xee, 0xab, 0xb9, 0xe0, 0x90, 0xaf, 0x6a, 0xb8, 0x51, 0x0d, 0x93, 0x03, 0x84, 0x61, 0xdd, 0xbd,
	0x88, 0xbe, 0x0f, 0xb1, 0x16, 0x36, 0x45, 0x49, 0x34, 0xc5, 0x54, 0x8c, 0x1a, 0x72, 0xfe, 0x94,
	0x86, 0x7c, 0x68, 0xb3, 0x53, 0x53, 0x0a, 0x1d, 0x69, 0xe8, 0x29, 0x8c, 0xac, 0xab, 0xaa, 0x59,
	0x97, 0x64, 0x63, 0xcb, 0x82, 0x1b, 0xa7, 0x70, 0x6f, 0xf8, 0xca, 0x5f, 0x30, 0x4d, 0xb1, 0xf1,
	0x12, 0x4b, 0x8b, 0xb2, 0xb1, 0xe5, 0x42, 0x3c, 0x44, 0xc4, 0x38, 0x6b, 0x48, 0x82, 0x51, 0x03,
	0x37, 0x54, 0x62, 0xa1, 0x9d, 0x23, 0xd9, 0x46, 0x0a, 0x28, 0xf8, 0x53, 0x08, 0x1f, 0xdc, 0x3d,
	0xe0, 0x43, 0xf3, 0x77, 0xa6, 0x05, 0xd4, 0x91, 0xe7, 0xec, 0x19, 0xa8, 0x09, 0xe3, 0x0a, 0x36,
	0x5f, 0xa9, 0xfa, 0x56, 0x5d, 0x56, 0x4c, 0xac, 0x6f, 0x88, 0x24, 0x99, 0xd3, 0x83, 0x12, 0xf4,
	0xa0, 0xac, 0xef, 0x41, 0x8f, 0x2c, 0xbe, 0x9a, 0xc3, 0x46, 0x0f, 0x8b, 0xec, 0x1e, 0xf0, 0x0c,
	0x2f, 0x8c, 0x29, 0x1e, 0x9b, 0x06, 0xba, 0x03, 0xb1, 0x97, 0xaa, 0x61, 0xd2, 0xa0, 0x19, 0x0a,
	0x1a, 0x34, 0x1d, 0x16, 0xb4, 0x06, 0xdf, 0x30, 0x88, 0x6a, 0xed, 0xa6, 0xac, 0x6c, 0xd6, 0x35,
	0xb5, 0x29, 0x37, 0x76, 0x52, 0xc3, 0x27, 0x18, 0x7b, 0xb5, 0xc3, 0xf1, 0x98, 0x32, 0x08, 0x49,
	0xa3, 0x67, 0x05, 0x71, 0x80, 0xec, 0xfa, 0x55, 0x17, 0x1b, 0x0d, 0xb5, 0xad, 0x98, 0xc4, 0x5b,
	0x47, 0x68, 0xde, 0x48, 0xda, 0x3b, 0x0b, 0xd6, 0x46, 0x4d, 0x4a, 0x57, 0x20, 0xe1, 0x8a, 0x29,
	0x94, 0x84, 0xd0, 0x16, 0xde, 0xb1, 0x32, 0x85, 0x40, 0x7e, 0xa2, 0x51, 0x88, 0x6c, 0x8b, 0xcd,
	0xb6, 0x9d, 0x17, 0x04, 0xeb, 0xe3, 0xd6, 0xc0, 0x1c, 0x93, 0xbe, 0x0d, 0xc3, 0x5d, 0x5e, 0x74,
	0x1a, 0x66, 0xf6, 0x2e, 0x5c, 0xee, 0x76, 0x4c, 0x47, 0x14, 0xba, 0xe1, 0x55, 0x74, 0x62, 0x5e,
	0x05, 0x87, 0xfd, 0x47, 0x04, 0xc6, 0x9e, 0x6a, 0x92, 0x47, 0xde, 0x3b, 0x65, 0xe5, 0xba, 0x0d,
	0x89, 0x36, 0x95, 0x43, 0xcb, 0x33, 0x45, 0x9b, 0x28, 0xa6, 0x73, 0x56, 0x05, 0xcf, 0x39, 0x15,
	0x3c, 0xb7, 0x4c, 0x2a, 0xf8, 0x43, 0xd1, 0xd8, 0x12, 0xc0, 0x22, 0x27, 0xbf, 0x3b, 0x89, 0x33,
	0x74, 0xae, 0xc4, 0x19, 0x0e, 0x9a, 0x38, 0x23, 0x27, 0x24, 0x4e, 0x4f, 0x83, 0xfc, 0x7f, 0x12,
	0x67, 0xc1, 0x2b, 0x23, 0x5e, 0xec, 0x97, 0x0d, 0x1f, 0x9e, 0x2f, 0x1b, 0x9e, 0x27, 0x0f, 0x7a,
	0xdb, 0xc5, 0x27, 0x0f, 0x7e, 0x6d, 0x71, 0x51, 0x81, 0xcb, 0xdd, 0x40, 0x3b, 0x71, 0xf1, 0x2d,
	0x0f, 0x97, 0xee, 0x8a, 0x86, 0x65, 0x18, 0x5b, 0xc4, 0x4d, 0x7c, 0xde, 0x60, 0x20, 0x10, 0xba,
	0xe5, 0x04, 0x87, 0xf0, 0x5f, 0x06, 0x26, 0xbc, 0xe1, 0x3b, 0x58, 0x4e, 0x12, 0x81, 0x2e, 0x43,
	0x54, 0xa2, 0xa7, 0xa7, 0x06, 0x26, 0x43, 0x53, 0x71, 0xc1, 0xfe, 0x42, 0xcf, 0x20, 0xda, 0xd6,
	0x0c, 0xac, 0x9b, 0xa9, 0x10, 0xbd, 0xe8, 0x6a, 0xc0, 0x8b, 0xee, 0x01, 0x90, 0x7b, 0x4a, 0x85,
	0x58, 0xd7, 0x6d, 0x4b, 0x24, 0x97, 0xed, 0x5a, 0x3e, 0xd5, 0x7d, 0x2d, 0xc0, 0xa7, 0xde, 0xe7,
	0x05, 0x37, 0xda, 0x2a, 0xb0, 0xae, 0xde, 0x7b, 0x15, 0xeb, 0xb2, 0xd8, 0x7c, 0xac, 0xea, 0xe6,
	0x4a, 0xdb, 0xd4, 0xda, 0xe6, 0x19, 0x2f, 0x71, 0x01, 0xae, 0xf6, 0x15, 0x6a, 0xb7, 0xa8, 0x69,
	0x88, 0x35, 0x54, 0xc5, 0xc4, 0x8a, 0x69, 0xd8, 0xc8, 0x3a, 0xdf, 0xec, 0x22, 0x5c, 0x5a, 0x35,
	0x55, 0xed, 0x9c, 0xde, 0x34, 0x0b, 0xa3, 0x6e, 0x29, 0xc1, 0xcd, 0xb2, 0x44, 0x18, 0x45, 0xfd,
	0x9c, 0x43, 0x09, 0x3b, 0x07, 0x63, 0x5d, 0x62, 0x82, 0x03, 0xb8, 0x07, 0x97, 0x05, 0x6c, 0x7c,
	0x04, 0x08, 0xb7, 0x60, 0xbc, 0x47, 0x50, 0x70, 0x10, 0xbf, 0x63, 0xe0, 0x13, 0xab, 0x09, 0x72,
	0x78, 0x49, 0xbb, 0x73, 0xc6, 0x32, 0xf7, 0x02, 0x90, 0x68, 0x37, 0x54, 0xae, 0x06, 0x6f, 0xe0,
	0x6c, 0x0d, 0x5e, 0x52, 0xec, 0x59, 0x67, 0xd7, 0x20, 0x7d, 0x1c, 0x6a, 0x60, 0x55, 0xd1, 0x38,
	0x0c, 0x52, 0x50, 0xb2, 0x64, 0x87, 0x59, 0x94, 0x7c, 0xd6, 0x24, 0xf6, 0x4b, 0x06, 0x3e, 0x59,
	0xc4, 0x1f, 0xc9, 0x06, 0x57, 0x7b, 0x4e, 0x39, 0x6a, 0x2d, 0xee, 0x5f, 0x70, 0x4e, 0x24, 0xfd,
	0x80, 0x84, 0x69, 0x0b, 0xe5, 0xaa, 0xec, 0xa9, 0xf7, 0xfb, 0xfc, 0xa8, 0x55, 0x0b, 0xad, 0x4a,
	0x9e, 0xad, 0xbf, 0x78, 0xc3, 0xf1, 0x95, 0xb7, 0xf7, 0x2f, 0x08, 0x60, 0x91, 0x3f, 0x12, 0x5b,
	0xb8, 0x3a, 0x04, 0x61, 0x22, 0x06, 0x85, 0xff, 0xf2, 0x57, 0x9e, 0x21, 0x46, 0x39, 0x8e, 0xfd,
	0x23, 0x18, 0xe5, 0xd7, 0x0c, 0x4c, 0xb8, 0xc7, 0xce, 0x15, 0x67, 0xe0, 0x37, 0xce, 0x68, 0x98,
	0x8f, 0x3f, 0x3e, 0xb3, 0xbf, 0x64, 0xe0, 0x53, 0x3f, 0x8c, 0x76, 0x02, 0x5a, 0x00, 0xe8, 0x3c,
	0x55, 0xf8, 0x0c, 0xc9, 0x47, 0x4f, 0x19, 0x1d, 0x7e, 0xc1, 0xc5, 0x14, 0x78, 0x4a, 0xfe, 0x8a,
	0x81, 0xe1, 0xae, 0x6e, 0x02, 0xe5, 0x20, 0xda, 0xc2, 0x2d, 0x55, 0xb7, 0x72, 0x7d, 0xa8, 0x7a,
	0x99, 0x18, 0xe7, 0xc3, 0x3e, 0x3f, 0x32, 0x7f, 0xa7, 0x38, 0x5b, 0x9a, 0x9b, 0x9d, 0xad, 0x14,
	0xca, 0x95, 0x52, 0x49, 0xb0, 0xa9, 0xd0, 0x77, 0x20, 0xd2, 0x50, 0x75, 0x6c, 0xd8, 0xe6, 0x99,
	0xb1, 0xc9, 0xb3, 0x3c, 0x57, 0xe4, 0x4a, 0x5c, 0x99, 0x9b, 0xe3, 0xf8, 0x02, 0xc7, 0x17, 0x39,
	0xbe, 0xc4, 0xf1, 0x65, 0x8e, 0x9f, 0xe3, 0x8a, 0x05, 0xae, 0x58, 0xe4, 0x8a, 0x25, 0xae, 0x58,
	0xe6, 0x8a, 0x73, 0xdc, 0x74, 0x81, 0x9b, 0x2e, 0x0a, 0x96, 0x0c, 0x54, 0x80, 0x61, 0xf2, 0xa3,
	0xbe, 0xa1, 0x8b, 0x8d, 0xce, 0xe8, 0x1c, 0xaa, 0x26, 0x3e, 0xec, 0xf3, 0x83, 0x05, 0x6e, 0x86,
	0x23, 0xb6, 0x1c, 0x22, 0x14, 0xcb, 0x36, 0x01, 0xfb, 0xab, 0x08, 0x24, 0x7b, 0x83, 0x11, 0x55,
	0x21, 0xdc, 0x52, 0x25, 0x4c, 0x35, 0x18, 0x29, 0xe6, 0x02, 0x47, 0x71, 0xee, 0xa1, 0x2a, 0x61,
	0x81, 0xf2, 0xa2, 0x4a, 0xb7, 0xbb, 0x0f, 0xf4, 0x77, 0x77, 0xb7, 0xb3, 0x13, 0x07, 0x16, 0xdb,
	0xa6, 0x5a, 0xb7, 0x6b, 0x36, 0xd1, 0x21, 0x26, 0x00, 0x59, 0xb2, 0x7a, 0x08, 0xf4, 0x5d, 0x88,
	0x1f, 0xa5, 0x9a, 0x30, 0x4d, 0x35, 0xc5, 0xe0, 0x20, 0x9d, 0x1f, 0xf7, 0x2f, 0x08, 0x31, 0xc9,
	0x51, 0xd9, 0x15, 0xc2, 0x11, 0xbf, 0x10, 0x4e, 0xff, 0x66, 0x00, 0x62, 0x1d, 0x23, 0x39, 0x2d,
	0x3a, 0x73, 0xae, 0x16, 0x7d, 0xa0, 0x6f, 0x8b, 0x7e, 0x05, 0x06, 0xcd, 0x1d, 0x8d, 0x86, 0x5a,
	0xa8, 0x67, 0x66, 0x89, 0x92, 0x8d, 0x9a, 0x84, 0x78, 0x08, 0xd3, 0xe8, 0x0a, 0xd3, 0x9b, 0x9e,
	0xb0, 0xdd, 0x67, 0xac, 0xc4, 0x57, 0x4a, 0xd3, 0x85, 0x52, 0xb6, 0x34, 0x5d, 0x99, 0x2b, 0x94,
	0xca, 0x33, 0x3c, 0xcf, 0x17, 0x4a, 0x02, 0x25, 0x45, 0xd7, 0x20, 0x26, 0xb7, 0x88, 0x63, 0x7b,
	0x2a, 0x3b, 0x48, 0xf7, 0x6a, 0x12, 0x41, 0x6a, 0x28, 0xa2, 0x66, 0xbc, 0x54, 0xcd, 0xa3, 0x4e,
	0xdc, 0x4d, 0x09, 0xce, 0x76, 0x4d, 0xaa, 0xc6, 0x20, 0x6a, 0x45, 0x01, 0x7b, 0x1b, 0xc2, 0xc4,
	0x0d, 0xd0, 0x28, 0x24, 0x1f, 0xae, 0x2c, 0x2e, 0xd5, 0x9f, 0x3e, 0x5a, 0x7d, 0xbc, 0x74, 0xb7,
	0xb6, 0x5c, 0x5b, 0x5a, 0x4c, 0x5e, 0x40, 0xc3, 0x10, 0x17, 0x96, 0x16, 0x16, 0xeb, 0x2b, 0x8f,
	0x1e, 0xfc, 0x20, 0xc9, 0xa0, 0x11, 0x00, 0xfa, 0xf9, 0x3d, 0xa1, 0xf6, 0x64, 0x29, 0x39, 0xd0,
	0x93, 0xe7, 0x7e, 0x31, 0x00, 0xa3, 0x5e, 0x43, 0x34, 0xba, 0x01, 0x71, 0xa3, 0xbd, 0xae, 0x60,
	0xd3, 0xf7, 0x09, 0xca, 0xda, 0xae, 0x49, 0x68, 0x1d, 0xc6, 0x35, 0x5d, 0x6e, 0x89, 0xfa, 0x4e,
	0x7d, 0xbb, 0x54, 0x17, 0x25, 0x49, 0xc7, 0x86, 0xe1, 0x2e, 0x52, 0x37, 0x7d, 0x3d, 0xe7, 0xb1,
	0xc5, 0xb7, 0x60, 0xf1, 0xd0, 0x59, 0x61, 0xd4, 0x96, 0xb5, 0x56, 0x72, 0xad, 0x76, 0x9d, 0x51,
	0xee, 0x3e, 0x23, 0x74, 0x8e, 0x33, 0xca, 0xae, 0x55, 0xf6, 0xe7, 0x0c, 0xa0, 0xe3, 0xc4, 0x28,
	0x05, 0x83, 0xf6, 0x79, 0x76, 0xa2, 0x77, 0x3e, 0xd1, 0x1a, 0x5c, 0x52, 0x15, 0x92, 0xbc, 0xea,
	0xe4, 0x1f, 0x45, 0x34, 0xdd, 0x4a, 0x4f, 0xf9, 0x02, 0x5a, 0x51, 0xf0, 0x13, 0x75, 0x45, 0xc1,
	0x8f, 0x44, 0x93, 0xa2, 0xb9, 0xa8, 0x76, 0x2f, 0xb0, 0xcf, 0xe0, 0x62, 0x0f, 0x0d, 0xba, 0x07,
	0x20, 0x6b, 0xf5, 0x6d, 0xac, 0x1b, 0xc4, 0xa5, 0xad, 0xac, 0xc1, 0xfa, 0xbf, 0x4a, 0x6a, 0x6b,
	0x16, 0xa5, 0x5d, 0xf4, 0xe3, 0xb2, 0xb3, 0x90, 0xb9, 0x0a, 0x43, 0xee, 0x87, 0x5c, 0x14, 0x87,
	0x48, 0x75, 0x61, 0xb5, 0x76, 0x37, 0x79, 0x01, 0xc5, 0x20, 0xbc, 0xfc, 0xf4, 0xc1, 0x83, 0x24,
	0x53, 0xfc, 0x80, 0xe0, 0xa2, 0xab, 0x09, 0x25, 0x69, 0x03, 0xed, 0x32, 0x10, 0xba, 0x87, 0x4d,
	0xe4, 0x6f, 0xe8, 0xe3, 0x4f, 0xd1, 0xe9, 0x93, 0x1f, 0x4e, 0xd9, 0x9b, 0xbb, 0xff, 0xfc, 0xf7,
	0x17, 0x03, 0xd7, 0xd0, 0x55, 0xaf, 0xe7, 0x72, 0x23, 0xff, 0xc6, 0x55, 0x0c, 0xdf, 0xa2, 0x9f,
	0x31, 0x10, 0x26, 0xa5, 0x09, 0xf9, 0x3f, 0x09, 0x79, 0xbd, 0x47, 0xa7, 0x73, 0x41, 0xc9, 0xad,
	0xfa, 0xc6, 0x4e, 0x50, 0x50, 0xe3, 0x68, 0xcc, 0x13, 0x14, 0xfa, 0x2d, 0x03, 0x51, 0xeb, 0x1d,
	0x04, 0xe5, 0x4e, 0xf7, 0x82, 0x97, 0x3e, 0xb9, 0x4a, 0xb2, 0xcb, 0x7b, 0x87, 0x19, 0xd6, 0xf7,
	0xa1, 0x25, 0xe6, 0xac, 0x50, 0x88, 0x69, 0xd6, 0x1b, 0xe2, 0x2d, 0x26, 0x83, 0xfe, 0xc0, 0x40,
	0xd4, 0x9a, 0x72, 0xfa, 0xa0, 0xf4, 0x9c, 0xaf, 0x83, 0xa0, 0x7c, 0x62, 0xa1, 0xf4, 0x19, 0x7b,
	0xbb, 0x51, 0x4e, 0x15, 0x83, 0xdc, 0x2e, 0xc1, 0xfc, 0x67, 0x06, 0xa2, 0x76, 0x09, 0xf2, 0xc7,
	0xec, 0x39, 0x2f, 0x07, 0xc1, 0xfc, 0xc3, 0xbd, 0xc3, 0x4c, 0xde, 0x77, 0x4e, 0x1e, 0xeb, 0x7d,
	0x38, 0x5a, 0x6a, 0x69, 0xe6, 0x8e, 0xe5, 0x9e, 0x99, 0x40, 0xee, 0xf9, 0x2f, 0x06, 0x46, 0x2c,
	0x83, 0x74, 0x84, 0x96, 0xcf, 0x36, 0xf0, 0x06, 0xd1, 0x66, 0x6b, 0xef, 0x30, 0x93, 0x39, 0x71,
	0x90, 0xed, 0xbe, 0x89, 0x59, 0xb6, 0x18, 0x40, 0x91, 0x7c, 0xbb, 0x4b, 0x09, 0x72, 0x31, 0x7f,
	0x67, 0xe0, 0xd2, 0x3d, 0x6c, 0xf6, 0x8e, 0xa4, 0xe8, 0x76, 0x90, 0x74, 0xe0, 0x33, 0x1d, 0xa7,
	0xe7, 0xcf, 0xc6, 0x6c, 0x07, 0xe9, 0x3c, 0xd5, 0xa8, 0x8c, 0x4a, 0x41, 0x7c, 0xcb, 0xe8, 0x05,
	0xfe, 0x25, 0x03, 0x61, 0x32, 0xe2, 0x22, 0xce, 0xff, 0xd9, 0xf6, 0xf8, 0x1c, 0x1d, 0xe4, 0x5e,
	0xc4, 0xbd, 0xc3, 0x4c, 0xd6, 0x67, 0x7e, 0xee, 0xe3, 0x63, 0x19, 0x76, 0x2a, 0x90, 0x22, 0x04,
	0xf3, 0x57, 0x0c, 0x44, 0xe8, 0x7c, 0xdc, 0x27, 0x11, 0x7a, 0x8d, 0xe1, 0x41, 0xe0, 0x37, 0xf6,
	0x0e, 0x33, 0x39, 0xbf, 0xf1, 0xbb, 0x0f, 0xfe, 0x9b, 0xec, 0x8d, 0x60, 0xf8, 0x09, 0xec, 0xbf,
	0x31, 0x30, 0x68, 0x4f, 0xd7, 0x28, 0xdf, 0xef, 0x15, 0xf1, 0x8c, 0x4a, 0x6c, 0xee, 0x1d, 0x66,
	0x0a, 0xfe, 0x03, 0x7c, 0x1f, 0x35, 0xb2, 0xec, 0xcd, 0x20, 0x6a, 0xe8, 0x36, 0xf8, 0x03, 0x06,
	0xc0, 0xea, 0x7f, 0x49, 0xdb, 0x8a, 0x4e, 0x6a, 0x92, 0x3d, 0x46, 0xe1, 0xa0, 0x77, 0x72, 0xbd,
	0xef, 0x9c, 0xde, 0x1d, 0xe6, 0xd3, 0x6c, 0x2e, 0x88, 0x12, 0x62, 0x07, 0x38, 0x09, 0x71, 0xa2,
	0x8a, 0x35, 0xf4, 0x9e, 0xa0, 0x8a, 0xef, 0x54, 0x7f, 0x0a, 0x55, 0xfa, 0x4c, 0xd7, 0x67, 0x52,
	0x45, 0xc2, 0x6e, 0x55, 0xfe, 0xc4, 0xc0, 0x08, 0xa9, 0xec, 0x47, 0xa3, 0x6b, 0x9f, 0x44, 0xdc,
	0x77, 0x1e, 0x4f, 0xcf, 0x9e, 0x9a, 0xcf, 0x4e, 0x4f, 0x65, 0x0a, 0xbf, 0x80, 0x82, 0xc0, 0x3f,
	0xfa, 0x8f, 0x7f, 0xa3, 0xba, 0xf4, 0xec, 0xee, 0xa6, 0x6c, 0xbe, 0x6c, 0xaf, 0x93, 0xb3, 0xf2,
	0xd6, 0xe1, 0x59, 0xeb, 0x0f, 0x00, 0x36, 0xd5, 0xec, 0x26, 0x56, 0xa8, 0xd3, 0xe6, 0x7d, 0xfe,
	0xd2, 0xe0, 0xb6, 0xfd, 0x73, 0x3d, 0x4a, 0xc9, 0xa6, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0xa6,
	0x53, 0x64, 0x28, 0x38, 0x21, 0x00, 0x00,
}
