// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/zone_service.proto

package compute // import "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ListZonesRequest struct {
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListZonesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListZonesResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListZonesRequest) Reset()         { *m = ListZonesRequest{} }
func (m *ListZonesRequest) String() string { return proto.CompactTextString(m) }
func (*ListZonesRequest) ProtoMessage()    {}
func (*ListZonesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_service_e9c86d533e92d608, []int{0}
}
func (m *ListZonesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListZonesRequest.Unmarshal(m, b)
}
func (m *ListZonesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListZonesRequest.Marshal(b, m, deterministic)
}
func (dst *ListZonesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListZonesRequest.Merge(dst, src)
}
func (m *ListZonesRequest) XXX_Size() int {
	return xxx_messageInfo_ListZonesRequest.Size(m)
}
func (m *ListZonesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListZonesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListZonesRequest proto.InternalMessageInfo

func (m *ListZonesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListZonesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListZonesResponse struct {
	// List of availability zones.
	Zones []*Zone `protobuf:"bytes,1,rep,name=zones,proto3" json:"zones,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListZonesRequest.page_size], use
	// the [ListZonesRequest.page_token] as the value
	// for the [ListZonesRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [ListZonesRequest.page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListZonesResponse) Reset()         { *m = ListZonesResponse{} }
func (m *ListZonesResponse) String() string { return proto.CompactTextString(m) }
func (*ListZonesResponse) ProtoMessage()    {}
func (*ListZonesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_service_e9c86d533e92d608, []int{1}
}
func (m *ListZonesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListZonesResponse.Unmarshal(m, b)
}
func (m *ListZonesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListZonesResponse.Marshal(b, m, deterministic)
}
func (dst *ListZonesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListZonesResponse.Merge(dst, src)
}
func (m *ListZonesResponse) XXX_Size() int {
	return xxx_messageInfo_ListZonesResponse.Size(m)
}
func (m *ListZonesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListZonesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListZonesResponse proto.InternalMessageInfo

func (m *ListZonesResponse) GetZones() []*Zone {
	if m != nil {
		return m.Zones
	}
	return nil
}

func (m *ListZonesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type GetZoneRequest struct {
	// ID of the availability zone to return information about.
	ZoneId               string   `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetZoneRequest) Reset()         { *m = GetZoneRequest{} }
func (m *GetZoneRequest) String() string { return proto.CompactTextString(m) }
func (*GetZoneRequest) ProtoMessage()    {}
func (*GetZoneRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_service_e9c86d533e92d608, []int{2}
}
func (m *GetZoneRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetZoneRequest.Unmarshal(m, b)
}
func (m *GetZoneRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetZoneRequest.Marshal(b, m, deterministic)
}
func (dst *GetZoneRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetZoneRequest.Merge(dst, src)
}
func (m *GetZoneRequest) XXX_Size() int {
	return xxx_messageInfo_GetZoneRequest.Size(m)
}
func (m *GetZoneRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetZoneRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetZoneRequest proto.InternalMessageInfo

func (m *GetZoneRequest) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func init() {
	proto.RegisterType((*ListZonesRequest)(nil), "yandex.cloud.compute.v1.ListZonesRequest")
	proto.RegisterType((*ListZonesResponse)(nil), "yandex.cloud.compute.v1.ListZonesResponse")
	proto.RegisterType((*GetZoneRequest)(nil), "yandex.cloud.compute.v1.GetZoneRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ZoneServiceClient is the client API for ZoneService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ZoneServiceClient interface {
	// Returns the information about the specified availability zone.
	//
	// To get the list of availability zones, make a [List] request.
	Get(ctx context.Context, in *GetZoneRequest, opts ...grpc.CallOption) (*Zone, error)
	// Retrieves the list of availability zones.
	List(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error)
}

type zoneServiceClient struct {
	cc *grpc.ClientConn
}

func NewZoneServiceClient(cc *grpc.ClientConn) ZoneServiceClient {
	return &zoneServiceClient{cc}
}

func (c *zoneServiceClient) Get(ctx context.Context, in *GetZoneRequest, opts ...grpc.CallOption) (*Zone, error) {
	out := new(Zone)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ZoneService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *zoneServiceClient) List(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error) {
	out := new(ListZonesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.ZoneService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ZoneServiceServer is the server API for ZoneService service.
type ZoneServiceServer interface {
	// Returns the information about the specified availability zone.
	//
	// To get the list of availability zones, make a [List] request.
	Get(context.Context, *GetZoneRequest) (*Zone, error)
	// Retrieves the list of availability zones.
	List(context.Context, *ListZonesRequest) (*ListZonesResponse, error)
}

func RegisterZoneServiceServer(s *grpc.Server, srv ZoneServiceServer) {
	s.RegisterService(&_ZoneService_serviceDesc, srv)
}

func _ZoneService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetZoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ZoneServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ZoneService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ZoneServiceServer).Get(ctx, req.(*GetZoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ZoneService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListZonesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ZoneServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.ZoneService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ZoneServiceServer).List(ctx, req.(*ListZonesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ZoneService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.ZoneService",
	HandlerType: (*ZoneServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ZoneService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ZoneService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/zone_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/zone_service.proto", fileDescriptor_zone_service_e9c86d533e92d608)
}

var fileDescriptor_zone_service_e9c86d533e92d608 = []byte{
	// 421 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0x4f, 0x8b, 0xd3, 0x40,
	0x18, 0xc6, 0xc9, 0x76, 0xb7, 0x9a, 0x59, 0xff, 0xed, 0x78, 0xb0, 0x46, 0x0b, 0x25, 0xa2, 0x1b,
	0x17, 0x36, 0x93, 0x6c, 0x11, 0x0f, 0xb6, 0x97, 0x88, 0x14, 0xc1, 0x83, 0xa4, 0x9e, 0x7a, 0x29,
	0x69, 0xf3, 0x12, 0x07, 0xeb, 0x4c, 0xec, 0x4c, 0x42, 0xad, 0x78, 0xf1, 0xd8, 0xab, 0x1f, 0xaa,
	0xbd, 0xfb, 0x15, 0x3c, 0xf8, 0x19, 0xf4, 0x22, 0x33, 0x13, 0xc5, 0x56, 0x52, 0xf6, 0x16, 0xf2,
	0xfe, 0xe6, 0x79, 0x9e, 0xf7, 0x0f, 0x3a, 0xfb, 0x98, 0xb0, 0x14, 0x16, 0x64, 0x3a, 0xe3, 0x45,
	0x4a, 0xa6, 0xfc, 0x7d, 0x5e, 0x48, 0x20, 0x65, 0x48, 0x96, 0x9c, 0xc1, 0x58, 0xc0, 0xbc, 0xa4,
	0x53, 0xf0, 0xf3, 0x39, 0x97, 0x1c, 0xdf, 0x31, 0xac, 0xaf, 0x59, 0xbf, 0x62, 0xfd, 0x32, 0x74,
	0xee, 0x67, 0x9c, 0x67, 0x33, 0x20, 0x49, 0x4e, 0x49, 0xc2, 0x18, 0x97, 0x89, 0xa4, 0x9c, 0x09,
	0xf3, 0xcc, 0x71, 0xf7, 0x59, 0x54, 0x4c, 0x7b, 0x8b, 0x29, 0x93, 0x19, 0x4d, 0xb5, 0x86, 0x29,
	0xbb, 0x80, 0x6e, 0xbd, 0xa2, 0x42, 0x8e, 0x38, 0x03, 0x11, 0xc3, 0x87, 0x02, 0x84, 0xc4, 0xa7,
	0xc8, 0xce, 0x93, 0x0c, 0xc6, 0x82, 0x2e, 0xa1, 0x65, 0x75, 0x2c, 0xaf, 0x11, 0xa1, 0x9f, 0xeb,
	0xb0, 0xd9, 0xeb, 0x87, 0x41, 0x10, 0xc4, 0x57, 0x55, 0x71, 0x48, 0x97, 0x80, 0x3d, 0x84, 0x34,
	0x28, 0xf9, 0x3b, 0x60, 0xad, 0x83, 0x8e, 0xe5, 0xd9, 0x91, 0xbd, 0xda, 0x84, 0x47, 0x9a, 0x8c,
	0xb5, 0xca, 0x1b, 0x55, 0x73, 0x73, 0x74, 0xf2, 0x8f, 0x8d, 0xc8, 0x39, 0x13, 0x80, 0xbb, 0xe8,
	0x48, 0x05, 0x15, 0x2d, 0xab, 0xd3, 0xf0, 0x8e, 0x2f, 0xda, 0x7e, 0xcd, 0x14, 0x7c, 0xf5, 0x2c,
	0x36, 0x2c, 0x7e, 0x84, 0x6e, 0x32, 0x58, 0xc8, 0xf1, 0xae, 0x71, 0x7c, 0x5d, 0xfd, 0x7e, 0xfd,
	0xd7, 0xf1, 0x29, 0xba, 0x31, 0x00, 0x6d, 0xf8, 0xa7, 0xad, 0x87, 0xe8, 0x8a, 0x1e, 0x3d, 0x4d,
	0x75, 0x53, 0x76, 0x74, 0xed, 0xc7, 0x3a, 0xb4, 0x56, 0x9b, 0xf0, 0xb0, 0xd7, 0x7f, 0x12, 0xc4,
	0x4d, 0x55, 0x7c, 0x99, 0x5e, 0xfc, 0xb2, 0xd0, 0xb1, 0x7a, 0x36, 0x34, 0x1b, 0xc2, 0x73, 0xd4,
	0x18, 0x80, 0xc4, 0xa7, 0xb5, 0xe9, 0xb6, 0x6d, 0x9c, 0xfd, 0x6d, 0xb8, 0x0f, 0xbe, 0x7c, 0xfb,
	0xfe, 0xf5, 0xa0, 0x8d, 0xef, 0xed, 0xee, 0x4b, 0x90, 0x4f, 0x55, 0xbc, 0xcf, 0x78, 0x81, 0x0e,
	0xd5, 0xb8, 0xf0, 0xe3, 0x5a, 0xad, 0xdd, 0xa5, 0x39, 0x67, 0x97, 0x41, 0xcd, 0xe0, 0xdd, 0xbb,
	0x3a, 0xc3, 0x6d, 0x7c, 0xf2, 0x5f, 0x86, 0xe8, 0xc5, 0xe8, 0x79, 0x46, 0xe5, 0xdb, 0x62, 0xa2,
	0x14, 0x88, 0x91, 0x3c, 0x37, 0xb7, 0x93, 0xf1, 0xf3, 0x0c, 0x98, 0x3e, 0x1b, 0x52, 0x73, 0x78,
	0xcf, 0xaa, 0xcf, 0x49, 0x53, 0x63, 0xdd, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x18, 0x19, 0x69,
	0xb4, 0x05, 0x03, 0x00, 0x00,
}
