// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/loadbalancer/v1/network_load_balancer.proto

package loadbalancer // import "github.com/yandex-cloud/go-genproto/yandex/cloud/loadbalancer/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// IP version of the addresses that the load balancer works with.
// Only IPv4 is currently available.
type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4
	IpVersion_IPV4 IpVersion = 1
	// IPv6
	IpVersion_IPV6 IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "IP_VERSION_UNSPECIFIED",
	1: "IPV4",
	2: "IPV6",
}
var IpVersion_value = map[string]int32{
	"IP_VERSION_UNSPECIFIED": 0,
	"IPV4": 1,
	"IPV6": 2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}
func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{0}
}

type NetworkLoadBalancer_Status int32

const (
	NetworkLoadBalancer_STATUS_UNSPECIFIED NetworkLoadBalancer_Status = 0
	// Network load balancer is being created.
	NetworkLoadBalancer_CREATING NetworkLoadBalancer_Status = 1
	// Network load balancer is being started.
	NetworkLoadBalancer_STARTING NetworkLoadBalancer_Status = 2
	// Network load balancer is active and sends traffic to the targets.
	NetworkLoadBalancer_ACTIVE NetworkLoadBalancer_Status = 3
	// Network load balancer is being stopped.
	NetworkLoadBalancer_STOPPING NetworkLoadBalancer_Status = 4
	// Network load balancer is stopped and doesn't send traffic to the targets.
	NetworkLoadBalancer_STOPPED NetworkLoadBalancer_Status = 5
	// Network load balancer is being deleted.
	NetworkLoadBalancer_DELETING NetworkLoadBalancer_Status = 6
	// The load balancer doesn't have any listeners or target groups, or
	// attached target groups are empty. The load balancer doesn't perform any health checks or
	// send traffic in this state.
	NetworkLoadBalancer_INACTIVE NetworkLoadBalancer_Status = 7
)

var NetworkLoadBalancer_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "CREATING",
	2: "STARTING",
	3: "ACTIVE",
	4: "STOPPING",
	5: "STOPPED",
	6: "DELETING",
	7: "INACTIVE",
}
var NetworkLoadBalancer_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"CREATING":           1,
	"STARTING":           2,
	"ACTIVE":             3,
	"STOPPING":           4,
	"STOPPED":            5,
	"DELETING":           6,
	"INACTIVE":           7,
}

func (x NetworkLoadBalancer_Status) String() string {
	return proto.EnumName(NetworkLoadBalancer_Status_name, int32(x))
}
func (NetworkLoadBalancer_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{0, 0}
}

// Type of the load balancer. Only external load balancers are currently available.
type NetworkLoadBalancer_Type int32

const (
	NetworkLoadBalancer_TYPE_UNSPECIFIED NetworkLoadBalancer_Type = 0
	// External network load balancer.
	NetworkLoadBalancer_EXTERNAL NetworkLoadBalancer_Type = 1
)

var NetworkLoadBalancer_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "EXTERNAL",
}
var NetworkLoadBalancer_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"EXTERNAL":         1,
}

func (x NetworkLoadBalancer_Type) String() string {
	return proto.EnumName(NetworkLoadBalancer_Type_name, int32(x))
}
func (NetworkLoadBalancer_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{0, 1}
}

// Type of session affinity. Only 5-tuple affinity is currently available.
// For more information, see [Load Balancer concepts](/load-balancer/concepts/).
type NetworkLoadBalancer_SessionAffinity int32

const (
	NetworkLoadBalancer_SESSION_AFFINITY_UNSPECIFIED NetworkLoadBalancer_SessionAffinity = 0
	// 5-tuple affinity.
	NetworkLoadBalancer_CLIENT_IP_PORT_PROTO NetworkLoadBalancer_SessionAffinity = 1
)

var NetworkLoadBalancer_SessionAffinity_name = map[int32]string{
	0: "SESSION_AFFINITY_UNSPECIFIED",
	1: "CLIENT_IP_PORT_PROTO",
}
var NetworkLoadBalancer_SessionAffinity_value = map[string]int32{
	"SESSION_AFFINITY_UNSPECIFIED": 0,
	"CLIENT_IP_PORT_PROTO":         1,
}

func (x NetworkLoadBalancer_SessionAffinity) String() string {
	return proto.EnumName(NetworkLoadBalancer_SessionAffinity_name, int32(x))
}
func (NetworkLoadBalancer_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{0, 2}
}

// Network protocol to use.
type Listener_Protocol int32

const (
	Listener_PROTOCOL_UNSPECIFIED Listener_Protocol = 0
	Listener_TCP                  Listener_Protocol = 1
)

var Listener_Protocol_name = map[int32]string{
	0: "PROTOCOL_UNSPECIFIED",
	1: "TCP",
}
var Listener_Protocol_value = map[string]int32{
	"PROTOCOL_UNSPECIFIED": 0,
	"TCP": 1,
}

func (x Listener_Protocol) String() string {
	return proto.EnumName(Listener_Protocol_name, int32(x))
}
func (Listener_Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{2, 0}
}

// Status of the target.
type TargetState_Status int32

const (
	TargetState_STATUS_UNSPECIFIED TargetState_Status = 0
	// The network load balancer is setting up health checks for this target.
	TargetState_INITIAL TargetState_Status = 1
	// Health check passed and the target is ready to receive traffic.
	TargetState_HEALTHY TargetState_Status = 2
	// Health check failed and the target is not receiving traffic.
	TargetState_UNHEALTHY TargetState_Status = 3
	// Target is being deleted and the network load balancer is no longer sending traffic to this target.
	TargetState_DRAINING TargetState_Status = 4
	// The network load balancer is stopped and not performing health checks on this target.
	TargetState_INACTIVE TargetState_Status = 5
)

var TargetState_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "INITIAL",
	2: "HEALTHY",
	3: "UNHEALTHY",
	4: "DRAINING",
	5: "INACTIVE",
}
var TargetState_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"INITIAL":            1,
	"HEALTHY":            2,
	"UNHEALTHY":          3,
	"DRAINING":           4,
	"INACTIVE":           5,
}

func (x TargetState_Status) String() string {
	return proto.EnumName(TargetState_Status_name, int32(x))
}
func (TargetState_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{3, 0}
}

// A NetworkLoadBalancer resource. For more information, see [Network Load Balancer](/docs/load-balancer/concepts).
type NetworkLoadBalancer struct {
	// ID of the network load balancer.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the network load balancer belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the network load balancer. The name is unique within the folder. 3-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Optional description of the network load balancer. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs. Мaximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the region that the network load balancer belongs to.
	RegionId string `protobuf:"bytes,7,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Status of the network load balancer.
	Status NetworkLoadBalancer_Status `protobuf:"varint,9,opt,name=status,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Status" json:"status,omitempty"`
	// Type of the network load balancer. Only external network load balancers are available now.
	Type NetworkLoadBalancer_Type `protobuf:"varint,10,opt,name=type,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Type" json:"type,omitempty"`
	// Type of the session affinity. Only 5-tuple affinity is available now.
	SessionAffinity NetworkLoadBalancer_SessionAffinity `protobuf:"varint,11,opt,name=session_affinity,json=sessionAffinity,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_SessionAffinity" json:"session_affinity,omitempty"`
	// List of listeners for the network load balancer.
	Listeners []*Listener `protobuf:"bytes,12,rep,name=listeners,proto3" json:"listeners,omitempty"`
	// List of target groups attached to the network load balancer.
	AttachedTargetGroups []*AttachedTargetGroup `protobuf:"bytes,13,rep,name=attached_target_groups,json=attachedTargetGroups,proto3" json:"attached_target_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *NetworkLoadBalancer) Reset()         { *m = NetworkLoadBalancer{} }
func (m *NetworkLoadBalancer) String() string { return proto.CompactTextString(m) }
func (*NetworkLoadBalancer) ProtoMessage()    {}
func (*NetworkLoadBalancer) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{0}
}
func (m *NetworkLoadBalancer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkLoadBalancer.Unmarshal(m, b)
}
func (m *NetworkLoadBalancer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkLoadBalancer.Marshal(b, m, deterministic)
}
func (dst *NetworkLoadBalancer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkLoadBalancer.Merge(dst, src)
}
func (m *NetworkLoadBalancer) XXX_Size() int {
	return xxx_messageInfo_NetworkLoadBalancer.Size(m)
}
func (m *NetworkLoadBalancer) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkLoadBalancer.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkLoadBalancer proto.InternalMessageInfo

func (m *NetworkLoadBalancer) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NetworkLoadBalancer) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *NetworkLoadBalancer) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *NetworkLoadBalancer) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkLoadBalancer) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NetworkLoadBalancer) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NetworkLoadBalancer) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *NetworkLoadBalancer) GetStatus() NetworkLoadBalancer_Status {
	if m != nil {
		return m.Status
	}
	return NetworkLoadBalancer_STATUS_UNSPECIFIED
}

func (m *NetworkLoadBalancer) GetType() NetworkLoadBalancer_Type {
	if m != nil {
		return m.Type
	}
	return NetworkLoadBalancer_TYPE_UNSPECIFIED
}

func (m *NetworkLoadBalancer) GetSessionAffinity() NetworkLoadBalancer_SessionAffinity {
	if m != nil {
		return m.SessionAffinity
	}
	return NetworkLoadBalancer_SESSION_AFFINITY_UNSPECIFIED
}

func (m *NetworkLoadBalancer) GetListeners() []*Listener {
	if m != nil {
		return m.Listeners
	}
	return nil
}

func (m *NetworkLoadBalancer) GetAttachedTargetGroups() []*AttachedTargetGroup {
	if m != nil {
		return m.AttachedTargetGroups
	}
	return nil
}

// An AttachedTargetGroup resource. For more information, see [Attached Target Groups](/load-balancer/concepts)
type AttachedTargetGroup struct {
	// ID of the target group.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// A health check to perform on the target group.
	// For now we accept only one health check per AttachedTargetGroup.
	HealthChecks         []*HealthCheck `protobuf:"bytes,2,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *AttachedTargetGroup) Reset()         { *m = AttachedTargetGroup{} }
func (m *AttachedTargetGroup) String() string { return proto.CompactTextString(m) }
func (*AttachedTargetGroup) ProtoMessage()    {}
func (*AttachedTargetGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{1}
}
func (m *AttachedTargetGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedTargetGroup.Unmarshal(m, b)
}
func (m *AttachedTargetGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedTargetGroup.Marshal(b, m, deterministic)
}
func (dst *AttachedTargetGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedTargetGroup.Merge(dst, src)
}
func (m *AttachedTargetGroup) XXX_Size() int {
	return xxx_messageInfo_AttachedTargetGroup.Size(m)
}
func (m *AttachedTargetGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedTargetGroup.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedTargetGroup proto.InternalMessageInfo

func (m *AttachedTargetGroup) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *AttachedTargetGroup) GetHealthChecks() []*HealthCheck {
	if m != nil {
		return m.HealthChecks
	}
	return nil
}

// A Listener resource. For more information, see [Listener](/docs/load-balancer/concepts/listener)
type Listener struct {
	// Name of the listener. The name must be unique for each listener on a single load balancer. 3-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// IP address for the listener.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Port.
	Port int64 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// Network protocol for incoming traffic.
	Protocol             Listener_Protocol `protobuf:"varint,4,opt,name=protocol,proto3,enum=yandex.cloud.loadbalancer.v1.Listener_Protocol" json:"protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Listener) Reset()         { *m = Listener{} }
func (m *Listener) String() string { return proto.CompactTextString(m) }
func (*Listener) ProtoMessage()    {}
func (*Listener) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{2}
}
func (m *Listener) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Listener.Unmarshal(m, b)
}
func (m *Listener) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Listener.Marshal(b, m, deterministic)
}
func (dst *Listener) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Listener.Merge(dst, src)
}
func (m *Listener) XXX_Size() int {
	return xxx_messageInfo_Listener.Size(m)
}
func (m *Listener) XXX_DiscardUnknown() {
	xxx_messageInfo_Listener.DiscardUnknown(m)
}

var xxx_messageInfo_Listener proto.InternalMessageInfo

func (m *Listener) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Listener) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Listener) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Listener) GetProtocol() Listener_Protocol {
	if m != nil {
		return m.Protocol
	}
	return Listener_PROTOCOL_UNSPECIFIED
}

// State of the target that was returned after the last health check.
type TargetState struct {
	// ID of the subnet that the target is connected to.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// IP address of the target.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Status of the target.
	Status               TargetState_Status `protobuf:"varint,3,opt,name=status,proto3,enum=yandex.cloud.loadbalancer.v1.TargetState_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TargetState) Reset()         { *m = TargetState{} }
func (m *TargetState) String() string { return proto.CompactTextString(m) }
func (*TargetState) ProtoMessage()    {}
func (*TargetState) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_load_balancer_8287c63ad9723666, []int{3}
}
func (m *TargetState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetState.Unmarshal(m, b)
}
func (m *TargetState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetState.Marshal(b, m, deterministic)
}
func (dst *TargetState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetState.Merge(dst, src)
}
func (m *TargetState) XXX_Size() int {
	return xxx_messageInfo_TargetState.Size(m)
}
func (m *TargetState) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetState.DiscardUnknown(m)
}

var xxx_messageInfo_TargetState proto.InternalMessageInfo

func (m *TargetState) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *TargetState) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *TargetState) GetStatus() TargetState_Status {
	if m != nil {
		return m.Status
	}
	return TargetState_STATUS_UNSPECIFIED
}

func init() {
	proto.RegisterType((*NetworkLoadBalancer)(nil), "yandex.cloud.loadbalancer.v1.NetworkLoadBalancer")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.LabelsEntry")
	proto.RegisterType((*AttachedTargetGroup)(nil), "yandex.cloud.loadbalancer.v1.AttachedTargetGroup")
	proto.RegisterType((*Listener)(nil), "yandex.cloud.loadbalancer.v1.Listener")
	proto.RegisterType((*TargetState)(nil), "yandex.cloud.loadbalancer.v1.TargetState")
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Status", NetworkLoadBalancer_Status_name, NetworkLoadBalancer_Status_value)
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Type", NetworkLoadBalancer_Type_name, NetworkLoadBalancer_Type_value)
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_SessionAffinity", NetworkLoadBalancer_SessionAffinity_name, NetworkLoadBalancer_SessionAffinity_value)
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.Listener_Protocol", Listener_Protocol_name, Listener_Protocol_value)
	proto.RegisterEnum("yandex.cloud.loadbalancer.v1.TargetState_Status", TargetState_Status_name, TargetState_Status_value)
}

func init() {
	proto.RegisterFile("yandex/cloud/loadbalancer/v1/network_load_balancer.proto", fileDescriptor_network_load_balancer_8287c63ad9723666)
}

var fileDescriptor_network_load_balancer_8287c63ad9723666 = []byte{
	// 977 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x5f, 0x6f, 0xe3, 0x44,
	0x10, 0xc7, 0x49, 0x9a, 0x3f, 0x93, 0xf6, 0x6a, 0xed, 0x55, 0x95, 0x55, 0xee, 0x44, 0xc8, 0x03,
	0x2a, 0x27, 0xe2, 0xd4, 0xe5, 0xae, 0x6a, 0x39, 0xee, 0xc1, 0x4d, 0xdc, 0xab, 0x21, 0xe7, 0x58,
	0x1b, 0xa7, 0xa2, 0x54, 0x27, 0x6b, 0x13, 0x6f, 0x13, 0xab, 0xae, 0x1d, 0xd9, 0x9b, 0x42, 0x0e,
	0x10, 0x12, 0x8f, 0x7c, 0x03, 0x5e, 0xf9, 0x32, 0x77, 0x1f, 0x05, 0x89, 0x37, 0x24, 0xde, 0xd1,
	0xae, 0x9d, 0x36, 0xed, 0x9d, 0x02, 0xc7, 0xdb, 0xce, 0xcc, 0xfe, 0x7e, 0xb3, 0xb3, 0xbf, 0xd9,
	0x59, 0xd8, 0x9f, 0x91, 0xd0, 0xa3, 0xdf, 0x37, 0x87, 0x41, 0x34, 0xf5, 0x9a, 0x41, 0x44, 0xbc,
	0x01, 0x09, 0x48, 0x38, 0xa4, 0x71, 0xf3, 0x4a, 0x6b, 0x86, 0x94, 0x7d, 0x17, 0xc5, 0x17, 0x2e,
	0xf7, 0xbb, 0xf3, 0x80, 0x3a, 0x89, 0x23, 0x16, 0xa1, 0x07, 0x29, 0x52, 0x15, 0x48, 0x75, 0x11,
	0xa9, 0x5e, 0x69, 0x5b, 0x1f, 0x8d, 0xa2, 0x68, 0x14, 0xd0, 0xa6, 0xd8, 0x3b, 0x98, 0x9e, 0x37,
	0x99, 0x7f, 0x49, 0x13, 0x46, 0x2e, 0x27, 0x29, 0x7c, 0xeb, 0xe1, 0xad, 0xc4, 0x57, 0x24, 0xf0,
	0x3d, 0xc2, 0xfc, 0x28, 0xcc, 0xc2, 0xcd, 0xa5, 0xe7, 0x1a, 0x53, 0x12, 0xb0, 0xb1, 0x3b, 0x1c,
	0xd3, 0xe1, 0x45, 0x0a, 0xa8, 0xff, 0x56, 0x86, 0xfb, 0x56, 0x7a, 0xdc, 0x4e, 0x44, 0xbc, 0xc3,
	0x6c, 0x37, 0xba, 0x07, 0x39, 0xdf, 0x53, 0xa4, 0x9a, 0xb4, 0x5d, 0xc1, 0x39, 0xdf, 0x43, 0x1f,
	0x42, 0xe5, 0x3c, 0x0a, 0x3c, 0x1a, 0xbb, 0xbe, 0xa7, 0xe4, 0x84, 0xbb, 0x9c, 0x3a, 0x4c, 0x0f,
	0x1d, 0x00, 0x0c, 0x63, 0x4a, 0x18, 0xf5, 0x5c, 0xc2, 0x94, 0x7c, 0x4d, 0xda, 0xae, 0xee, 0x6e,
	0xa9, 0x69, 0x29, 0xea, 0xbc, 0x14, 0xd5, 0x99, 0x97, 0x82, 0x2b, 0xd9, 0x6e, 0x9d, 0x21, 0x04,
	0x85, 0x90, 0x5c, 0x52, 0xa5, 0x20, 0x28, 0xc5, 0x1a, 0xd5, 0xa0, 0xea, 0xd1, 0x64, 0x18, 0xfb,
	0x13, 0x5e, 0x99, 0xb2, 0x22, 0x42, 0x8b, 0x2e, 0xd4, 0x87, 0x62, 0x40, 0x06, 0x34, 0x48, 0x94,
	0x62, 0x2d, 0xbf, 0x5d, 0xdd, 0x7d, 0xa6, 0x2e, 0xbb, 0x55, 0xf5, 0x1d, 0x05, 0xaa, 0x1d, 0x81,
	0x37, 0x42, 0x16, 0xcf, 0x70, 0x46, 0xc6, 0x8b, 0x8c, 0xe9, 0xc8, 0x8f, 0x42, 0x5e, 0x64, 0x29,
	0x2d, 0x32, 0x75, 0x98, 0x1e, 0xb2, 0xa1, 0x98, 0x30, 0xc2, 0xa6, 0x89, 0x52, 0xa9, 0x49, 0xdb,
	0xf7, 0x76, 0xf7, 0xdf, 0x3f, 0x67, 0x4f, 0xe0, 0x71, 0xc6, 0x83, 0xbe, 0x82, 0x02, 0x9b, 0x4d,
	0xa8, 0x02, 0x82, 0x6f, 0xef, 0xfd, 0xf9, 0x9c, 0xd9, 0x84, 0x62, 0xc1, 0x81, 0x02, 0x90, 0x13,
	0x9a, 0x24, 0xfc, 0xec, 0xe4, 0xfc, 0xdc, 0x0f, 0x7d, 0x36, 0x53, 0xaa, 0x82, 0x57, 0xff, 0x1f,
	0xe7, 0x4c, 0x99, 0xf4, 0x8c, 0x08, 0xaf, 0x27, 0xb7, 0x1d, 0xa8, 0x0d, 0x95, 0xc0, 0x4f, 0x18,
	0x0d, 0x69, 0x9c, 0x28, 0xab, 0x42, 0x82, 0x4f, 0x96, 0xa7, 0xe9, 0x64, 0xdb, 0xf1, 0x0d, 0x10,
	0x8d, 0x60, 0x93, 0x30, 0x46, 0x86, 0x63, 0xea, 0xb9, 0x8c, 0xc4, 0x23, 0xca, 0xdc, 0x51, 0x1c,
	0x4d, 0x27, 0x89, 0xb2, 0x26, 0x28, 0xb5, 0xe5, 0x94, 0x7a, 0x86, 0x75, 0x04, 0xf4, 0x39, 0x47,
	0xe2, 0x0d, 0xf2, 0xb6, 0x33, 0xd9, 0x3a, 0x80, 0xea, 0x82, 0xdc, 0x48, 0x86, 0xfc, 0x05, 0x9d,
	0x65, 0xcd, 0xcd, 0x97, 0x68, 0x03, 0x56, 0xae, 0x48, 0x30, 0xa5, 0x59, 0x67, 0xa7, 0xc6, 0x17,
	0xb9, 0x7d, 0xa9, 0xfe, 0x33, 0x14, 0x53, 0xd5, 0xd0, 0x26, 0xa0, 0x9e, 0xa3, 0x3b, 0xfd, 0x9e,
	0xdb, 0xb7, 0x7a, 0xb6, 0xd1, 0x32, 0x8f, 0x4c, 0xa3, 0x2d, 0x7f, 0x80, 0x56, 0xa1, 0xdc, 0xc2,
	0x86, 0xee, 0x98, 0xd6, 0x73, 0x59, 0xe2, 0x56, 0xcf, 0xd1, 0xb1, 0xb0, 0x72, 0x08, 0xa0, 0xa8,
	0xb7, 0x1c, 0xf3, 0xc4, 0x90, 0xf3, 0x69, 0xa4, 0x6b, 0xdb, 0x3c, 0x52, 0x40, 0x55, 0x28, 0x09,
	0xcb, 0x68, 0xcb, 0x2b, 0x3c, 0xd4, 0x36, 0x3a, 0x86, 0x00, 0x15, 0xb9, 0x65, 0x5a, 0x19, 0xac,
	0x54, 0x7f, 0x04, 0x05, 0x2e, 0x33, 0xda, 0x00, 0xd9, 0x39, 0xb5, 0x8d, 0xb7, 0x93, 0x1b, 0xdf,
	0x38, 0x06, 0xb6, 0xf4, 0x8e, 0x2c, 0xd5, 0x5f, 0xc0, 0xfa, 0x1d, 0xe9, 0x50, 0x0d, 0x1e, 0xf4,
	0x8c, 0x5e, 0xcf, 0xec, 0x5a, 0xae, 0x7e, 0x74, 0x64, 0x5a, 0xa6, 0x73, 0x7a, 0x87, 0x42, 0x81,
	0x8d, 0x56, 0xc7, 0x34, 0x2c, 0xc7, 0x35, 0x6d, 0xd7, 0xee, 0x62, 0xc7, 0xb5, 0x71, 0xd7, 0xe9,
	0xca, 0x52, 0xfd, 0x77, 0x09, 0xee, 0xbf, 0xe3, 0x92, 0xd1, 0x63, 0x58, 0x5f, 0x94, 0xcb, 0x9d,
	0x0f, 0x8a, 0xc3, 0xd5, 0x3f, 0x5e, 0x6b, 0xd2, 0xaf, 0x6f, 0xb4, 0xc2, 0x97, 0xcf, 0x9e, 0xec,
	0xe0, 0x35, 0x76, 0x83, 0x31, 0x3d, 0xd4, 0x87, 0xb5, 0xc5, 0xf9, 0x93, 0x28, 0x39, 0x21, 0xf2,
	0xa7, 0xcb, 0x45, 0x3e, 0x16, 0x90, 0x16, 0x47, 0x1c, 0xae, 0xfc, 0xf2, 0x46, 0x93, 0x34, 0xbc,
	0x3a, 0xbe, 0xf1, 0x25, 0xf5, 0x3f, 0x25, 0x28, 0xcf, 0x9b, 0x0b, 0x3d, 0xc9, 0xa6, 0x49, 0x7a,
	0x9c, 0x8f, 0xff, 0x7a, 0xad, 0x3d, 0xfc, 0xf1, 0x8c, 0x34, 0x5e, 0xbd, 0x3c, 0x6b, 0x90, 0xc6,
	0xab, 0x9d, 0xc6, 0xc1, 0xcb, 0x1f, 0xb4, 0xcf, 0xf6, 0xb4, 0x9f, 0xce, 0x32, 0x2b, 0x1b, 0x38,
	0x0a, 0x94, 0x88, 0xe7, 0xc5, 0x34, 0x49, 0xb2, 0x06, 0x98, 0x9b, 0x7c, 0x3c, 0x4d, 0xa2, 0x38,
	0x9d, 0x69, 0x79, 0x2c, 0xd6, 0xe8, 0x6b, 0x28, 0x8b, 0x99, 0x36, 0x8c, 0x02, 0x31, 0xb6, 0xee,
	0xed, 0x36, 0xff, 0x5b, 0xef, 0xab, 0x76, 0x06, 0xc3, 0xd7, 0x04, 0xf5, 0x06, 0x94, 0xe7, 0x5e,
	0xae, 0x84, 0xb8, 0xfa, 0x56, 0xb7, 0x73, 0x47, 0xa3, 0x12, 0xe4, 0x9d, 0x96, 0x2d, 0x4b, 0xf5,
	0xbf, 0x25, 0xa8, 0xa6, 0x52, 0xf0, 0xae, 0xa4, 0x7c, 0x62, 0x25, 0xd3, 0x41, 0x48, 0xd9, 0xb5,
	0x08, 0xb8, 0x9c, 0x3a, 0x4c, 0x6f, 0x49, 0x59, 0xc7, 0xd7, 0xb3, 0x2c, 0x2f, 0x0a, 0xd8, 0x59,
	0x5e, 0xc0, 0x42, 0xc6, 0x3b, 0x33, 0xac, 0x4e, 0xff, 0xf5, 0x7d, 0x54, 0xa1, 0xc4, 0xdb, 0xce,
	0xe4, 0x1d, 0xca, 0x8d, 0x63, 0x43, 0xef, 0x38, 0xc7, 0xa7, 0x72, 0x0e, 0xad, 0x41, 0xa5, 0x6f,
	0xcd, 0x4d, 0xf1, 0x40, 0xda, 0x58, 0x37, 0xad, 0xf4, 0x81, 0x2c, 0xbe, 0x82, 0x95, 0x47, 0x4f,
	0xa1, 0x62, 0x4e, 0x4e, 0x68, 0xcc, 0x7b, 0x1b, 0x6d, 0xc1, 0xa6, 0x69, 0xbb, 0x27, 0x06, 0x16,
	0x6d, 0x7d, 0x3b, 0x5b, 0x19, 0x0a, 0xa6, 0x7d, 0xf2, 0x58, 0x96, 0xb2, 0xd5, 0x9e, 0x9c, 0x3b,
	0xec, 0x7e, 0xfb, 0x62, 0xe4, 0xb3, 0xf1, 0x74, 0xa0, 0x0e, 0xa3, 0xcb, 0xec, 0x87, 0x6c, 0xa4,
	0x3f, 0xe4, 0x28, 0x6a, 0x8c, 0x68, 0x28, 0xd4, 0x58, 0xfa, 0x75, 0x3e, 0x5d, 0xb4, 0x07, 0x45,
	0x01, 0xf8, 0xfc, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc8, 0x8d, 0xac, 0xdb, 0x06, 0x08, 0x00,
	0x00,
}
