// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/loadbalancer/v1/target_group_service.proto

package loadbalancer // import "github.com/yandex-cloud/go-genproto/yandex/cloud/loadbalancer/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetTargetGroupRequest struct {
	// ID of the TargetGroup resource to return.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetGroupRequest) Reset()         { *m = GetTargetGroupRequest{} }
func (m *GetTargetGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetTargetGroupRequest) ProtoMessage()    {}
func (*GetTargetGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{0}
}
func (m *GetTargetGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetGroupRequest.Unmarshal(m, b)
}
func (m *GetTargetGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetGroupRequest.Marshal(b, m, deterministic)
}
func (dst *GetTargetGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetGroupRequest.Merge(dst, src)
}
func (m *GetTargetGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetTargetGroupRequest.Size(m)
}
func (m *GetTargetGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetGroupRequest proto.InternalMessageInfo

func (m *GetTargetGroupRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type ListTargetGroupsRequest struct {
	// ID of the folder to list target groups in.
	// To get the folder ID, use a [TargetGroupService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListTargetGroupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListTargetGroupsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only filter by the [TargetGroup.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, or `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetGroupsRequest) Reset()         { *m = ListTargetGroupsRequest{} }
func (m *ListTargetGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTargetGroupsRequest) ProtoMessage()    {}
func (*ListTargetGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{1}
}
func (m *ListTargetGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetGroupsRequest.Unmarshal(m, b)
}
func (m *ListTargetGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetGroupsRequest.Marshal(b, m, deterministic)
}
func (dst *ListTargetGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetGroupsRequest.Merge(dst, src)
}
func (m *ListTargetGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTargetGroupsRequest.Size(m)
}
func (m *ListTargetGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetGroupsRequest proto.InternalMessageInfo

func (m *ListTargetGroupsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListTargetGroupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTargetGroupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTargetGroupsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListTargetGroupsResponse struct {
	// List of TargetGroup resources.
	TargetGroups []*TargetGroup `protobuf:"bytes,1,rep,name=target_groups,json=targetGroups,proto3" json:"target_groups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListTargetGroupsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListTargetGroupsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetGroupsResponse) Reset()         { *m = ListTargetGroupsResponse{} }
func (m *ListTargetGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTargetGroupsResponse) ProtoMessage()    {}
func (*ListTargetGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{2}
}
func (m *ListTargetGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetGroupsResponse.Unmarshal(m, b)
}
func (m *ListTargetGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetGroupsResponse.Marshal(b, m, deterministic)
}
func (dst *ListTargetGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetGroupsResponse.Merge(dst, src)
}
func (m *ListTargetGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTargetGroupsResponse.Size(m)
}
func (m *ListTargetGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetGroupsResponse proto.InternalMessageInfo

func (m *ListTargetGroupsResponse) GetTargetGroups() []*TargetGroup {
	if m != nil {
		return m.TargetGroups
	}
	return nil
}

func (m *ListTargetGroupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateTargetGroupRequest struct {
	// ID of the folder to list target groups in.
	// To get the folder ID, use a [TargetGroupService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the target group.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the target group.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the availability zone where the target group resides.
	RegionId string `protobuf:"bytes,5,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// List of targets within the target group.
	Targets              []*Target `protobuf:"bytes,7,rep,name=targets,proto3" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateTargetGroupRequest) Reset()         { *m = CreateTargetGroupRequest{} }
func (m *CreateTargetGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTargetGroupRequest) ProtoMessage()    {}
func (*CreateTargetGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{3}
}
func (m *CreateTargetGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetGroupRequest.Unmarshal(m, b)
}
func (m *CreateTargetGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetGroupRequest.Marshal(b, m, deterministic)
}
func (dst *CreateTargetGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetGroupRequest.Merge(dst, src)
}
func (m *CreateTargetGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTargetGroupRequest.Size(m)
}
func (m *CreateTargetGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetGroupRequest proto.InternalMessageInfo

func (m *CreateTargetGroupRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateTargetGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateTargetGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateTargetGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateTargetGroupRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *CreateTargetGroupRequest) GetTargets() []*Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type CreateTargetGroupMetadata struct {
	// ID of the target group that is being created.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTargetGroupMetadata) Reset()         { *m = CreateTargetGroupMetadata{} }
func (m *CreateTargetGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateTargetGroupMetadata) ProtoMessage()    {}
func (*CreateTargetGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{4}
}
func (m *CreateTargetGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetGroupMetadata.Unmarshal(m, b)
}
func (m *CreateTargetGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetGroupMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateTargetGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetGroupMetadata.Merge(dst, src)
}
func (m *CreateTargetGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateTargetGroupMetadata.Size(m)
}
func (m *CreateTargetGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetGroupMetadata proto.InternalMessageInfo

func (m *CreateTargetGroupMetadata) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type UpdateTargetGroupRequest struct {
	// ID of the TargetGroup resource to update.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// Field mask that specifies which fields of the TargetGroup resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the target group.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the target group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	//
	// The existing set of `` labels `` is completely replaced with the provided set.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A new list of targets for this target group.
	Targets              []*Target `protobuf:"bytes,6,rep,name=targets,proto3" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateTargetGroupRequest) Reset()         { *m = UpdateTargetGroupRequest{} }
func (m *UpdateTargetGroupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTargetGroupRequest) ProtoMessage()    {}
func (*UpdateTargetGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{5}
}
func (m *UpdateTargetGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTargetGroupRequest.Unmarshal(m, b)
}
func (m *UpdateTargetGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTargetGroupRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateTargetGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTargetGroupRequest.Merge(dst, src)
}
func (m *UpdateTargetGroupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTargetGroupRequest.Size(m)
}
func (m *UpdateTargetGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTargetGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTargetGroupRequest proto.InternalMessageInfo

func (m *UpdateTargetGroupRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *UpdateTargetGroupRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTargetGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTargetGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateTargetGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateTargetGroupRequest) GetTargets() []*Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type UpdateTargetGroupMetadata struct {
	// ID of the target group that is being updated.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateTargetGroupMetadata) Reset()         { *m = UpdateTargetGroupMetadata{} }
func (m *UpdateTargetGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateTargetGroupMetadata) ProtoMessage()    {}
func (*UpdateTargetGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{6}
}
func (m *UpdateTargetGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTargetGroupMetadata.Unmarshal(m, b)
}
func (m *UpdateTargetGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTargetGroupMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateTargetGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTargetGroupMetadata.Merge(dst, src)
}
func (m *UpdateTargetGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateTargetGroupMetadata.Size(m)
}
func (m *UpdateTargetGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTargetGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTargetGroupMetadata proto.InternalMessageInfo

func (m *UpdateTargetGroupMetadata) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type DeleteTargetGroupRequest struct {
	// ID of the target group to delete.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTargetGroupRequest) Reset()         { *m = DeleteTargetGroupRequest{} }
func (m *DeleteTargetGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTargetGroupRequest) ProtoMessage()    {}
func (*DeleteTargetGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{7}
}
func (m *DeleteTargetGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTargetGroupRequest.Unmarshal(m, b)
}
func (m *DeleteTargetGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTargetGroupRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteTargetGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTargetGroupRequest.Merge(dst, src)
}
func (m *DeleteTargetGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTargetGroupRequest.Size(m)
}
func (m *DeleteTargetGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTargetGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTargetGroupRequest proto.InternalMessageInfo

func (m *DeleteTargetGroupRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type DeleteTargetGroupMetadata struct {
	// ID of the target group that is being deleted.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTargetGroupMetadata) Reset()         { *m = DeleteTargetGroupMetadata{} }
func (m *DeleteTargetGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteTargetGroupMetadata) ProtoMessage()    {}
func (*DeleteTargetGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{8}
}
func (m *DeleteTargetGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTargetGroupMetadata.Unmarshal(m, b)
}
func (m *DeleteTargetGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTargetGroupMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteTargetGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTargetGroupMetadata.Merge(dst, src)
}
func (m *DeleteTargetGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteTargetGroupMetadata.Size(m)
}
func (m *DeleteTargetGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTargetGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTargetGroupMetadata proto.InternalMessageInfo

func (m *DeleteTargetGroupMetadata) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type AddTargetsRequest struct {
	// ID of the TargetGroup resource to add targets to.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// List of targets to add to the target group.
	Targets              []*Target `protobuf:"bytes,2,rep,name=targets,proto3" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *AddTargetsRequest) Reset()         { *m = AddTargetsRequest{} }
func (m *AddTargetsRequest) String() string { return proto.CompactTextString(m) }
func (*AddTargetsRequest) ProtoMessage()    {}
func (*AddTargetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{9}
}
func (m *AddTargetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetsRequest.Unmarshal(m, b)
}
func (m *AddTargetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetsRequest.Marshal(b, m, deterministic)
}
func (dst *AddTargetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetsRequest.Merge(dst, src)
}
func (m *AddTargetsRequest) XXX_Size() int {
	return xxx_messageInfo_AddTargetsRequest.Size(m)
}
func (m *AddTargetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetsRequest proto.InternalMessageInfo

func (m *AddTargetsRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *AddTargetsRequest) GetTargets() []*Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type AddTargetsMetadata struct {
	// ID of the target group that targets are being added to.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddTargetsMetadata) Reset()         { *m = AddTargetsMetadata{} }
func (m *AddTargetsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddTargetsMetadata) ProtoMessage()    {}
func (*AddTargetsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{10}
}
func (m *AddTargetsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetsMetadata.Unmarshal(m, b)
}
func (m *AddTargetsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetsMetadata.Marshal(b, m, deterministic)
}
func (dst *AddTargetsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetsMetadata.Merge(dst, src)
}
func (m *AddTargetsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddTargetsMetadata.Size(m)
}
func (m *AddTargetsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetsMetadata proto.InternalMessageInfo

func (m *AddTargetsMetadata) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type RemoveTargetsRequest struct {
	// ID of the target group to remove targets from.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// List of targets to remove from the target group.
	Targets              []*Target `protobuf:"bytes,2,rep,name=targets,proto3" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RemoveTargetsRequest) Reset()         { *m = RemoveTargetsRequest{} }
func (m *RemoveTargetsRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetsRequest) ProtoMessage()    {}
func (*RemoveTargetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{11}
}
func (m *RemoveTargetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetsRequest.Unmarshal(m, b)
}
func (m *RemoveTargetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetsRequest.Marshal(b, m, deterministic)
}
func (dst *RemoveTargetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetsRequest.Merge(dst, src)
}
func (m *RemoveTargetsRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetsRequest.Size(m)
}
func (m *RemoveTargetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetsRequest proto.InternalMessageInfo

func (m *RemoveTargetsRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *RemoveTargetsRequest) GetTargets() []*Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type RemoveTargetsMetadata struct {
	// ID of the target group that targets are being removed from.
	TargetGroupId        string   `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveTargetsMetadata) Reset()         { *m = RemoveTargetsMetadata{} }
func (m *RemoveTargetsMetadata) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetsMetadata) ProtoMessage()    {}
func (*RemoveTargetsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{12}
}
func (m *RemoveTargetsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetsMetadata.Unmarshal(m, b)
}
func (m *RemoveTargetsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetsMetadata.Marshal(b, m, deterministic)
}
func (dst *RemoveTargetsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetsMetadata.Merge(dst, src)
}
func (m *RemoveTargetsMetadata) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetsMetadata.Size(m)
}
func (m *RemoveTargetsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetsMetadata proto.InternalMessageInfo

func (m *RemoveTargetsMetadata) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

type ListTargetGroupOperationsRequest struct {
	// ID of the TargetGroup resource to update.
	// To get the target group ID, use a [TargetGroupService.List] request.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListTargetGroupOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListTargetGroupOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetGroupOperationsRequest) Reset()         { *m = ListTargetGroupOperationsRequest{} }
func (m *ListTargetGroupOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTargetGroupOperationsRequest) ProtoMessage()    {}
func (*ListTargetGroupOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{13}
}
func (m *ListTargetGroupOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetGroupOperationsRequest.Unmarshal(m, b)
}
func (m *ListTargetGroupOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetGroupOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListTargetGroupOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetGroupOperationsRequest.Merge(dst, src)
}
func (m *ListTargetGroupOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTargetGroupOperationsRequest.Size(m)
}
func (m *ListTargetGroupOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetGroupOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetGroupOperationsRequest proto.InternalMessageInfo

func (m *ListTargetGroupOperationsRequest) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *ListTargetGroupOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTargetGroupOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListTargetGroupOperationsResponse struct {
	// List of operations for the specified target group.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListTargetGroupOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListTargetGroupOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetGroupOperationsResponse) Reset()         { *m = ListTargetGroupOperationsResponse{} }
func (m *ListTargetGroupOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTargetGroupOperationsResponse) ProtoMessage()    {}
func (*ListTargetGroupOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_group_service_7bf758e657f72fa8, []int{14}
}
func (m *ListTargetGroupOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetGroupOperationsResponse.Unmarshal(m, b)
}
func (m *ListTargetGroupOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetGroupOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListTargetGroupOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetGroupOperationsResponse.Merge(dst, src)
}
func (m *ListTargetGroupOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTargetGroupOperationsResponse.Size(m)
}
func (m *ListTargetGroupOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetGroupOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetGroupOperationsResponse proto.InternalMessageInfo

func (m *ListTargetGroupOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListTargetGroupOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetTargetGroupRequest)(nil), "yandex.cloud.loadbalancer.v1.GetTargetGroupRequest")
	proto.RegisterType((*ListTargetGroupsRequest)(nil), "yandex.cloud.loadbalancer.v1.ListTargetGroupsRequest")
	proto.RegisterType((*ListTargetGroupsResponse)(nil), "yandex.cloud.loadbalancer.v1.ListTargetGroupsResponse")
	proto.RegisterType((*CreateTargetGroupRequest)(nil), "yandex.cloud.loadbalancer.v1.CreateTargetGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.loadbalancer.v1.CreateTargetGroupRequest.LabelsEntry")
	proto.RegisterType((*CreateTargetGroupMetadata)(nil), "yandex.cloud.loadbalancer.v1.CreateTargetGroupMetadata")
	proto.RegisterType((*UpdateTargetGroupRequest)(nil), "yandex.cloud.loadbalancer.v1.UpdateTargetGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.loadbalancer.v1.UpdateTargetGroupRequest.LabelsEntry")
	proto.RegisterType((*UpdateTargetGroupMetadata)(nil), "yandex.cloud.loadbalancer.v1.UpdateTargetGroupMetadata")
	proto.RegisterType((*DeleteTargetGroupRequest)(nil), "yandex.cloud.loadbalancer.v1.DeleteTargetGroupRequest")
	proto.RegisterType((*DeleteTargetGroupMetadata)(nil), "yandex.cloud.loadbalancer.v1.DeleteTargetGroupMetadata")
	proto.RegisterType((*AddTargetsRequest)(nil), "yandex.cloud.loadbalancer.v1.AddTargetsRequest")
	proto.RegisterType((*AddTargetsMetadata)(nil), "yandex.cloud.loadbalancer.v1.AddTargetsMetadata")
	proto.RegisterType((*RemoveTargetsRequest)(nil), "yandex.cloud.loadbalancer.v1.RemoveTargetsRequest")
	proto.RegisterType((*RemoveTargetsMetadata)(nil), "yandex.cloud.loadbalancer.v1.RemoveTargetsMetadata")
	proto.RegisterType((*ListTargetGroupOperationsRequest)(nil), "yandex.cloud.loadbalancer.v1.ListTargetGroupOperationsRequest")
	proto.RegisterType((*ListTargetGroupOperationsResponse)(nil), "yandex.cloud.loadbalancer.v1.ListTargetGroupOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TargetGroupServiceClient is the client API for TargetGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TargetGroupServiceClient interface {
	// Returns the specified TargetGroup resource.
	Get(ctx context.Context, in *GetTargetGroupRequest, opts ...grpc.CallOption) (*TargetGroup, error)
	// Retrieves the list of TargetGroup resources in the specified folder.
	List(ctx context.Context, in *ListTargetGroupsRequest, opts ...grpc.CallOption) (*ListTargetGroupsResponse, error)
	// Creates a target group in the specified folder and adds the specified targets to it.
	Create(ctx context.Context, in *CreateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified target group.
	Update(ctx context.Context, in *UpdateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified target group.
	Delete(ctx context.Context, in *DeleteTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Adds targets to the target group.
	AddTargets(ctx context.Context, in *AddTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Removes targets from the target group.
	RemoveTargets(ctx context.Context, in *RemoveTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified target group.
	ListOperations(ctx context.Context, in *ListTargetGroupOperationsRequest, opts ...grpc.CallOption) (*ListTargetGroupOperationsResponse, error)
}

type targetGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewTargetGroupServiceClient(cc *grpc.ClientConn) TargetGroupServiceClient {
	return &targetGroupServiceClient{cc}
}

func (c *targetGroupServiceClient) Get(ctx context.Context, in *GetTargetGroupRequest, opts ...grpc.CallOption) (*TargetGroup, error) {
	out := new(TargetGroup)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) List(ctx context.Context, in *ListTargetGroupsRequest, opts ...grpc.CallOption) (*ListTargetGroupsResponse, error) {
	out := new(ListTargetGroupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) Create(ctx context.Context, in *CreateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) Update(ctx context.Context, in *UpdateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) Delete(ctx context.Context, in *DeleteTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) AddTargets(ctx context.Context, in *AddTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/AddTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) RemoveTargets(ctx context.Context, in *RemoveTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/RemoveTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *targetGroupServiceClient) ListOperations(ctx context.Context, in *ListTargetGroupOperationsRequest, opts ...grpc.CallOption) (*ListTargetGroupOperationsResponse, error) {
	out := new(ListTargetGroupOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.loadbalancer.v1.TargetGroupService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TargetGroupServiceServer is the server API for TargetGroupService service.
type TargetGroupServiceServer interface {
	// Returns the specified TargetGroup resource.
	Get(context.Context, *GetTargetGroupRequest) (*TargetGroup, error)
	// Retrieves the list of TargetGroup resources in the specified folder.
	List(context.Context, *ListTargetGroupsRequest) (*ListTargetGroupsResponse, error)
	// Creates a target group in the specified folder and adds the specified targets to it.
	Create(context.Context, *CreateTargetGroupRequest) (*operation.Operation, error)
	// Updates the specified target group.
	Update(context.Context, *UpdateTargetGroupRequest) (*operation.Operation, error)
	// Deletes the specified target group.
	Delete(context.Context, *DeleteTargetGroupRequest) (*operation.Operation, error)
	// Adds targets to the target group.
	AddTargets(context.Context, *AddTargetsRequest) (*operation.Operation, error)
	// Removes targets from the target group.
	RemoveTargets(context.Context, *RemoveTargetsRequest) (*operation.Operation, error)
	// Lists operations for the specified target group.
	ListOperations(context.Context, *ListTargetGroupOperationsRequest) (*ListTargetGroupOperationsResponse, error)
}

func RegisterTargetGroupServiceServer(s *grpc.Server, srv TargetGroupServiceServer) {
	s.RegisterService(&_TargetGroupService_serviceDesc, srv)
}

func _TargetGroupService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).Get(ctx, req.(*GetTargetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).List(ctx, req.(*ListTargetGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).Create(ctx, req.(*CreateTargetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).Update(ctx, req.(*UpdateTargetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).Delete(ctx, req.(*DeleteTargetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_AddTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).AddTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/AddTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).AddTargets(ctx, req.(*AddTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_RemoveTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).RemoveTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/RemoveTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).RemoveTargets(ctx, req.(*RemoveTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TargetGroupService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetGroupOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TargetGroupServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.loadbalancer.v1.TargetGroupService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TargetGroupServiceServer).ListOperations(ctx, req.(*ListTargetGroupOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TargetGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.loadbalancer.v1.TargetGroupService",
	HandlerType: (*TargetGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _TargetGroupService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _TargetGroupService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _TargetGroupService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _TargetGroupService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _TargetGroupService_Delete_Handler,
		},
		{
			MethodName: "AddTargets",
			Handler:    _TargetGroupService_AddTargets_Handler,
		},
		{
			MethodName: "RemoveTargets",
			Handler:    _TargetGroupService_RemoveTargets_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _TargetGroupService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/loadbalancer/v1/target_group_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/loadbalancer/v1/target_group_service.proto", fileDescriptor_target_group_service_7bf758e657f72fa8)
}

var fileDescriptor_target_group_service_7bf758e657f72fa8 = []byte{
	// 1166 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xbf, 0x6f, 0xdb, 0xd6,
	0x13, 0xc7, 0xb3, 0x64, 0x25, 0x3a, 0xd9, 0xdf, 0xe4, 0xfb, 0x10, 0xa3, 0xac, 0x90, 0x14, 0x32,
	0x1b, 0xb8, 0x8e, 0x5a, 0x51, 0xa2, 0x1c, 0xab, 0x71, 0xfc, 0xab, 0x91, 0x9b, 0x1a, 0x06, 0xe2,
	0x26, 0x60, 0x92, 0xa5, 0x46, 0x20, 0x3c, 0x9b, 0xcf, 0x2a, 0x61, 0x9a, 0x54, 0x48, 0x4a, 0x88,
	0x9d, 0x66, 0xf1, 0xe8, 0xa1, 0x43, 0x8a, 0x4e, 0x45, 0xd1, 0x3f, 0xa0, 0x9b, 0xc7, 0x16, 0x9d,
	0xed, 0xa1, 0x5d, 0x1c, 0xa0, 0x40, 0xf7, 0x0e, 0x5d, 0xba, 0x64, 0xec, 0x54, 0xf0, 0x3d, 0x4a,
	0xa2, 0x4c, 0x89, 0x26, 0xed, 0xb4, 0xe8, 0x26, 0xf2, 0xde, 0x9d, 0x3e, 0x9f, 0xbb, 0x7b, 0x77,
	0x1f, 0x10, 0x3e, 0xdc, 0x21, 0x86, 0x4a, 0x9f, 0x15, 0x37, 0x74, 0xb3, 0xa9, 0x16, 0x75, 0x93,
	0xa8, 0xeb, 0x44, 0x27, 0xc6, 0x06, 0xb5, 0x8a, 0x2d, 0xb9, 0xe8, 0x10, 0xab, 0x4e, 0x9d, 0x5a,
	0xdd, 0x32, 0x9b, 0x8d, 0x9a, 0x4d, 0xad, 0x96, 0xb6, 0x41, 0xa5, 0x86, 0x65, 0x3a, 0x26, 0xbe,
	0xca, 0x1d, 0x25, 0xe6, 0x28, 0xf9, 0x1d, 0xa5, 0x96, 0x9c, 0xbd, 0x5a, 0x37, 0xcd, 0xba, 0x4e,
	0x8b, 0xa4, 0xa1, 0x15, 0x89, 0x61, 0x98, 0x0e, 0x71, 0x34, 0xd3, 0xb0, 0xb9, 0x6f, 0x36, 0xe7,
	0x59, 0xd9, 0xd3, 0x7a, 0x73, 0xb3, 0xb8, 0xa9, 0x51, 0x5d, 0xad, 0x6d, 0x13, 0x7b, 0xcb, 0x3b,
	0x91, 0xf5, 0x60, 0xb9, 0xfe, 0x66, 0x83, 0x5a, 0xcc, 0xdd, 0xb3, 0x5d, 0xeb, 0x81, 0xdc, 0x22,
	0xba, 0xa6, 0xfa, 0xcd, 0x13, 0x3d, 0xe6, 0x8e, 0x73, 0x20, 0x4c, 0x31, 0x32, 0x73, 0xee, 0x20,
	0xae, 0xc2, 0xd8, 0x32, 0x75, 0x1e, 0x31, 0xc3, 0xb2, 0xfb, 0x5e, 0xa1, 0x4f, 0x9b, 0xd4, 0x76,
	0xf0, 0x4d, 0xb8, 0xd4, 0x93, 0x28, 0x4d, 0x15, 0x50, 0x0e, 0x4d, 0xa6, 0xab, 0x23, 0x7f, 0x1c,
	0xca, 0x68, 0xff, 0x48, 0x4e, 0xce, 0xcd, 0x4f, 0x97, 0x94, 0x51, 0xa7, 0xeb, 0xba, 0xa2, 0x8a,
	0x3f, 0x22, 0x78, 0xeb, 0x9e, 0x66, 0xfb, 0x03, 0xda, 0xed, 0x88, 0x37, 0x20, 0xbd, 0x69, 0xea,
	0x2a, 0xb5, 0x06, 0xc5, 0xba, 0xc8, 0xcd, 0x2b, 0x2a, 0x7e, 0x0f, 0xd2, 0x0d, 0x52, 0xa7, 0x35,
	0x5b, 0xdb, 0xa5, 0xc2, 0x50, 0x0e, 0x4d, 0x26, 0xaa, 0xf0, 0xd7, 0xa1, 0x9c, 0x9a, 0x9b, 0x97,
	0x4b, 0xa5, 0x92, 0x72, 0xd1, 0x35, 0x3e, 0xd4, 0x76, 0x29, 0x9e, 0x04, 0x60, 0x07, 0x1d, 0x73,
	0x8b, 0x1a, 0x42, 0x82, 0x05, 0x4d, 0xef, 0x1f, 0xc9, 0xc3, 0xec, 0xa4, 0xc2, 0xa2, 0x3c, 0x72,
	0x6d, 0x58, 0x84, 0xd4, 0xa6, 0xa6, 0x3b, 0xd4, 0x12, 0x92, 0xec, 0x14, 0xec, 0x1f, 0x75, 0xe2,
	0x79, 0x16, 0xf1, 0x25, 0x02, 0x21, 0x88, 0xde, 0x6e, 0x98, 0x86, 0x4d, 0xf1, 0xa7, 0x30, 0xea,
	0x4f, 0x88, 0x2d, 0xa0, 0x5c, 0x62, 0x32, 0x53, 0xbe, 0x21, 0x85, 0xf5, 0x8c, 0xe4, 0xcf, 0xec,
	0x88, 0x2f, 0x57, 0x36, 0x9e, 0x80, 0x4b, 0x06, 0x7d, 0xe6, 0xd4, 0x7c, 0xf8, 0x5d, 0xa6, 0x69,
	0x65, 0xd4, 0x7d, 0xfd, 0xa0, 0x0d, 0x5c, 0xfc, 0x33, 0x01, 0xc2, 0x92, 0x45, 0x89, 0x43, 0xfb,
	0x54, 0x29, 0x46, 0x4e, 0xa7, 0x21, 0x69, 0x90, 0x6d, 0x9e, 0xce, 0x74, 0x75, 0xfc, 0xf5, 0xa1,
	0x7c, 0xed, 0x8b, 0x35, 0x52, 0xd8, 0x7d, 0xb2, 0x56, 0x20, 0x85, 0xdd, 0x52, 0x61, 0xe6, 0xc9,
	0x73, 0xf9, 0x83, 0x8a, 0xfc, 0x62, 0xcd, 0x7b, 0x52, 0xd8, 0x71, 0xfc, 0x3e, 0x64, 0x54, 0x6a,
	0x6f, 0x58, 0x5a, 0xc3, 0x6d, 0xb3, 0xde, 0x14, 0x97, 0xa7, 0x2b, 0x8a, 0xdf, 0x8a, 0xbf, 0x41,
	0x90, 0xd2, 0xc9, 0x3a, 0xd5, 0x6d, 0x21, 0xc9, 0xb2, 0x53, 0x0d, 0xcf, 0xce, 0x20, 0x5e, 0xd2,
	0x3d, 0x16, 0xe4, 0xae, 0xe1, 0x58, 0x3b, 0xd5, 0xc5, 0xd7, 0x87, 0x72, 0x66, 0xad, 0x50, 0x2b,
	0x15, 0x66, 0x5c, 0xb8, 0xf9, 0x3d, 0xc6, 0xad, 0x72, 0x93, 0x73, 0xac, 0x4c, 0x1d, 0x1c, 0xc9,
	0xa9, 0x6c, 0x52, 0x2e, 0xb0, 0x5f, 0x18, 0x5f, 0xf6, 0x48, 0x75, 0xce, 0x2b, 0x1e, 0x24, 0x37,
	0x59, 0x16, 0xad, 0x6b, 0xa6, 0xe1, 0x26, 0x6b, 0xb8, 0x5f, 0xb2, 0xb8, 0x79, 0x45, 0xc5, 0x0b,
	0x70, 0x81, 0x17, 0xcb, 0x16, 0x2e, 0x30, 0x22, 0xd7, 0xa3, 0x94, 0x59, 0x69, 0x3b, 0x65, 0x67,
	0x20, 0xe3, 0xa3, 0x80, 0x2f, 0x43, 0x62, 0x8b, 0xee, 0xf0, 0x02, 0x29, 0xee, 0x4f, 0x7c, 0x05,
	0x86, 0x5b, 0x44, 0x6f, 0x7a, 0xe5, 0x50, 0xf8, 0xc3, 0xed, 0xa1, 0x5b, 0x48, 0x5c, 0x82, 0xb7,
	0x03, 0x69, 0x59, 0xa5, 0x0e, 0x51, 0x89, 0x43, 0xdc, 0xa6, 0xe9, 0x7b, 0x2b, 0x4f, 0xde, 0xc3,
	0xfd, 0x24, 0x08, 0x8f, 0x1b, 0x6a, 0xff, 0xa6, 0x39, 0xd3, 0xd5, 0xc6, 0xb3, 0x90, 0x69, 0xb2,
	0x88, 0x6c, 0xa4, 0x31, 0xdc, 0x99, 0x72, 0x56, 0xe2, 0x53, 0x4f, 0x6a, 0x4f, 0x3d, 0xe9, 0x13,
	0x77, 0xea, 0xad, 0x12, 0x7b, 0x4b, 0x01, 0x7e, 0xdc, 0xfd, 0xdd, 0x69, 0xbe, 0xc4, 0xb9, 0x9a,
	0x2f, 0x19, 0xb5, 0xf9, 0x86, 0xa3, 0x34, 0xdf, 0xa0, 0xfc, 0xfc, 0x33, 0xcd, 0xe7, 0xeb, 0xa8,
	0xd4, 0xbf, 0xdf, 0x51, 0x01, 0xae, 0xb1, 0x3b, 0xea, 0x01, 0x08, 0x1f, 0x53, 0x9d, 0xbe, 0xb9,
	0x86, 0x72, 0x61, 0x05, 0x22, 0xc6, 0x86, 0xf5, 0x12, 0xc1, 0xff, 0xef, 0xa8, 0x2a, 0x0f, 0x61,
	0x9f, 0xaf, 0xc3, 0x97, 0xbb, 0x25, 0x1a, 0x8a, 0x5e, 0xa2, 0xea, 0x85, 0xbd, 0x23, 0x39, 0xb1,
	0x30, 0x2f, 0x77, 0x6a, 0x25, 0xce, 0x01, 0xee, 0x62, 0x8a, 0x4d, 0xe9, 0x6b, 0x04, 0x57, 0x14,
	0xba, 0x6d, 0xb6, 0xe8, 0x7f, 0x8b, 0xd5, 0x22, 0x8c, 0xf5, 0xc0, 0x8a, 0x4d, 0xec, 0x7b, 0x04,
	0xb9, 0x13, 0xeb, 0xf5, 0x7e, 0x5b, 0xbf, 0x9c, 0x93, 0xe4, 0x9b, 0x17, 0x0c, 0xe2, 0x97, 0x08,
	0xc6, 0x43, 0xd0, 0x7a, 0xaa, 0xe0, 0x0e, 0x40, 0x47, 0x83, 0xb5, 0x25, 0xc1, 0x78, 0x6f, 0x82,
	0xbb, 0x1a, 0xad, 0xe3, 0xaf, 0xf8, 0x9c, 0xa2, 0x0a, 0x81, 0xf2, 0x4f, 0x23, 0x80, 0x7d, 0x60,
	0x1e, 0x72, 0xe5, 0x8a, 0xbf, 0x43, 0x90, 0x58, 0xa6, 0x0e, 0x9e, 0x0a, 0x2f, 0x6b, 0x5f, 0x95,
	0x97, 0x8d, 0xae, 0x5e, 0xc4, 0x5b, 0x7b, 0xaf, 0x7e, 0xff, 0x6a, 0xa8, 0x8c, 0x4b, 0x4c, 0x56,
	0x16, 0x82, 0xba, 0x92, 0xeb, 0x9a, 0xe2, 0xf3, 0x13, 0xe5, 0x7b, 0x81, 0xbf, 0x45, 0x90, 0x74,
	0x33, 0x89, 0xa7, 0xc3, 0xff, 0x6d, 0x80, 0x70, 0xcc, 0x56, 0xe2, 0xba, 0xf1, 0xda, 0x88, 0x13,
	0x0c, 0x71, 0x0e, 0xbf, 0x13, 0x8e, 0x18, 0xff, 0x80, 0x20, 0xc5, 0x57, 0x2e, 0xae, 0x9c, 0x4d,
	0xaf, 0x64, 0x4f, 0x2f, 0xb9, 0xf8, 0xf8, 0xe0, 0x38, 0x3f, 0x19, 0xb6, 0xdb, 0x33, 0xbe, 0x97,
	0x0c, 0xf9, 0xbb, 0xe2, 0x29, 0xc8, 0x6f, 0xa3, 0x3c, 0xfe, 0x19, 0x41, 0x8a, 0x4f, 0xf7, 0xd3,
	0xc0, 0x0f, 0xda, 0x77, 0x51, 0xc0, 0xd7, 0x39, 0xf8, 0xc1, 0x6b, 0x24, 0x00, 0x7e, 0xba, 0x1c,
	0xbb, 0x51, 0x5c, 0x3a, 0xaf, 0x10, 0xa4, 0xf8, 0x56, 0x38, 0x8d, 0xce, 0xa0, 0x6d, 0x14, 0x85,
	0x8e, 0x71, 0x70, 0x9c, 0x2f, 0x87, 0xad, 0x9f, 0xb1, 0x93, 0xb2, 0xe6, 0xee, 0x76, 0xc3, 0xd9,
	0xe1, 0x37, 0x20, 0x1f, 0xff, 0x06, 0xfc, 0x82, 0x00, 0xba, 0x1b, 0x01, 0x17, 0xc3, 0x99, 0x05,
	0xf6, 0x59, 0x14, 0x4a, 0x5b, 0x07, 0xc7, 0xf9, 0xf1, 0xbe, 0x7b, 0x27, 0x50, 0x9a, 0x8f, 0xc4,
	0xd9, 0xd8, 0xa5, 0x21, 0x9d, 0xb8, 0x6e, 0x95, 0x7e, 0x43, 0x30, 0xda, 0xb3, 0x0b, 0x70, 0x39,
	0x9c, 0x52, 0xbf, 0x7d, 0x16, 0x85, 0xd5, 0xd3, 0x83, 0xe3, 0xfc, 0xf5, 0x41, 0x7b, 0x27, 0x40,
	0x6c, 0x49, 0x5c, 0x88, 0x4d, 0xcc, 0xf2, 0x87, 0x76, 0xb9, 0xfd, 0x8a, 0xe0, 0x7f, 0xee, 0x48,
	0xe9, 0x0e, 0x7b, 0xbc, 0x10, 0x6b, 0x00, 0x05, 0x76, 0x5a, 0x76, 0xf1, 0xcc, 0xfe, 0xde, 0x24,
	0x5b, 0x62, 0xf4, 0xe6, 0x71, 0xec, 0xba, 0x75, 0x3f, 0x10, 0xd8, 0xd5, 0xfb, 0x9f, 0xad, 0xd6,
	0x35, 0xe7, 0xf3, 0xe6, 0xba, 0xb4, 0x61, 0x6e, 0x7b, 0x1f, 0x0a, 0x0a, 0xfc, 0x43, 0x41, 0xdd,
	0x2c, 0xd4, 0xa9, 0xc1, 0x9a, 0x3d, 0xf4, 0x0b, 0xc2, 0xac, 0xff, 0x79, 0x3d, 0xc5, 0x1c, 0xa6,
	0xfe, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xdc, 0xe8, 0x1e, 0x4c, 0x6f, 0x11, 0x00, 0x00,
}
