// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/clickhouse/v1/cluster.proto

package clickhouse // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1/config"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}
var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// ClickHouse host.
	Host_CLICKHOUSE Host_Type = 1
	// ZooKeeper host.
	Host_ZOOKEEPER Host_Type = 2
)

var Host_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CLICKHOUSE",
	2: "ZOOKEEPER",
}
var Host_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"CLICKHOUSE":       1,
	"ZOOKEEPER":        2,
}

func (x Host_Type) String() string {
	return proto.EnumName(Host_Type_name, int32(x))
}
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{5, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}
var Host_Health_value = map[string]int32{
	"UNKNOWN":  0,
	"ALIVE":    1,
	"DEAD":     2,
	"DEGRADED": 3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{5, 1}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a ClickHouse server.
	Service_CLICKHOUSE Service_Type = 1
	// The host is a ZooKeeper server.
	Service_ZOOKEEPER Service_Type = 2
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CLICKHOUSE",
	2: "ZOOKEEPER",
}
var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"CLICKHOUSE":       1,
	"ZOOKEEPER":        2,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{6, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}
var Service_Health_value = map[string]int32{
	"UNKNOWN": 0,
	"ALIVE":   1,
	"DEAD":    2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{6, 1}
}

// A ClickHouse Cluster resource. For more information, see the
// [Cluster](/docs/managed-clickhouse/concepts) section in the Developer's Guide.
type Cluster struct {
	// ID of the ClickHouse cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the ClickHouse cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the ClickHouse cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the ClickHouse cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the ClickHouse cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the ClickHouse cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the ClickHouse cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status               Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

// Monitoring system metadata.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the ClickHouse cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{1}
}
func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (dst *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(dst, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of the ClickHouse server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resource allocation for ClickHouse hosts.
	Clickhouse *ClusterConfig_Clickhouse `protobuf:"bytes,2,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	// Configuration and resource allocation for ZooKeeper hosts.
	Zookeeper *ClusterConfig_Zookeeper `protobuf:"bytes,3,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// Start time for the daily backup in UTC timezone
	BackupWindowStart    *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{2}
}
func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (dst *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(dst, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ClusterConfig) GetClickhouse() *ClusterConfig_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

func (m *ClusterConfig) GetZookeeper() *ClusterConfig_Zookeeper {
	if m != nil {
		return m.Zookeeper
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

type ClusterConfig_Clickhouse struct {
	// Configuration settings of a ClickHouse server.
	Config *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to ClickHouse hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ClusterConfig_Clickhouse) Reset()         { *m = ClusterConfig_Clickhouse{} }
func (m *ClusterConfig_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig_Clickhouse) ProtoMessage()    {}
func (*ClusterConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{2, 0}
}
func (m *ClusterConfig_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Unmarshal(m, b)
}
func (m *ClusterConfig_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Marshal(b, m, deterministic)
}
func (dst *ClusterConfig_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig_Clickhouse.Merge(dst, src)
}
func (m *ClusterConfig_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Size(m)
}
func (m *ClusterConfig_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig_Clickhouse proto.InternalMessageInfo

func (m *ClusterConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ClusterConfig_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type ClusterConfig_Zookeeper struct {
	// Resources allocated to ZooKeeper hosts.
	Resources            *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ClusterConfig_Zookeeper) Reset()         { *m = ClusterConfig_Zookeeper{} }
func (m *ClusterConfig_Zookeeper) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig_Zookeeper) ProtoMessage()    {}
func (*ClusterConfig_Zookeeper) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{2, 1}
}
func (m *ClusterConfig_Zookeeper) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Unmarshal(m, b)
}
func (m *ClusterConfig_Zookeeper) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Marshal(b, m, deterministic)
}
func (dst *ClusterConfig_Zookeeper) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig_Zookeeper.Merge(dst, src)
}
func (m *ClusterConfig_Zookeeper) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Size(m)
}
func (m *ClusterConfig_Zookeeper) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig_Zookeeper.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig_Zookeeper proto.InternalMessageInfo

func (m *ClusterConfig_Zookeeper) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Shard struct {
	Name                 string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ClusterId            string       `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Config               *ShardConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{3}
}
func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (dst *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(dst, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Shard) GetConfig() *ShardConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

type ShardConfig struct {
	Clickhouse           *ShardConfig_Clickhouse `protobuf:"bytes,1,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ShardConfig) Reset()         { *m = ShardConfig{} }
func (m *ShardConfig) String() string { return proto.CompactTextString(m) }
func (*ShardConfig) ProtoMessage()    {}
func (*ShardConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{4}
}
func (m *ShardConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfig.Unmarshal(m, b)
}
func (m *ShardConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfig.Marshal(b, m, deterministic)
}
func (dst *ShardConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfig.Merge(dst, src)
}
func (m *ShardConfig) XXX_Size() int {
	return xxx_messageInfo_ShardConfig.Size(m)
}
func (m *ShardConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfig proto.InternalMessageInfo

func (m *ShardConfig) GetClickhouse() *ShardConfig_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

type ShardConfig_Clickhouse struct {
	Config               *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Resources            *Resources                  `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	Weight               *wrappers.Int64Value        `protobuf:"bytes,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ShardConfig_Clickhouse) Reset()         { *m = ShardConfig_Clickhouse{} }
func (m *ShardConfig_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ShardConfig_Clickhouse) ProtoMessage()    {}
func (*ShardConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{4, 0}
}
func (m *ShardConfig_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfig_Clickhouse.Unmarshal(m, b)
}
func (m *ShardConfig_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfig_Clickhouse.Marshal(b, m, deterministic)
}
func (dst *ShardConfig_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfig_Clickhouse.Merge(dst, src)
}
func (m *ShardConfig_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ShardConfig_Clickhouse.Size(m)
}
func (m *ShardConfig_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfig_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfig_Clickhouse proto.InternalMessageInfo

func (m *ShardConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ShardConfig_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ShardConfig_Clickhouse) GetWeight() *wrappers.Int64Value {
	if m != nil {
		return m.Weight
	}
	return nil
}

type Host struct {
	// Name of the ClickHouse host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the ClickHouse host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the ClickHouse host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Type of the host.
	Type Host_Type `protobuf:"varint,4,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Type" json:"type,omitempty"`
	// Resources allocated to the ClickHouse host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp       bool     `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ShardName            string   `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{5}
}
func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (dst *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(dst, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{6}
}
func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (dst *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(dst, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-clickhouse/concepts/instance-types)
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-nvme — network SSD drive,
	// * local-nvme — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_023f72bf3ea54d88, []int{7}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (dst *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(dst, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.clickhouse.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.clickhouse.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig")
	proto.RegisterType((*ClusterConfig_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse")
	proto.RegisterType((*ClusterConfig_Zookeeper)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.clickhouse.v1.Shard")
	proto.RegisterType((*ShardConfig)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfig")
	proto.RegisterType((*ShardConfig_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.clickhouse.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.clickhouse.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.clickhouse.v1.Resources")
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Host_Type", Host_Type_name, Host_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Service_Health", Service_Health_name, Service_Health_value)
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/clickhouse/v1/cluster.proto", fileDescriptor_cluster_023f72bf3ea54d88)
}

var fileDescriptor_cluster_023f72bf3ea54d88 = []byte{
	// 1229 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0xcb, 0x6e, 0xdb, 0x46,
	0x17, 0x0e, 0x75, 0xe7, 0xa1, 0x23, 0xf0, 0x9f, 0x3f, 0x68, 0x08, 0x19, 0x49, 0x0d, 0x6e, 0xea,
	0xe6, 0x42, 0x21, 0x4e, 0xe1, 0x3a, 0x09, 0x8a, 0x56, 0x91, 0x68, 0x9b, 0xb5, 0x4d, 0x09, 0x23,
	0xca, 0x69, 0xbd, 0x11, 0x28, 0x71, 0x2c, 0x11, 0x92, 0x48, 0x82, 0xa4, 0xe4, 0xc8, 0x9b, 0xbe,
	0x4c, 0x37, 0x7d, 0x8c, 0x6e, 0xba, 0xed, 0x1b, 0xf4, 0x49, 0xba, 0x28, 0x66, 0x86, 0xba, 0xd9,
	0x4d, 0x24, 0x27, 0xab, 0xee, 0x34, 0xe7, 0x9c, 0xef, 0xe3, 0xb9, 0xce, 0x19, 0xc1, 0xb3, 0xa9,
	0xed, 0x39, 0xe4, 0x7d, 0xb9, 0x3b, 0xf4, 0xc7, 0x4e, 0x79, 0xe4, 0x74, 0xca, 0xdd, 0xa1, 0xdb,
	0x1d, 0xf4, 0xfd, 0x71, 0x44, 0xca, 0x93, 0x17, 0xe5, 0xee, 0x70, 0x1c, 0xc5, 0x24, 0xd4, 0x82,
	0xd0, 0x8f, 0x7d, 0xf4, 0x98, 0x5b, 0x6b, 0xcc, 0x5a, 0x1b, 0x39, 0x1d, 0x6d, 0x61, 0xad, 0x4d,
	0x5e, 0x94, 0xbe, 0xec, 0xf9, 0x7e, 0x6f, 0x48, 0xca, 0xcc, 0xba, 0x33, 0xbe, 0x2c, 0xc7, 0xee,
	0x88, 0x44, 0xb1, 0x3d, 0x0a, 0x38, 0x41, 0xe9, 0xf1, 0x4d, 0x83, 0xab, 0xd0, 0x0e, 0x02, 0x12,
	0x46, 0x89, 0x7e, 0x3b, 0xd1, 0xc7, 0xd3, 0x80, 0x30, 0xb0, 0x7f, 0xe9, 0xd8, 0xd3, 0x44, 0xb9,
	0xbf, 0xce, 0x57, 0xdf, 0xbb, 0x74, 0x7b, 0x4b, 0x42, 0x8e, 0x53, 0xff, 0xcc, 0x43, 0xbe, 0xca,
	0xe3, 0x40, 0x45, 0x48, 0xb9, 0x8e, 0x22, 0xec, 0x08, 0xbb, 0x22, 0x4e, 0xb9, 0x0e, 0xda, 0x06,
	0xf1, 0xd2, 0x1f, 0x3a, 0x24, 0x6c, 0xbb, 0x8e, 0x92, 0x62, 0xe2, 0x02, 0x17, 0x18, 0x0e, 0x7a,
	0x05, 0xd0, 0x0d, 0x89, 0x1d, 0x13, 0xa7, 0x6d, 0xc7, 0x4a, 0x7a, 0x47, 0xd8, 0x95, 0xf6, 0x4a,
	0x1a, 0x77, 0x51, 0x9b, 0x85, 0xa0, 0x59, 0xb3, 0x18, 0xb1, 0x98, 0x58, 0x57, 0x62, 0x84, 0x20,
	0xe3, 0xd9, 0x23, 0xa2, 0x64, 0x18, 0x25, 0xfb, 0x8d, 0x76, 0x40, 0x72, 0x48, 0xd4, 0x0d, 0xdd,
	0x20, 0x76, 0x7d, 0x4f, 0xc9, 0x32, 0xd5, 0xb2, 0x08, 0x9d, 0x40, 0x6e, 0x68, 0x77, 0xc8, 0x30,
	0x52, 0x72, 0x3b, 0xe9, 0x5d, 0x69, 0xef, 0xa5, 0xf6, 0xf1, 0x84, 0x6b, 0x49, 0x58, 0xda, 0x29,
	0x43, 0xe9, 0x5e, 0x1c, 0x4e, 0x71, 0x42, 0x81, 0x5a, 0x20, 0x11, 0x6f, 0xe2, 0x86, 0xbe, 0x37,
	0x22, 0x5e, 0xac, 0xe4, 0x77, 0x84, 0xdd, 0xe2, 0xe6, 0x8c, 0xfa, 0x02, 0x8a, 0x97, 0x79, 0xd0,
	0x8f, 0x00, 0x23, 0xdf, 0x73, 0x63, 0x3f, 0x74, 0xbd, 0x9e, 0x52, 0x60, 0x7e, 0x3e, 0x59, 0xc7,
	0x7a, 0x36, 0x47, 0xe0, 0x25, 0x34, 0xd2, 0x21, 0xc7, 0x8b, 0xa6, 0x88, 0x2c, 0xb9, 0xcf, 0x37,
	0xf4, 0xae, 0xca, 0x40, 0x38, 0x01, 0xa3, 0x47, 0x00, 0x1e, 0x89, 0xaf, 0xfc, 0x70, 0x40, 0xab,
	0x08, 0x2c, 0xaf, 0x62, 0x22, 0x31, 0x1c, 0x74, 0x08, 0xb9, 0x3e, 0xb1, 0x87, 0x71, 0x5f, 0x91,
	0x58, 0x0e, 0xb4, 0x4d, 0x73, 0x70, 0xcc, 0x50, 0x38, 0x41, 0x53, 0x9e, 0x28, 0xb6, 0xe3, 0x71,
	0xa4, 0x6c, 0xdd, 0x8d, 0xa7, 0xc9, 0x50, 0x38, 0x41, 0x97, 0x5e, 0x81, 0xb4, 0x54, 0x2f, 0x24,
	0x43, 0x7a, 0x40, 0xa6, 0x49, 0x4f, 0xd2, 0x9f, 0xe8, 0x01, 0x64, 0x27, 0xf6, 0x70, 0x4c, 0x92,
	0x86, 0xe4, 0x87, 0xd7, 0xa9, 0x03, 0x41, 0x35, 0x40, 0x5a, 0x2a, 0x0c, 0xda, 0x86, 0x87, 0xba,
	0x79, 0x6e, 0xe0, 0xba, 0x79, 0xa6, 0x9b, 0x56, 0xbb, 0x65, 0x36, 0x1b, 0x7a, 0xd5, 0x38, 0x34,
	0xf4, 0x9a, 0x7c, 0x0f, 0x15, 0x01, 0x1a, 0xb8, 0x5e, 0x6b, 0x55, 0x2d, 0xa3, 0x6e, 0xca, 0x02,
	0xba, 0x0f, 0x62, 0x03, 0xeb, 0x4d, 0xab, 0xf2, 0xf6, 0x54, 0x97, 0x53, 0xea, 0xf7, 0x90, 0xe3,
	0xf1, 0x21, 0x04, 0xc5, 0x63, 0xbd, 0x72, 0x6a, 0x1d, 0xb7, 0x5b, 0xe6, 0x89, 0x59, 0x7f, 0x67,
	0xca, 0xf7, 0x90, 0x08, 0xd9, 0xca, 0xa9, 0x71, 0xae, 0xcb, 0x02, 0x2a, 0x40, 0xa6, 0xa6, 0x57,
	0x6a, 0x72, 0x0a, 0x6d, 0x41, 0xa1, 0xa6, 0x1f, 0xe1, 0x4a, 0x4d, 0xaf, 0xc9, 0x69, 0x75, 0x0a,
	0x39, 0x1e, 0x18, 0x25, 0x68, 0x5a, 0x15, 0xab, 0xd5, 0x5c, 0x22, 0xd8, 0x82, 0x42, 0x15, 0xeb,
	0x15, 0xcb, 0x30, 0x8f, 0x64, 0x01, 0x49, 0x90, 0xc7, 0x2d, 0xd3, 0xa4, 0x87, 0x14, 0xe5, 0xd6,
	0x31, 0xae, 0x63, 0x39, 0x4d, 0xad, 0x5a, 0x8d, 0x1a, 0xb7, 0xca, 0xd0, 0x53, 0xd3, 0xaa, 0x37,
	0x1a, 0xf4, 0x94, 0xa5, 0x18, 0x76, 0xd2, 0x6b, 0x72, 0x8e, 0xab, 0x2a, 0x98, 0x19, 0xe6, 0xd5,
	0x73, 0x80, 0x45, 0x47, 0xcd, 0x67, 0x4d, 0xf8, 0xf0, 0xac, 0xa5, 0x6e, 0xcf, 0x1a, 0x82, 0xcc,
	0xd0, 0xf5, 0x06, 0x6c, 0xac, 0x45, 0xcc, 0x7e, 0xab, 0xbf, 0x66, 0xe0, 0xfe, 0x4a, 0x8b, 0x21,
	0x05, 0xf2, 0x13, 0x12, 0x46, 0x94, 0x83, 0xd3, 0xcf, 0x8e, 0xe8, 0x27, 0x80, 0x45, 0xb5, 0xd9,
	0x07, 0xa4, 0xbd, 0x83, 0x3b, 0xf5, 0xaf, 0x56, 0x9d, 0xeb, 0xf0, 0x12, 0x17, 0x6a, 0x81, 0x78,
	0xed, 0xfb, 0x03, 0x42, 0x02, 0x12, 0x26, 0xb7, 0xce, 0xb7, 0x77, 0x23, 0xbe, 0x98, 0xc1, 0xf1,
	0x82, 0x09, 0x1d, 0xc2, 0xff, 0x3b, 0x76, 0x77, 0x30, 0x0e, 0xda, 0x57, 0xae, 0xe7, 0xf8, 0x57,
	0xed, 0x28, 0xb6, 0xc3, 0x98, 0xdd, 0x50, 0xd2, 0xde, 0x17, 0xb3, 0x6b, 0x8d, 0xde, 0xbc, 0xec,
	0x4a, 0xab, 0x5f, 0xd6, 0xec, 0x29, 0xfe, 0x1f, 0x87, 0xbc, 0x63, 0x88, 0x26, 0x05, 0x94, 0x7e,
	0x13, 0x00, 0x16, 0x9e, 0x23, 0x3c, 0x9f, 0x61, 0x81, 0x31, 0xbd, 0x5e, 0xe7, 0x6a, 0xf7, 0x66,
	0xf0, 0xdc, 0xe9, 0x26, 0x89, 0xe7, 0x03, 0x7d, 0x04, 0x62, 0x48, 0x22, 0x7f, 0x1c, 0x76, 0x49,
	0x94, 0xa4, 0xf6, 0xeb, 0x75, 0xb4, 0x78, 0x06, 0xc0, 0x0b, 0x6c, 0xc9, 0x02, 0x71, 0x9e, 0x8b,
	0x55, 0x56, 0xe1, 0xd3, 0x59, 0xd5, 0x5f, 0x20, 0xdb, 0xec, 0xdb, 0xa1, 0xf3, 0xaf, 0x9d, 0xf7,
	0x88, 0xf6, 0x05, 0x2b, 0xc6, 0x62, 0xa5, 0x88, 0x89, 0xc4, 0x70, 0x50, 0x75, 0x9e, 0x2e, 0x5e,
	0xd9, 0xa7, 0xeb, 0x3c, 0x60, 0x5f, 0x5a, 0xbd, 0xf0, 0xd4, 0x3f, 0x52, 0x20, 0x2d, 0xc9, 0xd1,
	0xf9, 0x4a, 0x2f, 0xf2, 0xd0, 0xf6, 0xef, 0x40, 0xfc, 0x81, 0x4e, 0x2c, 0xfd, 0xf5, 0xdf, 0x29,
	0x35, 0x7a, 0x09, 0xb9, 0x2b, 0xe2, 0xf6, 0xfa, 0xb3, 0x45, 0xbd, 0x7d, 0x6b, 0x51, 0x1b, 0x5e,
	0xbc, 0xff, 0xcd, 0x39, 0xbd, 0x4b, 0x71, 0x62, 0xaa, 0xfe, 0x9e, 0x81, 0xcc, 0xb1, 0x1f, 0xc5,
	0x9f, 0x52, 0xc9, 0x87, 0x90, 0xbf, 0xf6, 0x3d, 0x42, 0x75, 0xfc, 0x0e, 0xc9, 0xd1, 0xa3, 0xe1,
	0xa0, 0xef, 0x20, 0x43, 0xa7, 0x88, 0x4d, 0x56, 0x71, 0x7d, 0x34, 0xf4, 0xfb, 0x9a, 0x35, 0x0d,
	0x08, 0x66, 0xb0, 0xd5, 0x8c, 0x64, 0x3f, 0x23, 0x23, 0xd5, 0xf9, 0xde, 0xcb, 0x31, 0x4f, 0x9e,
	0x6e, 0xe4, 0xc9, 0x8d, 0xa5, 0x57, 0x85, 0x42, 0x44, 0xc2, 0x89, 0x4b, 0x9d, 0xc9, 0xb3, 0x65,
	0xff, 0xd5, 0xda, 0xc6, 0xe2, 0xf6, 0x78, 0x0e, 0xa4, 0xaf, 0xac, 0x68, 0xdc, 0xf1, 0x48, 0x4c,
	0x93, 0x55, 0xe0, 0xaf, 0x2c, 0x2e, 0x30, 0x1c, 0xb4, 0x0b, 0xb2, 0x1d, 0x45, 0x6e, 0xcf, 0x6b,
	0x07, 0xe3, 0xce, 0xd0, 0xed, 0xb6, 0xdd, 0x80, 0x3d, 0x07, 0x0a, 0xb8, 0xc8, 0xe5, 0x0d, 0x26,
	0x36, 0x02, 0x5a, 0x90, 0x88, 0x36, 0x6d, 0x9b, 0x95, 0x2a, 0xd9, 0xf3, 0x4c, 0x62, 0xda, 0x23,
	0xa2, 0xbe, 0x81, 0x0c, 0x4d, 0x23, 0x7a, 0x00, 0xb2, 0xf5, 0x73, 0x43, 0xbf, 0xbd, 0x0e, 0xab,
	0xa7, 0x46, 0xf5, 0xe4, 0xb8, 0xde, 0x6a, 0xea, 0x7c, 0x1d, 0x5e, 0xd4, 0xeb, 0x27, 0xba, 0xde,
	0xd0, 0xb1, 0x9c, 0x52, 0x0f, 0xe6, 0xeb, 0x50, 0x82, 0xfc, 0x9d, 0xf6, 0xe0, 0xdf, 0x02, 0xe4,
	0x93, 0x90, 0xd1, 0x0f, 0x49, 0xe9, 0x05, 0x96, 0xf0, 0x67, 0x1b, 0x66, 0x6a, 0xb9, 0xfa, 0x8b,
	0xc7, 0x4a, 0x6a, 0xb3, 0x47, 0xc6, 0x8c, 0x63, 0xb5, 0x6e, 0x9f, 0x97, 0x8c, 0x27, 0x9b, 0x27,
	0x43, 0x7d, 0x0f, 0xe2, 0xbc, 0xfb, 0xd0, 0x33, 0x40, 0xb3, 0xfe, 0x6b, 0x07, 0x21, 0x89, 0x78,
	0xc5, 0xf9, 0x50, 0xc9, 0x33, 0x4d, 0x83, 0x29, 0x0c, 0xf6, 0xf8, 0x76, 0xdc, 0x68, 0xd0, 0x8e,
	0xdc, 0x6b, 0xbe, 0x41, 0xd3, 0xb8, 0x40, 0x05, 0x4d, 0xf7, 0x9a, 0x6e, 0xf0, 0x2d, 0xa6, 0xa4,
	0x59, 0x59, 0xcc, 0x18, 0x50, 0x19, 0x0d, 0xcc, 0x70, 0xde, 0xd6, 0x2f, 0xce, 0x7a, 0x6e, 0xdc,
	0x1f, 0x77, 0xb4, 0xae, 0x3f, 0x2a, 0xf3, 0x34, 0x3d, 0xe7, 0x7f, 0x0e, 0x7a, 0xfe, 0xf3, 0x1e,
	0xf1, 0xd8, 0xe4, 0x97, 0x3f, 0xfe, 0xaf, 0xe1, 0xcd, 0xe2, 0xd4, 0xc9, 0x31, 0xc0, 0xcb, 0x7f,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x73, 0x22, 0xb2, 0x58, 0x15, 0x0d, 0x00, 0x00,
}
