// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/clickhouse/v1/cluster_service.proto

package clickhouse // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1/config"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ListClusterLogsRequest_ServiceType int32

const (
	ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED ListClusterLogsRequest_ServiceType = 0
	// Logs of ClickHouse activity.
	ListClusterLogsRequest_CLICKHOUSE ListClusterLogsRequest_ServiceType = 1
)

var ListClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "CLICKHOUSE",
}
var ListClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"CLICKHOUSE":               1,
}

func (x ListClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(ListClusterLogsRequest_ServiceType_name, int32(x))
}
func (ListClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{20, 0}
}

type GetClusterRequest struct {
	// ID of the ClickHouse Cluster resource to return.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{0}
}
func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (dst *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(dst, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list ClickHouse clusters in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only use filtering with the [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 1-63 characters long and match the regular expression `^[a-zA-Z0-9_-]+$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{1}
}
func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (dst *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(dst, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of ClickHouse Cluster resources.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{2}
}
func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (dst *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(dst, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateClusterRequest struct {
	// ID of the folder to create the ClickHouse cluster in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the ClickHouse cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the ClickHouse cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the ClickHouse cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the ClickHouse cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration and resources for hosts that should be created for the ClickHouse cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Descriptions of databases to be created in the ClickHouse cluster.
	DatabaseSpecs []*DatabaseSpec `protobuf:"bytes,7,rep,name=database_specs,json=databaseSpecs,proto3" json:"database_specs,omitempty"`
	// Descriptions of database users to be created in the ClickHouse cluster.
	UserSpecs []*UserSpec `protobuf:"bytes,8,rep,name=user_specs,json=userSpecs,proto3" json:"user_specs,omitempty"`
	// Individual configurations for hosts that should be created for the ClickHouse cluster.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the cluster in.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Name of the first shard in cluster. If not set, it defaults to the value 'shard1'.
	ShardName            string   `protobuf:"bytes,11,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{3}
}
func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (dst *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(dst, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *CreateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetDatabaseSpecs() []*DatabaseSpec {
	if m != nil {
		return m.DatabaseSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetUserSpecs() []*UserSpec {
	if m != nil {
		return m.UserSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CreateClusterRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the ClickHouse cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{4}
}
func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(dst, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the ClickHouse Cluster resource to update.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which fields of the ClickHouse Cluster resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description of the ClickHouse cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the ClickHouse cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	//
	// The new set of labels will completely replace the old ones. To add a label, request the current
	// set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// New configuration and resources for hosts in the cluster.
	ConfigSpec           *ConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{5}
}
func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(dst, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type UpdateClusterMetadata struct {
	// ID of the ClickHouse Cluster resource that is being updated.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{6}
}
func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(dst, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the ClickHouse cluster to delete.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{7}
}
func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(dst, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterMetadata struct {
	// ID of the ClickHouse cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{8}
}
func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(dst, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterRequest struct {
	// Required. ID of the ClickHouse cluster to start.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{9}
}
func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (dst *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(dst, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// Required. ID of the ClickHouse cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{10}
}
func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(dst, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// Required. ID of the ClickHouse cluster to stop.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{11}
}
func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (dst *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(dst, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterMetadata struct {
	// Required. ID of the ClickHouse cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{12}
}
func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(dst, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type MoveClusterRequest struct {
	// ID of the ClickHouse cluster to move.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterRequest) Reset()         { *m = MoveClusterRequest{} }
func (m *MoveClusterRequest) String() string { return proto.CompactTextString(m) }
func (*MoveClusterRequest) ProtoMessage()    {}
func (*MoveClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{13}
}
func (m *MoveClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterRequest.Unmarshal(m, b)
}
func (m *MoveClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterRequest.Marshal(b, m, deterministic)
}
func (dst *MoveClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterRequest.Merge(dst, src)
}
func (m *MoveClusterRequest) XXX_Size() int {
	return xxx_messageInfo_MoveClusterRequest.Size(m)
}
func (m *MoveClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterRequest proto.InternalMessageInfo

func (m *MoveClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveClusterMetadata struct {
	// ID of the ClickHouse cluster being moved.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// ID of the destnation folder.
	DestinationFolderId  string   `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterMetadata) Reset()         { *m = MoveClusterMetadata{} }
func (m *MoveClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveClusterMetadata) ProtoMessage()    {}
func (*MoveClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{14}
}
func (m *MoveClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterMetadata.Unmarshal(m, b)
}
func (m *MoveClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *MoveClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterMetadata.Merge(dst, src)
}
func (m *MoveClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveClusterMetadata.Size(m)
}
func (m *MoveClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterMetadata proto.InternalMessageInfo

func (m *MoveClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterMetadata) GetSourceFolderId() string {
	if m != nil {
		return m.SourceFolderId
	}
	return ""
}

func (m *MoveClusterMetadata) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type BackupClusterRequest struct {
	// ID of the ClickHouse cluster to back up.
	// To get the ClickHouse cluster ID use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterRequest) Reset()         { *m = BackupClusterRequest{} }
func (m *BackupClusterRequest) String() string { return proto.CompactTextString(m) }
func (*BackupClusterRequest) ProtoMessage()    {}
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{15}
}
func (m *BackupClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterRequest.Unmarshal(m, b)
}
func (m *BackupClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterRequest.Marshal(b, m, deterministic)
}
func (dst *BackupClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterRequest.Merge(dst, src)
}
func (m *BackupClusterRequest) XXX_Size() int {
	return xxx_messageInfo_BackupClusterRequest.Size(m)
}
func (m *BackupClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterRequest proto.InternalMessageInfo

func (m *BackupClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterMetadata struct {
	// ID of the ClickHouse cluster that is being backed up.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterMetadata) Reset()         { *m = BackupClusterMetadata{} }
func (m *BackupClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*BackupClusterMetadata) ProtoMessage()    {}
func (*BackupClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{16}
}
func (m *BackupClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterMetadata.Unmarshal(m, b)
}
func (m *BackupClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *BackupClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterMetadata.Merge(dst, src)
}
func (m *BackupClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_BackupClusterMetadata.Size(m)
}
func (m *BackupClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterMetadata proto.InternalMessageInfo

func (m *BackupClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type RestoreClusterRequest struct {
	// ID of the backup to create a cluster from.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Name of the new ClickHouse cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the new ClickHouse cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the ClickHouse cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the new ClickHouse cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration for the ClickHouse cluster to be created.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Configurations for ClickHouse hosts that should be created for
	// the cluster that is being created from the backup.
	HostSpecs []*HostSpec `protobuf:"bytes,7,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the ClickHouse cluster in.
	NetworkId            string   `protobuf:"bytes,8,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterRequest) Reset()         { *m = RestoreClusterRequest{} }
func (m *RestoreClusterRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest) ProtoMessage()    {}
func (*RestoreClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{17}
}
func (m *RestoreClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest.Unmarshal(m, b)
}
func (m *RestoreClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest.Marshal(b, m, deterministic)
}
func (dst *RestoreClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest.Merge(dst, src)
}
func (m *RestoreClusterRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest.Size(m)
}
func (m *RestoreClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest proto.InternalMessageInfo

func (m *RestoreClusterRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *RestoreClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RestoreClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RestoreClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *RestoreClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *RestoreClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *RestoreClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *RestoreClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type RestoreClusterMetadata struct {
	// ID of the new ClickHouse cluster that is being created from a backup.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the backup that is being used for creating a cluster.
	BackupId             string   `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterMetadata) Reset()         { *m = RestoreClusterMetadata{} }
func (m *RestoreClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterMetadata) ProtoMessage()    {}
func (*RestoreClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{18}
}
func (m *RestoreClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterMetadata.Unmarshal(m, b)
}
func (m *RestoreClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterMetadata.Marshal(b, m, deterministic)
}
func (dst *RestoreClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterMetadata.Merge(dst, src)
}
func (m *RestoreClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterMetadata.Size(m)
}
func (m *RestoreClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterMetadata proto.InternalMessageInfo

func (m *RestoreClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestoreClusterMetadata) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type LogRecord struct {
	// Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contents of the log record.
	Message              map[string]string `protobuf:"bytes,2,rep,name=message,proto3" json:"message,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{19}
}
func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (dst *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(dst, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() map[string]string {
	if m != nil {
		return m.Message
	}
	return nil
}

type ListClusterLogsRequest struct {
	// ID of the ClickHouse cluster to request logs for.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from logs table to request.
	// If no columns are specified, entire log records are returned.
	ColumnFilter []string `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	// Type of the service to request logs about.
	ServiceType ListClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.clickhouse.v1.ListClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ToTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterLogsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsRequest) Reset()         { *m = ListClusterLogsRequest{} }
func (m *ListClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsRequest) ProtoMessage()    {}
func (*ListClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{20}
}
func (m *ListClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsRequest.Unmarshal(m, b)
}
func (m *ListClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsRequest.Merge(dst, src)
}
func (m *ListClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsRequest.Size(m)
}
func (m *ListClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsRequest proto.InternalMessageInfo

func (m *ListClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *ListClusterLogsRequest) GetServiceType() ListClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *ListClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterLogsResponse struct {
	// Requested log records.
	Logs []*LogRecord `protobuf:"bytes,1,rep,name=logs,proto3" json:"logs,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsResponse) Reset()         { *m = ListClusterLogsResponse{} }
func (m *ListClusterLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsResponse) ProtoMessage()    {}
func (*ListClusterLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{21}
}
func (m *ListClusterLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsResponse.Unmarshal(m, b)
}
func (m *ListClusterLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsResponse.Merge(dst, src)
}
func (m *ListClusterLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsResponse.Size(m)
}
func (m *ListClusterLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsResponse proto.InternalMessageInfo

func (m *ListClusterLogsResponse) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *ListClusterLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterOperationsRequest struct {
	// ID of the ClickHouse Cluster resource to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{22}
}
func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(dst, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of Operation resources for the specified ClickHouse cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{23}
}
func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(dst, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterBackupsRequest struct {
	// ID of the ClickHouse cluster.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterBackupsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsRequest) Reset()         { *m = ListClusterBackupsRequest{} }
func (m *ListClusterBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsRequest) ProtoMessage()    {}
func (*ListClusterBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{24}
}
func (m *ListClusterBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsRequest.Unmarshal(m, b)
}
func (m *ListClusterBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsRequest.Merge(dst, src)
}
func (m *ListClusterBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsRequest.Size(m)
}
func (m *ListClusterBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsRequest proto.InternalMessageInfo

func (m *ListClusterBackupsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterBackupsResponse struct {
	// List of ClickHouse Backup resources.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsResponse) Reset()         { *m = ListClusterBackupsResponse{} }
func (m *ListClusterBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsResponse) ProtoMessage()    {}
func (*ListClusterBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{25}
}
func (m *ListClusterBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsResponse.Unmarshal(m, b)
}
func (m *ListClusterBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsResponse.Merge(dst, src)
}
func (m *ListClusterBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsResponse.Size(m)
}
func (m *ListClusterBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsResponse proto.InternalMessageInfo

func (m *ListClusterBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListClusterBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the ClickHouse cluster.
	// To get the ClickHouse cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{26}
}
func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(dst, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterHostsResponse struct {
	// Requested list of hosts for the cluster.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{27}
}
func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(dst, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterHostsRequest struct {
	// ID of the ClickHouse cluster to add hosts to.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configurations for ClickHouse hosts that should be added to the cluster.
	HostSpecs            []*HostSpec `protobuf:"bytes,2,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterHostsRequest) Reset()         { *m = AddClusterHostsRequest{} }
func (m *AddClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsRequest) ProtoMessage()    {}
func (*AddClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{28}
}
func (m *AddClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsRequest.Unmarshal(m, b)
}
func (m *AddClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *AddClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsRequest.Merge(dst, src)
}
func (m *AddClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsRequest.Size(m)
}
func (m *AddClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsRequest proto.InternalMessageInfo

func (m *AddClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterHostsMetadata struct {
	// ID of the ClickHouse cluster to which the hosts are being added.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being added to the cluster.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterHostsMetadata) Reset()         { *m = AddClusterHostsMetadata{} }
func (m *AddClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsMetadata) ProtoMessage()    {}
func (*AddClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{29}
}
func (m *AddClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsMetadata.Unmarshal(m, b)
}
func (m *AddClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (dst *AddClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsMetadata.Merge(dst, src)
}
func (m *AddClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsMetadata.Size(m)
}
func (m *AddClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsMetadata proto.InternalMessageInfo

func (m *AddClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsRequest struct {
	// ID of the ClickHouse cluster to remove hosts from.
	// To get the ClickHouse cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts to delete.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsRequest) Reset()         { *m = DeleteClusterHostsRequest{} }
func (m *DeleteClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsRequest) ProtoMessage()    {}
func (*DeleteClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{30}
}
func (m *DeleteClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsRequest.Unmarshal(m, b)
}
func (m *DeleteClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsRequest.Merge(dst, src)
}
func (m *DeleteClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsRequest.Size(m)
}
func (m *DeleteClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsRequest proto.InternalMessageInfo

func (m *DeleteClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsMetadata struct {
	// ID of the ClickHouse cluster to remove hosts from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being deleted.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsMetadata) Reset()         { *m = DeleteClusterHostsMetadata{} }
func (m *DeleteClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsMetadata) ProtoMessage()    {}
func (*DeleteClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{31}
}
func (m *DeleteClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsMetadata.Merge(dst, src)
}
func (m *DeleteClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Size(m)
}
func (m *DeleteClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsMetadata proto.InternalMessageInfo

func (m *DeleteClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type GetClusterShardRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterShardRequest) Reset()         { *m = GetClusterShardRequest{} }
func (m *GetClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterShardRequest) ProtoMessage()    {}
func (*GetClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{32}
}
func (m *GetClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterShardRequest.Unmarshal(m, b)
}
func (m *GetClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterShardRequest.Marshal(b, m, deterministic)
}
func (dst *GetClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterShardRequest.Merge(dst, src)
}
func (m *GetClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterShardRequest.Size(m)
}
func (m *GetClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterShardRequest proto.InternalMessageInfo

func (m *GetClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type ListClusterShardsRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize             int64    `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterShardsRequest) Reset()         { *m = ListClusterShardsRequest{} }
func (m *ListClusterShardsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterShardsRequest) ProtoMessage()    {}
func (*ListClusterShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{33}
}
func (m *ListClusterShardsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterShardsRequest.Unmarshal(m, b)
}
func (m *ListClusterShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterShardsRequest.Marshal(b, m, deterministic)
}
func (dst *ListClusterShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterShardsRequest.Merge(dst, src)
}
func (m *ListClusterShardsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterShardsRequest.Size(m)
}
func (m *ListClusterShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterShardsRequest proto.InternalMessageInfo

func (m *ListClusterShardsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterShardsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterShardsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterShardsResponse struct {
	Shards               []*Shard `protobuf:"bytes,1,rep,name=shards,proto3" json:"shards,omitempty"`
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterShardsResponse) Reset()         { *m = ListClusterShardsResponse{} }
func (m *ListClusterShardsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterShardsResponse) ProtoMessage()    {}
func (*ListClusterShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{34}
}
func (m *ListClusterShardsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterShardsResponse.Unmarshal(m, b)
}
func (m *ListClusterShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterShardsResponse.Marshal(b, m, deterministic)
}
func (dst *ListClusterShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterShardsResponse.Merge(dst, src)
}
func (m *ListClusterShardsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterShardsResponse.Size(m)
}
func (m *ListClusterShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterShardsResponse proto.InternalMessageInfo

func (m *ListClusterShardsResponse) GetShards() []*Shard {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *ListClusterShardsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterShardRequest struct {
	ClusterId            string           `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string           `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	ConfigSpec           *ShardConfigSpec `protobuf:"bytes,3,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	HostSpecs            []*HostSpec      `protobuf:"bytes,4,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AddClusterShardRequest) Reset()         { *m = AddClusterShardRequest{} }
func (m *AddClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterShardRequest) ProtoMessage()    {}
func (*AddClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{35}
}
func (m *AddClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterShardRequest.Unmarshal(m, b)
}
func (m *AddClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterShardRequest.Marshal(b, m, deterministic)
}
func (dst *AddClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterShardRequest.Merge(dst, src)
}
func (m *AddClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterShardRequest.Size(m)
}
func (m *AddClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterShardRequest proto.InternalMessageInfo

func (m *AddClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *AddClusterShardRequest) GetConfigSpec() *ShardConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *AddClusterShardRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterShardMetadata struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterShardMetadata) Reset()         { *m = AddClusterShardMetadata{} }
func (m *AddClusterShardMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterShardMetadata) ProtoMessage()    {}
func (*AddClusterShardMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{36}
}
func (m *AddClusterShardMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterShardMetadata.Unmarshal(m, b)
}
func (m *AddClusterShardMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterShardMetadata.Marshal(b, m, deterministic)
}
func (dst *AddClusterShardMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterShardMetadata.Merge(dst, src)
}
func (m *AddClusterShardMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterShardMetadata.Size(m)
}
func (m *AddClusterShardMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterShardMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterShardMetadata proto.InternalMessageInfo

func (m *AddClusterShardMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterShardMetadata) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type UpdateClusterShardRequest struct {
	ClusterId            string                `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string                `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	ConfigSpec           *ShardConfigSpec      `protobuf:"bytes,4,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateClusterShardRequest) Reset()         { *m = UpdateClusterShardRequest{} }
func (m *UpdateClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterShardRequest) ProtoMessage()    {}
func (*UpdateClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{37}
}
func (m *UpdateClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterShardRequest.Unmarshal(m, b)
}
func (m *UpdateClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterShardRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterShardRequest.Merge(dst, src)
}
func (m *UpdateClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterShardRequest.Size(m)
}
func (m *UpdateClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterShardRequest proto.InternalMessageInfo

func (m *UpdateClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *UpdateClusterShardRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterShardRequest) GetConfigSpec() *ShardConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type UpdateClusterShardMetadata struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterShardMetadata) Reset()         { *m = UpdateClusterShardMetadata{} }
func (m *UpdateClusterShardMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterShardMetadata) ProtoMessage()    {}
func (*UpdateClusterShardMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{38}
}
func (m *UpdateClusterShardMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterShardMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterShardMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterShardMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateClusterShardMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterShardMetadata.Merge(dst, src)
}
func (m *UpdateClusterShardMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterShardMetadata.Size(m)
}
func (m *UpdateClusterShardMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterShardMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterShardMetadata proto.InternalMessageInfo

func (m *UpdateClusterShardMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterShardMetadata) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type DeleteClusterShardRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterShardRequest) Reset()         { *m = DeleteClusterShardRequest{} }
func (m *DeleteClusterShardRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterShardRequest) ProtoMessage()    {}
func (*DeleteClusterShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{39}
}
func (m *DeleteClusterShardRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterShardRequest.Unmarshal(m, b)
}
func (m *DeleteClusterShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterShardRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterShardRequest.Merge(dst, src)
}
func (m *DeleteClusterShardRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterShardRequest.Size(m)
}
func (m *DeleteClusterShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterShardRequest proto.InternalMessageInfo

func (m *DeleteClusterShardRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterShardRequest) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type DeleteClusterShardMetadata struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ShardName            string   `protobuf:"bytes,2,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterShardMetadata) Reset()         { *m = DeleteClusterShardMetadata{} }
func (m *DeleteClusterShardMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterShardMetadata) ProtoMessage()    {}
func (*DeleteClusterShardMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{40}
}
func (m *DeleteClusterShardMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterShardMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterShardMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterShardMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteClusterShardMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterShardMetadata.Merge(dst, src)
}
func (m *DeleteClusterShardMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterShardMetadata.Size(m)
}
func (m *DeleteClusterShardMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterShardMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterShardMetadata proto.InternalMessageInfo

func (m *DeleteClusterShardMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterShardMetadata) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type HostSpec struct {
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Type of the host to be deployed.
	Type Host_Type `protobuf:"varint,2,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Type" json:"type,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The ID of the network is set in the [Cluster.network_id] field.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false — don't assign a public IP to the host.
	// * true — the host should have a public IP address.
	AssignPublicIp       bool     `protobuf:"varint,4,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ShardName            string   `protobuf:"bytes,5,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostSpec) Reset()         { *m = HostSpec{} }
func (m *HostSpec) String() string { return proto.CompactTextString(m) }
func (*HostSpec) ProtoMessage()    {}
func (*HostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{41}
}
func (m *HostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostSpec.Unmarshal(m, b)
}
func (m *HostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostSpec.Marshal(b, m, deterministic)
}
func (dst *HostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostSpec.Merge(dst, src)
}
func (m *HostSpec) XXX_Size() int {
	return xxx_messageInfo_HostSpec.Size(m)
}
func (m *HostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HostSpec proto.InternalMessageInfo

func (m *HostSpec) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *HostSpec) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (m *HostSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *HostSpec) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *HostSpec) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type ConfigSpec struct {
	// Version of the ClickHouse server software.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resources for a ClickHouse server.
	Clickhouse *ConfigSpec_Clickhouse `protobuf:"bytes,1,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	// Configuration and resources for a ZooKeeper server.
	Zookeeper *ConfigSpec_Zookeeper `protobuf:"bytes,2,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// Start time for the daily backup in UTC timezone
	BackupWindowStart    *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ConfigSpec) Reset()         { *m = ConfigSpec{} }
func (m *ConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec) ProtoMessage()    {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{42}
}
func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec.Unmarshal(m, b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
}
func (dst *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(dst, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec.Size(m)
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func (m *ConfigSpec) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ConfigSpec) GetClickhouse() *ConfigSpec_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

func (m *ConfigSpec) GetZookeeper() *ConfigSpec_Zookeeper {
	if m != nil {
		return m.Zookeeper
	}
	return nil
}

func (m *ConfigSpec) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

type ConfigSpec_Clickhouse struct {
	// Configuration for a ClickHouse server.
	Config *config.ClickhouseConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to ClickHouse hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ConfigSpec_Clickhouse) Reset()         { *m = ConfigSpec_Clickhouse{} }
func (m *ConfigSpec_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec_Clickhouse) ProtoMessage()    {}
func (*ConfigSpec_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{42, 0}
}
func (m *ConfigSpec_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec_Clickhouse.Unmarshal(m, b)
}
func (m *ConfigSpec_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec_Clickhouse.Marshal(b, m, deterministic)
}
func (dst *ConfigSpec_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec_Clickhouse.Merge(dst, src)
}
func (m *ConfigSpec_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec_Clickhouse.Size(m)
}
func (m *ConfigSpec_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec_Clickhouse proto.InternalMessageInfo

func (m *ConfigSpec_Clickhouse) GetConfig() *config.ClickhouseConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ConfigSpec_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type ConfigSpec_Zookeeper struct {
	// Resources allocated to ZooKeeper hosts. If not set, minimal available resources will be used.
	Resources            *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ConfigSpec_Zookeeper) Reset()         { *m = ConfigSpec_Zookeeper{} }
func (m *ConfigSpec_Zookeeper) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec_Zookeeper) ProtoMessage()    {}
func (*ConfigSpec_Zookeeper) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{42, 1}
}
func (m *ConfigSpec_Zookeeper) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec_Zookeeper.Unmarshal(m, b)
}
func (m *ConfigSpec_Zookeeper) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec_Zookeeper.Marshal(b, m, deterministic)
}
func (dst *ConfigSpec_Zookeeper) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec_Zookeeper.Merge(dst, src)
}
func (m *ConfigSpec_Zookeeper) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec_Zookeeper.Size(m)
}
func (m *ConfigSpec_Zookeeper) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec_Zookeeper.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec_Zookeeper proto.InternalMessageInfo

func (m *ConfigSpec_Zookeeper) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type ShardConfigSpec struct {
	Clickhouse           *ShardConfigSpec_Clickhouse `protobuf:"bytes,1,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ShardConfigSpec) Reset()         { *m = ShardConfigSpec{} }
func (m *ShardConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ShardConfigSpec) ProtoMessage()    {}
func (*ShardConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{43}
}
func (m *ShardConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfigSpec.Unmarshal(m, b)
}
func (m *ShardConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfigSpec.Marshal(b, m, deterministic)
}
func (dst *ShardConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfigSpec.Merge(dst, src)
}
func (m *ShardConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ShardConfigSpec.Size(m)
}
func (m *ShardConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfigSpec proto.InternalMessageInfo

func (m *ShardConfigSpec) GetClickhouse() *ShardConfigSpec_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

type ShardConfigSpec_Clickhouse struct {
	Config               *config.ClickhouseConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Resources            *Resources               `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	Weight               *wrappers.Int64Value     `protobuf:"bytes,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ShardConfigSpec_Clickhouse) Reset()         { *m = ShardConfigSpec_Clickhouse{} }
func (m *ShardConfigSpec_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ShardConfigSpec_Clickhouse) ProtoMessage()    {}
func (*ShardConfigSpec_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cluster_service_92dc4355161406f9, []int{43, 0}
}
func (m *ShardConfigSpec_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfigSpec_Clickhouse.Unmarshal(m, b)
}
func (m *ShardConfigSpec_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfigSpec_Clickhouse.Marshal(b, m, deterministic)
}
func (dst *ShardConfigSpec_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfigSpec_Clickhouse.Merge(dst, src)
}
func (m *ShardConfigSpec_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ShardConfigSpec_Clickhouse.Size(m)
}
func (m *ShardConfigSpec_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfigSpec_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfigSpec_Clickhouse proto.InternalMessageInfo

func (m *ShardConfigSpec_Clickhouse) GetConfig() *config.ClickhouseConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ShardConfigSpec_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ShardConfigSpec_Clickhouse) GetWeight() *wrappers.Int64Value {
	if m != nil {
		return m.Weight
	}
	return nil
}

func init() {
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClustersResponse")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.StopClusterMetadata")
	proto.RegisterType((*MoveClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.MoveClusterRequest")
	proto.RegisterType((*MoveClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.MoveClusterMetadata")
	proto.RegisterType((*BackupClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.BackupClusterRequest")
	proto.RegisterType((*BackupClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.BackupClusterMetadata")
	proto.RegisterType((*RestoreClusterRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.RestoreClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.RestoreClusterRequest.LabelsEntry")
	proto.RegisterType((*RestoreClusterMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.RestoreClusterMetadata")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.mdb.clickhouse.v1.LogRecord")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.LogRecord.MessageEntry")
	proto.RegisterType((*ListClusterLogsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterLogsRequest")
	proto.RegisterType((*ListClusterLogsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterLogsResponse")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterBackupsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterBackupsRequest")
	proto.RegisterType((*ListClusterBackupsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterBackupsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterHostsResponse")
	proto.RegisterType((*AddClusterHostsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.AddClusterHostsRequest")
	proto.RegisterType((*AddClusterHostsMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.AddClusterHostsMetadata")
	proto.RegisterType((*DeleteClusterHostsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterHostsRequest")
	proto.RegisterType((*DeleteClusterHostsMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterHostsMetadata")
	proto.RegisterType((*GetClusterShardRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.GetClusterShardRequest")
	proto.RegisterType((*ListClusterShardsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterShardsRequest")
	proto.RegisterType((*ListClusterShardsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListClusterShardsResponse")
	proto.RegisterType((*AddClusterShardRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.AddClusterShardRequest")
	proto.RegisterType((*AddClusterShardMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.AddClusterShardMetadata")
	proto.RegisterType((*UpdateClusterShardRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateClusterShardRequest")
	proto.RegisterType((*UpdateClusterShardMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateClusterShardMetadata")
	proto.RegisterType((*DeleteClusterShardRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterShardRequest")
	proto.RegisterType((*DeleteClusterShardMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteClusterShardMetadata")
	proto.RegisterType((*HostSpec)(nil), "yandex.cloud.mdb.clickhouse.v1.HostSpec")
	proto.RegisterType((*ConfigSpec)(nil), "yandex.cloud.mdb.clickhouse.v1.ConfigSpec")
	proto.RegisterType((*ConfigSpec_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ConfigSpec.Clickhouse")
	proto.RegisterType((*ConfigSpec_Zookeeper)(nil), "yandex.cloud.mdb.clickhouse.v1.ConfigSpec.Zookeeper")
	proto.RegisterType((*ShardConfigSpec)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfigSpec")
	proto.RegisterType((*ShardConfigSpec_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfigSpec.Clickhouse")
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.ListClusterLogsRequest_ServiceType", ListClusterLogsRequest_ServiceType_name, ListClusterLogsRequest_ServiceType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified ClickHouse Cluster resource.
	//
	// To get the list of available ClickHouse Cluster resources, make a [List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves a list of ClickHouse Cluster resources that belong
	// to the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a ClickHouse cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified ClickHouse cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified ClickHouse cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start the specified ClickHouse cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stop the specified ClickHouse cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Moves the specified ClickHouse cluster to the specified folder.
	Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a backup for the specified ClickHouse cluster.
	Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a new ClickHouse cluster using the specified backup.
	Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves logs for the specified ClickHouse cluster.
	// For more information about logs, see the [Logs](/docs/yandex-mdb-guide/concepts/logs) section in the Developer's Guide.
	ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified ClickHouse cluster.
	ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified shard.
	GetShard(ctx context.Context, in *GetClusterShardRequest, opts ...grpc.CallOption) (*Shard, error)
	// Retrieves a list of shards.
	ListShards(ctx context.Context, in *ListClusterShardsRequest, opts ...grpc.CallOption) (*ListClusterShardsResponse, error)
	// Creates a new shard.
	AddShard(ctx context.Context, in *AddClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Modifies the specified shard.
	UpdateShard(ctx context.Context, in *UpdateClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified shard.
	DeleteShard(ctx context.Context, in *DeleteClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type clusterServiceClient struct {
	cc *grpc.ClientConn
}

func NewClusterServiceClient(cc *grpc.ClientConn) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Backup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error) {
	out := new(ListClusterLogsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error) {
	out := new(ListClusterBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/AddHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/DeleteHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) GetShard(ctx context.Context, in *GetClusterShardRequest, opts ...grpc.CallOption) (*Shard, error) {
	out := new(Shard)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/GetShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListShards(ctx context.Context, in *ListClusterShardsRequest, opts ...grpc.CallOption) (*ListClusterShardsResponse, error) {
	out := new(ListClusterShardsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListShards", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddShard(ctx context.Context, in *AddClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/AddShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) UpdateShard(ctx context.Context, in *UpdateClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/UpdateShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteShard(ctx context.Context, in *DeleteClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.ClusterService/DeleteShard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified ClickHouse Cluster resource.
	//
	// To get the list of available ClickHouse Cluster resources, make a [List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves a list of ClickHouse Cluster resources that belong
	// to the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a ClickHouse cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Updates the specified ClickHouse cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified ClickHouse cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Start the specified ClickHouse cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stop the specified ClickHouse cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Moves the specified ClickHouse cluster to the specified folder.
	Move(context.Context, *MoveClusterRequest) (*operation.Operation, error)
	// Creates a backup for the specified ClickHouse cluster.
	Backup(context.Context, *BackupClusterRequest) (*operation.Operation, error)
	// Creates a new ClickHouse cluster using the specified backup.
	Restore(context.Context, *RestoreClusterRequest) (*operation.Operation, error)
	// Retrieves logs for the specified ClickHouse cluster.
	// For more information about logs, see the [Logs](/docs/yandex-mdb-guide/concepts/logs) section in the Developer's Guide.
	ListLogs(context.Context, *ListClusterLogsRequest) (*ListClusterLogsResponse, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified ClickHouse cluster.
	ListBackups(context.Context, *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(context.Context, *AddClusterHostsRequest) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(context.Context, *DeleteClusterHostsRequest) (*operation.Operation, error)
	// Returns the specified shard.
	GetShard(context.Context, *GetClusterShardRequest) (*Shard, error)
	// Retrieves a list of shards.
	ListShards(context.Context, *ListClusterShardsRequest) (*ListClusterShardsResponse, error)
	// Creates a new shard.
	AddShard(context.Context, *AddClusterShardRequest) (*operation.Operation, error)
	// Modifies the specified shard.
	UpdateShard(context.Context, *UpdateClusterShardRequest) (*operation.Operation, error)
	// Deletes the specified shard.
	DeleteShard(context.Context, *DeleteClusterShardRequest) (*operation.Operation, error)
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Move(ctx, req.(*MoveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Backup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Backup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Backup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Backup(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Restore(ctx, req.(*RestoreClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListLogs(ctx, req.(*ListClusterLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListBackups(ctx, req.(*ListClusterBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/AddHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddHosts(ctx, req.(*AddClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/DeleteHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, req.(*DeleteClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_GetShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).GetShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/GetShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).GetShard(ctx, req.(*GetClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListShards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterShardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListShards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/ListShards",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListShards(ctx, req.(*ListClusterShardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/AddShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddShard(ctx, req.(*AddClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_UpdateShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).UpdateShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/UpdateShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).UpdateShard(ctx, req.(*UpdateClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteShard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterShardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteShard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.ClusterService/DeleteShard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteShard(ctx, req.(*DeleteClusterShardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.clickhouse.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _ClusterService_Move_Handler,
		},
		{
			MethodName: "Backup",
			Handler:    _ClusterService_Backup_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ClusterService_Restore_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _ClusterService_ListLogs_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _ClusterService_ListBackups_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
		{
			MethodName: "AddHosts",
			Handler:    _ClusterService_AddHosts_Handler,
		},
		{
			MethodName: "DeleteHosts",
			Handler:    _ClusterService_DeleteHosts_Handler,
		},
		{
			MethodName: "GetShard",
			Handler:    _ClusterService_GetShard_Handler,
		},
		{
			MethodName: "ListShards",
			Handler:    _ClusterService_ListShards_Handler,
		},
		{
			MethodName: "AddShard",
			Handler:    _ClusterService_AddShard_Handler,
		},
		{
			MethodName: "UpdateShard",
			Handler:    _ClusterService_UpdateShard_Handler,
		},
		{
			MethodName: "DeleteShard",
			Handler:    _ClusterService_DeleteShard_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/clickhouse/v1/cluster_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/clickhouse/v1/cluster_service.proto", fileDescriptor_cluster_service_92dc4355161406f9)
}

var fileDescriptor_cluster_service_92dc4355161406f9 = []byte{
	// 2724 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5b, 0x4d, 0x6c, 0x1b, 0xc7,
	0xf5, 0xff, 0xaf, 0x44, 0x51, 0xe4, 0xa3, 0xa3, 0x38, 0x63, 0xd9, 0x61, 0x98, 0xd8, 0x91, 0x37,
	0x1f, 0x96, 0x19, 0x93, 0x14, 0xa9, 0x0f, 0x5b, 0xb2, 0x9d, 0x58, 0xa4, 0x25, 0x47, 0x88, 0x64,
	0xe9, 0xbf, 0x92, 0x13, 0xd4, 0x86, 0x41, 0x2c, 0xb9, 0x23, 0x8a, 0x10, 0xc9, 0x65, 0x77, 0x97,
	0x72, 0xa4, 0x20, 0x6d, 0xe0, 0x14, 0x2d, 0xe0, 0x53, 0xd1, 0x02, 0x69, 0x93, 0x02, 0x05, 0x7a,
	0x69, 0xcf, 0x55, 0x81, 0x16, 0x08, 0x8a, 0x14, 0xc8, 0xc5, 0x2e, 0x0a, 0xb4, 0xa8, 0x72, 0xec,
	0xa1, 0x97, 0x1c, 0x7a, 0x28, 0x7a, 0xc8, 0xb1, 0x87, 0xa2, 0x98, 0x8f, 0x25, 0x77, 0xc9, 0xa5,
	0x76, 0x97, 0x94, 0xeb, 0x14, 0xe8, 0x4d, 0xdc, 0x99, 0xf7, 0xe6, 0xf7, 0x7b, 0xf3, 0x3e, 0x66,
	0xde, 0xd8, 0x30, 0xb5, 0x2b, 0xd7, 0x14, 0xfc, 0x6e, 0xaa, 0x58, 0x51, 0x1b, 0x4a, 0xaa, 0xaa,
	0x14, 0x52, 0xc5, 0x4a, 0xb9, 0xb8, 0xbd, 0xa5, 0x36, 0x74, 0x9c, 0xda, 0x49, 0xa7, 0x8a, 0x95,
	0x86, 0x6e, 0x60, 0x2d, 0xaf, 0x63, 0x6d, 0xa7, 0x5c, 0xc4, 0xc9, 0xba, 0xa6, 0x1a, 0x2a, 0x3a,
	0xc3, 0xa4, 0x92, 0x54, 0x2a, 0x59, 0x55, 0x0a, 0xc9, 0x96, 0x54, 0x72, 0x27, 0x1d, 0x7b, 0xa1,
	0xa4, 0xaa, 0xa5, 0x0a, 0x4e, 0xc9, 0xf5, 0x72, 0x4a, 0xae, 0xd5, 0x54, 0x43, 0x36, 0xca, 0x6a,
	0x4d, 0x67, 0xd2, 0xb1, 0x31, 0x3e, 0x4a, 0x7f, 0x15, 0x1a, 0x9b, 0xa9, 0xcd, 0x32, 0xae, 0x28,
	0xf9, 0xaa, 0xac, 0x6f, 0xf3, 0x19, 0x2f, 0xb6, 0xcf, 0x30, 0xca, 0x55, 0xac, 0x1b, 0x72, 0xb5,
	0xce, 0x27, 0x9c, 0x69, 0x9f, 0x70, 0x4f, 0x93, 0xeb, 0x75, 0xac, 0x99, 0x4b, 0x3c, 0xcf, 0xc7,
	0x8d, 0xdd, 0x3a, 0xa6, 0xc2, 0xea, 0xa6, 0x22, 0xef, 0xf2, 0xc1, 0x18, 0xe7, 0x4c, 0xd0, 0xa9,
	0x75, 0xac, 0x51, 0x70, 0x7c, 0xec, 0x55, 0x9b, 0x3d, 0x9a, 0xa3, 0x1d, 0xf3, 0x4e, 0xdb, 0xe6,
	0xed, 0xc8, 0x95, 0xb2, 0x62, 0x1d, 0x7e, 0xcd, 0xc5, 0xac, 0x05, 0xb9, 0xb8, 0xdd, 0x30, 0xc9,
	0x5c, 0xf0, 0xb6, 0x07, 0x7c, 0x76, 0xc2, 0x65, 0xb6, 0x22, 0x1b, 0x72, 0x41, 0xd6, 0xf9, 0x56,
	0xc5, 0xce, 0xbb, 0x4c, 0x6f, 0xe8, 0x4d, 0xcd, 0x33, 0x6e, 0x38, 0xd4, 0xda, 0x66, 0xb9, 0x64,
	0xf9, 0xc8, 0xe4, 0xc4, 0x6b, 0xf0, 0xcc, 0x0d, 0x6c, 0xe4, 0x18, 0x4a, 0x09, 0x7f, 0xb3, 0x81,
	0x75, 0x03, 0xbd, 0x06, 0x60, 0xfa, 0x4e, 0x59, 0x89, 0x0a, 0x63, 0xc2, 0x78, 0x38, 0x7b, 0xec,
	0x6f, 0x0f, 0xd3, 0xc2, 0x83, 0x47, 0xe9, 0xc0, 0x95, 0xab, 0xd3, 0x13, 0x52, 0x98, 0x8f, 0x2f,
	0x29, 0xe2, 0x6f, 0x04, 0x38, 0xb1, 0x5c, 0xd6, 0x4d, 0x1d, 0xba, 0xa9, 0xe4, 0x3c, 0x84, 0x37,
	0xd5, 0x8a, 0xd2, 0x5d, 0x47, 0x88, 0x0d, 0x2f, 0x29, 0xe8, 0x1c, 0x84, 0xeb, 0x72, 0x09, 0xe7,
	0xf5, 0xf2, 0x1e, 0x8e, 0x0e, 0x8c, 0x09, 0xe3, 0x83, 0x59, 0xf8, 0xe7, 0xc3, 0x74, 0xf0, 0xca,
	0xd5, 0xf4, 0xc4, 0xc4, 0x84, 0x14, 0x22, 0x83, 0xeb, 0xe5, 0x3d, 0x8c, 0xc6, 0x01, 0xe8, 0x44,
	0x43, 0xdd, 0xc6, 0xb5, 0xe8, 0x20, 0x55, 0x1a, 0x7e, 0xf0, 0x28, 0x3d, 0x44, 0x67, 0x4a, 0x54,
	0xcb, 0x06, 0x19, 0x43, 0x22, 0x04, 0x37, 0xcb, 0x15, 0x03, 0x6b, 0xd1, 0x00, 0x9d, 0x05, 0x0f,
	0x1e, 0x35, 0xf5, 0xf1, 0x11, 0xf1, 0x43, 0x01, 0x46, 0xed, 0xc8, 0xf5, 0xba, 0x5a, 0xd3, 0x31,
	0xca, 0x41, 0x88, 0xf3, 0xd3, 0xa3, 0xc2, 0xd8, 0xe0, 0x78, 0x24, 0x73, 0x2e, 0x79, 0x78, 0xd4,
	0x24, 0x4d, 0x0b, 0x36, 0x05, 0xd1, 0xab, 0xf0, 0x74, 0x0d, 0xbf, 0x6b, 0xe4, 0x2d, 0x80, 0x09,
	0xb5, 0xb0, 0xf4, 0x14, 0xf9, 0xbc, 0x66, 0x22, 0x15, 0xbf, 0x3f, 0x0c, 0xa3, 0x39, 0x0d, 0xcb,
	0x06, 0x6e, 0xdb, 0x05, 0x1f, 0x06, 0xcc, 0x40, 0xa0, 0x26, 0x57, 0x99, 0xed, 0xc2, 0xd9, 0x33,
	0x64, 0xd6, 0x57, 0x0f, 0xd3, 0x23, 0x77, 0xe4, 0xc4, 0xde, 0x7c, 0xe2, 0xf6, 0x44, 0x62, 0x36,
	0x9f, 0xb8, 0x1b, 0x67, 0x72, 0x33, 0x93, 0x12, 0x9d, 0x8b, 0x5e, 0x83, 0x88, 0x82, 0xf5, 0xa2,
	0x56, 0xae, 0x13, 0xdf, 0xb7, 0x1b, 0x33, 0x33, 0x3d, 0x23, 0x59, 0x47, 0xd1, 0xc7, 0x02, 0x04,
	0x2b, 0x72, 0x01, 0x57, 0xf4, 0x68, 0x80, 0x1a, 0xe4, 0x9a, 0xab, 0x41, 0x1c, 0x28, 0x25, 0x97,
	0xa9, 0x8a, 0x85, 0x9a, 0xa1, 0xed, 0x66, 0xdf, 0xf8, 0xea, 0x61, 0x3a, 0x72, 0x27, 0x91, 0x9f,
	0x48, 0xcc, 0xca, 0x89, 0xbd, 0xbb, 0xf1, 0xfb, 0x0c, 0xde, 0x94, 0x09, 0x73, 0xff, 0x51, 0x3a,
	0x18, 0x33, 0xff, 0x42, 0xe8, 0x38, 0x21, 0x73, 0xd7, 0x32, 0x5f, 0xe2, 0x80, 0xd0, 0x1d, 0x88,
	0xe0, 0xda, 0x4e, 0x59, 0x53, 0x6b, 0x55, 0x5c, 0x33, 0xa2, 0x43, 0x63, 0xc2, 0xf8, 0x48, 0x66,
	0xd2, 0xe3, 0x86, 0x25, 0x17, 0x5a, 0xa2, 0xd9, 0x00, 0x31, 0x9c, 0x64, 0xd5, 0x86, 0xfe, 0x1f,
	0x22, 0x2c, 0x74, 0xf2, 0x7a, 0x1d, 0x17, 0xa3, 0xc1, 0x31, 0x61, 0x3c, 0x92, 0x89, 0xbb, 0x2a,
	0xa7, 0x22, 0xeb, 0x75, 0x5c, 0xe4, 0x3a, 0xa1, 0xd8, 0xfc, 0x82, 0xee, 0xc0, 0x88, 0x19, 0xe7,
	0x54, 0xa9, 0x1e, 0x1d, 0xa6, 0x26, 0xbd, 0xe0, 0xa6, 0xf5, 0x3a, 0x97, 0xa2, 0x7a, 0x83, 0xf7,
	0x1f, 0xa5, 0x07, 0x5e, 0x9f, 0x90, 0x9e, 0x52, 0x2c, 0x5f, 0x75, 0xb4, 0x0a, 0x40, 0xb2, 0x02,
	0x57, 0x1c, 0xa2, 0x8a, 0xc7, 0xdd, 0x14, 0xdf, 0xd2, 0xb1, 0x66, 0x53, 0x1a, 0x6e, 0xf0, 0x2f,
	0x54, 0xe1, 0x96, 0xaa, 0x1b, 0x5c, 0x61, 0xd8, 0x9b, 0xc2, 0x37, 0x55, 0xdd, 0xb0, 0x2b, 0xdc,
	0xe2, 0x5f, 0x74, 0x92, 0x5c, 0x6a, 0xd8, 0xb8, 0xa7, 0x6a, 0xdb, 0xc4, 0xaf, 0xc1, 0x29, 0xb9,
	0xf0, 0xf1, 0x25, 0x05, 0xcd, 0x02, 0xe8, 0x5b, 0xb2, 0xa6, 0xe4, 0xa9, 0x7b, 0x47, 0xe8, 0xe4,
	0xd8, 0x21, 0xae, 0x1d, 0xa6, 0xb3, 0x6f, 0xca, 0x55, 0x1c, 0x9b, 0x85, 0x88, 0xc5, 0xdd, 0xd0,
	0x71, 0x18, 0xdc, 0xc6, 0xbb, 0x2c, 0x8e, 0x24, 0xf2, 0x27, 0x1a, 0x85, 0xa1, 0x1d, 0xb9, 0xd2,
	0xe0, 0x51, 0x23, 0xb1, 0x1f, 0x73, 0x03, 0x97, 0x04, 0x71, 0x06, 0x4e, 0xda, 0xdc, 0x77, 0x05,
	0x1b, 0x32, 0x31, 0x33, 0x3a, 0xdd, 0x99, 0x18, 0xad, 0xa9, 0xf0, 0xcf, 0x83, 0x30, 0x7a, 0xab,
	0xae, 0x74, 0x86, 0xb2, 0x9f, 0x84, 0x8a, 0x2e, 0x43, 0xa4, 0x41, 0x95, 0xd0, 0xaa, 0x4a, 0xd1,
	0x45, 0x32, 0xb1, 0x24, 0xab, 0x8a, 0x49, 0xb3, 0x6a, 0x26, 0x17, 0x49, 0xe1, 0x5d, 0x91, 0xf5,
	0x6d, 0x09, 0xd8, 0x74, 0xf2, 0xf7, 0xe3, 0x8e, 0x6a, 0x27, 0x76, 0x8f, 0x27, 0xaa, 0xdf, 0xb2,
	0x07, 0xde, 0x90, 0xdf, 0xc0, 0xb3, 0x86, 0x5c, 0x9f, 0xbe, 0x60, 0x23, 0xed, 0xd5, 0x17, 0x72,
	0x30, 0x7a, 0x1d, 0x57, 0x70, 0x5f, 0xae, 0x40, 0x16, 0xb7, 0x29, 0xf1, 0xba, 0x78, 0x16, 0x4e,
	0xac, 0x1b, 0xb2, 0xd6, 0x57, 0x5d, 0x9f, 0x86, 0x51, 0xab, 0x0e, 0xaf, 0x4b, 0xcf, 0x03, 0x5a,
	0x37, 0xd4, 0x7a, 0x3f, 0x2b, 0x4f, 0x11, 0xf4, 0x4d, 0x15, 0x5e, 0x17, 0xfe, 0x50, 0x00, 0xb4,
	0xa2, 0xee, 0xf4, 0x15, 0x7a, 0xd7, 0xe0, 0xa4, 0x82, 0x75, 0xa3, 0x5c, 0xa3, 0xe7, 0xc1, 0x7c,
	0xab, 0xfc, 0x0e, 0x38, 0xc8, 0x9d, 0xb0, 0x4c, 0x5d, 0xe4, 0x95, 0x58, 0xfc, 0x81, 0x00, 0x27,
	0x2c, 0x28, 0x3c, 0x82, 0x47, 0xe3, 0x70, 0x5c, 0x57, 0x1b, 0x5a, 0x11, 0xb7, 0xaf, 0x29, 0x8d,
	0xb0, 0xef, 0x8b, 0xad, 0x52, 0xdf, 0x05, 0x22, 0x0d, 0x75, 0x67, 0x50, 0x39, 0x18, 0xcd, 0xd2,
	0x43, 0x6b, 0x9f, 0xbe, 0x68, 0x53, 0xe2, 0x75, 0x5f, 0x7e, 0x36, 0x04, 0x27, 0x25, 0xac, 0x1b,
	0xaa, 0xd6, 0xbe, 0x35, 0x67, 0x21, 0xcc, 0xce, 0xd2, 0xad, 0xd5, 0x59, 0xb5, 0x0c, 0xb1, 0xcf,
	0xff, 0x89, 0x83, 0xcd, 0x27, 0xed, 0x29, 0x70, 0xde, 0x2d, 0xc5, 0x38, 0x72, 0xf9, 0xdf, 0xc9,
	0x86, 0x9c, 0x6c, 0xec, 0x67, 0x85, 0xe1, 0xa3, 0x3e, 0x2b, 0x84, 0x0e, 0x3d, 0x2b, 0xf4, 0x93,
	0xe4, 0x37, 0xe0, 0x94, 0x7d, 0x5b, 0xbd, 0xc6, 0xed, 0xf3, 0x56, 0x17, 0x66, 0x6a, 0x9b, 0xce,
	0x2b, 0x7e, 0x21, 0x40, 0x78, 0x59, 0x2d, 0x49, 0xb8, 0xa8, 0x6a, 0x0a, 0xba, 0x04, 0xe1, 0xe6,
	0x4d, 0x98, 0x2a, 0x72, 0x2a, 0xea, 0x1b, 0xe6, 0x0c, 0xa9, 0x35, 0x19, 0xad, 0xc1, 0x70, 0x15,
	0xeb, 0xba, 0x5c, 0x22, 0xc8, 0x89, 0x4d, 0x67, 0xdc, 0x6c, 0xda, 0x5c, 0x35, 0xb9, 0xc2, 0x04,
	0xa9, 0x49, 0x24, 0x53, 0x4d, 0x6c, 0x0e, 0x8e, 0x59, 0x07, 0x7c, 0xd9, 0xea, 0x4f, 0x83, 0x70,
	0xca, 0x72, 0x6b, 0x5a, 0x56, 0x4b, 0x7a, 0x4f, 0xb9, 0xf6, 0x25, 0x78, 0xaa, 0xa8, 0x56, 0x1a,
	0xd5, 0x5a, 0x9e, 0x5f, 0xd4, 0x08, 0xb7, 0xb0, 0x74, 0x8c, 0x7d, 0x5c, 0xa4, 0xdf, 0x10, 0x86,
	0x63, 0xbc, 0x7b, 0x91, 0x37, 0x76, 0xeb, 0x98, 0x06, 0xf3, 0x48, 0x26, 0xeb, 0xca, 0xdf, 0x11,
	0x5f, 0x72, 0x9d, 0xa9, 0xda, 0xd8, 0xad, 0x63, 0x29, 0xa2, 0xb7, 0x7e, 0xa0, 0x8b, 0x10, 0xde,
	0xd4, 0xd4, 0x6a, 0x9e, 0xd8, 0x9c, 0x5e, 0x18, 0x0f, 0xdf, 0x9b, 0x10, 0x99, 0x4c, 0x7e, 0xa2,
	0x49, 0x18, 0x36, 0x54, 0x26, 0x36, 0xe4, 0x2a, 0x16, 0x34, 0x54, 0x2a, 0x64, 0xbb, 0xee, 0x06,
	0x3d, 0x5f, 0x77, 0x87, 0xbb, 0x5f, 0x77, 0xc5, 0xcb, 0x10, 0xb1, 0x90, 0x43, 0x2f, 0x40, 0x74,
	0x7d, 0x41, 0x7a, 0x7b, 0x29, 0xb7, 0x90, 0xdf, 0xf8, 0xc6, 0xda, 0x42, 0xfe, 0xd6, 0xcd, 0xf5,
	0xb5, 0x85, 0xdc, 0xd2, 0xe2, 0xd2, 0xc2, 0xf5, 0xe3, 0xff, 0x87, 0x46, 0x00, 0x72, 0xcb, 0x4b,
	0xb9, 0xb7, 0xde, 0x5c, 0xbd, 0xb5, 0xbe, 0x70, 0x5c, 0x10, 0x3f, 0x10, 0xe0, 0xd9, 0x0e, 0x8b,
	0xf1, 0xab, 0xf0, 0x55, 0x08, 0x54, 0xd4, 0x92, 0x79, 0x0d, 0x3e, 0xef, 0xd9, 0xf1, 0x24, 0x2a,
	0xe6, 0xf9, 0x12, 0xfc, 0x53, 0x01, 0x5e, 0xb0, 0x40, 0x58, 0x35, 0x3b, 0x36, 0xbd, 0xb9, 0xd6,
	0xd1, 0xf7, 0x13, 0xc4, 0x07, 0x02, 0x9c, 0xee, 0x02, 0x90, 0x5b, 0x6a, 0x1e, 0xa0, 0xd9, 0x68,
	0x32, 0xed, 0x75, 0xd6, 0x6e, 0xaf, 0x56, 0x23, 0xaa, 0x29, 0x2f, 0x59, 0x84, 0x3c, 0x5b, 0xeb,
	0x27, 0x02, 0x3c, 0x67, 0x01, 0xc3, 0xca, 0xf2, 0xd7, 0xc6, 0x54, 0xdf, 0x15, 0x20, 0xe6, 0x84,
	0x8e, 0xdb, 0xe9, 0x1a, 0x0c, 0xb3, 0x0c, 0x69, 0x1a, 0xe9, 0x55, 0x37, 0xa7, 0x62, 0x1a, 0x24,
	0x53, 0xcc, 0xb3, 0x99, 0x3e, 0xb6, 0xfb, 0x35, 0x29, 0x34, 0x5f, 0x1b, 0x23, 0x7d, 0x0b, 0xa2,
	0x9d, 0xd0, 0xb8, 0x85, 0xe6, 0x60, 0x88, 0x94, 0x40, 0xd3, 0x3e, 0x2f, 0x7b, 0xa9, 0xa0, 0x12,
	0x13, 0xf1, 0x6c, 0x9b, 0x8f, 0x04, 0x38, 0x35, 0xaf, 0x28, 0x7d, 0x9b, 0xc6, 0x5e, 0xf2, 0x07,
	0xfa, 0x2e, 0xf9, 0xe2, 0x3b, 0xf0, 0x6c, 0x1b, 0x2e, 0xaf, 0xb5, 0xf8, 0x34, 0x87, 0x42, 0x0e,
	0x81, 0x3a, 0xaf, 0x26, 0x54, 0xf1, 0x4d, 0xf2, 0x41, 0x7c, 0x17, 0x9e, 0xb3, 0xdd, 0xa5, 0x7a,
	0xe7, 0x9c, 0xec, 0x5c, 0x28, 0xfb, 0x34, 0x63, 0x62, 0x9e, 0x32, 0x27, 0xad, 0x2b, 0xdf, 0x86,
	0x58, 0xe7, 0xca, 0x47, 0xc4, 0xea, 0x3b, 0x02, 0x9c, 0x6a, 0x35, 0x70, 0xd7, 0xb7, 0x64, 0x4d,
	0xe9, 0x89, 0xd3, 0x55, 0x5b, 0xa3, 0xc5, 0xdb, 0x71, 0xbb, 0xd5, 0x6c, 0x11, 0x3f, 0x11, 0x6c,
	0xfe, 0x4c, 0x71, 0x1c, 0x6d, 0xac, 0x4d, 0x24, 0x7a, 0x8e, 0xb5, 0xfb, 0xf6, 0x74, 0x69, 0x82,
	0x6b, 0x56, 0xb8, 0x20, 0xe5, 0x61, 0x86, 0xdb, 0x2b, 0x6e, 0xde, 0xcb, 0x8c, 0xcc, 0x85, 0x3c,
	0x07, 0xdc, 0x2f, 0x06, 0xac, 0x01, 0xf7, 0xa4, 0x36, 0x0a, 0xad, 0xd9, 0x4f, 0xfd, 0x83, 0xf4,
	0xd0, 0x92, 0xf2, 0x44, 0xd9, 0xb9, 0xb7, 0xd2, 0x96, 0x01, 0x02, 0x47, 0x9c, 0x01, 0xe8, 0xca,
	0x3e, 0x62, 0xa5, 0xdd, 0x36, 0x56, 0x27, 0xfd, 0x68, 0x00, 0x9e, 0xb3, 0xf5, 0x72, 0x9e, 0xd8,
	0x2e, 0xb4, 0xb5, 0xf8, 0x06, 0x7d, 0xb5, 0xf8, 0xda, 0xb6, 0x30, 0xd0, 0xf7, 0x16, 0x92, 0x04,
	0xd5, 0x69, 0x97, 0x23, 0x32, 0xfa, 0xf7, 0x84, 0xb6, 0xbc, 0xfb, 0xc4, 0x72, 0x54, 0x7b, 0x1a,
	0x3e, 0x4a, 0x96, 0xff, 0x12, 0x20, 0x64, 0xfa, 0x34, 0x3a, 0x0b, 0xc3, 0x7b, 0x6a, 0x0d, 0xb7,
	0x18, 0x85, 0x9a, 0x6c, 0x82, 0x64, 0x60, 0x49, 0x41, 0x39, 0x08, 0xd0, 0xfb, 0xcc, 0x00, 0xbd,
	0xcf, 0x9c, 0xf7, 0x12, 0x2e, 0x49, 0x72, 0xb2, 0xe7, 0x97, 0x6e, 0x2a, 0x8c, 0x5e, 0x81, 0xb0,
	0xde, 0x28, 0xd4, 0xb0, 0xd1, 0x6c, 0xff, 0x58, 0x56, 0x0a, 0xb1, 0x21, 0xd6, 0x5b, 0x92, 0x75,
	0xbd, 0x5c, 0xaa, 0xe5, 0xeb, 0x8d, 0x42, 0xa5, 0x5c, 0xcc, 0x97, 0xeb, 0xd4, 0x69, 0x42, 0xd2,
	0x08, 0xfb, 0xbe, 0x46, 0x3f, 0x2f, 0xd5, 0xdb, 0xba, 0xed, 0x43, 0x3e, 0xba, 0xed, 0xe2, 0x8f,
	0x03, 0x00, 0x2d, 0xef, 0x42, 0x51, 0x18, 0xde, 0xc1, 0x9a, 0xde, 0xec, 0xbf, 0x48, 0xe6, 0x4f,
	0x74, 0x8b, 0xd8, 0xd9, 0xe4, 0xc6, 0xef, 0xc1, 0xd3, 0xde, 0xbb, 0x0e, 0xc9, 0x5c, 0x73, 0x40,
	0xb2, 0x28, 0x42, 0x12, 0x84, 0xf7, 0x54, 0x75, 0x1b, 0xe3, 0x3a, 0xbd, 0x49, 0x12, 0xad, 0x53,
	0x3e, 0xb4, 0xde, 0x36, 0x65, 0xa5, 0x96, 0x1a, 0xb4, 0x08, 0x27, 0xf8, 0xe5, 0xfe, 0x5e, 0xb9,
	0xa6, 0xa8, 0xf7, 0xf2, 0xba, 0x21, 0x6b, 0x06, 0x0f, 0xb8, 0x53, 0x66, 0xb4, 0x92, 0xad, 0xa0,
	0x97, 0xbc, 0xd5, 0xcd, 0xeb, 0xf2, 0xae, 0xf4, 0x0c, 0x13, 0x79, 0x87, 0x4a, 0xd0, 0x06, 0x6a,
	0xec, 0xe7, 0x02, 0x40, 0x0b, 0x36, 0x5a, 0x85, 0x20, 0x8b, 0x3d, 0xce, 0xfe, 0xa2, 0x1b, 0x4e,
	0x36, 0xdb, 0xc2, 0x9c, 0x01, 0x97, 0xb8, 0x1a, 0x74, 0x03, 0xc2, 0x1a, 0x66, 0x6d, 0x42, 0x9d,
	0x73, 0x3f, 0xef, 0xa1, 0x8b, 0xc5, 0x04, 0xa4, 0x96, 0x6c, 0x6c, 0x03, 0xc2, 0x4d, 0x43, 0xd8,
	0xb5, 0x0a, 0xbd, 0x6b, 0x15, 0xff, 0x30, 0x00, 0x4f, 0xb7, 0x65, 0x1f, 0x74, 0xdb, 0xc1, 0x0b,
	0xe6, 0x7c, 0xa6, 0xb0, 0x2e, 0xae, 0x10, 0xfb, 0xcb, 0x7f, 0x89, 0xb9, 0xd1, 0x24, 0x04, 0xef,
	0xe1, 0x72, 0x69, 0xcb, 0xe0, 0x05, 0xe0, 0xf9, 0x8e, 0x02, 0xb0, 0x54, 0x33, 0x66, 0xa6, 0xde,
	0x96, 0x2b, 0x0d, 0x2c, 0xf1, 0xa9, 0x99, 0xdf, 0x8d, 0xc1, 0x88, 0x99, 0xc0, 0xd8, 0x8d, 0x1f,
	0xfd, 0x48, 0x80, 0xc1, 0x1b, 0xd8, 0x40, 0x69, 0x37, 0x14, 0x1d, 0x2f, 0xfd, 0x31, 0xaf, 0xef,
	0xda, 0xe2, 0xd4, 0xfd, 0x2f, 0xbe, 0xfc, 0xe1, 0x40, 0x12, 0x5d, 0x48, 0x55, 0xe5, 0x9a, 0x5c,
	0xc2, 0x4a, 0xc2, 0xf1, 0xdf, 0x39, 0xe8, 0xa9, 0xf7, 0x5a, 0x59, 0xf4, 0x7d, 0xf4, 0x89, 0x00,
	0x01, 0x72, 0xf2, 0x42, 0x93, 0x3e, 0x3a, 0x36, 0xe6, 0xb9, 0x31, 0x36, 0xe5, 0x4f, 0x88, 0x9d,
	0xe7, 0xc4, 0x73, 0x14, 0xe9, 0x59, 0xf4, 0xa2, 0x0b, 0x52, 0xf4, 0x4b, 0x01, 0x82, 0xec, 0x99,
	0x0f, 0x4d, 0xf5, 0xf2, 0x9a, 0x1d, 0x73, 0xbf, 0xdd, 0x8b, 0x37, 0xf7, 0x0f, 0xe2, 0x63, 0xdd,
	0x5e, 0x13, 0x87, 0xf9, 0x07, 0x0a, 0xf8, 0x65, 0xd1, 0x0d, 0xf0, 0x9c, 0x10, 0x47, 0x9f, 0x09,
	0x10, 0x64, 0xa5, 0xda, 0x1d, 0xb3, 0xd3, 0x5b, 0x9d, 0x17, 0xcc, 0x77, 0x18, 0x66, 0xe7, 0x57,
	0x2f, 0x1b, 0xe6, 0x74, 0xc6, 0x97, 0x3b, 0x10, 0x02, 0xbf, 0x17, 0x20, 0xc8, 0xaa, 0xb0, 0x3b,
	0x01, 0xa7, 0xf7, 0x33, 0x2f, 0x04, 0x36, 0xf7, 0x0f, 0xe2, 0xc9, 0x6e, 0x2f, 0x67, 0x27, 0xdb,
	0x63, 0x6c, 0xa1, 0x5a, 0x37, 0x76, 0x99, 0x77, 0xc7, 0xfd, 0x79, 0xf7, 0x67, 0x02, 0x0c, 0xd1,
	0x0c, 0xef, 0xee, 0xde, 0x0e, 0xaf, 0x71, 0x5e, 0x98, 0xdc, 0xdd, 0x3f, 0x88, 0xbf, 0xd8, 0xe5,
	0x1d, 0xce, 0xb6, 0x13, 0x53, 0x62, 0xc6, 0xd7, 0x4e, 0xd0, 0x4a, 0x86, 0x3e, 0x15, 0x20, 0xb0,
	0x6e, 0xa8, 0x75, 0x94, 0x71, 0xc7, 0xdf, 0xfe, 0xa4, 0xe7, 0xd5, 0x93, 0xce, 0x38, 0x3f, 0xe6,
	0xd9, 0xd0, 0x4f, 0x8a, 0x69, 0x9f, 0xe8, 0xd5, 0x3a, 0x05, 0xbf, 0xa2, 0xee, 0x60, 0x77, 0xf0,
	0x9d, 0xaf, 0x82, 0x3e, 0xc0, 0x3b, 0x3d, 0xe6, 0xf5, 0x05, 0xbe, 0x4a, 0x30, 0x7f, 0x2e, 0x40,
	0x90, 0xb5, 0xb5, 0xdc, 0xc3, 0xc0, 0xe9, 0xe9, 0xce, 0x0b, 0x81, 0x3c, 0x8b, 0x63, 0xe7, 0x47,
	0x3b, 0x1b, 0x85, 0x69, 0x71, 0xd2, 0x17, 0x05, 0x76, 0xc4, 0x41, 0xbf, 0x15, 0x60, 0x98, 0x3f,
	0x9b, 0xa0, 0xe9, 0x9e, 0x9e, 0xcd, 0xbc, 0xd0, 0x78, 0x67, 0xff, 0x20, 0x7e, 0xb6, 0xeb, 0xfb,
	0x8c, 0x8d, 0xc7, 0x05, 0xf1, 0x9c, 0x5b, 0x0e, 0xd5, 0x98, 0x1a, 0x92, 0x8a, 0x7e, 0x2d, 0x40,
	0x88, 0x54, 0x90, 0x65, 0xb5, 0xa4, 0xa3, 0x99, 0xde, 0x9e, 0x14, 0x62, 0x17, 0x7d, 0xcb, 0xf1,
	0x32, 0x35, 0xcb, 0x9c, 0x07, 0xf9, 0x73, 0x1e, 0xda, 0x54, 0xff, 0xa3, 0x00, 0x23, 0x44, 0x6d,
	0xab, 0x09, 0x8d, 0xae, 0xf8, 0x80, 0xd1, 0xd1, 0x5c, 0x8f, 0x5d, 0xed, 0x51, 0x9a, 0x53, 0x79,
	0x83, 0x52, 0x99, 0x45, 0x17, 0xfd, 0x50, 0x49, 0x59, 0xfa, 0xde, 0x9f, 0x0b, 0x10, 0x21, 0x4b,
	0xf0, 0x56, 0x31, 0x9a, 0xf5, 0x81, 0xc7, 0xde, 0xfc, 0x8e, 0xcd, 0xf5, 0x22, 0xca, 0x79, 0x5c,
	0xa1, 0x3c, 0x66, 0xd0, 0x94, 0x2f, 0x1e, 0x66, 0x57, 0xfa, 0x53, 0x01, 0xc2, 0x44, 0x39, 0xed,
	0xee, 0x21, 0x3f, 0x7e, 0x61, 0xed, 0x44, 0xc6, 0x2e, 0xf9, 0x17, 0xe4, 0xf0, 0xe7, 0x58, 0x25,
	0x40, 0xbe, 0x2a, 0x41, 0x8a, 0xb5, 0x8d, 0xbf, 0x14, 0x20, 0x34, 0xaf, 0x28, 0x0c, 0xbb, 0x6b,
	0x2c, 0x38, 0x37, 0x8e, 0xbd, 0x04, 0xf3, 0xfb, 0xfb, 0x07, 0xf1, 0x89, 0xee, 0x1d, 0xde, 0x43,
	0x8a, 0x73, 0x4e, 0x7c, 0xdd, 0x3f, 0xaf, 0xb9, 0x82, 0x6c, 0x14, 0xb7, 0xd8, 0xe9, 0x8b, 0x84,
	0xfc, 0x3f, 0x04, 0x88, 0xb0, 0x63, 0x01, 0x63, 0x3a, 0xeb, 0xeb, 0x08, 0xe2, 0x97, 0xec, 0x07,
	0xc2, 0xfe, 0x41, 0x7c, 0xf2, 0xd0, 0xe6, 0xef, 0xe3, 0x21, 0xcc, 0x16, 0x24, 0x84, 0x7f, 0x25,
	0x40, 0xe8, 0x06, 0x36, 0xe8, 0xcd, 0xc9, 0x7d, 0x5f, 0x9d, 0x1b, 0xc9, 0x31, 0x6f, 0x1d, 0x51,
	0xf1, 0x4d, 0x0a, 0x3b, 0x8b, 0xae, 0xf9, 0x82, 0xcd, 0xda, 0xa8, 0xa9, 0xf7, 0x5a, 0x8d, 0x07,
	0x7a, 0xb0, 0x02, 0xe2, 0xe6, 0xac, 0x53, 0x8b, 0xfc, 0x84, 0x84, 0xad, 0xf3, 0x1c, 0x9b, 0xed,
	0x41, 0x92, 0x47, 0xd3, 0x65, 0x56, 0x19, 0xd1, 0x64, 0x0f, 0x6c, 0xc8, 0x29, 0x97, 0x84, 0x93,
	0x47, 0xb3, 0x3b, 0xb7, 0x85, 0xbd, 0x78, 0x58, 0x81, 0x96, 0xf8, 0xae, 0xed, 0xd2, 0x21, 0xfa,
	0x93, 0x12, 0xb9, 0x24, 0xf6, 0x42, 0x84, 0xb8, 0xd0, 0x5f, 0x05, 0x88, 0xb0, 0xbb, 0x00, 0xa3,
	0x33, 0xeb, 0xeb, 0xde, 0xe1, 0x97, 0x91, 0xb6, 0x7f, 0x10, 0x7f, 0xe9, 0xd0, 0x76, 0xa4, 0x85,
	0xd4, 0x42, 0xa6, 0x6f, 0x5f, 0x23, 0x0c, 0xff, 0xde, 0xcc, 0x0a, 0x1e, 0x19, 0x76, 0xed, 0x67,
	0x7a, 0x61, 0xf8, 0x6d, 0x87, 0xa4, 0x60, 0x67, 0x78, 0x48, 0x52, 0xc8, 0xc6, 0xfb, 0x66, 0x9c,
	0x5d, 0xbd, 0xbd, 0x52, 0x2a, 0x1b, 0x5b, 0x8d, 0x42, 0xb2, 0xa8, 0x56, 0x53, 0x0c, 0x6f, 0x82,
	0xfd, 0xbf, 0x81, 0x92, 0x9a, 0x28, 0xe1, 0x1a, 0x5d, 0x37, 0x75, 0xf8, 0x7f, 0x28, 0xb8, 0xdc,
	0xfa, 0x55, 0x08, 0x52, 0x81, 0xc9, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0xc4, 0x06, 0x5b, 0xc0,
	0x90, 0x32, 0x00, 0x00,
}
