// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/clickhouse/v1/user_service.proto

package clickhouse // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetUserRequest struct {
	// ID of the ClickHouse cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the ClickHouse User resource to return.
	// To get the name of the user, use a [UserService.List] request.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUserRequest) Reset()         { *m = GetUserRequest{} }
func (m *GetUserRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserRequest) ProtoMessage()    {}
func (*GetUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{0}
}
func (m *GetUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetUserRequest.Unmarshal(m, b)
}
func (m *GetUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetUserRequest.Marshal(b, m, deterministic)
}
func (dst *GetUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUserRequest.Merge(dst, src)
}
func (m *GetUserRequest) XXX_Size() int {
	return xxx_messageInfo_GetUserRequest.Size(m)
}
func (m *GetUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUserRequest proto.InternalMessageInfo

func (m *GetUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type ListUsersRequest struct {
	// ID of the cluster to list ClickHouse users in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListUsersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListUsersResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsersRequest) Reset()         { *m = ListUsersRequest{} }
func (m *ListUsersRequest) String() string { return proto.CompactTextString(m) }
func (*ListUsersRequest) ProtoMessage()    {}
func (*ListUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{1}
}
func (m *ListUsersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsersRequest.Unmarshal(m, b)
}
func (m *ListUsersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsersRequest.Marshal(b, m, deterministic)
}
func (dst *ListUsersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsersRequest.Merge(dst, src)
}
func (m *ListUsersRequest) XXX_Size() int {
	return xxx_messageInfo_ListUsersRequest.Size(m)
}
func (m *ListUsersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsersRequest proto.InternalMessageInfo

func (m *ListUsersRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListUsersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListUsersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListUsersResponse struct {
	// List of ClickHouse User resources.
	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListUsersRequest.page_size], use the [next_page_token] as the value
	// for the [ListUsersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsersResponse) Reset()         { *m = ListUsersResponse{} }
func (m *ListUsersResponse) String() string { return proto.CompactTextString(m) }
func (*ListUsersResponse) ProtoMessage()    {}
func (*ListUsersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{2}
}
func (m *ListUsersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsersResponse.Unmarshal(m, b)
}
func (m *ListUsersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsersResponse.Marshal(b, m, deterministic)
}
func (dst *ListUsersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsersResponse.Merge(dst, src)
}
func (m *ListUsersResponse) XXX_Size() int {
	return xxx_messageInfo_ListUsersResponse.Size(m)
}
func (m *ListUsersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsersResponse proto.InternalMessageInfo

func (m *ListUsersResponse) GetUsers() []*User {
	if m != nil {
		return m.Users
	}
	return nil
}

func (m *ListUsersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateUserRequest struct {
	// ID of the ClickHouse cluster to create a user in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Properties of the user to be created.
	UserSpec             *UserSpec `protobuf:"bytes,2,opt,name=user_spec,json=userSpec,proto3" json:"user_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateUserRequest) Reset()         { *m = CreateUserRequest{} }
func (m *CreateUserRequest) String() string { return proto.CompactTextString(m) }
func (*CreateUserRequest) ProtoMessage()    {}
func (*CreateUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{3}
}
func (m *CreateUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateUserRequest.Unmarshal(m, b)
}
func (m *CreateUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateUserRequest.Marshal(b, m, deterministic)
}
func (dst *CreateUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateUserRequest.Merge(dst, src)
}
func (m *CreateUserRequest) XXX_Size() int {
	return xxx_messageInfo_CreateUserRequest.Size(m)
}
func (m *CreateUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateUserRequest proto.InternalMessageInfo

func (m *CreateUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateUserRequest) GetUserSpec() *UserSpec {
	if m != nil {
		return m.UserSpec
	}
	return nil
}

type CreateUserMetadata struct {
	// ID of the ClickHouse cluster the user is being created in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being created.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateUserMetadata) Reset()         { *m = CreateUserMetadata{} }
func (m *CreateUserMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateUserMetadata) ProtoMessage()    {}
func (*CreateUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{4}
}
func (m *CreateUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateUserMetadata.Unmarshal(m, b)
}
func (m *CreateUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateUserMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateUserMetadata.Merge(dst, src)
}
func (m *CreateUserMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateUserMetadata.Size(m)
}
func (m *CreateUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateUserMetadata proto.InternalMessageInfo

func (m *CreateUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type UpdateUserRequest struct {
	// ID of the ClickHouse cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to be updated.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Field mask that specifies which fields of the ClickHouse User resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New password for the user.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// New set of permissions for the user.
	Permissions          []*Permission `protobuf:"bytes,5,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateUserRequest) Reset()         { *m = UpdateUserRequest{} }
func (m *UpdateUserRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateUserRequest) ProtoMessage()    {}
func (*UpdateUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{5}
}
func (m *UpdateUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateUserRequest.Unmarshal(m, b)
}
func (m *UpdateUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateUserRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateUserRequest.Merge(dst, src)
}
func (m *UpdateUserRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateUserRequest.Size(m)
}
func (m *UpdateUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateUserRequest proto.InternalMessageInfo

func (m *UpdateUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *UpdateUserRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateUserRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *UpdateUserRequest) GetPermissions() []*Permission {
	if m != nil {
		return m.Permissions
	}
	return nil
}

type UpdateUserMetadata struct {
	// ID of the ClickHouse cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being updated.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateUserMetadata) Reset()         { *m = UpdateUserMetadata{} }
func (m *UpdateUserMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateUserMetadata) ProtoMessage()    {}
func (*UpdateUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{6}
}
func (m *UpdateUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateUserMetadata.Unmarshal(m, b)
}
func (m *UpdateUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateUserMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateUserMetadata.Merge(dst, src)
}
func (m *UpdateUserMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateUserMetadata.Size(m)
}
func (m *UpdateUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateUserMetadata proto.InternalMessageInfo

func (m *UpdateUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type DeleteUserRequest struct {
	// ID of the ClickHouse cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to delete.
	// To get the name of the user, use a [UserService.List] request.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteUserRequest) Reset()         { *m = DeleteUserRequest{} }
func (m *DeleteUserRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteUserRequest) ProtoMessage()    {}
func (*DeleteUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{7}
}
func (m *DeleteUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteUserRequest.Unmarshal(m, b)
}
func (m *DeleteUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteUserRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteUserRequest.Merge(dst, src)
}
func (m *DeleteUserRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteUserRequest.Size(m)
}
func (m *DeleteUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteUserRequest proto.InternalMessageInfo

func (m *DeleteUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type DeleteUserMetadata struct {
	// ID of the ClickHouse cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being deleted.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteUserMetadata) Reset()         { *m = DeleteUserMetadata{} }
func (m *DeleteUserMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteUserMetadata) ProtoMessage()    {}
func (*DeleteUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{8}
}
func (m *DeleteUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteUserMetadata.Unmarshal(m, b)
}
func (m *DeleteUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteUserMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteUserMetadata.Merge(dst, src)
}
func (m *DeleteUserMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteUserMetadata.Size(m)
}
func (m *DeleteUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteUserMetadata proto.InternalMessageInfo

func (m *DeleteUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type GrantUserPermissionRequest struct {
	// ID of the ClickHouse cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to grant the permission to.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Permission that should be granted to the specified user.
	Permission           *Permission `protobuf:"bytes,3,opt,name=permission,proto3" json:"permission,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GrantUserPermissionRequest) Reset()         { *m = GrantUserPermissionRequest{} }
func (m *GrantUserPermissionRequest) String() string { return proto.CompactTextString(m) }
func (*GrantUserPermissionRequest) ProtoMessage()    {}
func (*GrantUserPermissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{9}
}
func (m *GrantUserPermissionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GrantUserPermissionRequest.Unmarshal(m, b)
}
func (m *GrantUserPermissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GrantUserPermissionRequest.Marshal(b, m, deterministic)
}
func (dst *GrantUserPermissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrantUserPermissionRequest.Merge(dst, src)
}
func (m *GrantUserPermissionRequest) XXX_Size() int {
	return xxx_messageInfo_GrantUserPermissionRequest.Size(m)
}
func (m *GrantUserPermissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GrantUserPermissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GrantUserPermissionRequest proto.InternalMessageInfo

func (m *GrantUserPermissionRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GrantUserPermissionRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *GrantUserPermissionRequest) GetPermission() *Permission {
	if m != nil {
		return m.Permission
	}
	return nil
}

type GrantUserPermissionMetadata struct {
	// ID of the ClickHouse cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being granted a permission.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GrantUserPermissionMetadata) Reset()         { *m = GrantUserPermissionMetadata{} }
func (m *GrantUserPermissionMetadata) String() string { return proto.CompactTextString(m) }
func (*GrantUserPermissionMetadata) ProtoMessage()    {}
func (*GrantUserPermissionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{10}
}
func (m *GrantUserPermissionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GrantUserPermissionMetadata.Unmarshal(m, b)
}
func (m *GrantUserPermissionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GrantUserPermissionMetadata.Marshal(b, m, deterministic)
}
func (dst *GrantUserPermissionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrantUserPermissionMetadata.Merge(dst, src)
}
func (m *GrantUserPermissionMetadata) XXX_Size() int {
	return xxx_messageInfo_GrantUserPermissionMetadata.Size(m)
}
func (m *GrantUserPermissionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_GrantUserPermissionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_GrantUserPermissionMetadata proto.InternalMessageInfo

func (m *GrantUserPermissionMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GrantUserPermissionMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type RevokeUserPermissionRequest struct {
	// ID of the ClickHouse cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to revoke a permission from.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Name of the database that the user should lose access to.
	DatabaseName         string   `protobuf:"bytes,3,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeUserPermissionRequest) Reset()         { *m = RevokeUserPermissionRequest{} }
func (m *RevokeUserPermissionRequest) String() string { return proto.CompactTextString(m) }
func (*RevokeUserPermissionRequest) ProtoMessage()    {}
func (*RevokeUserPermissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{11}
}
func (m *RevokeUserPermissionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeUserPermissionRequest.Unmarshal(m, b)
}
func (m *RevokeUserPermissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeUserPermissionRequest.Marshal(b, m, deterministic)
}
func (dst *RevokeUserPermissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeUserPermissionRequest.Merge(dst, src)
}
func (m *RevokeUserPermissionRequest) XXX_Size() int {
	return xxx_messageInfo_RevokeUserPermissionRequest.Size(m)
}
func (m *RevokeUserPermissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeUserPermissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeUserPermissionRequest proto.InternalMessageInfo

func (m *RevokeUserPermissionRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RevokeUserPermissionRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *RevokeUserPermissionRequest) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type RevokeUserPermissionMetadata struct {
	// ID of the ClickHouse cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user whose permission is being revoked.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeUserPermissionMetadata) Reset()         { *m = RevokeUserPermissionMetadata{} }
func (m *RevokeUserPermissionMetadata) String() string { return proto.CompactTextString(m) }
func (*RevokeUserPermissionMetadata) ProtoMessage()    {}
func (*RevokeUserPermissionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_service_c4b5b8d2a1dd03ab, []int{12}
}
func (m *RevokeUserPermissionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Unmarshal(m, b)
}
func (m *RevokeUserPermissionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Marshal(b, m, deterministic)
}
func (dst *RevokeUserPermissionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeUserPermissionMetadata.Merge(dst, src)
}
func (m *RevokeUserPermissionMetadata) XXX_Size() int {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Size(m)
}
func (m *RevokeUserPermissionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeUserPermissionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeUserPermissionMetadata proto.InternalMessageInfo

func (m *RevokeUserPermissionMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RevokeUserPermissionMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetUserRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.GetUserRequest")
	proto.RegisterType((*ListUsersRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListUsersRequest")
	proto.RegisterType((*ListUsersResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListUsersResponse")
	proto.RegisterType((*CreateUserRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateUserRequest")
	proto.RegisterType((*CreateUserMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateUserMetadata")
	proto.RegisterType((*UpdateUserRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateUserRequest")
	proto.RegisterType((*UpdateUserMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateUserMetadata")
	proto.RegisterType((*DeleteUserRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteUserRequest")
	proto.RegisterType((*DeleteUserMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteUserMetadata")
	proto.RegisterType((*GrantUserPermissionRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.GrantUserPermissionRequest")
	proto.RegisterType((*GrantUserPermissionMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.GrantUserPermissionMetadata")
	proto.RegisterType((*RevokeUserPermissionRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.RevokeUserPermissionRequest")
	proto.RegisterType((*RevokeUserPermissionMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.RevokeUserPermissionMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// UserServiceClient is the client API for UserService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserServiceClient interface {
	// Returns the specified ClickHouse User resource.
	//
	// To get the list of available ClickHouse User resources, make a [List] request.
	Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error)
	// Retrieves the list of ClickHouse User resources in the specified cluster.
	List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error)
	// Creates a ClickHouse user in the specified cluster.
	Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified ClickHouse user.
	Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified ClickHouse user.
	Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Grants a permission to the specified ClickHouse user.
	GrantPermission(ctx context.Context, in *GrantUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Revokes a permission from the specified ClickHouse user.
	RevokePermission(ctx context.Context, in *RevokeUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type userServiceClient struct {
	cc *grpc.ClientConn
}

func NewUserServiceClient(cc *grpc.ClientConn) UserServiceClient {
	return &userServiceClient{cc}
}

func (c *userServiceClient) Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error) {
	out := new(ListUsersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) GrantPermission(ctx context.Context, in *GrantUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/GrantPermission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) RevokePermission(ctx context.Context, in *RevokeUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.UserService/RevokePermission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserServiceServer is the server API for UserService service.
type UserServiceServer interface {
	// Returns the specified ClickHouse User resource.
	//
	// To get the list of available ClickHouse User resources, make a [List] request.
	Get(context.Context, *GetUserRequest) (*User, error)
	// Retrieves the list of ClickHouse User resources in the specified cluster.
	List(context.Context, *ListUsersRequest) (*ListUsersResponse, error)
	// Creates a ClickHouse user in the specified cluster.
	Create(context.Context, *CreateUserRequest) (*operation.Operation, error)
	// Updates the specified ClickHouse user.
	Update(context.Context, *UpdateUserRequest) (*operation.Operation, error)
	// Deletes the specified ClickHouse user.
	Delete(context.Context, *DeleteUserRequest) (*operation.Operation, error)
	// Grants a permission to the specified ClickHouse user.
	GrantPermission(context.Context, *GrantUserPermissionRequest) (*operation.Operation, error)
	// Revokes a permission from the specified ClickHouse user.
	RevokePermission(context.Context, *RevokeUserPermissionRequest) (*operation.Operation, error)
}

func RegisterUserServiceServer(s *grpc.Server, srv UserServiceServer) {
	s.RegisterService(&_UserService_serviceDesc, srv)
}

func _UserService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Get(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).List(ctx, req.(*ListUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Create(ctx, req.(*CreateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Update(ctx, req.(*UpdateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Delete(ctx, req.(*DeleteUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_GrantPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GrantUserPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).GrantPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/GrantPermission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).GrantPermission(ctx, req.(*GrantUserPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_RevokePermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeUserPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).RevokePermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.UserService/RevokePermission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).RevokePermission(ctx, req.(*RevokeUserPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.clickhouse.v1.UserService",
	HandlerType: (*UserServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _UserService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _UserService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _UserService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserService_Delete_Handler,
		},
		{
			MethodName: "GrantPermission",
			Handler:    _UserService_GrantPermission_Handler,
		},
		{
			MethodName: "RevokePermission",
			Handler:    _UserService_RevokePermission_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/clickhouse/v1/user_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/clickhouse/v1/user_service.proto", fileDescriptor_user_service_c4b5b8d2a1dd03ab)
}

var fileDescriptor_user_service_c4b5b8d2a1dd03ab = []byte{
	// 990 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x4d, 0x6f, 0x1b, 0x45,
	0x18, 0xd6, 0x24, 0x8e, 0x15, 0xbf, 0x6e, 0xda, 0x66, 0x24, 0x24, 0x6b, 0xd3, 0xa0, 0xb0, 0x94,
	0x12, 0x5c, 0x79, 0xd7, 0xeb, 0xf2, 0x51, 0x9c, 0x96, 0x8f, 0x14, 0x1a, 0x01, 0x4d, 0x13, 0x6d,
	0xda, 0x03, 0xa9, 0x90, 0x35, 0xf6, 0x4e, 0xdd, 0x95, 0xed, 0xdd, 0x65, 0x67, 0xd7, 0x6d, 0x52,
	0x2a, 0xa1, 0x1e, 0x2b, 0x71, 0x81, 0x9f, 0xc0, 0x81, 0x13, 0x1c, 0x72, 0xe5, 0x07, 0xb8, 0x57,
	0x82, 0xf8, 0x07, 0x1c, 0x38, 0x97, 0x03, 0x12, 0x27, 0x34, 0x33, 0x9b, 0xec, 0x3a, 0x36, 0x59,
	0x27, 0x8e, 0x9a, 0xdb, 0xae, 0xe7, 0x7d, 0xe6, 0x7d, 0x9e, 0xf7, 0xd3, 0x0b, 0xc6, 0x16, 0x71,
	0x2c, 0xfa, 0x48, 0x6f, 0xb4, 0xdd, 0xd0, 0xd2, 0x3b, 0x56, 0x5d, 0x6f, 0xb4, 0xed, 0x46, 0xeb,
	0x81, 0x1b, 0x32, 0xaa, 0x77, 0x0d, 0x3d, 0x64, 0xd4, 0xaf, 0x31, 0xea, 0x77, 0xed, 0x06, 0xd5,
	0x3c, 0xdf, 0x0d, 0x5c, 0xfc, 0xaa, 0x84, 0x68, 0x02, 0xa2, 0x75, 0xac, 0xba, 0x16, 0x43, 0xb4,
	0xae, 0xa1, 0x5c, 0x68, 0xba, 0x6e, 0xb3, 0x4d, 0x75, 0xe2, 0xd9, 0x3a, 0x71, 0x1c, 0x37, 0x20,
	0x81, 0xed, 0x3a, 0x4c, 0xa2, 0x95, 0x85, 0xe8, 0x54, 0xbc, 0xd5, 0xc3, 0xfb, 0xfa, 0x7d, 0x9b,
	0xb6, 0xad, 0x5a, 0x87, 0xb0, 0x56, 0x64, 0x71, 0xa9, 0x8f, 0x92, 0xeb, 0x51, 0x5f, 0x5c, 0x10,
	0x3f, 0x45, 0x76, 0x6f, 0x8d, 0x40, 0x3d, 0x32, 0x55, 0x22, 0x53, 0x4e, 0xe9, 0xe0, 0x35, 0xf3,
	0x7d, 0xd7, 0x74, 0x49, 0xdb, 0xb6, 0x12, 0xc7, 0xea, 0x16, 0x9c, 0x5d, 0xa1, 0xc1, 0x5d, 0x46,
	0x7d, 0x93, 0x7e, 0x1d, 0x52, 0x16, 0xe0, 0xcb, 0x00, 0x8d, 0x76, 0xc8, 0x02, 0xea, 0xd7, 0x6c,
	0xab, 0x80, 0x16, 0xd0, 0x62, 0x6e, 0xf9, 0xcc, 0x5f, 0x3d, 0x03, 0x3d, 0x7b, 0x6e, 0x64, 0xae,
	0x5d, 0x7f, 0xa7, 0x6c, 0xe6, 0xa2, 0xf3, 0xcf, 0x2c, 0x5c, 0x85, 0x9c, 0x08, 0xa1, 0x43, 0x3a,
	0xb4, 0x30, 0x21, 0x6c, 0xe7, 0xb9, 0xed, 0x8b, 0x9e, 0x31, 0x73, 0x8f, 0x94, 0xb6, 0x3f, 0x2e,
	0x6d, 0x96, 0x4b, 0xef, 0xd7, 0xbe, 0x2a, 0x4a, 0xf0, 0xbb, 0x57, 0xcc, 0x69, 0x6e, 0x7f, 0x9b,
	0x74, 0xa8, 0xfa, 0x3d, 0x82, 0xf3, 0xb7, 0x6c, 0x26, 0x9c, 0xb3, 0x63, 0x79, 0x7f, 0x13, 0x72,
	0x1e, 0x69, 0xd2, 0x1a, 0xb3, 0xb7, 0xa5, 0xf7, 0xc9, 0x65, 0xf8, 0xb7, 0x67, 0x64, 0xaf, 0x5d,
	0x37, 0xca, 0xe5, 0xb2, 0x39, 0xcd, 0x0f, 0x37, 0xec, 0x6d, 0x8a, 0x17, 0x01, 0x84, 0x61, 0xe0,
	0xb6, 0xa8, 0x53, 0x98, 0x14, 0xb7, 0xe6, 0x9e, 0x3d, 0x37, 0xa6, 0x84, 0xa5, 0x29, 0x6e, 0xb9,
	0xc3, 0xcf, 0xd4, 0x87, 0x30, 0x9b, 0xe0, 0xc4, 0x3c, 0xd7, 0x61, 0x14, 0x57, 0x61, 0x8a, 0xb3,
	0x66, 0x05, 0xb4, 0x30, 0xb9, 0x98, 0xaf, 0x5c, 0xd4, 0x0e, 0x2f, 0x11, 0x4d, 0x84, 0x53, 0x42,
	0xf0, 0x25, 0x38, 0xe7, 0xd0, 0x47, 0x41, 0x2d, 0xe1, 0x5f, 0xc4, 0xc9, 0x9c, 0xe1, 0x3f, 0xaf,
	0xef, 0x3b, 0xfe, 0x0e, 0xc1, 0xec, 0x0d, 0x9f, 0x92, 0x80, 0x1e, 0x3b, 0x19, 0x5f, 0x44, 0xc9,
	0x60, 0x1e, 0x6d, 0x08, 0x27, 0xf9, 0xca, 0xe2, 0x28, 0x54, 0x37, 0x3c, 0xda, 0x58, 0xce, 0xf0,
	0x5b, 0x65, 0x76, 0xf8, 0xbb, 0xba, 0x0e, 0x38, 0xa6, 0xb3, 0x4a, 0x03, 0x62, 0x91, 0x80, 0xe0,
	0xf9, 0x41, 0x3e, 0x49, 0x06, 0x73, 0x03, 0xe5, 0x90, 0xc8, 0xf7, 0x2f, 0x13, 0x30, 0x7b, 0xd7,
	0xb3, 0xc6, 0x51, 0x38, 0x46, 0xb9, 0xe1, 0x25, 0xc8, 0x87, 0xc2, 0xbb, 0x68, 0x46, 0x51, 0x04,
	0xf9, 0x8a, 0xa2, 0xc9, 0x7e, 0xd5, 0xf6, 0xfa, 0x55, 0xbb, 0xc9, 0xfb, 0x75, 0x95, 0xb0, 0x96,
	0x09, 0xd2, 0x9c, 0x3f, 0xe3, 0x37, 0x60, 0xda, 0x23, 0x8c, 0x3d, 0x74, 0x7d, 0xab, 0x90, 0x89,
	0xcb, 0xe7, 0x6a, 0xc9, 0xa8, 0x5c, 0x35, 0xf7, 0x8f, 0xf0, 0x2d, 0xc8, 0x7b, 0xd4, 0xef, 0xd8,
	0x8c, 0xf1, 0x91, 0x50, 0x98, 0x12, 0xe5, 0x52, 0x4c, 0xcb, 0xc1, 0xfa, 0x3e, 0xc4, 0x4c, 0xc2,
	0x79, 0x0a, 0xe2, 0x78, 0x9d, 0x48, 0x0a, 0xbe, 0x81, 0xd9, 0x4f, 0x68, 0x9b, 0x9e, 0x4e, 0x06,
	0xb8, 0x9e, 0xd8, 0xfb, 0x89, 0xe8, 0xf9, 0x0d, 0x81, 0xb2, 0xe2, 0x13, 0x47, 0xf4, 0x6b, 0x22,
	0x8c, 0x2f, 0xbb, 0xb6, 0x3e, 0x07, 0x88, 0x13, 0x17, 0x95, 0xd6, 0x51, 0xd2, 0x9e, 0x40, 0xab,
	0x5f, 0xc2, 0xdc, 0x10, 0x49, 0x27, 0x12, 0xae, 0x1e, 0x82, 0x39, 0x93, 0x76, 0xdd, 0x16, 0x3d,
	0xe5, 0x78, 0x7d, 0x08, 0x33, 0x5c, 0x4c, 0x9d, 0x30, 0x2a, 0xf1, 0x72, 0x24, 0x2b, 0x2f, 0x7a,
	0xc6, 0xd9, 0x04, 0xb6, 0x94, 0x00, 0x9f, 0xd9, 0x03, 0x08, 0x25, 0x9b, 0x70, 0x61, 0x98, 0x90,
	0x93, 0x88, 0x52, 0xe5, 0xe7, 0x3c, 0xe4, 0xc5, 0x58, 0x94, 0x7f, 0x0b, 0xf0, 0x8f, 0x08, 0x26,
	0x57, 0x68, 0x80, 0xb5, 0xb4, 0x84, 0xf6, 0x2f, 0x52, 0x65, 0xa4, 0x35, 0xa1, 0xde, 0x7c, 0xfa,
	0xfb, 0x9f, 0x3f, 0x4c, 0x7c, 0x84, 0x3f, 0xd0, 0x3b, 0xc4, 0x21, 0x4d, 0x6a, 0x95, 0xfa, 0xd7,
	0x7c, 0x44, 0x9a, 0xe9, 0x8f, 0x63, 0x41, 0x4f, 0xc4, 0xf2, 0x67, 0xfa, 0xe3, 0x7d, 0x11, 0x4f,
	0xf0, 0x4f, 0x08, 0x32, 0x7c, 0x73, 0xe1, 0x72, 0x9a, 0xdb, 0x83, 0x3b, 0x57, 0x31, 0x8e, 0x80,
	0x90, 0x1b, 0x51, 0xad, 0x0a, 0xd6, 0x6f, 0xe3, 0xca, 0xd1, 0x59, 0xe3, 0x5f, 0x11, 0x64, 0xe5,
	0x6a, 0xc1, 0xa9, 0x9e, 0x07, 0x36, 0xa2, 0xf2, 0x5a, 0x3f, 0x24, 0xfe, 0xbb, 0xb3, 0xb6, 0xf7,
	0xa4, 0xde, 0xdb, 0xd9, 0x2d, 0x2a, 0x43, 0xd7, 0x57, 0x86, 0xbf, 0x09, 0xea, 0xef, 0xa9, 0xc7,
	0xa0, 0x5e, 0x45, 0x45, 0xdc, 0x43, 0x90, 0x95, 0x53, 0x39, 0x9d, 0xfd, 0xc0, 0xb6, 0x1b, 0x85,
	0x7d, 0x53, 0xb2, 0x1f, 0x32, 0xf9, 0x63, 0xf6, 0x37, 0x2a, 0x63, 0x96, 0x0b, 0x57, 0xf2, 0x07,
	0x82, 0xac, 0x9c, 0xc7, 0xe9, 0x4a, 0x06, 0xb6, 0xc6, 0x28, 0x4a, 0xc2, 0x9d, 0xdd, 0xe2, 0xe5,
	0xa1, 0x33, 0xff, 0x95, 0x83, 0x5b, 0xf7, 0xd3, 0x8e, 0x17, 0x6c, 0xc9, 0x4e, 0x28, 0x8e, 0xdb,
	0x09, 0x7f, 0x23, 0x38, 0x27, 0x26, 0x68, 0x3c, 0x17, 0x70, 0x35, 0xb5, 0x77, 0xff, 0x77, 0x8b,
	0x8c, 0xa2, 0xf4, 0x5b, 0xb4, 0xb3, 0x5b, 0x7c, 0xfd, 0xf0, 0xc1, 0x1d, 0x67, 0x6f, 0x43, 0xbd,
	0x3d, 0x66, 0xf6, 0x9a, 0xfd, 0xf2, 0x78, 0x36, 0xff, 0x41, 0x70, 0x5e, 0x8e, 0xc4, 0x84, 0xec,
	0xa5, 0x34, 0xd9, 0x87, 0x6c, 0x83, 0x51, 0x74, 0x3f, 0xe5, 0xba, 0x2f, 0xa6, 0xcc, 0xe2, 0x58,
	0xf8, 0x1d, 0x75, 0x6d, 0x4c, 0xe1, 0xfe, 0x01, 0x85, 0x55, 0x54, 0x5c, 0x5e, 0xdb, 0x5c, 0x6d,
	0xda, 0xc1, 0x83, 0xb0, 0xae, 0x35, 0xdc, 0x8e, 0x2e, 0x39, 0x97, 0xe4, 0xe7, 0x4e, 0xd3, 0x2d,
	0x35, 0xa9, 0x23, 0xaa, 0x4c, 0x3f, 0xfc, 0x73, 0x6a, 0x29, 0x7e, 0xab, 0x67, 0x05, 0xe0, 0xca,
	0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x14, 0x78, 0xfd, 0xcf, 0x3d, 0x0e, 0x00, 0x00,
}
