// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/redis/v1/backup_service.proto

package redis // import "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/redis/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetBackupRequest struct {
	// ID of the Redis backup to return.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId             string   `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBackupRequest) Reset()         { *m = GetBackupRequest{} }
func (m *GetBackupRequest) String() string { return proto.CompactTextString(m) }
func (*GetBackupRequest) ProtoMessage()    {}
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_service_9428ea5254459973, []int{0}
}
func (m *GetBackupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBackupRequest.Unmarshal(m, b)
}
func (m *GetBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBackupRequest.Marshal(b, m, deterministic)
}
func (dst *GetBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBackupRequest.Merge(dst, src)
}
func (m *GetBackupRequest) XXX_Size() int {
	return xxx_messageInfo_GetBackupRequest.Size(m)
}
func (m *GetBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBackupRequest proto.InternalMessageInfo

func (m *GetBackupRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type ListBackupsRequest struct {
	// ID of the folder to list backups in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListBackupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListBackupsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupsRequest) Reset()         { *m = ListBackupsRequest{} }
func (m *ListBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBackupsRequest) ProtoMessage()    {}
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_service_9428ea5254459973, []int{1}
}
func (m *ListBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupsRequest.Unmarshal(m, b)
}
func (m *ListBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupsRequest.Marshal(b, m, deterministic)
}
func (dst *ListBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupsRequest.Merge(dst, src)
}
func (m *ListBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBackupsRequest.Size(m)
}
func (m *ListBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupsRequest proto.InternalMessageInfo

func (m *ListBackupsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListBackupsResponse struct {
	// Requested list of backups.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListBackupsRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupsResponse) Reset()         { *m = ListBackupsResponse{} }
func (m *ListBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBackupsResponse) ProtoMessage()    {}
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_service_9428ea5254459973, []int{2}
}
func (m *ListBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupsResponse.Unmarshal(m, b)
}
func (m *ListBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupsResponse.Marshal(b, m, deterministic)
}
func (dst *ListBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupsResponse.Merge(dst, src)
}
func (m *ListBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBackupsResponse.Size(m)
}
func (m *ListBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupsResponse proto.InternalMessageInfo

func (m *ListBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetBackupRequest)(nil), "yandex.cloud.mdb.redis.v1.GetBackupRequest")
	proto.RegisterType((*ListBackupsRequest)(nil), "yandex.cloud.mdb.redis.v1.ListBackupsRequest")
	proto.RegisterType((*ListBackupsResponse)(nil), "yandex.cloud.mdb.redis.v1.ListBackupsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BackupServiceClient is the client API for BackupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackupServiceClient interface {
	// Returns the specified Redis backup.
	//
	// To get the list of available Redis backups, make a [List] request.
	Get(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Retrieves the list of Redis backups available for the specified folder.
	List(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
}

type backupServiceClient struct {
	cc *grpc.ClientConn
}

func NewBackupServiceClient(cc *grpc.ClientConn) BackupServiceClient {
	return &backupServiceClient{cc}
}

func (c *backupServiceClient) Get(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.redis.v1.BackupService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) List(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.redis.v1.BackupService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupServiceServer is the server API for BackupService service.
type BackupServiceServer interface {
	// Returns the specified Redis backup.
	//
	// To get the list of available Redis backups, make a [List] request.
	Get(context.Context, *GetBackupRequest) (*Backup, error)
	// Retrieves the list of Redis backups available for the specified folder.
	List(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
}

func RegisterBackupServiceServer(s *grpc.Server, srv BackupServiceServer) {
	s.RegisterService(&_BackupService_serviceDesc, srv)
}

func _BackupService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.redis.v1.BackupService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).Get(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.redis.v1.BackupService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).List(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.redis.v1.BackupService",
	HandlerType: (*BackupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _BackupService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _BackupService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/redis/v1/backup_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/redis/v1/backup_service.proto", fileDescriptor_backup_service_9428ea5254459973)
}

var fileDescriptor_backup_service_9428ea5254459973 = []byte{
	// 463 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xc1, 0x6e, 0x13, 0x31,
	0x10, 0x86, 0xb5, 0x49, 0x28, 0x59, 0x43, 0x05, 0x32, 0x97, 0x34, 0x80, 0x94, 0xac, 0x44, 0x1b,
	0x84, 0xd6, 0x5e, 0x17, 0xf5, 0xd4, 0xf6, 0x12, 0x84, 0xaa, 0x4a, 0x1c, 0xd0, 0x96, 0x13, 0x97,
	0xc8, 0x1b, 0x0f, 0x8b, 0xd5, 0xc4, 0x5e, 0x62, 0x27, 0x2a, 0x41, 0x5c, 0x10, 0x07, 0xd4, 0x23,
	0x3c, 0x01, 0x4f, 0xd3, 0xde, 0x79, 0x05, 0x0e, 0x3c, 0x03, 0x27, 0xb4, 0xf6, 0x06, 0x68, 0x51,
	0x1a, 0x6e, 0x96, 0xe7, 0xff, 0x67, 0x3e, 0xfd, 0x33, 0x88, 0xbc, 0xe5, 0x4a, 0xc0, 0x09, 0x1d,
	0x8e, 0xf4, 0x54, 0xd0, 0xb1, 0xc8, 0xe8, 0x04, 0x84, 0x34, 0x74, 0xc6, 0x68, 0xc6, 0x87, 0xc7,
	0xd3, 0x62, 0x60, 0x60, 0x32, 0x93, 0x43, 0x20, 0xc5, 0x44, 0x5b, 0x8d, 0x37, 0xbc, 0x9e, 0x38,
	0x3d, 0x19, 0x8b, 0x8c, 0x38, 0x3d, 0x99, 0xb1, 0xf6, 0xbd, 0x5c, 0xeb, 0x7c, 0x04, 0x94, 0x17,
	0x92, 0x72, 0xa5, 0xb4, 0xe5, 0x56, 0x6a, 0x65, 0xbc, 0xb1, 0x7d, 0xff, 0xc2, 0xa0, 0x19, 0x1f,
	0x49, 0xe1, 0xea, 0x55, 0x79, 0x73, 0x15, 0x87, 0xd7, 0x45, 0x3b, 0xe8, 0xf6, 0x01, 0xd8, 0xbe,
	0xfb, 0x4a, 0xe1, 0xcd, 0x14, 0x8c, 0xc5, 0x5d, 0x14, 0x56, 0xac, 0x52, 0xb4, 0x82, 0x4e, 0xd0,
	0x0b, 0xfb, 0x8d, 0x1f, 0x67, 0x2c, 0x48, 0x9b, 0xfe, 0xfb, 0x50, 0x44, 0x9f, 0x03, 0x84, 0x9f,
	0x49, 0x53, 0x19, 0xcd, 0xc2, 0xf9, 0x10, 0x85, 0xaf, 0xf4, 0x48, 0xc0, 0xe4, 0x8f, 0xf3, 0x66,
	0xe9, 0x3c, 0x3d, 0x67, 0x8d, 0xbd, 0xfd, 0x9d, 0x24, 0x6d, 0xfa, 0xf2, 0xa1, 0xc0, 0x5b, 0x28,
	0x2c, 0x78, 0x0e, 0x03, 0x23, 0xe7, 0xd0, 0xaa, 0x75, 0x82, 0x5e, 0xbd, 0x8f, 0x7e, 0x9e, 0xb1,
	0xb5, 0x24, 0x66, 0x49, 0x92, 0xa4, 0xcd, 0xb2, 0x78, 0x24, 0xe7, 0x80, 0x7b, 0x08, 0x39, 0xa1,
	0xd5, 0xc7, 0xa0, 0x5a, 0x75, 0xd7, 0x34, 0x3c, 0x3d, 0x67, 0xd7, 0xf6, 0xf6, 0x59, 0x92, 0xa4,
	0xae, 0xcb, 0x8b, 0xb2, 0x16, 0xcd, 0xd1, 0x9d, 0x0b, 0x4c, 0xa6, 0xd0, 0xca, 0x00, 0xde, 0x45,
	0xd7, 0x3d, 0xb7, 0x69, 0x05, 0x9d, 0x7a, 0xef, 0xc6, 0x76, 0x97, 0x2c, 0x0d, 0x9d, 0x54, 0x49,
	0x2c, 0x1c, 0x78, 0x13, 0xdd, 0x52, 0x70, 0x62, 0x07, 0x7f, 0x21, 0x94, 0xb0, 0x61, 0xba, 0x5e,
	0x7e, 0x3f, 0x5f, 0xcc, 0xde, 0xfe, 0x5a, 0x43, 0xeb, 0xde, 0x7b, 0xe4, 0xf7, 0x8b, 0x3f, 0x06,
	0xa8, 0x7e, 0x00, 0x16, 0x3f, 0xba, 0x62, 0xda, 0xe5, 0xe8, 0xdb, 0xab, 0xd1, 0xa2, 0xf8, 0xc3,
	0xb7, 0xef, 0x5f, 0x6a, 0x5b, 0xf8, 0x01, 0x1d, 0x73, 0xc5, 0x73, 0x10, 0xf1, 0xa5, 0xcd, 0x1a,
	0xfa, 0xee, 0xf7, 0xfa, 0xde, 0xe3, 0x4f, 0x01, 0x6a, 0x94, 0xa9, 0xe0, 0xf8, 0x8a, 0xd6, 0xff,
	0xae, 0xb2, 0x4d, 0xfe, 0x57, 0xee, 0x53, 0x8e, 0xba, 0x0e, 0xeb, 0x2e, 0xde, 0x58, 0x8a, 0xd5,
	0x7f, 0xfa, 0xf2, 0x49, 0x2e, 0xed, 0xeb, 0x69, 0x46, 0x86, 0x7a, 0x4c, 0x7d, 0xfb, 0xd8, 0x1f,
	0x68, 0xae, 0xe3, 0x1c, 0x94, 0x3b, 0x49, 0xba, 0xf4, 0x72, 0x77, 0xdd, 0x23, 0x5b, 0x73, 0xb2,
	0xc7, 0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0xcd, 0x5a, 0x72, 0x2d, 0x6b, 0x03, 0x00, 0x00,
}
