// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/vpc/v1/network_service.proto

package vpc // import "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/yandex-cloud/go-genproto/yandex/api"
import operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
import _ "github.com/yandex-cloud/go-genproto/yandex/cloud/validation"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetNetworkRequest struct {
	// ID of the Network resource to return.
	// To get the network ID, use a [NetworkService.List] request.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNetworkRequest) Reset()         { *m = GetNetworkRequest{} }
func (m *GetNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*GetNetworkRequest) ProtoMessage()    {}
func (*GetNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{0}
}
func (m *GetNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNetworkRequest.Unmarshal(m, b)
}
func (m *GetNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNetworkRequest.Marshal(b, m, deterministic)
}
func (dst *GetNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNetworkRequest.Merge(dst, src)
}
func (m *GetNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_GetNetworkRequest.Size(m)
}
func (m *GetNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNetworkRequest proto.InternalMessageInfo

func (m *GetNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type ListNetworksRequest struct {
	// ID of the folder to list networks in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNetworksResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListNetworksResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Network.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworksRequest) Reset()         { *m = ListNetworksRequest{} }
func (m *ListNetworksRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworksRequest) ProtoMessage()    {}
func (*ListNetworksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{1}
}
func (m *ListNetworksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworksRequest.Unmarshal(m, b)
}
func (m *ListNetworksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworksRequest.Marshal(b, m, deterministic)
}
func (dst *ListNetworksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworksRequest.Merge(dst, src)
}
func (m *ListNetworksRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworksRequest.Size(m)
}
func (m *ListNetworksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworksRequest proto.InternalMessageInfo

func (m *ListNetworksRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListNetworksRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNetworksRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListNetworksResponse struct {
	// List of Network resources.
	Networks []*Network `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworksRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListNetworksRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworksResponse) Reset()         { *m = ListNetworksResponse{} }
func (m *ListNetworksResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworksResponse) ProtoMessage()    {}
func (*ListNetworksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{2}
}
func (m *ListNetworksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworksResponse.Unmarshal(m, b)
}
func (m *ListNetworksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworksResponse.Marshal(b, m, deterministic)
}
func (dst *ListNetworksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworksResponse.Merge(dst, src)
}
func (m *ListNetworksResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworksResponse.Size(m)
}
func (m *ListNetworksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworksResponse proto.InternalMessageInfo

func (m *ListNetworksResponse) GetNetworks() []*Network {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *ListNetworksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateNetworkRequest struct {
	// ID of the folder for this request to create a network in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the network.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the network.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateNetworkRequest) Reset()         { *m = CreateNetworkRequest{} }
func (m *CreateNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNetworkRequest) ProtoMessage()    {}
func (*CreateNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{3}
}
func (m *CreateNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNetworkRequest.Unmarshal(m, b)
}
func (m *CreateNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNetworkRequest.Marshal(b, m, deterministic)
}
func (dst *CreateNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNetworkRequest.Merge(dst, src)
}
func (m *CreateNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNetworkRequest.Size(m)
}
func (m *CreateNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNetworkRequest proto.InternalMessageInfo

func (m *CreateNetworkRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateNetworkRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateNetworkRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateNetworkRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateNetworkMetadata struct {
	// ID of the Network that is being created.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNetworkMetadata) Reset()         { *m = CreateNetworkMetadata{} }
func (m *CreateNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateNetworkMetadata) ProtoMessage()    {}
func (*CreateNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{4}
}
func (m *CreateNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNetworkMetadata.Unmarshal(m, b)
}
func (m *CreateNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNetworkMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNetworkMetadata.Merge(dst, src)
}
func (m *CreateNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateNetworkMetadata.Size(m)
}
func (m *CreateNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNetworkMetadata proto.InternalMessageInfo

func (m *CreateNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type UpdateNetworkRequest struct {
	// ID of the Network resource to update.
	// To get the network ID use a [NetworkService.List] request.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Field mask that specifies which fields of the Network resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the network.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the network.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateNetworkRequest) Reset()         { *m = UpdateNetworkRequest{} }
func (m *UpdateNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNetworkRequest) ProtoMessage()    {}
func (*UpdateNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{5}
}
func (m *UpdateNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNetworkRequest.Unmarshal(m, b)
}
func (m *UpdateNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNetworkRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNetworkRequest.Merge(dst, src)
}
func (m *UpdateNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNetworkRequest.Size(m)
}
func (m *UpdateNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNetworkRequest proto.InternalMessageInfo

func (m *UpdateNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *UpdateNetworkRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateNetworkRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNetworkRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateNetworkRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateNetworkMetadata struct {
	// ID of the Network resource that is being updated.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNetworkMetadata) Reset()         { *m = UpdateNetworkMetadata{} }
func (m *UpdateNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateNetworkMetadata) ProtoMessage()    {}
func (*UpdateNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{6}
}
func (m *UpdateNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNetworkMetadata.Unmarshal(m, b)
}
func (m *UpdateNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNetworkMetadata.Marshal(b, m, deterministic)
}
func (dst *UpdateNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNetworkMetadata.Merge(dst, src)
}
func (m *UpdateNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateNetworkMetadata.Size(m)
}
func (m *UpdateNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNetworkMetadata proto.InternalMessageInfo

func (m *UpdateNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type DeleteNetworkRequest struct {
	// ID of the Network resource to update.
	// To get the network ID, use a [NetworkService.List] request.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNetworkRequest) Reset()         { *m = DeleteNetworkRequest{} }
func (m *DeleteNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNetworkRequest) ProtoMessage()    {}
func (*DeleteNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{7}
}
func (m *DeleteNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNetworkRequest.Unmarshal(m, b)
}
func (m *DeleteNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNetworkRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNetworkRequest.Merge(dst, src)
}
func (m *DeleteNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNetworkRequest.Size(m)
}
func (m *DeleteNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNetworkRequest proto.InternalMessageInfo

func (m *DeleteNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type DeleteNetworkMetadata struct {
	// ID of the network that is being deleted.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNetworkMetadata) Reset()         { *m = DeleteNetworkMetadata{} }
func (m *DeleteNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteNetworkMetadata) ProtoMessage()    {}
func (*DeleteNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{8}
}
func (m *DeleteNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNetworkMetadata.Unmarshal(m, b)
}
func (m *DeleteNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNetworkMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNetworkMetadata.Merge(dst, src)
}
func (m *DeleteNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteNetworkMetadata.Size(m)
}
func (m *DeleteNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNetworkMetadata proto.InternalMessageInfo

func (m *DeleteNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type ListNetworkSubnetsRequest struct {
	// ID of the Network resource to list subnets for.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNetworkSubnetsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListNetworkSubnetsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkSubnetsRequest) Reset()         { *m = ListNetworkSubnetsRequest{} }
func (m *ListNetworkSubnetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworkSubnetsRequest) ProtoMessage()    {}
func (*ListNetworkSubnetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{9}
}
func (m *ListNetworkSubnetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Unmarshal(m, b)
}
func (m *ListNetworkSubnetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListNetworkSubnetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkSubnetsRequest.Merge(dst, src)
}
func (m *ListNetworkSubnetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Size(m)
}
func (m *ListNetworkSubnetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkSubnetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkSubnetsRequest proto.InternalMessageInfo

func (m *ListNetworkSubnetsRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *ListNetworkSubnetsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworkSubnetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListNetworkSubnetsResponse struct {
	// List of subnets that belong to the network which is specified in the request.
	Subnets []*Subnet `protobuf:"bytes,1,rep,name=subnets,proto3" json:"subnets,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworkSubnetsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListNetworkSubnetsRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkSubnetsResponse) Reset()         { *m = ListNetworkSubnetsResponse{} }
func (m *ListNetworkSubnetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworkSubnetsResponse) ProtoMessage()    {}
func (*ListNetworkSubnetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{10}
}
func (m *ListNetworkSubnetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Unmarshal(m, b)
}
func (m *ListNetworkSubnetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListNetworkSubnetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkSubnetsResponse.Merge(dst, src)
}
func (m *ListNetworkSubnetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Size(m)
}
func (m *ListNetworkSubnetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkSubnetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkSubnetsResponse proto.InternalMessageInfo

func (m *ListNetworkSubnetsResponse) GetSubnets() []*Subnet {
	if m != nil {
		return m.Subnets
	}
	return nil
}

func (m *ListNetworkSubnetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListNetworkOperationsRequest struct {
	// ID of the Network resource to list operations for.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListNetworkOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListNetworkOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkOperationsRequest) Reset()         { *m = ListNetworkOperationsRequest{} }
func (m *ListNetworkOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworkOperationsRequest) ProtoMessage()    {}
func (*ListNetworkOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{11}
}
func (m *ListNetworkOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkOperationsRequest.Unmarshal(m, b)
}
func (m *ListNetworkOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListNetworkOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkOperationsRequest.Merge(dst, src)
}
func (m *ListNetworkOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworkOperationsRequest.Size(m)
}
func (m *ListNetworkOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkOperationsRequest proto.InternalMessageInfo

func (m *ListNetworkOperationsRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *ListNetworkOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworkOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListNetworkOperationsResponse struct {
	// List of operations for the specified network.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworkOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListNetworkOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkOperationsResponse) Reset()         { *m = ListNetworkOperationsResponse{} }
func (m *ListNetworkOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworkOperationsResponse) ProtoMessage()    {}
func (*ListNetworkOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_network_service_ee3168d16ae63f82, []int{12}
}
func (m *ListNetworkOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkOperationsResponse.Unmarshal(m, b)
}
func (m *ListNetworkOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListNetworkOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkOperationsResponse.Merge(dst, src)
}
func (m *ListNetworkOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworkOperationsResponse.Size(m)
}
func (m *ListNetworkOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkOperationsResponse proto.InternalMessageInfo

func (m *ListNetworkOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListNetworkOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetNetworkRequest)(nil), "yandex.cloud.vpc.v1.GetNetworkRequest")
	proto.RegisterType((*ListNetworksRequest)(nil), "yandex.cloud.vpc.v1.ListNetworksRequest")
	proto.RegisterType((*ListNetworksResponse)(nil), "yandex.cloud.vpc.v1.ListNetworksResponse")
	proto.RegisterType((*CreateNetworkRequest)(nil), "yandex.cloud.vpc.v1.CreateNetworkRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.CreateNetworkRequest.LabelsEntry")
	proto.RegisterType((*CreateNetworkMetadata)(nil), "yandex.cloud.vpc.v1.CreateNetworkMetadata")
	proto.RegisterType((*UpdateNetworkRequest)(nil), "yandex.cloud.vpc.v1.UpdateNetworkRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.UpdateNetworkRequest.LabelsEntry")
	proto.RegisterType((*UpdateNetworkMetadata)(nil), "yandex.cloud.vpc.v1.UpdateNetworkMetadata")
	proto.RegisterType((*DeleteNetworkRequest)(nil), "yandex.cloud.vpc.v1.DeleteNetworkRequest")
	proto.RegisterType((*DeleteNetworkMetadata)(nil), "yandex.cloud.vpc.v1.DeleteNetworkMetadata")
	proto.RegisterType((*ListNetworkSubnetsRequest)(nil), "yandex.cloud.vpc.v1.ListNetworkSubnetsRequest")
	proto.RegisterType((*ListNetworkSubnetsResponse)(nil), "yandex.cloud.vpc.v1.ListNetworkSubnetsResponse")
	proto.RegisterType((*ListNetworkOperationsRequest)(nil), "yandex.cloud.vpc.v1.ListNetworkOperationsRequest")
	proto.RegisterType((*ListNetworkOperationsResponse)(nil), "yandex.cloud.vpc.v1.ListNetworkOperationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NetworkServiceClient is the client API for NetworkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NetworkServiceClient interface {
	// Returns the specified Network resource.
	//
	// Get the list of available Network resources by making a [List] request.
	Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Retrieves the list of Network resources in the specified folder.
	List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error)
	// Creates a network in the specified folder using the data specified in the request.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified network.
	Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists subnets from the specified network.
	ListSubnets(ctx context.Context, in *ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*ListNetworkSubnetsResponse, error)
	// Lists operations for the specified network.
	ListOperations(ctx context.Context, in *ListNetworkOperationsRequest, opts ...grpc.CallOption) (*ListNetworkOperationsResponse, error)
}

type networkServiceClient struct {
	cc *grpc.ClientConn
}

func NewNetworkServiceClient(cc *grpc.ClientConn) NetworkServiceClient {
	return &networkServiceClient{cc}
}

func (c *networkServiceClient) Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error) {
	out := new(ListNetworksResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Create(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Update(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) ListSubnets(ctx context.Context, in *ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*ListNetworkSubnetsResponse, error) {
	out := new(ListNetworkSubnetsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/ListSubnets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) ListOperations(ctx context.Context, in *ListNetworkOperationsRequest, opts ...grpc.CallOption) (*ListNetworkOperationsResponse, error) {
	out := new(ListNetworkOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkServiceServer is the server API for NetworkService service.
type NetworkServiceServer interface {
	// Returns the specified Network resource.
	//
	// Get the list of available Network resources by making a [List] request.
	Get(context.Context, *GetNetworkRequest) (*Network, error)
	// Retrieves the list of Network resources in the specified folder.
	List(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error)
	// Creates a network in the specified folder using the data specified in the request.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateNetworkRequest) (*operation.Operation, error)
	// Updates the specified network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(context.Context, *UpdateNetworkRequest) (*operation.Operation, error)
	// Deletes the specified network.
	Delete(context.Context, *DeleteNetworkRequest) (*operation.Operation, error)
	// Lists subnets from the specified network.
	ListSubnets(context.Context, *ListNetworkSubnetsRequest) (*ListNetworkSubnetsResponse, error)
	// Lists operations for the specified network.
	ListOperations(context.Context, *ListNetworkOperationsRequest) (*ListNetworkOperationsResponse, error)
}

func RegisterNetworkServiceServer(s *grpc.Server, srv NetworkServiceServer) {
	s.RegisterService(&_NetworkService_serviceDesc, srv)
}

func _NetworkService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Get(ctx, req.(*GetNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).List(ctx, req.(*ListNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Create(ctx, req.(*CreateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Update(ctx, req.(*UpdateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Delete(ctx, req.(*DeleteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_ListSubnets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).ListSubnets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/ListSubnets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).ListSubnets(ctx, req.(*ListNetworkSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).ListOperations(ctx, req.(*ListNetworkOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.vpc.v1.NetworkService",
	HandlerType: (*NetworkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _NetworkService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _NetworkService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _NetworkService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkService_Delete_Handler,
		},
		{
			MethodName: "ListSubnets",
			Handler:    _NetworkService_ListSubnets_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _NetworkService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/vpc/v1/network_service.proto",
}

func init() {
	proto.RegisterFile("yandex/cloud/vpc/v1/network_service.proto", fileDescriptor_network_service_ee3168d16ae63f82)
}

var fileDescriptor_network_service_ee3168d16ae63f82 = []byte{
	// 1041 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x6f, 0xdb, 0x64,
	0x18, 0x96, 0x9b, 0x34, 0x6b, 0xde, 0xc0, 0x28, 0xdf, 0x52, 0x29, 0x98, 0x46, 0xa4, 0x96, 0xd6,
	0xa5, 0x19, 0xb6, 0xe3, 0x8c, 0x44, 0xeb, 0xba, 0x6a, 0x90, 0x31, 0xa6, 0x49, 0x1d, 0x20, 0x0f,
	0x84, 0x44, 0x35, 0x45, 0x4e, 0xfc, 0x35, 0x58, 0x71, 0x6d, 0x63, 0x3b, 0xa1, 0x3f, 0xd8, 0x65,
	0xc7, 0x1e, 0xb8, 0x70, 0xe0, 0x80, 0xe0, 0xc4, 0x85, 0x13, 0xa8, 0x17, 0x24, 0xfe, 0x81, 0xf6,
	0x3c, 0xfe, 0x05, 0x0e, 0x5c, 0xd9, 0x91, 0x13, 0xf2, 0xf7, 0x7d, 0x4e, 0xe3, 0xc6, 0x49, 0x5c,
	0xc6, 0x61, 0x37, 0xbb, 0xef, 0xf3, 0xbd, 0xef, 0xf3, 0x3d, 0xef, 0xdb, 0xe7, 0x75, 0x60, 0x6d,
	0x5f, 0xb3, 0x74, 0xbc, 0x27, 0x77, 0x4c, 0xbb, 0xaf, 0xcb, 0x03, 0xa7, 0x23, 0x0f, 0x14, 0xd9,
	0xc2, 0xfe, 0x57, 0xb6, 0xdb, 0x6b, 0x79, 0xd8, 0x1d, 0x18, 0x1d, 0x2c, 0x39, 0xae, 0xed, 0xdb,
	0xe8, 0x0a, 0x85, 0x4a, 0x04, 0x2a, 0x0d, 0x9c, 0x8e, 0x34, 0x50, 0xf8, 0xe5, 0xae, 0x6d, 0x77,
	0x4d, 0x2c, 0x6b, 0x8e, 0x21, 0x6b, 0x96, 0x65, 0xfb, 0x9a, 0x6f, 0xd8, 0x96, 0x47, 0x8f, 0xf0,
	0x25, 0x16, 0x25, 0x6f, 0xed, 0xfe, 0x8e, 0xbc, 0x63, 0x60, 0x53, 0x6f, 0xed, 0x6a, 0x5e, 0x8f,
	0x21, 0x78, 0x56, 0x3f, 0x38, 0x6f, 0x3b, 0xd8, 0x25, 0xc7, 0x59, 0x6c, 0x65, 0x0a, 0xb7, 0xb0,
	0x40, 0x1c, 0xc4, 0xeb, 0xb7, 0x2d, 0xec, 0x33, 0xc4, 0x6a, 0x04, 0x31, 0x2c, 0x31, 0x56, 0xac,
	0x18, 0xcd, 0xa4, 0x99, 0x86, 0x3e, 0x12, 0x16, 0xde, 0x85, 0xd7, 0xef, 0x63, 0xff, 0x43, 0x5a,
	0x5c, 0xc5, 0x5f, 0xf6, 0xb1, 0xe7, 0xa3, 0xeb, 0x00, 0xa1, 0x54, 0x86, 0x5e, 0xe0, 0x4a, 0x5c,
	0x39, 0xdb, 0x7c, 0xe5, 0xaf, 0x13, 0x85, 0x3b, 0x3a, 0x55, 0xd2, 0xb7, 0x37, 0xeb, 0x55, 0x35,
	0xcb, 0xe2, 0x0f, 0x74, 0xe1, 0x37, 0x0e, 0xae, 0x6c, 0x19, 0x5e, 0x98, 0xc3, 0x0b, 0x93, 0xac,
	0x41, 0x76, 0xc7, 0x36, 0x75, 0xec, 0x4e, 0xca, 0xb1, 0x40, 0xc3, 0x0f, 0x74, 0x74, 0x0d, 0xb2,
	0x8e, 0xd6, 0xc5, 0x2d, 0xcf, 0x38, 0xc0, 0x85, 0xb9, 0x12, 0x57, 0x4e, 0x35, 0xe1, 0x9f, 0x13,
	0x25, 0x73, 0x7b, 0x53, 0xa9, 0x56, 0xab, 0xea, 0x42, 0x10, 0x7c, 0x64, 0x1c, 0x60, 0x54, 0x06,
	0x20, 0x40, 0xdf, 0xee, 0x61, 0xab, 0x90, 0x22, 0x49, 0xb3, 0x47, 0xa7, 0xca, 0x3c, 0x41, 0xaa,
	0x24, 0xcb, 0x27, 0x41, 0x0c, 0x09, 0x90, 0xd9, 0x31, 0x4c, 0x1f, 0xbb, 0x85, 0x34, 0x41, 0xc1,
	0xd1, 0xe9, 0x30, 0x1f, 0x8b, 0x08, 0x7b, 0x90, 0x8f, 0x12, 0xf7, 0x1c, 0xdb, 0xf2, 0x30, 0xba,
	0x09, 0x0b, 0xec, 0x7a, 0x5e, 0x81, 0x2b, 0xa5, 0xca, 0xb9, 0xda, 0xb2, 0x14, 0x33, 0x23, 0x52,
	0xa8, 0xda, 0x10, 0x8d, 0x56, 0xe1, 0x35, 0x0b, 0xef, 0xf9, 0xad, 0x11, 0x92, 0xc1, 0x75, 0xb2,
	0xea, 0xab, 0xc1, 0x9f, 0x3f, 0x0e, 0xd9, 0x09, 0x7f, 0xcf, 0x41, 0xfe, 0xae, 0x8b, 0x35, 0x1f,
	0x9f, 0x53, 0xfe, 0x02, 0xa2, 0xd5, 0x21, 0x6d, 0x69, 0xbb, 0x54, 0xaf, 0x6c, 0x73, 0xe5, 0xf9,
	0x89, 0x52, 0xfc, 0x7a, 0x5b, 0x13, 0x0f, 0x1e, 0x6f, 0x8b, 0x9a, 0x78, 0x50, 0x15, 0xd7, 0x1f,
	0x1f, 0x2a, 0x6f, 0x37, 0x94, 0x27, 0xdb, 0xec, 0x4d, 0x25, 0x70, 0x74, 0x1d, 0x72, 0x3a, 0xf6,
	0x3a, 0xae, 0xe1, 0x04, 0x53, 0x10, 0xd5, 0xb0, 0x56, 0x6f, 0xa8, 0xa3, 0x51, 0xf4, 0x0d, 0x07,
	0x19, 0x53, 0x6b, 0x63, 0xd3, 0x2b, 0xa4, 0x89, 0x10, 0xf5, 0x58, 0x21, 0xe2, 0xae, 0x22, 0x6d,
	0x91, 0x73, 0xf7, 0x2c, 0xdf, 0xdd, 0x6f, 0xde, 0x79, 0x7e, 0xa2, 0xe4, 0xb6, 0xc5, 0x56, 0x55,
	0x5c, 0x0f, 0x18, 0x56, 0x9e, 0x92, 0xeb, 0x34, 0xde, 0xa1, 0xd7, 0x6a, 0xdc, 0x38, 0x3e, 0x55,
	0x32, 0x7c, 0x5a, 0x11, 0xc9, 0x13, 0x42, 0x8b, 0xec, 0x1e, 0x43, 0xbc, 0xca, 0x58, 0xf0, 0xeb,
	0x90, 0x1b, 0xc9, 0x8b, 0x16, 0x21, 0xd5, 0xc3, 0xfb, 0x54, 0x28, 0x35, 0x78, 0x44, 0x79, 0x98,
	0x1f, 0x68, 0x66, 0x9f, 0xc9, 0xa2, 0xd2, 0x97, 0x5b, 0x73, 0x37, 0x39, 0xa1, 0x01, 0x4b, 0x11,
	0x9e, 0x0f, 0xb1, 0xaf, 0xe9, 0x9a, 0xaf, 0xa1, 0xe2, 0xf8, 0xb4, 0x8f, 0xce, 0xf7, 0xaf, 0x29,
	0xc8, 0x7f, 0xea, 0xe8, 0xe3, 0xbd, 0xba, 0xc8, 0x7f, 0x09, 0xda, 0x80, 0x5c, 0x9f, 0x24, 0x21,
	0x26, 0x41, 0xd8, 0xe5, 0x6a, 0xbc, 0x44, 0x7d, 0x44, 0x0a, 0x7d, 0x44, 0xfa, 0x20, 0xf0, 0x91,
	0x87, 0x9a, 0xd7, 0x53, 0x81, 0xc2, 0x83, 0xe7, 0x61, 0xab, 0x53, 0x2f, 0xd4, 0xea, 0x74, 0xd2,
	0x56, 0xcf, 0x4f, 0x69, 0x75, 0x9c, 0x12, 0x2f, 0x63, 0xab, 0x23, 0x3c, 0x93, 0xb6, 0xfa, 0x2e,
	0xe4, 0xdf, 0xc7, 0x26, 0x7e, 0xa1, 0x4e, 0x07, 0xc5, 0x23, 0x49, 0x92, 0x16, 0xff, 0x9e, 0x83,
	0x37, 0x46, 0xec, 0xe8, 0x11, 0x31, 0x7b, 0xef, 0x3f, 0x0d, 0xdb, 0xff, 0xef, 0xa7, 0xc2, 0x21,
	0xf0, 0x71, 0xe4, 0x98, 0x63, 0xd6, 0xe1, 0x12, 0x5d, 0x4e, 0xa1, 0x61, 0xbe, 0x19, 0x3b, 0x3c,
	0xf4, 0x98, 0x1a, 0x62, 0x13, 0xdb, 0xe5, 0x8f, 0x1c, 0x2c, 0x8f, 0x54, 0xff, 0x28, 0x5c, 0x71,
	0x2f, 0x8d, 0x3a, 0x47, 0x1c, 0x14, 0x27, 0x10, 0x64, 0x0a, 0xbd, 0x07, 0x30, 0xdc, 0xcc, 0xa1,
	0x48, 0x2b, 0x51, 0x91, 0xce, 0x36, 0xf7, 0xf0, 0xbc, 0x3a, 0x72, 0x28, 0xa9, 0x5a, 0xb5, 0xdf,
	0x17, 0xe0, 0x72, 0xd8, 0x27, 0xfa, 0xa1, 0x83, 0x5c, 0x48, 0xdd, 0xc7, 0x3e, 0x5a, 0x8d, 0xed,
	0xca, 0xd8, 0xfe, 0xe7, 0xa7, 0xae, 0x3b, 0xe1, 0xea, 0xd3, 0x3f, 0xfe, 0xfc, 0x76, 0xee, 0x2d,
	0x54, 0x3c, 0xf7, 0xe9, 0xe2, 0xc9, 0x87, 0x67, 0x4d, 0x78, 0x82, 0xfa, 0x90, 0x0e, 0x24, 0x41,
	0xe5, 0xd8, 0x64, 0x31, 0x5f, 0x0c, 0xfc, 0x5a, 0x02, 0x24, 0x95, 0x53, 0x28, 0x10, 0x0e, 0x08,
	0x2d, 0x9e, 0xe7, 0x80, 0xbe, 0xe3, 0x20, 0x43, 0x7d, 0x1e, 0xad, 0x25, 0x5e, 0x56, 0xfc, 0xec,
	0x56, 0x08, 0x77, 0x8e, 0x9f, 0x55, 0x4a, 0x93, 0x76, 0xc8, 0x25, 0xf6, 0x07, 0x42, 0x6b, 0x49,
	0x18, 0xa3, 0x75, 0x8b, 0xab, 0xa0, 0x9f, 0x38, 0xc8, 0x50, 0x5b, 0x9a, 0xc0, 0x2c, 0xce, 0x5b,
	0x93, 0x30, 0xdb, 0xa2, 0xcc, 0xe2, 0x2d, 0x2f, 0xc2, 0x4c, 0xa8, 0x4d, 0x6f, 0x5a, 0x40, 0xf3,
	0x17, 0x0e, 0x32, 0xd4, 0xc0, 0x26, 0xd0, 0x8c, 0xb3, 0xc8, 0x24, 0x34, 0x3f, 0x3b, 0x7e, 0x56,
	0x91, 0x26, 0x99, 0xe3, 0xd2, 0xf9, 0x4d, 0x78, 0x6f, 0xd7, 0xf1, 0xf7, 0xe9, 0xa4, 0x55, 0x66,
	0x4c, 0xda, 0x0f, 0x1c, 0xe4, 0x82, 0x29, 0x61, 0xae, 0x84, 0xa4, 0x59, 0x73, 0x14, 0xf5, 0x56,
	0x5e, 0x4e, 0x8c, 0x67, 0xd3, 0x27, 0x12, 0x5e, 0xd7, 0xd0, 0xd5, 0xa9, 0xbc, 0xe4, 0xd0, 0xe6,
	0x7e, 0xe6, 0xe0, 0x72, 0x90, 0xed, 0xcc, 0x16, 0x90, 0x32, 0xab, 0xe4, 0x98, 0xc7, 0xf1, 0xb5,
	0x8b, 0x1c, 0x61, 0x44, 0xab, 0x84, 0x68, 0x05, 0x95, 0xa7, 0x13, 0x3d, 0x33, 0x99, 0xe6, 0xe6,
	0xe7, 0x1b, 0x5d, 0xc3, 0xff, 0xa2, 0xdf, 0x96, 0x3a, 0xf6, 0xae, 0x4c, 0x2b, 0x8a, 0xf4, 0xb7,
	0x43, 0xd7, 0x16, 0xbb, 0xd8, 0x22, 0x0d, 0x92, 0x63, 0x7e, 0x9e, 0x6c, 0x0c, 0x9c, 0x4e, 0x3b,
	0x43, 0xc2, 0x37, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xae, 0xe7, 0x44, 0x00, 0x7f, 0x0d, 0x00,
	0x00,
}
