-   `spot_instance_types` (array of strings) - a list of acceptable instance
    types to run your build on. We will request a spot instance using the max
    price of `spot_price` and the allocation strategy of "lowest price".
    Your instance will be launched on an instance type of the lowest available
    price that you have in your list.  This is used in place of instance_type.
    You may only set either spot_instance_types or instance_type, not both.
    This feature exists to help prevent situations where a Packer build fails
    because a particular availability zone does not have capacity for the
    specific instance_type requested in instance_type.

-   `spot_price` (string) - The maximum hourly price to pay for a spot instance
    to create the AMI. Spot instances are a type of instance that EC2 starts
    when the current spot price is less than the maximum price you specify.
    Spot price will be updated based on available spot instance capacity and
    current spot instance requests. It may save you some costs. You can set
    this to `auto` for Packer to automatically discover the best spot price or
    to "0" to use an on demand instance (default).

-   `spot_price_auto_product` (string) - Required if `spot_price` is set to
    `auto`. This tells Packer what sort of AMI you're launching to find the
    best spot price. This must be one of: `Linux/UNIX`, `SUSE Linux`,
    `Windows`, `Linux/UNIX (Amazon VPC)`, `SUSE Linux (Amazon VPC)`,
    `Windows (Amazon VPC)`

-   `spot_tags` (object of key/value strings) - Requires `spot_price` to be
    set. This tells Packer to apply tags to the spot request that is issued.