// Code generated by protoc-gen-go. DO NOT EDIT.
// source: api.proto

package pb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EventType int32

const (
	EventType_ADDED    EventType = 0
	EventType_MODIFIED EventType = 1
	EventType_DELETED  EventType = 2
)

var EventType_name = map[int32]string{
	0: "ADDED",
	1: "MODIFIED",
	2: "DELETED",
}

var EventType_value = map[string]int32{
	"ADDED":    0,
	"MODIFIED": 1,
	"DELETED":  2,
}

func (x EventType) String() string {
	return proto.EnumName(EventType_name, int32(x))
}

func (EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}

type TagCardinality int32

const (
	TagCardinality_LOW          TagCardinality = 0
	TagCardinality_ORCHESTRATOR TagCardinality = 1
	TagCardinality_HIGH         TagCardinality = 2
)

var TagCardinality_name = map[int32]string{
	0: "LOW",
	1: "ORCHESTRATOR",
	2: "HIGH",
}

var TagCardinality_value = map[string]int32{
	"LOW":          0,
	"ORCHESTRATOR": 1,
	"HIGH":         2,
}

func (x TagCardinality) String() string {
	return proto.EnumName(TagCardinality_name, int32(x))
}

func (TagCardinality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{1}
}

type HostnameRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostnameRequest) Reset()         { *m = HostnameRequest{} }
func (m *HostnameRequest) String() string { return proto.CompactTextString(m) }
func (*HostnameRequest) ProtoMessage()    {}
func (*HostnameRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}

func (m *HostnameRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostnameRequest.Unmarshal(m, b)
}
func (m *HostnameRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostnameRequest.Marshal(b, m, deterministic)
}
func (m *HostnameRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostnameRequest.Merge(m, src)
}
func (m *HostnameRequest) XXX_Size() int {
	return xxx_messageInfo_HostnameRequest.Size(m)
}
func (m *HostnameRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HostnameRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HostnameRequest proto.InternalMessageInfo

// The response message containing the requested hostname
type HostnameReply struct {
	Hostname             string   `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HostnameReply) Reset()         { *m = HostnameReply{} }
func (m *HostnameReply) String() string { return proto.CompactTextString(m) }
func (*HostnameReply) ProtoMessage()    {}
func (*HostnameReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{1}
}

func (m *HostnameReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostnameReply.Unmarshal(m, b)
}
func (m *HostnameReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostnameReply.Marshal(b, m, deterministic)
}
func (m *HostnameReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostnameReply.Merge(m, src)
}
func (m *HostnameReply) XXX_Size() int {
	return xxx_messageInfo_HostnameReply.Size(m)
}
func (m *HostnameReply) XXX_DiscardUnknown() {
	xxx_messageInfo_HostnameReply.DiscardUnknown(m)
}

var xxx_messageInfo_HostnameReply proto.InternalMessageInfo

func (m *HostnameReply) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

type StreamTagsRequest struct {
	Cardinality          TagCardinality `protobuf:"varint,1,opt,name=cardinality,proto3,enum=pb.TagCardinality" json:"cardinality,omitempty"`
	IncludeFilter        *Filter        `protobuf:"bytes,2,opt,name=includeFilter,proto3" json:"includeFilter,omitempty"`
	ExcludeFilter        *Filter        `protobuf:"bytes,3,opt,name=excludeFilter,proto3" json:"excludeFilter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StreamTagsRequest) Reset()         { *m = StreamTagsRequest{} }
func (m *StreamTagsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamTagsRequest) ProtoMessage()    {}
func (*StreamTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{2}
}

func (m *StreamTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTagsRequest.Unmarshal(m, b)
}
func (m *StreamTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTagsRequest.Marshal(b, m, deterministic)
}
func (m *StreamTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTagsRequest.Merge(m, src)
}
func (m *StreamTagsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamTagsRequest.Size(m)
}
func (m *StreamTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTagsRequest proto.InternalMessageInfo

func (m *StreamTagsRequest) GetCardinality() TagCardinality {
	if m != nil {
		return m.Cardinality
	}
	return TagCardinality_LOW
}

func (m *StreamTagsRequest) GetIncludeFilter() *Filter {
	if m != nil {
		return m.IncludeFilter
	}
	return nil
}

func (m *StreamTagsRequest) GetExcludeFilter() *Filter {
	if m != nil {
		return m.ExcludeFilter
	}
	return nil
}

type StreamTagsResponse struct {
	Events               []*StreamTagsEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamTagsResponse) Reset()         { *m = StreamTagsResponse{} }
func (m *StreamTagsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamTagsResponse) ProtoMessage()    {}
func (*StreamTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{3}
}

func (m *StreamTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTagsResponse.Unmarshal(m, b)
}
func (m *StreamTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTagsResponse.Marshal(b, m, deterministic)
}
func (m *StreamTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTagsResponse.Merge(m, src)
}
func (m *StreamTagsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamTagsResponse.Size(m)
}
func (m *StreamTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTagsResponse proto.InternalMessageInfo

func (m *StreamTagsResponse) GetEvents() []*StreamTagsEvent {
	if m != nil {
		return m.Events
	}
	return nil
}

type StreamTagsEvent struct {
	Type                 EventType `protobuf:"varint,1,opt,name=type,proto3,enum=pb.EventType" json:"type,omitempty"`
	Entity               *Entity   `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *StreamTagsEvent) Reset()         { *m = StreamTagsEvent{} }
func (m *StreamTagsEvent) String() string { return proto.CompactTextString(m) }
func (*StreamTagsEvent) ProtoMessage()    {}
func (*StreamTagsEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{4}
}

func (m *StreamTagsEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTagsEvent.Unmarshal(m, b)
}
func (m *StreamTagsEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTagsEvent.Marshal(b, m, deterministic)
}
func (m *StreamTagsEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTagsEvent.Merge(m, src)
}
func (m *StreamTagsEvent) XXX_Size() int {
	return xxx_messageInfo_StreamTagsEvent.Size(m)
}
func (m *StreamTagsEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTagsEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTagsEvent proto.InternalMessageInfo

func (m *StreamTagsEvent) GetType() EventType {
	if m != nil {
		return m.Type
	}
	return EventType_ADDED
}

func (m *StreamTagsEvent) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

type Filter struct {
	KubeNamespace        string   `protobuf:"bytes,1,opt,name=kubeNamespace,proto3" json:"kubeNamespace,omitempty"`
	Image                string   `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	ContainerName        string   `protobuf:"bytes,3,opt,name=containerName,proto3" json:"containerName,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{5}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetKubeNamespace() string {
	if m != nil {
		return m.KubeNamespace
	}
	return ""
}

func (m *Filter) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *Filter) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

type Entity struct {
	Id                          *EntityId `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Hash                        string    `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	HighCardinalityTags         []string  `protobuf:"bytes,3,rep,name=highCardinalityTags,proto3" json:"highCardinalityTags,omitempty"`
	OrchestratorCardinalityTags []string  `protobuf:"bytes,4,rep,name=orchestratorCardinalityTags,proto3" json:"orchestratorCardinalityTags,omitempty"`
	LowCardinalityTags          []string  `protobuf:"bytes,5,rep,name=lowCardinalityTags,proto3" json:"lowCardinalityTags,omitempty"`
	StandardTags                []string  `protobuf:"bytes,6,rep,name=standardTags,proto3" json:"standardTags,omitempty"`
	XXX_NoUnkeyedLiteral        struct{}  `json:"-"`
	XXX_unrecognized            []byte    `json:"-"`
	XXX_sizecache               int32     `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{6}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetId() *EntityId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Entity) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Entity) GetHighCardinalityTags() []string {
	if m != nil {
		return m.HighCardinalityTags
	}
	return nil
}

func (m *Entity) GetOrchestratorCardinalityTags() []string {
	if m != nil {
		return m.OrchestratorCardinalityTags
	}
	return nil
}

func (m *Entity) GetLowCardinalityTags() []string {
	if m != nil {
		return m.LowCardinalityTags
	}
	return nil
}

func (m *Entity) GetStandardTags() []string {
	if m != nil {
		return m.StandardTags
	}
	return nil
}

type FetchEntityRequest struct {
	Id                   *EntityId      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Cardinality          TagCardinality `protobuf:"varint,2,opt,name=cardinality,proto3,enum=pb.TagCardinality" json:"cardinality,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FetchEntityRequest) Reset()         { *m = FetchEntityRequest{} }
func (m *FetchEntityRequest) String() string { return proto.CompactTextString(m) }
func (*FetchEntityRequest) ProtoMessage()    {}
func (*FetchEntityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{7}
}

func (m *FetchEntityRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchEntityRequest.Unmarshal(m, b)
}
func (m *FetchEntityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchEntityRequest.Marshal(b, m, deterministic)
}
func (m *FetchEntityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchEntityRequest.Merge(m, src)
}
func (m *FetchEntityRequest) XXX_Size() int {
	return xxx_messageInfo_FetchEntityRequest.Size(m)
}
func (m *FetchEntityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchEntityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FetchEntityRequest proto.InternalMessageInfo

func (m *FetchEntityRequest) GetId() *EntityId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *FetchEntityRequest) GetCardinality() TagCardinality {
	if m != nil {
		return m.Cardinality
	}
	return TagCardinality_LOW
}

type FetchEntityResponse struct {
	Id                   *EntityId      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Cardinality          TagCardinality `protobuf:"varint,2,opt,name=cardinality,proto3,enum=pb.TagCardinality" json:"cardinality,omitempty"`
	Tags                 []string       `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FetchEntityResponse) Reset()         { *m = FetchEntityResponse{} }
func (m *FetchEntityResponse) String() string { return proto.CompactTextString(m) }
func (*FetchEntityResponse) ProtoMessage()    {}
func (*FetchEntityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{8}
}

func (m *FetchEntityResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchEntityResponse.Unmarshal(m, b)
}
func (m *FetchEntityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchEntityResponse.Marshal(b, m, deterministic)
}
func (m *FetchEntityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchEntityResponse.Merge(m, src)
}
func (m *FetchEntityResponse) XXX_Size() int {
	return xxx_messageInfo_FetchEntityResponse.Size(m)
}
func (m *FetchEntityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchEntityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FetchEntityResponse proto.InternalMessageInfo

func (m *FetchEntityResponse) GetId() *EntityId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *FetchEntityResponse) GetCardinality() TagCardinality {
	if m != nil {
		return m.Cardinality
	}
	return TagCardinality_LOW
}

func (m *FetchEntityResponse) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type EntityId struct {
	Prefix               string   `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Uid                  string   `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityId) Reset()         { *m = EntityId{} }
func (m *EntityId) String() string { return proto.CompactTextString(m) }
func (*EntityId) ProtoMessage()    {}
func (*EntityId) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{9}
}

func (m *EntityId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityId.Unmarshal(m, b)
}
func (m *EntityId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityId.Marshal(b, m, deterministic)
}
func (m *EntityId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityId.Merge(m, src)
}
func (m *EntityId) XXX_Size() int {
	return xxx_messageInfo_EntityId.Size(m)
}
func (m *EntityId) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityId.DiscardUnknown(m)
}

var xxx_messageInfo_EntityId proto.InternalMessageInfo

func (m *EntityId) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *EntityId) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func init() {
	proto.RegisterEnum("pb.EventType", EventType_name, EventType_value)
	proto.RegisterEnum("pb.TagCardinality", TagCardinality_name, TagCardinality_value)
	proto.RegisterType((*HostnameRequest)(nil), "pb.HostnameRequest")
	proto.RegisterType((*HostnameReply)(nil), "pb.HostnameReply")
	proto.RegisterType((*StreamTagsRequest)(nil), "pb.StreamTagsRequest")
	proto.RegisterType((*StreamTagsResponse)(nil), "pb.StreamTagsResponse")
	proto.RegisterType((*StreamTagsEvent)(nil), "pb.StreamTagsEvent")
	proto.RegisterType((*Filter)(nil), "pb.Filter")
	proto.RegisterType((*Entity)(nil), "pb.Entity")
	proto.RegisterType((*FetchEntityRequest)(nil), "pb.FetchEntityRequest")
	proto.RegisterType((*FetchEntityResponse)(nil), "pb.FetchEntityResponse")
	proto.RegisterType((*EntityId)(nil), "pb.EntityId")
}

func init() { proto.RegisterFile("api.proto", fileDescriptor_00212fb1f9d3bf1c) }

var fileDescriptor_00212fb1f9d3bf1c = []byte{
	// 719 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0xcd, 0x6e, 0xda, 0x40,
	0x10, 0x8e, 0xcd, 0x4f, 0x60, 0x80, 0xc4, 0x4c, 0x7e, 0x8a, 0x68, 0xa4, 0x92, 0x55, 0xa4, 0x22,
	0x22, 0x41, 0x42, 0xd3, 0x4b, 0x4e, 0x45, 0xc1, 0x09, 0x48, 0x69, 0x91, 0x1c, 0xaa, 0xf6, 0x56,
	0x2d, 0xf6, 0xc6, 0x76, 0x0b, 0xb6, 0x6b, 0x2f, 0x69, 0x38, 0xf4, 0x92, 0x57, 0xe8, 0x73, 0xf4,
	0x69, 0xfa, 0x0a, 0x7d, 0x81, 0xbe, 0x41, 0xe5, 0xb5, 0x09, 0x98, 0x44, 0x51, 0x2f, 0xbd, 0xed,
	0x7e, 0xf3, 0x7d, 0xf3, 0xed, 0xce, 0xcc, 0x2e, 0xe4, 0xa9, 0x67, 0x37, 0x3d, 0xdf, 0xe5, 0x2e,
	0xca, 0xde, 0xa8, 0xba, 0x67, 0xba, 0xae, 0x39, 0x66, 0x2d, 0xea, 0xd9, 0x2d, 0xea, 0x38, 0x2e,
	0xa7, 0xdc, 0x76, 0x9d, 0x20, 0x62, 0x90, 0x32, 0x6c, 0xf6, 0xdc, 0x80, 0x3b, 0x74, 0xc2, 0x34,
	0xf6, 0x75, 0xca, 0x02, 0x4e, 0x0e, 0xa1, 0xb4, 0x80, 0xbc, 0xf1, 0x0c, 0xab, 0x90, 0xb3, 0x62,
	0xa0, 0x22, 0xd5, 0xa4, 0x7a, 0x5e, 0xbb, 0xdf, 0x93, 0x9f, 0x12, 0x94, 0xaf, 0xb8, 0xcf, 0xe8,
	0x64, 0x48, 0xcd, 0x20, 0x4e, 0x81, 0x27, 0x50, 0xd0, 0xa9, 0x6f, 0xd8, 0x0e, 0x1d, 0xdb, 0x7c,
	0x26, 0x44, 0x1b, 0x6d, 0x6c, 0x7a, 0xa3, 0xe6, 0x90, 0x9a, 0x67, 0x8b, 0x88, 0xb6, 0x4c, 0xc3,
	0x23, 0x28, 0xd9, 0x8e, 0x3e, 0x9e, 0x1a, 0xec, 0xdc, 0x1e, 0x73, 0xe6, 0x57, 0xe4, 0x9a, 0x54,
	0x2f, 0xb4, 0x21, 0xd4, 0x45, 0x88, 0x96, 0x24, 0x84, 0x0a, 0x76, 0xbb, 0xac, 0x48, 0x3d, 0x54,
	0x24, 0x08, 0xa4, 0x03, 0xb8, 0x7c, 0xdc, 0xc0, 0x73, 0x9d, 0x80, 0xe1, 0x21, 0x64, 0xd9, 0x0d,
	0x73, 0x78, 0x50, 0x91, 0x6a, 0xa9, 0x7a, 0xa1, 0xbd, 0x15, 0x26, 0x58, 0xf0, 0xd4, 0x30, 0xa6,
	0xc5, 0x14, 0xf2, 0x11, 0x36, 0x57, 0x42, 0xb8, 0x0f, 0x69, 0x3e, 0xf3, 0x58, 0x7c, 0xd1, 0x52,
	0xa8, 0x16, 0x81, 0xe1, 0xcc, 0x63, 0x9a, 0x08, 0x21, 0x81, 0x2c, 0x73, 0x78, 0x58, 0x8d, 0xa5,
	0x5b, 0xa9, 0x02, 0xd1, 0xe2, 0x08, 0xf9, 0x0c, 0xd9, 0xf8, 0x62, 0x07, 0x50, 0xfa, 0x32, 0x1d,
	0xb1, 0x77, 0x74, 0xc2, 0x02, 0x8f, 0xea, 0xf3, 0xba, 0x27, 0x41, 0xdc, 0x86, 0x8c, 0x3d, 0xa1,
	0x26, 0x13, 0x29, 0xf3, 0x5a, 0xb4, 0x09, 0xb5, 0xba, 0xeb, 0x70, 0x6a, 0x3b, 0xcc, 0x0f, 0xb9,
	0xa2, 0x28, 0x79, 0x2d, 0x09, 0x92, 0x3b, 0x19, 0xb2, 0x91, 0x3d, 0xee, 0x81, 0x6c, 0x1b, 0xc2,
	0xa1, 0xd0, 0x2e, 0x2e, 0x8e, 0xd5, 0x37, 0x34, 0xd9, 0x36, 0x10, 0x21, 0x6d, 0xd1, 0xc0, 0x8a,
	0x3d, 0xc4, 0x1a, 0x8f, 0x60, 0xcb, 0xb2, 0x4d, 0x6b, 0xa9, 0x93, 0x61, 0x2d, 0x2a, 0xa9, 0x5a,
	0xaa, 0x9e, 0xd7, 0x1e, 0x0b, 0xe1, 0x1b, 0x78, 0xee, 0xfa, 0xba, 0xc5, 0x02, 0xee, 0x53, 0xee,
	0xfa, 0xab, 0xca, 0xb4, 0x50, 0x3e, 0x45, 0xc1, 0x26, 0xe0, 0xd8, 0xfd, 0xb6, 0x2a, 0xcc, 0x08,
	0xe1, 0x23, 0x11, 0x24, 0x50, 0x0c, 0x38, 0x75, 0x0c, 0xea, 0x1b, 0x82, 0x99, 0x15, 0xcc, 0x04,
	0x46, 0x2c, 0xc0, 0x73, 0xc6, 0x75, 0x2b, 0xee, 0x43, 0x3c, 0xbd, 0x4f, 0xd7, 0x63, 0x65, 0xb6,
	0xe5, 0x7f, 0x9a, 0x6d, 0xf2, 0x1d, 0xb6, 0x12, 0x4e, 0xf1, 0xe0, 0xfd, 0x07, 0xab, 0xb0, 0x61,
	0x7c, 0xd1, 0x0d, 0xb1, 0x26, 0x27, 0x90, 0x9b, 0x67, 0xc6, 0x5d, 0xc8, 0x7a, 0x3e, 0xbb, 0xb6,
	0x6f, 0xe3, 0xa1, 0x8a, 0x77, 0xa8, 0x40, 0x6a, 0x6a, 0x1b, 0x71, 0x9f, 0xc3, 0x65, 0xe3, 0x18,
	0xf2, 0xf7, 0x63, 0x8c, 0x79, 0xc8, 0x74, 0xba, 0x5d, 0xb5, 0xab, 0xac, 0x61, 0x11, 0x72, 0x6f,
	0x07, 0xdd, 0xfe, 0x79, 0x5f, 0xed, 0x2a, 0x12, 0x16, 0x60, 0xbd, 0xab, 0x5e, 0xaa, 0x43, 0xb5,
	0xab, 0xc8, 0x8d, 0xd7, 0xb0, 0x91, 0x3c, 0x1b, 0xae, 0x43, 0xea, 0x72, 0xf0, 0x41, 0x59, 0x43,
	0x05, 0x8a, 0x03, 0xed, 0xac, 0xa7, 0x5e, 0x0d, 0xb5, 0xce, 0x70, 0xa0, 0x29, 0x12, 0xe6, 0x20,
	0xdd, 0xeb, 0x5f, 0xf4, 0x14, 0xb9, 0xfd, 0x1e, 0x32, 0x1d, 0x33, 0x7c, 0x49, 0x97, 0x50, 0xb8,
	0x60, 0x7c, 0xfe, 0xff, 0xa0, 0x78, 0x88, 0x2b, 0x1f, 0x54, 0xb5, 0x9c, 0x04, 0xbd, 0xf1, 0x8c,
	0xec, 0xdc, 0xfd, 0xfa, 0xfd, 0x43, 0xde, 0xc4, 0x52, 0xeb, 0xe6, 0xb8, 0x65, 0xfa, 0x9e, 0xde,
	0x0a, 0x7f, 0xa8, 0xf6, 0x1f, 0x09, 0x0a, 0x22, 0xef, 0x15, 0xd3, 0xa7, 0x3e, 0xc3, 0x00, 0xb6,
	0x87, 0xd4, 0x34, 0x99, 0x1f, 0x3d, 0x60, 0x51, 0x12, 0x9b, 0x05, 0xb8, 0x93, 0x7c, 0xef, 0x73,
	0xa3, 0xdd, 0x55, 0x38, 0xea, 0x1a, 0x69, 0x08, 0xb7, 0x03, 0xf2, 0xe2, 0xde, 0x8d, 0x8b, 0xac,
	0xad, 0x40, 0x70, 0x3f, 0xb1, 0x38, 0xef, 0xa9, 0xd4, 0x38, 0x92, 0x70, 0x02, 0xe5, 0xc8, 0x74,
	0x69, 0x00, 0x50, 0xa4, 0x7e, 0x38, 0x7b, 0xd5, 0x67, 0x0f, 0xf0, 0xd8, 0xf3, 0xa5, 0xf0, 0xdc,
	0x27, 0x7b, 0xab, 0x9e, 0xd7, 0x21, 0x39, 0xb2, 0x9c, 0x9d, 0x4a, 0x8d, 0x51, 0x56, 0x7c, 0xec,
	0xaf, 0xfe, 0x06, 0x00, 0x00, 0xff, 0xff, 0x26, 0xcf, 0x34, 0x3b, 0x07, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentClient is the client API for Agent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentClient interface {
	// get the hostname
	GetHostname(ctx context.Context, in *HostnameRequest, opts ...grpc.CallOption) (*HostnameReply, error)
}

type agentClient struct {
	cc *grpc.ClientConn
}

func NewAgentClient(cc *grpc.ClientConn) AgentClient {
	return &agentClient{cc}
}

func (c *agentClient) GetHostname(ctx context.Context, in *HostnameRequest, opts ...grpc.CallOption) (*HostnameReply, error) {
	out := new(HostnameReply)
	err := c.cc.Invoke(ctx, "/pb.Agent/GetHostname", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentServer is the server API for Agent service.
type AgentServer interface {
	// get the hostname
	GetHostname(context.Context, *HostnameRequest) (*HostnameReply, error)
}

// UnimplementedAgentServer can be embedded to have forward compatible implementations.
type UnimplementedAgentServer struct {
}

func (*UnimplementedAgentServer) GetHostname(ctx context.Context, req *HostnameRequest) (*HostnameReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHostname not implemented")
}

func RegisterAgentServer(s *grpc.Server, srv AgentServer) {
	s.RegisterService(&_Agent_serviceDesc, srv)
}

func _Agent_GetHostname_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HostnameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).GetHostname(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Agent/GetHostname",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).GetHostname(ctx, req.(*HostnameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Agent",
	HandlerType: (*AgentServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHostname",
			Handler:    _Agent_GetHostname_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api.proto",
}

// AgentSecureClient is the client API for AgentSecure service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentSecureClient interface {
	// subscribes to added, removed, or changed entities in the Tagger
	// and streams them to clients as events.
	// can be called through the HTTP gateway, and events will be streamed as JSON:
	//   $  curl -H "authorization: Bearer $(cat /etc/datadog-agent/auth_token)" \
	//      -XPOST -k https://localhost:5001/v1/grpc/tagger/stream_entities
	//   {
	//    "result": {
	//        "entity": {
	//            "id": {
	//                "prefix": "kubernetes_pod_uid",
	//                "uid": "4025461f832caf3fceb7fc2a32f879c6"
	//            },
	//            "hash": "cad4fc8fc409fcc1",
	//            "lowCardinalityTags": [
	//                "kube_namespace:kube-system",
	//                "pod_phase:running"
	//            ]
	//        }
	//    }
	//}
	TaggerStreamEntities(ctx context.Context, in *StreamTagsRequest, opts ...grpc.CallOption) (AgentSecure_TaggerStreamEntitiesClient, error)
	// fetches an entity from the Tagger with the desired cardinality tags.
	// can be called through the HTTP gateway, and entity will be returned as JSON:
	//   $ curl -H "authorization: Bearer $(cat /etc/datadog-agent/auth_token)" \
	//      -XPOST -k -H "Content-Type: application/json" \
	//      --data '{"id":{"prefix":"kubernetes_pod_uid","uid":"d575fb58-82dc-418e-bfb1-aececc9bc507"}}' \
	//      https://localhost:5001/v1/grpc/tagger/fetch_entity
	//   {
	//    "id": {
	//        "prefix": "kubernetes_pod_uid",
	//        "uid": "d575fb58-82dc-418e-bfb1-aececc9bc507"
	//    },
	//    "tags": [
	//        "kube_namespace:kube-system",
	//        "pod_phase:running",
	//        "kube_deployment:coredns",
	//        "kube_service:kube-dns"
	//    ]
	//}
	TaggerFetchEntity(ctx context.Context, in *FetchEntityRequest, opts ...grpc.CallOption) (*FetchEntityResponse, error)
}

type agentSecureClient struct {
	cc *grpc.ClientConn
}

func NewAgentSecureClient(cc *grpc.ClientConn) AgentSecureClient {
	return &agentSecureClient{cc}
}

func (c *agentSecureClient) TaggerStreamEntities(ctx context.Context, in *StreamTagsRequest, opts ...grpc.CallOption) (AgentSecure_TaggerStreamEntitiesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentSecure_serviceDesc.Streams[0], "/pb.AgentSecure/TaggerStreamEntities", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentSecureTaggerStreamEntitiesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentSecure_TaggerStreamEntitiesClient interface {
	Recv() (*StreamTagsResponse, error)
	grpc.ClientStream
}

type agentSecureTaggerStreamEntitiesClient struct {
	grpc.ClientStream
}

func (x *agentSecureTaggerStreamEntitiesClient) Recv() (*StreamTagsResponse, error) {
	m := new(StreamTagsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentSecureClient) TaggerFetchEntity(ctx context.Context, in *FetchEntityRequest, opts ...grpc.CallOption) (*FetchEntityResponse, error) {
	out := new(FetchEntityResponse)
	err := c.cc.Invoke(ctx, "/pb.AgentSecure/TaggerFetchEntity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentSecureServer is the server API for AgentSecure service.
type AgentSecureServer interface {
	// subscribes to added, removed, or changed entities in the Tagger
	// and streams them to clients as events.
	// can be called through the HTTP gateway, and events will be streamed as JSON:
	//   $  curl -H "authorization: Bearer $(cat /etc/datadog-agent/auth_token)" \
	//      -XPOST -k https://localhost:5001/v1/grpc/tagger/stream_entities
	//   {
	//    "result": {
	//        "entity": {
	//            "id": {
	//                "prefix": "kubernetes_pod_uid",
	//                "uid": "4025461f832caf3fceb7fc2a32f879c6"
	//            },
	//            "hash": "cad4fc8fc409fcc1",
	//            "lowCardinalityTags": [
	//                "kube_namespace:kube-system",
	//                "pod_phase:running"
	//            ]
	//        }
	//    }
	//}
	TaggerStreamEntities(*StreamTagsRequest, AgentSecure_TaggerStreamEntitiesServer) error
	// fetches an entity from the Tagger with the desired cardinality tags.
	// can be called through the HTTP gateway, and entity will be returned as JSON:
	//   $ curl -H "authorization: Bearer $(cat /etc/datadog-agent/auth_token)" \
	//      -XPOST -k -H "Content-Type: application/json" \
	//      --data '{"id":{"prefix":"kubernetes_pod_uid","uid":"d575fb58-82dc-418e-bfb1-aececc9bc507"}}' \
	//      https://localhost:5001/v1/grpc/tagger/fetch_entity
	//   {
	//    "id": {
	//        "prefix": "kubernetes_pod_uid",
	//        "uid": "d575fb58-82dc-418e-bfb1-aececc9bc507"
	//    },
	//    "tags": [
	//        "kube_namespace:kube-system",
	//        "pod_phase:running",
	//        "kube_deployment:coredns",
	//        "kube_service:kube-dns"
	//    ]
	//}
	TaggerFetchEntity(context.Context, *FetchEntityRequest) (*FetchEntityResponse, error)
}

// UnimplementedAgentSecureServer can be embedded to have forward compatible implementations.
type UnimplementedAgentSecureServer struct {
}

func (*UnimplementedAgentSecureServer) TaggerStreamEntities(req *StreamTagsRequest, srv AgentSecure_TaggerStreamEntitiesServer) error {
	return status.Errorf(codes.Unimplemented, "method TaggerStreamEntities not implemented")
}
func (*UnimplementedAgentSecureServer) TaggerFetchEntity(ctx context.Context, req *FetchEntityRequest) (*FetchEntityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TaggerFetchEntity not implemented")
}

func RegisterAgentSecureServer(s *grpc.Server, srv AgentSecureServer) {
	s.RegisterService(&_AgentSecure_serviceDesc, srv)
}

func _AgentSecure_TaggerStreamEntities_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamTagsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentSecureServer).TaggerStreamEntities(m, &agentSecureTaggerStreamEntitiesServer{stream})
}

type AgentSecure_TaggerStreamEntitiesServer interface {
	Send(*StreamTagsResponse) error
	grpc.ServerStream
}

type agentSecureTaggerStreamEntitiesServer struct {
	grpc.ServerStream
}

func (x *agentSecureTaggerStreamEntitiesServer) Send(m *StreamTagsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentSecure_TaggerFetchEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentSecureServer).TaggerFetchEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.AgentSecure/TaggerFetchEntity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentSecureServer).TaggerFetchEntity(ctx, req.(*FetchEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentSecure_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.AgentSecure",
	HandlerType: (*AgentSecureServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TaggerFetchEntity",
			Handler:    _AgentSecure_TaggerFetchEntity_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "TaggerStreamEntities",
			Handler:       _AgentSecure_TaggerStreamEntities_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api.proto",
}
