# Serverless Agent

The Serverless Agent is a build of the Datadog Agent capable of running
in serverless environments, to collect custom metrics, the logs generated by the
function and the traces of the function execution. Today, it's mainly used to
build the Datadog Lambda Extension for AWS Lambda.

## Concepts

The Serverless Agent is intended to run as a side-car of the serverless function.

### Validate the presence of the Serverless Agent and order a flush

The Serverless Agent runs an HTTP server on port 8124.

With the Datadog Lambda Extension, this HTTP server listens for two
different routes:
    - /lambda/hello
    - /lambda/flush

If the Serverless Agent needs to be set up to support a different serverless
environment, on GCP or Azure for instance, it would be important to create
different HTTP routes (most likely sharing a big part of the implementation).

#### `Hello` route

No payload.

This is a discover route: by calling this HTTP route, a function knows if the
Serverless Agent is running.


#### `Flush`

No payload.

This route is used to tell the Serverless Agent that it has to immediately flush
the data it has buffered. This route blocks and replies only once all the
data has been flushed to the Datadog intake.

### Configuration

The configuration of the Serverless Agent goes through the regular `config` package
of the Datadog Agent, reading both from a file and from the environment variables.

For the Datadog Lambda Extension, some fields are set directly in the environment
at startup for the config package to pick them up. (See `cmd/serverless/main.go` for the
startup process).

### Build

For more information about building a Serverless Agent, see [this README](https://github.com/DataDog/datadog-agent/tree/master/cmd/serverless/README.md).
