// Code generated by mockery v2.2.1. DO NOT EDIT.

package mocks

import (
	context "context"

	container "github.com/docker/docker/api/types/container"

	events "github.com/docker/docker/api/types/events"

	filters "github.com/docker/docker/api/types/filters"

	image "github.com/docker/docker/api/types/image"

	io "io"

	mock "github.com/stretchr/testify/mock"

	network "github.com/docker/docker/api/types/network"

	registry "github.com/docker/docker/api/types/registry"

	swarm "github.com/docker/docker/api/types/swarm"

	time "time"

	types "github.com/docker/docker/api/types"

	volume "github.com/docker/docker/api/types/volume"
)

// DockerClient is an autogenerated mock type for the DockerClient type
type DockerClient struct {
	mock.Mock
}

// BuildCachePrune provides a mock function with given fields: ctx, opts
func (_m *DockerClient) BuildCachePrune(ctx context.Context, opts types.BuildCachePruneOptions) (*types.BuildCachePruneReport, error) {
	ret := _m.Called(ctx, opts)

	var r0 *types.BuildCachePruneReport
	if rf, ok := ret.Get(0).(func(context.Context, types.BuildCachePruneOptions) *types.BuildCachePruneReport); ok {
		r0 = rf(ctx, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*types.BuildCachePruneReport)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.BuildCachePruneOptions) error); ok {
		r1 = rf(ctx, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BuildCancel provides a mock function with given fields: ctx, id
func (_m *DockerClient) BuildCancel(ctx context.Context, id string) error {
	ret := _m.Called(ctx, id)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Close provides a mock function with given fields:
func (_m *DockerClient) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ConfigCreate provides a mock function with given fields: ctx, config
func (_m *DockerClient) ConfigCreate(ctx context.Context, config swarm.ConfigSpec) (types.ConfigCreateResponse, error) {
	ret := _m.Called(ctx, config)

	var r0 types.ConfigCreateResponse
	if rf, ok := ret.Get(0).(func(context.Context, swarm.ConfigSpec) types.ConfigCreateResponse); ok {
		r0 = rf(ctx, config)
	} else {
		r0 = ret.Get(0).(types.ConfigCreateResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, swarm.ConfigSpec) error); ok {
		r1 = rf(ctx, config)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ConfigInspectWithRaw provides a mock function with given fields: ctx, name
func (_m *DockerClient) ConfigInspectWithRaw(ctx context.Context, name string) (swarm.Config, []byte, error) {
	ret := _m.Called(ctx, name)

	var r0 swarm.Config
	if rf, ok := ret.Get(0).(func(context.Context, string) swarm.Config); ok {
		r0 = rf(ctx, name)
	} else {
		r0 = ret.Get(0).(swarm.Config)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string) []byte); ok {
		r1 = rf(ctx, name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = rf(ctx, name)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// ConfigList provides a mock function with given fields: ctx, options
func (_m *DockerClient) ConfigList(ctx context.Context, options types.ConfigListOptions) ([]swarm.Config, error) {
	ret := _m.Called(ctx, options)

	var r0 []swarm.Config
	if rf, ok := ret.Get(0).(func(context.Context, types.ConfigListOptions) []swarm.Config); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]swarm.Config)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.ConfigListOptions) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ConfigRemove provides a mock function with given fields: ctx, id
func (_m *DockerClient) ConfigRemove(ctx context.Context, id string) error {
	ret := _m.Called(ctx, id)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ConfigUpdate provides a mock function with given fields: ctx, id, version, config
func (_m *DockerClient) ConfigUpdate(ctx context.Context, id string, version swarm.Version, config swarm.ConfigSpec) error {
	ret := _m.Called(ctx, id, version, config)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, swarm.Version, swarm.ConfigSpec) error); ok {
		r0 = rf(ctx, id, version, config)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerAttach provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerAttach(ctx context.Context, _a1 string, options types.ContainerAttachOptions) (types.HijackedResponse, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 types.HijackedResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ContainerAttachOptions) types.HijackedResponse); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Get(0).(types.HijackedResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ContainerAttachOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerCommit provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerCommit(ctx context.Context, _a1 string, options types.ContainerCommitOptions) (types.IDResponse, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 types.IDResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ContainerCommitOptions) types.IDResponse); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Get(0).(types.IDResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ContainerCommitOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerCreate provides a mock function with given fields: ctx, config, hostConfig, networkingConfig, containerName
func (_m *DockerClient) ContainerCreate(ctx context.Context, config *container.Config, hostConfig *container.HostConfig, networkingConfig *network.NetworkingConfig, containerName string) (container.ContainerCreateCreatedBody, error) {
	ret := _m.Called(ctx, config, hostConfig, networkingConfig, containerName)

	var r0 container.ContainerCreateCreatedBody
	if rf, ok := ret.Get(0).(func(context.Context, *container.Config, *container.HostConfig, *network.NetworkingConfig, string) container.ContainerCreateCreatedBody); ok {
		r0 = rf(ctx, config, hostConfig, networkingConfig, containerName)
	} else {
		r0 = ret.Get(0).(container.ContainerCreateCreatedBody)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *container.Config, *container.HostConfig, *network.NetworkingConfig, string) error); ok {
		r1 = rf(ctx, config, hostConfig, networkingConfig, containerName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerDiff provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ContainerDiff(ctx context.Context, _a1 string) ([]container.ContainerChangeResponseItem, error) {
	ret := _m.Called(ctx, _a1)

	var r0 []container.ContainerChangeResponseItem
	if rf, ok := ret.Get(0).(func(context.Context, string) []container.ContainerChangeResponseItem); ok {
		r0 = rf(ctx, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]container.ContainerChangeResponseItem)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerExecAttach provides a mock function with given fields: ctx, execID, config
func (_m *DockerClient) ContainerExecAttach(ctx context.Context, execID string, config types.ExecStartCheck) (types.HijackedResponse, error) {
	ret := _m.Called(ctx, execID, config)

	var r0 types.HijackedResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ExecStartCheck) types.HijackedResponse); ok {
		r0 = rf(ctx, execID, config)
	} else {
		r0 = ret.Get(0).(types.HijackedResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ExecStartCheck) error); ok {
		r1 = rf(ctx, execID, config)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerExecCreate provides a mock function with given fields: ctx, _a1, config
func (_m *DockerClient) ContainerExecCreate(ctx context.Context, _a1 string, config types.ExecConfig) (types.IDResponse, error) {
	ret := _m.Called(ctx, _a1, config)

	var r0 types.IDResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ExecConfig) types.IDResponse); ok {
		r0 = rf(ctx, _a1, config)
	} else {
		r0 = ret.Get(0).(types.IDResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ExecConfig) error); ok {
		r1 = rf(ctx, _a1, config)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerExecInspect provides a mock function with given fields: ctx, execID
func (_m *DockerClient) ContainerExecInspect(ctx context.Context, execID string) (types.ContainerExecInspect, error) {
	ret := _m.Called(ctx, execID)

	var r0 types.ContainerExecInspect
	if rf, ok := ret.Get(0).(func(context.Context, string) types.ContainerExecInspect); ok {
		r0 = rf(ctx, execID)
	} else {
		r0 = ret.Get(0).(types.ContainerExecInspect)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, execID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerExecResize provides a mock function with given fields: ctx, execID, options
func (_m *DockerClient) ContainerExecResize(ctx context.Context, execID string, options types.ResizeOptions) error {
	ret := _m.Called(ctx, execID, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ResizeOptions) error); ok {
		r0 = rf(ctx, execID, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerExecStart provides a mock function with given fields: ctx, execID, config
func (_m *DockerClient) ContainerExecStart(ctx context.Context, execID string, config types.ExecStartCheck) error {
	ret := _m.Called(ctx, execID, config)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ExecStartCheck) error); ok {
		r0 = rf(ctx, execID, config)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerExport provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ContainerExport(ctx context.Context, _a1 string) (io.ReadCloser, error) {
	ret := _m.Called(ctx, _a1)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string) io.ReadCloser); ok {
		r0 = rf(ctx, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerInspect provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ContainerInspect(ctx context.Context, _a1 string) (types.ContainerJSON, error) {
	ret := _m.Called(ctx, _a1)

	var r0 types.ContainerJSON
	if rf, ok := ret.Get(0).(func(context.Context, string) types.ContainerJSON); ok {
		r0 = rf(ctx, _a1)
	} else {
		r0 = ret.Get(0).(types.ContainerJSON)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerInspectWithRaw provides a mock function with given fields: ctx, _a1, getSize
func (_m *DockerClient) ContainerInspectWithRaw(ctx context.Context, _a1 string, getSize bool) (types.ContainerJSON, []byte, error) {
	ret := _m.Called(ctx, _a1, getSize)

	var r0 types.ContainerJSON
	if rf, ok := ret.Get(0).(func(context.Context, string, bool) types.ContainerJSON); ok {
		r0 = rf(ctx, _a1, getSize)
	} else {
		r0 = ret.Get(0).(types.ContainerJSON)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string, bool) []byte); ok {
		r1 = rf(ctx, _a1, getSize)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, bool) error); ok {
		r2 = rf(ctx, _a1, getSize)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// ContainerKill provides a mock function with given fields: ctx, _a1, signal
func (_m *DockerClient) ContainerKill(ctx context.Context, _a1 string, signal string) error {
	ret := _m.Called(ctx, _a1, signal)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, _a1, signal)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerList provides a mock function with given fields: ctx, options
func (_m *DockerClient) ContainerList(ctx context.Context, options types.ContainerListOptions) ([]types.Container, error) {
	ret := _m.Called(ctx, options)

	var r0 []types.Container
	if rf, ok := ret.Get(0).(func(context.Context, types.ContainerListOptions) []types.Container); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]types.Container)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.ContainerListOptions) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerLogs provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerLogs(ctx context.Context, _a1 string, options types.ContainerLogsOptions) (io.ReadCloser, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ContainerLogsOptions) io.ReadCloser); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ContainerLogsOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerPause provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ContainerPause(ctx context.Context, _a1 string) error {
	ret := _m.Called(ctx, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerRemove provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerRemove(ctx context.Context, _a1 string, options types.ContainerRemoveOptions) error {
	ret := _m.Called(ctx, _a1, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ContainerRemoveOptions) error); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerRename provides a mock function with given fields: ctx, _a1, newContainerName
func (_m *DockerClient) ContainerRename(ctx context.Context, _a1 string, newContainerName string) error {
	ret := _m.Called(ctx, _a1, newContainerName)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, _a1, newContainerName)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerResize provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerResize(ctx context.Context, _a1 string, options types.ResizeOptions) error {
	ret := _m.Called(ctx, _a1, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ResizeOptions) error); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerRestart provides a mock function with given fields: ctx, _a1, timeout
func (_m *DockerClient) ContainerRestart(ctx context.Context, _a1 string, timeout *time.Duration) error {
	ret := _m.Called(ctx, _a1, timeout)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *time.Duration) error); ok {
		r0 = rf(ctx, _a1, timeout)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerStart provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ContainerStart(ctx context.Context, _a1 string, options types.ContainerStartOptions) error {
	ret := _m.Called(ctx, _a1, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ContainerStartOptions) error); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerStatPath provides a mock function with given fields: ctx, _a1, path
func (_m *DockerClient) ContainerStatPath(ctx context.Context, _a1 string, path string) (types.ContainerPathStat, error) {
	ret := _m.Called(ctx, _a1, path)

	var r0 types.ContainerPathStat
	if rf, ok := ret.Get(0).(func(context.Context, string, string) types.ContainerPathStat); ok {
		r0 = rf(ctx, _a1, path)
	} else {
		r0 = ret.Get(0).(types.ContainerPathStat)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, _a1, path)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerStats provides a mock function with given fields: ctx, _a1, stream
func (_m *DockerClient) ContainerStats(ctx context.Context, _a1 string, stream bool) (types.ContainerStats, error) {
	ret := _m.Called(ctx, _a1, stream)

	var r0 types.ContainerStats
	if rf, ok := ret.Get(0).(func(context.Context, string, bool) types.ContainerStats); ok {
		r0 = rf(ctx, _a1, stream)
	} else {
		r0 = ret.Get(0).(types.ContainerStats)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, bool) error); ok {
		r1 = rf(ctx, _a1, stream)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerStop provides a mock function with given fields: ctx, _a1, timeout
func (_m *DockerClient) ContainerStop(ctx context.Context, _a1 string, timeout *time.Duration) error {
	ret := _m.Called(ctx, _a1, timeout)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *time.Duration) error); ok {
		r0 = rf(ctx, _a1, timeout)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerTop provides a mock function with given fields: ctx, _a1, arguments
func (_m *DockerClient) ContainerTop(ctx context.Context, _a1 string, arguments []string) (container.ContainerTopOKBody, error) {
	ret := _m.Called(ctx, _a1, arguments)

	var r0 container.ContainerTopOKBody
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) container.ContainerTopOKBody); ok {
		r0 = rf(ctx, _a1, arguments)
	} else {
		r0 = ret.Get(0).(container.ContainerTopOKBody)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string) error); ok {
		r1 = rf(ctx, _a1, arguments)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerUnpause provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ContainerUnpause(ctx context.Context, _a1 string) error {
	ret := _m.Called(ctx, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ContainerUpdate provides a mock function with given fields: ctx, _a1, updateConfig
func (_m *DockerClient) ContainerUpdate(ctx context.Context, _a1 string, updateConfig container.UpdateConfig) (container.ContainerUpdateOKBody, error) {
	ret := _m.Called(ctx, _a1, updateConfig)

	var r0 container.ContainerUpdateOKBody
	if rf, ok := ret.Get(0).(func(context.Context, string, container.UpdateConfig) container.ContainerUpdateOKBody); ok {
		r0 = rf(ctx, _a1, updateConfig)
	} else {
		r0 = ret.Get(0).(container.ContainerUpdateOKBody)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, container.UpdateConfig) error); ok {
		r1 = rf(ctx, _a1, updateConfig)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ContainerWait provides a mock function with given fields: ctx, _a1, condition
func (_m *DockerClient) ContainerWait(ctx context.Context, _a1 string, condition container.WaitCondition) (<-chan container.ContainerWaitOKBody, <-chan error) {
	ret := _m.Called(ctx, _a1, condition)

	var r0 <-chan container.ContainerWaitOKBody
	if rf, ok := ret.Get(0).(func(context.Context, string, container.WaitCondition) <-chan container.ContainerWaitOKBody); ok {
		r0 = rf(ctx, _a1, condition)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(<-chan container.ContainerWaitOKBody)
		}
	}

	var r1 <-chan error
	if rf, ok := ret.Get(1).(func(context.Context, string, container.WaitCondition) <-chan error); ok {
		r1 = rf(ctx, _a1, condition)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(<-chan error)
		}
	}

	return r0, r1
}

// ContainersPrune provides a mock function with given fields: ctx, pruneFilters
func (_m *DockerClient) ContainersPrune(ctx context.Context, pruneFilters filters.Args) (types.ContainersPruneReport, error) {
	ret := _m.Called(ctx, pruneFilters)

	var r0 types.ContainersPruneReport
	if rf, ok := ret.Get(0).(func(context.Context, filters.Args) types.ContainersPruneReport); ok {
		r0 = rf(ctx, pruneFilters)
	} else {
		r0 = ret.Get(0).(types.ContainersPruneReport)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, filters.Args) error); ok {
		r1 = rf(ctx, pruneFilters)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CopyFromContainer provides a mock function with given fields: ctx, _a1, srcPath
func (_m *DockerClient) CopyFromContainer(ctx context.Context, _a1 string, srcPath string) (io.ReadCloser, types.ContainerPathStat, error) {
	ret := _m.Called(ctx, _a1, srcPath)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string, string) io.ReadCloser); ok {
		r0 = rf(ctx, _a1, srcPath)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 types.ContainerPathStat
	if rf, ok := ret.Get(1).(func(context.Context, string, string) types.ContainerPathStat); ok {
		r1 = rf(ctx, _a1, srcPath)
	} else {
		r1 = ret.Get(1).(types.ContainerPathStat)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, string) error); ok {
		r2 = rf(ctx, _a1, srcPath)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// CopyToContainer provides a mock function with given fields: ctx, _a1, path, content, options
func (_m *DockerClient) CopyToContainer(ctx context.Context, _a1 string, path string, content io.Reader, options types.CopyToContainerOptions) error {
	ret := _m.Called(ctx, _a1, path, content, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, io.Reader, types.CopyToContainerOptions) error); ok {
		r0 = rf(ctx, _a1, path, content, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DiskUsage provides a mock function with given fields: ctx
func (_m *DockerClient) DiskUsage(ctx context.Context) (types.DiskUsage, error) {
	ret := _m.Called(ctx)

	var r0 types.DiskUsage
	if rf, ok := ret.Get(0).(func(context.Context) types.DiskUsage); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Get(0).(types.DiskUsage)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Events provides a mock function with given fields: ctx, options
func (_m *DockerClient) Events(ctx context.Context, options types.EventsOptions) (<-chan events.Message, <-chan error) {
	ret := _m.Called(ctx, options)

	var r0 <-chan events.Message
	if rf, ok := ret.Get(0).(func(context.Context, types.EventsOptions) <-chan events.Message); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(<-chan events.Message)
		}
	}

	var r1 <-chan error
	if rf, ok := ret.Get(1).(func(context.Context, types.EventsOptions) <-chan error); ok {
		r1 = rf(ctx, options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(<-chan error)
		}
	}

	return r0, r1
}

// ImageBuild provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ImageBuild(ctx context.Context, _a1 io.Reader, options types.ImageBuildOptions) (types.ImageBuildResponse, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 types.ImageBuildResponse
	if rf, ok := ret.Get(0).(func(context.Context, io.Reader, types.ImageBuildOptions) types.ImageBuildResponse); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Get(0).(types.ImageBuildResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, io.Reader, types.ImageBuildOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageCreate provides a mock function with given fields: ctx, parentReference, options
func (_m *DockerClient) ImageCreate(ctx context.Context, parentReference string, options types.ImageCreateOptions) (io.ReadCloser, error) {
	ret := _m.Called(ctx, parentReference, options)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ImageCreateOptions) io.ReadCloser); ok {
		r0 = rf(ctx, parentReference, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ImageCreateOptions) error); ok {
		r1 = rf(ctx, parentReference, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageHistory provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ImageHistory(ctx context.Context, _a1 string) ([]image.HistoryResponseItem, error) {
	ret := _m.Called(ctx, _a1)

	var r0 []image.HistoryResponseItem
	if rf, ok := ret.Get(0).(func(context.Context, string) []image.HistoryResponseItem); ok {
		r0 = rf(ctx, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]image.HistoryResponseItem)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageImport provides a mock function with given fields: ctx, source, ref, options
func (_m *DockerClient) ImageImport(ctx context.Context, source types.ImageImportSource, ref string, options types.ImageImportOptions) (io.ReadCloser, error) {
	ret := _m.Called(ctx, source, ref, options)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, types.ImageImportSource, string, types.ImageImportOptions) io.ReadCloser); ok {
		r0 = rf(ctx, source, ref, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.ImageImportSource, string, types.ImageImportOptions) error); ok {
		r1 = rf(ctx, source, ref, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageInspectWithRaw provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) ImageInspectWithRaw(ctx context.Context, _a1 string) (types.ImageInspect, []byte, error) {
	ret := _m.Called(ctx, _a1)

	var r0 types.ImageInspect
	if rf, ok := ret.Get(0).(func(context.Context, string) types.ImageInspect); ok {
		r0 = rf(ctx, _a1)
	} else {
		r0 = ret.Get(0).(types.ImageInspect)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string) []byte); ok {
		r1 = rf(ctx, _a1)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = rf(ctx, _a1)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// ImageList provides a mock function with given fields: ctx, options
func (_m *DockerClient) ImageList(ctx context.Context, options types.ImageListOptions) ([]types.ImageSummary, error) {
	ret := _m.Called(ctx, options)

	var r0 []types.ImageSummary
	if rf, ok := ret.Get(0).(func(context.Context, types.ImageListOptions) []types.ImageSummary); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]types.ImageSummary)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.ImageListOptions) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageLoad provides a mock function with given fields: ctx, input, quiet
func (_m *DockerClient) ImageLoad(ctx context.Context, input io.Reader, quiet bool) (types.ImageLoadResponse, error) {
	ret := _m.Called(ctx, input, quiet)

	var r0 types.ImageLoadResponse
	if rf, ok := ret.Get(0).(func(context.Context, io.Reader, bool) types.ImageLoadResponse); ok {
		r0 = rf(ctx, input, quiet)
	} else {
		r0 = ret.Get(0).(types.ImageLoadResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, io.Reader, bool) error); ok {
		r1 = rf(ctx, input, quiet)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImagePull provides a mock function with given fields: ctx, ref, options
func (_m *DockerClient) ImagePull(ctx context.Context, ref string, options types.ImagePullOptions) (io.ReadCloser, error) {
	ret := _m.Called(ctx, ref, options)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ImagePullOptions) io.ReadCloser); ok {
		r0 = rf(ctx, ref, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ImagePullOptions) error); ok {
		r1 = rf(ctx, ref, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImagePush provides a mock function with given fields: ctx, ref, options
func (_m *DockerClient) ImagePush(ctx context.Context, ref string, options types.ImagePushOptions) (io.ReadCloser, error) {
	ret := _m.Called(ctx, ref, options)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ImagePushOptions) io.ReadCloser); ok {
		r0 = rf(ctx, ref, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ImagePushOptions) error); ok {
		r1 = rf(ctx, ref, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageRemove provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) ImageRemove(ctx context.Context, _a1 string, options types.ImageRemoveOptions) ([]types.ImageDeleteResponseItem, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 []types.ImageDeleteResponseItem
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ImageRemoveOptions) []types.ImageDeleteResponseItem); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]types.ImageDeleteResponseItem)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ImageRemoveOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageSave provides a mock function with given fields: ctx, images
func (_m *DockerClient) ImageSave(ctx context.Context, images []string) (io.ReadCloser, error) {
	ret := _m.Called(ctx, images)

	var r0 io.ReadCloser
	if rf, ok := ret.Get(0).(func(context.Context, []string) io.ReadCloser); ok {
		r0 = rf(ctx, images)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.ReadCloser)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string) error); ok {
		r1 = rf(ctx, images)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageSearch provides a mock function with given fields: ctx, term, options
func (_m *DockerClient) ImageSearch(ctx context.Context, term string, options types.ImageSearchOptions) ([]registry.SearchResult, error) {
	ret := _m.Called(ctx, term, options)

	var r0 []registry.SearchResult
	if rf, ok := ret.Get(0).(func(context.Context, string, types.ImageSearchOptions) []registry.SearchResult); ok {
		r0 = rf(ctx, term, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]registry.SearchResult)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.ImageSearchOptions) error); ok {
		r1 = rf(ctx, term, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ImageTag provides a mock function with given fields: ctx, _a1, ref
func (_m *DockerClient) ImageTag(ctx context.Context, _a1 string, ref string) error {
	ret := _m.Called(ctx, _a1, ref)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, _a1, ref)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ImagesPrune provides a mock function with given fields: ctx, pruneFilter
func (_m *DockerClient) ImagesPrune(ctx context.Context, pruneFilter filters.Args) (types.ImagesPruneReport, error) {
	ret := _m.Called(ctx, pruneFilter)

	var r0 types.ImagesPruneReport
	if rf, ok := ret.Get(0).(func(context.Context, filters.Args) types.ImagesPruneReport); ok {
		r0 = rf(ctx, pruneFilter)
	} else {
		r0 = ret.Get(0).(types.ImagesPruneReport)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, filters.Args) error); ok {
		r1 = rf(ctx, pruneFilter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Info provides a mock function with given fields: ctx
func (_m *DockerClient) Info(ctx context.Context) (types.Info, error) {
	ret := _m.Called(ctx)

	var r0 types.Info
	if rf, ok := ret.Get(0).(func(context.Context) types.Info); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Get(0).(types.Info)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NetworkConnect provides a mock function with given fields: ctx, _a1, _a2, config
func (_m *DockerClient) NetworkConnect(ctx context.Context, _a1 string, _a2 string, config *network.EndpointSettings) error {
	ret := _m.Called(ctx, _a1, _a2, config)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *network.EndpointSettings) error); ok {
		r0 = rf(ctx, _a1, _a2, config)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NetworkCreate provides a mock function with given fields: ctx, name, options
func (_m *DockerClient) NetworkCreate(ctx context.Context, name string, options types.NetworkCreate) (types.NetworkCreateResponse, error) {
	ret := _m.Called(ctx, name, options)

	var r0 types.NetworkCreateResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, types.NetworkCreate) types.NetworkCreateResponse); ok {
		r0 = rf(ctx, name, options)
	} else {
		r0 = ret.Get(0).(types.NetworkCreateResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.NetworkCreate) error); ok {
		r1 = rf(ctx, name, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NetworkDisconnect provides a mock function with given fields: ctx, _a1, _a2, force
func (_m *DockerClient) NetworkDisconnect(ctx context.Context, _a1 string, _a2 string, force bool) error {
	ret := _m.Called(ctx, _a1, _a2, force)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, bool) error); ok {
		r0 = rf(ctx, _a1, _a2, force)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NetworkInspect provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) NetworkInspect(ctx context.Context, _a1 string, options types.NetworkInspectOptions) (types.NetworkResource, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 types.NetworkResource
	if rf, ok := ret.Get(0).(func(context.Context, string, types.NetworkInspectOptions) types.NetworkResource); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Get(0).(types.NetworkResource)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, types.NetworkInspectOptions) error); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NetworkInspectWithRaw provides a mock function with given fields: ctx, _a1, options
func (_m *DockerClient) NetworkInspectWithRaw(ctx context.Context, _a1 string, options types.NetworkInspectOptions) (types.NetworkResource, []byte, error) {
	ret := _m.Called(ctx, _a1, options)

	var r0 types.NetworkResource
	if rf, ok := ret.Get(0).(func(context.Context, string, types.NetworkInspectOptions) types.NetworkResource); ok {
		r0 = rf(ctx, _a1, options)
	} else {
		r0 = ret.Get(0).(types.NetworkResource)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string, types.NetworkInspectOptions) []byte); ok {
		r1 = rf(ctx, _a1, options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, types.NetworkInspectOptions) error); ok {
		r2 = rf(ctx, _a1, options)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// NetworkList provides a mock function with given fields: ctx, options
func (_m *DockerClient) NetworkList(ctx context.Context, options types.NetworkListOptions) ([]types.NetworkResource, error) {
	ret := _m.Called(ctx, options)

	var r0 []types.NetworkResource
	if rf, ok := ret.Get(0).(func(context.Context, types.NetworkListOptions) []types.NetworkResource); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]types.NetworkResource)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.NetworkListOptions) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NetworkRemove provides a mock function with given fields: ctx, _a1
func (_m *DockerClient) NetworkRemove(ctx context.Context, _a1 string) error {
	ret := _m.Called(ctx, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NetworksPrune provides a mock function with given fields: ctx, pruneFilter
func (_m *DockerClient) NetworksPrune(ctx context.Context, pruneFilter filters.Args) (types.NetworksPruneReport, error) {
	ret := _m.Called(ctx, pruneFilter)

	var r0 types.NetworksPruneReport
	if rf, ok := ret.Get(0).(func(context.Context, filters.Args) types.NetworksPruneReport); ok {
		r0 = rf(ctx, pruneFilter)
	} else {
		r0 = ret.Get(0).(types.NetworksPruneReport)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, filters.Args) error); ok {
		r1 = rf(ctx, pruneFilter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NodeInspectWithRaw provides a mock function with given fields: ctx, nodeID
func (_m *DockerClient) NodeInspectWithRaw(ctx context.Context, nodeID string) (swarm.Node, []byte, error) {
	ret := _m.Called(ctx, nodeID)

	var r0 swarm.Node
	if rf, ok := ret.Get(0).(func(context.Context, string) swarm.Node); ok {
		r0 = rf(ctx, nodeID)
	} else {
		r0 = ret.Get(0).(swarm.Node)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string) []byte); ok {
		r1 = rf(ctx, nodeID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = rf(ctx, nodeID)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// NodeList provides a mock function with given fields: ctx, options
func (_m *DockerClient) NodeList(ctx context.Context, options types.NodeListOptions) ([]swarm.Node, error) {
	ret := _m.Called(ctx, options)

	var r0 []swarm.Node
	if rf, ok := ret.Get(0).(func(context.Context, types.NodeListOptions) []swarm.Node); ok {
		r0 = rf(ctx, options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]swarm.Node)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.NodeListOptions) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NodeRemove provides a mock function with given fields: ctx, nodeID, options
func (_m *DockerClient) NodeRemove(ctx context.Context, nodeID string, options types.NodeRemoveOptions) error {
	ret := _m.Called(ctx, nodeID, options)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, types.NodeRemoveOptions) error); ok {
		r0 = rf(ctx, nodeID, options)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NodeUpdate provides a mock function with given fields: ctx, nodeID, version, node
func (_m *DockerClient) NodeUpdate(ctx context.Context, nodeID string, version swarm.Version, node swarm.NodeSpec) error {
	ret := _m.Called(ctx, nodeID, version, node)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, swarm.Version, swarm.NodeSpec) error); ok {
		r0 = rf(ctx, nodeID, version, node)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Ping provides a mock function with given fields: ctx
func (_m *DockerClient) Ping(ctx context.Context) (types.Ping, error) {
	ret := _m.Called(ctx)

	var r0 types.Ping
	if rf, ok := ret.Get(0).(func(context.Context) types.Ping); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Get(0).(types.Ping)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RegistryLogin provides a mock function with given fields: ctx, auth
func (_m *DockerClient) RegistryLogin(ctx context.Context, auth types.AuthConfig) (registry.AuthenticateOKBody, error) {
	ret := _m.Called(ctx, auth)

	var r0 registry.AuthenticateOKBody
	if rf, ok := ret.Get(0).(func(context.Context, types.AuthConfig) registry.AuthenticateOKBody); ok {
		r0 = rf(ctx, auth)
	} else {
		r0 = ret.Get(0).(registry.AuthenticateOKBody)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, types.AuthConfig) error); ok {
		r1 = rf(ctx, auth)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ServerVersion provides a mock function with given fields: ctx
func (_m *DockerClient) ServerVersion(ctx context.Context) (types.Version, error) {
	ret := _m.Called(ctx)

	var r0 types.Version
	if rf, ok := ret.Get(0).(func(context.Context) types.Version); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Get(0).(types.Version)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// VolumeCreate provides a mock function with given fields: ctx, options
func (_m *DockerClient) VolumeCreate(ctx context.Context, options volume.VolumeCreateBody) (types.Volume, error) {
	ret := _m.Called(ctx, options)

	var r0 types.Volume
	if rf, ok := ret.Get(0).(func(context.Context, volume.VolumeCreateBody) types.Volume); ok {
		r0 = rf(ctx, options)
	} else {
		r0 = ret.Get(0).(types.Volume)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, volume.VolumeCreateBody) error); ok {
		r1 = rf(ctx, options)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// VolumeInspect provides a mock function with given fields: ctx, volumeID
func (_m *DockerClient) VolumeInspect(ctx context.Context, volumeID string) (types.Volume, error) {
	ret := _m.Called(ctx, volumeID)

	var r0 types.Volume
	if rf, ok := ret.Get(0).(func(context.Context, string) types.Volume); ok {
		r0 = rf(ctx, volumeID)
	} else {
		r0 = ret.Get(0).(types.Volume)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, volumeID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// VolumeInspectWithRaw provides a mock function with given fields: ctx, volumeID
func (_m *DockerClient) VolumeInspectWithRaw(ctx context.Context, volumeID string) (types.Volume, []byte, error) {
	ret := _m.Called(ctx, volumeID)

	var r0 types.Volume
	if rf, ok := ret.Get(0).(func(context.Context, string) types.Volume); ok {
		r0 = rf(ctx, volumeID)
	} else {
		r0 = ret.Get(0).(types.Volume)
	}

	var r1 []byte
	if rf, ok := ret.Get(1).(func(context.Context, string) []byte); ok {
		r1 = rf(ctx, volumeID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]byte)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string) error); ok {
		r2 = rf(ctx, volumeID)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// VolumeList provides a mock function with given fields: ctx, filter
func (_m *DockerClient) VolumeList(ctx context.Context, filter filters.Args) (volume.VolumeListOKBody, error) {
	ret := _m.Called(ctx, filter)

	var r0 volume.VolumeListOKBody
	if rf, ok := ret.Get(0).(func(context.Context, filters.Args) volume.VolumeListOKBody); ok {
		r0 = rf(ctx, filter)
	} else {
		r0 = ret.Get(0).(volume.VolumeListOKBody)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, filters.Args) error); ok {
		r1 = rf(ctx, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// VolumeRemove provides a mock function with given fields: ctx, volumeID, force
func (_m *DockerClient) VolumeRemove(ctx context.Context, volumeID string, force bool) error {
	ret := _m.Called(ctx, volumeID, force)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, bool) error); ok {
		r0 = rf(ctx, volumeID, force)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// VolumesPrune provides a mock function with given fields: ctx, pruneFilter
func (_m *DockerClient) VolumesPrune(ctx context.Context, pruneFilter filters.Args) (types.VolumesPruneReport, error) {
	ret := _m.Called(ctx, pruneFilter)

	var r0 types.VolumesPruneReport
	if rf, ok := ret.Get(0).(func(context.Context, filters.Args) types.VolumesPruneReport); ok {
		r0 = rf(ctx, pruneFilter)
	} else {
		r0 = ret.Get(0).(types.VolumesPruneReport)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, filters.Args) error); ok {
		r1 = rf(ctx, pruneFilter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
