# GDB image to load Agent core dump

Assuming you have a core dump generated by a containerized Agent (with
the `c_core_dump` Agent option enabled), load the core dump with GDB with the provided Dockerfile.

The image built from the Dockerfile includes:

* the debug symbols of the Agent (datadog-agent-dbg), for the version you're debugging
* the GDB scripts for Go and Python (only tested with Python 3)

The image is based on the `datadog/agent` image for the version of the Agent you're debugging, so that the debug symbols of the system libraries are at the correct version.

## Usage

1. Build the image, passing as build argument the Agent version that generated the core dump. Example:

  ```sh
  docker build -t gdb-agent:7.18.0 --build-arg AGENT_VERSION=7.18.0 .
  ```

  Optional build args, which configure how to source the `datadog-agent-dbg` package:
  * `APT_REPO`: APT repo (default: `apt.datadoghq.com`)
  * `APT_DISTRIBUTION`: APT distro (default: `stable`)

  Example: for `7.18.0-rc.2` use `--build-arg APT_REPO=apt.datad0g.com --build-arg APT_DISTRIBUTION=beta`.
  
2. Navigate the core dump file in a gdb prompt:

  ```sh
  docker run -it -v /path/to/core_dump_file:/root/core gdb-agent:7.18.0 /root/core
  ```

You now have access to a regular gdb prompt, with the Python GDB extension. Example of commands:

```
info threads # list threads
thread <ID>  # switch to thread
bt           # show stacktrace for current thread
py-bt        # show python stacktrace (if selected thread is a python thread and has python frames)
```

See https://devguide.python.org/gdb/#gdb-7-and-later for more info on the Python-specific commands.

## TODO

* add cpython sources
