#pragma once
#include <map>
#include <string>

static const std::map<DWORD, std::wstring> lmerrors = {
    {2, L"The workstation driver is not installed."},
    {3, L"The server could not be located."},
    {4, L"An internal error occurred."},
    {5, L"A network resource shortage occurred ."},
    {6, L"This operation is not supported on workstations."},
    {7, L"The device is not connected."},
    {14, L"The Server service is not started."},
    {15, L"The queue is empty."},
    {16, L"The device or directory does not exist."},
    {17, L"The operation is invalid on a redirected resource."},
    {18, L"The name has already been shared."},
    {19, L"The server is currently out of the requested resource."},
    {21, L"Requested addition of items exceeds the maximum allowed."},
    {22, L"The Peer service supports only two simultaneous users."},
    {23, L"The API return buffer is too small."},
    {27, L"A remote API error occurred."},
    {31, L"An error occurred when opening or reading the configuration file."},
    {36, L"A general network error occurred."},
    {37, L"The Workstation service is in an inconsistent state."},
    {38, L"The Workstation service has not been started."},
    {39, L"The requested information is not available."},
    {40, L"An internal Windows error occurred."},
    {41, L"The server is not configured for transactions."},
    {42, L"The requested API is not supported on the remote server."},
    {43, L"The event name is invalid."},
    {44, L"The computer name already exists on the network."},
    {46, L"The specified component could not be found in the configuration information."},
    {47, L"The specified parameter could not be found in the configuration information."},
    {49, L"A line in the configuration file is too long."},
    {50, L"The printer does not exist."},
    {51, L"The print job does not exist."},
    {52, L"The printer destination cannot be found."},
    {53, L"The printer destination already exists."},
    {54, L"The printer queue already exists."},
    {55, L"No more printers can be added."},
    {56, L"No more print jobs can be added."},
    {57, L"No more printer destinations can be added."},
    {58, L"This printer destination is idle and cannot accept control operations."},
    {59, L"This printer destination request contains an invalid control function."},
    {60, L"The print processor is not responding."},
    {61, L"The spooler is not running."},
    {62, L"This operation cannot be performed on the print destination in its current state."},
    {63, L"This operation cannot be performed on the printer queue in its current state."},
    {64, L"This operation cannot be performed on the print job in its current state."},
    {65, L"A spooler memory allocation failure occurred."},
    {66, L"The device driver does not exist."},
    {67, L"The data type is not supported by the print processor."},
    {68, L"The print processor is not installed."},
    {80, L"The service database is locked."},
    {81, L"The service table is full."},
    {82, L"The requested service has already been started."},
    {83, L"The service does not respond to control actions."},
    {84, L"The service has not been started."},
    {85, L"The service name is invalid."},
    {86, L"The service is not responding to the control function."},
    {87, L"The service control is busy."},
    {88, L"The configuration file contains an invalid service program name."},
    {89, L"The service could not be controlled in its present state."},
    {90, L"The service ended abnormally."},
    {91, L"The requested pause, continue, or stop is not valid for this service."},
    {92, L"The service control dispatcher could not find the service name in the dispatch table."},
    {93, L"The service control dispatcher pipe read failed."},
    {94, L"A thread for the new service could not be created."},
    {100, L"This workstation is already logged on to the local-area network."},
    {101, L"The workstation is not logged on to the local-area network."},
    {102, L"The user name or group name parameter is invalid."},
    {103, L"The password parameter is invalid."},
    {104, L"@W The logon processor did not add the message alias."},
    {105, L"The logon processor did not add the message alias."},
    {106, L"@W The logoff processor did not delete the message alias."},
    {107, L"The logoff processor did not delete the message alias."},
    {109, L"Network logons are paused."},
    {110, L"A centralized logon-server conflict occurred."},
    {111, L"The server is configured without a valid user path."},
    {112, L"An error occurred while loading or running the logon script."},
    {114, L"The logon server was not specified."},
    {115, L"The logon server could not be found."},
    {116, L"There is already a logon domain for this computer."},
    {117, L"The logon server could not validate the logon."},
    {119, L"The security database could not be found."},
    {120, L"The group name could not be found."},
    {121, L"The user name could not be found."},
    {122, L"The resource name could not be found."},
    {123, L"The group already exists."},
    {124, L"The account already exists."},
    {125, L"The resource permission list already exists."},
    {126, L"This operation is only allowed on the primary domain controller of the domain."},
    {127, L"The security database has not been started."},
    {128, L"There are too many names in the user accounts database."},
    {129, L"A disk I/O failure occurred."},
    {130, L"The limit of 64 entries per resource was exceeded."},
    {131, L"Deleting a user with a session is not allowed."},
    {132, L"The parent directory could not be located."},
    {133, L"Unable to add to the security database session cache segment."},
    {134, L"This operation is not allowed on this special group."},
    {135, L"This user is not cached in user accounts database session cache."},
    {136, L"The user already belongs to this group."},
    {137, L"The user does not belong to this group."},
    {138, L"This user account is undefined."},
    {139, L"This user account has expired."},
    {140, L"The user is not allowed to log on from this workstation."},
    {141, L"The user is not allowed to log on at this time."},
    {142, L"The password of this user has expired."},
    {143, L"The password of this user cannot change."},
    {144, L"This password cannot be used now."},
    {145, L"The password does not meet the password policy requirements."},
    {146, L"The password of this user is too recent to change."},
    {147, L"The security database is corrupted."},
    {148, L"No updates are necessary to this replicant network/local security database."},
    {149, L"This replicant database is outdated; synchronization is required."},
    {150, L"The network connection could not be found."},
    {151, L"This asg_type is invalid."},
    {152, L"This device is currently being shared."},
    {153, L"The user name may not be same as computer name."},
    {170, L"The computer name could not be added as a message alias."},
    {171, L"The Messenger service is already started."},
    {172, L"The Messenger service failed to start."},
    {173, L"The message alias could not be found on the network."},
    {174, L"This message alias has already been forwarded."},
    {175, L"This message alias has been added but is still forwarded."},
    {176, L"This message alias already exists locally."},
    {177, L"The maximum number of added message aliases has been exceeded."},
    {178, L"The computer name could not be deleted."},
    {179, L"Messages cannot be forwarded back to the same workstation."},
    {180, L"An error occurred in the domain message processor."},
    {181, L"The message was sent, but the recipient has paused the Messenger service."},
    {182, L"The message was sent but not received."},
    {183, L"The message alias is currently in use."},
    {184, L"The Messenger service has not been started."},
    {185, L"The name is not on the local computer."},
    {186, L"The forwarded message alias could not be found on the network."},
    {187, L"The message alias table on the remote station is full."},
    {188, L"Messages for this alias are not currently being forwarded."},
    {189, L"The broadcast message was truncated."},
    {194, L"This is an invalid device name."},
    {195, L"A write fault occurred."},
    {197, L"A duplicate message alias exists on the network."},
    {198, L"@W This message alias will be deleted later."},
    {199, L"The message alias was not successfully deleted from all networks."},
    {200, L"This operation is not supported on computers with multiple networks."},
    {210, L"This shared resource does not exist."},
    {211, L"This device is not shared."},
    {212, L"A session does not exist with that computer name."},
    {214, L"There is not an open file with that identification number."},
    {215, L"A failure occurred when executing a remote administration command."},
    {216, L"A failure occurred when opening a remote temporary file."},
    {217, L"The data returned from a remote administration command has been truncated to 64K."},
    {218, L"This device cannot be shared as both a spooled and a non-spooled resource."},
    {219, L"The information in the list of servers may be incorrect."},
    {220, L"The computer is not active in this domain."},
    {221, L"The share must be removed from the Distributed File System before it can be deleted."},
    {231, L"The operation is invalid for this device."},
    {232, L"This device cannot be shared."},
    {233, L"This device was not open."},
    {234, L"This device name list is invalid."},
    {235, L"The queue priority is invalid."},
    {237, L"There are no shared communication devices."},
    {238, L"The queue you specified does not exist."},
    {240, L"This list of devices is invalid."},
    {241, L"The requested device is invalid."},
    {242, L"This device is already in use by the spooler."},
    {243, L"This device is already in use as a communication device."},
    {251, L"This computer name is invalid."},
    {254, L"The string and prefix specified are too long."},
    {256, L"This path component is invalid."},
    {257, L"Could not determine the type of input."},
    {262, L"The buffer for types is not big enough."},
    {270, L"Profile files cannot exceed 64K."},
    {271, L"The start offset is out of range."},
    {272, L"The system cannot delete current connections to network resources."},
    {273, L"The system was unable to parse the command line in this file."},
    {274, L"An error occurred while loading the profile file."},
    {275, L"@W Errors occurred while saving the profile file."},
    {277, L"Log file %1 is full."},
    {278, L"This log file has changed between reads."},
    {279, L"Log file %1 is corrupt."},
    {280, L"The source path cannot be a directory."},
    {281, L"The source path is illegal."},
    {282, L"The destination path is illegal."},
    {283, L"The source and destination paths are on different servers."},
    {285, L"The Run server you requested is paused."},
    {289, L"An error occurred when communicating with a Run server."},
    {291, L"An error occurred when starting a background process."},
    {292, L"The shared resource you are connected to could not be found."},
    {300, L"The LAN adapter number is invalid."},
    {301, L"There are open files on the connection."},
    {302, L"Active connections still exist."},
    {303, L"This share name or password is invalid."},
    {304, L"The device is being accessed by an active process."},
    {305, L"The drive letter is in use locally."},
    {330, L"The specified client is already registered for the specified event."},
    {331, L"The alert table is full."},
    {332, L"An invalid or nonexistent alert name was raised."},
    {333, L"The alert recipient is invalid."},
    {334, L"A user's session with this server has been deleted."},
    {340, L"The log file does not contain the requested record number."},
    {350, L"The user accounts database is not configured correctly."},
    {351, L"This operation is not permitted when the Netlogon service is running."},
    {352, L"This operation is not allowed on the last administrative account."},
    {353, L"Could not find domain controller for this domain."},
    {354, L"Could not set logon information for this user."},
    {355, L"The Netlogon service has not been started."},
    {356, L"Unable to add to the user accounts database."},
    {357, L"This server's clock is not synchronized with the primary domain controller's clock."},
    {358, L"A password mismatch has been detected."},
    {360, L"The server identification does not specify a valid server."},
    {361, L"The session identification does not specify a valid session."},
    {362, L"The connection identification does not specify a valid connection."},
    {363, L"There is no space for another entry in the table of available servers."},
    {364, L"The server has reached the maximum number of sessions it supports."},
    {365, L"The server has reached the maximum number of connections it supports."},
    {366, L"The server cannot open more files because it has reached its maximum number."},
    {367, L"There are no alternate servers registered on this server."},
    {370, L"Try down-level (remote admin protocol) version of API instead."},
    {380, L"The UPS driver could not be accessed by the UPS service."},
    {381, L"The UPS service is not configured correctly."},
    {382, L"The UPS service could not access the specified Comm Port."},
    {383, L"The UPS indicated a line fail or low battery situation."},
    {384, L"The UPS service failed to perform a system shut down."},
    {400, L"The program below returned an MS-DOS error code:*"},
    {401, L"The program below needs more memory:*"},
    {402, L"The program below called an unsupported MS-DOS function:*"},
    {403, L"The workstation failed to boot."},
    {404, L"The file below is corrupt."},
    {405, L"No loader is specified in the boot-block definition file."},
    {406, L"NetBIOS returned an error: The NCB and SMB are dumped above."},
    {407, L"A disk I/O error occurred."},
    {408, L"Image parameter substitution failed."},
    {409, L"Too many image parameters cross disk sector boundaries."},
    {410, L"The image was not generated from an MS-DOS diskette formatted with /S."},
    {411, L"Remote boot will be restarted later."},
    {412, L"The call to the Remoteboot server failed."},
    {413, L"Cannot connect to the Remoteboot server."},
    {414, L"Cannot open image file on the Remoteboot server."},
    {415, L"Connecting to the Remoteboot server."},
    {416, L"Connecting to the Remoteboot server."},
    {417, L"Remote boot service was stopped; check the error log for the cause of the problem."},
    {418, L"Remote boot startup failed; check the error log for the cause of the problem."},
    {419, L"A second connection to a Remoteboot resource is not allowed."},
    {450, L"The browser service was configured with MaintainServerList=No."},
    {510, L"Service failed to start since none of the network adapters started with this service."},
    {511, L"Service failed to start due to bad startup information in the registry."},
    {512, L"Service failed to start because its database is absent or corrupt."},
    {513, L"Service failed to start because RPLFILES share is absent."},
    {514, L"Service failed to start because RPLUSER group is absent."},
    {515, L"Cannot enumerate service records."},
    {516, L"Workstation record information has been corrupted."},
    {517, L"Workstation record was not found."},
    {518, L"Workstation name is in use by some other workstation."},
    {519, L"Profile record information has been corrupted."},
    {520, L"Profile record was not found."},
    {521, L"Profile name is in use by some other profile."},
    {522, L"There are workstations using this profile."},
    {523, L"Configuration record information has been corrupted."},
    {524, L"Configuration record was not found."},
    {525, L"Adapter id record information has been corrupted."},
    {526, L"An internal service error has occurred."},
    {527, L"Vendor id record information has been corrupted."},
    {528, L"Boot block record information has been corrupted."},
    {529, L"The user account for this workstation record is missing."},
    {530, L"The RPLUSER local group could not be found."},
    {531, L"Boot block record was not found."},
    {532, L"Chosen profile is incompatible with this workstation."},
    {533, L"Chosen network adapter id is in use by some other workstation."},
    {534, L"There are profiles using this configuration."},
    {535, L"There are workstations, profiles or configurations using this boot block."},
    {536, L"Service failed to backup Remoteboot database."},
    {537, L"Adapter record was not found."},
    {538, L"Vendor record was not found."},
    {539, L"Vendor name is in use by some other vendor record."},
    {540, L"(boot name, vendor id) is in use by some other boot block record."},
    {541, L"Configuration name is in use by some other configuration."},
    {560, L"The internal database maintained by the DFS service is corrupt*"},
    {561, L"One of the records in the internal DFS database is corrupt*"},
    {562, L"There is no DFS name whose entry path matches the input Entry Path*"},
    {563, L"A root or link with the given name already exists*"},
    {564, L"The server share specified is already shared in the DFS*"},
    {565, L"The indicated server share does not support the indicated DFS namespace*"},
    {566, L"The operation is not valid on this portion of the namespace*"},
    {567, L"The operation is not valid on this portion of the namespace*"},
    {568, L"The operation is ambiguous because the link has multiple servers*"},
    {569, L"Unable to create a link*"},
    {570, L"The server is not DFS Aware*"},
    {571, L"The specified rename target path is invalid*"},
    {572, L"The specified DFS link is offline*"},
    {573, L"The specified server is not a server for this link*"},
    {574, L"A cycle in the DFS name was detected*"},
    {575, L"The operation is not supported on a server-based DFS*"},
    {576, L"This link is already supported by the specified server-share*"},
    {577, L"Can't remove the last server-share supporting this root or link*"},
    {578, L"The operation is not supported for an Inter-DFS link*"},
    {579, L"The internal state of the DFS Service has become inconsistent*"},
    {580, L"The DFS Service has been installed on the specified server*"},
    {581, L"The DFS data being reconciled is identical*"},
    {582, L"The DFS root cannot be deleted - Uninstall DFS if required*"},
    {583, L"A child or parent directory of the share is already in a DFS*"},
    {590, L"DFS internal error*"},
    {591, L"This machine is already joined to a domain."},
    {592, L"This machine is not currently joined to a domain."},
    {593, L"This machine is a domain controller and cannot be unjoined from a domain."},
    {594, L"The destination domain controller does not support creating machine accounts in OUs."},
    {595, L"The specified workgroup name is invalid."},
    {596, L"The specified computer name is incompatible with the default language used on the domain controller."},
    {597, L"The specified computer account could not be found."},
    {598, L"This version of Windows cannot be joined to a domain."},
    {599, L"An attempt to resolve the DNS name of a domain controller in the domain being joined has failed."},
    {601, L"Password must change at next logon *"},
    {602, L"Account is locked out *"},
    {603, L"Password is too long *"},
    {604, L"Password doesn't meet the complexity policy *"},
    {605, L"Password doesn't meet the requirements of the filter dll's *"},
    {609, L"Offline join completion information was not found."},
    {610, L"The offline join completion information was bad."},
    {611, L"Unable to create offline join information."},
    {612, L"The domain join info being saved was incomplete or bad."},
    {613, L"Offline join operation successfully completed but a restart is needed."},
    {614, L"There was no offline join operation pending."},
    {615, L"Unable to set one or more requested machine or domain name values on the local computer."},
    {616,
     L"Could not verify the current machine's hostname against the saved value in the join completion information."},
    {617, L"Unable to load the specified offline registry hive."},
    {618, L"The minimum session security requirements for this operation were not met."},
    {619, L"Computer account provisioning blob version is not supported."},
    {620, L"The specified domain controller does not meet the version requirement for this operation."},
    {621, L"This operation requires a domain controller which supports LDAP."},
    {622, L"A domain controller which meets the version requirement for this operation could not be located."},
    {623, L"The Windows version of the specified image does not support provisioning."},
    {624, L"The machine name is blocked from joining the domain."},
    {625, L"The domain controller does not meet the version requirement for this operation."},
    {899, L"This is the last error in NERR range."}};
