# System.Reflection.Metadata

``` diff
 namespace System.Reflection.Metadata {
+    public struct ArrayShape {
+        public ArrayShape(int rank, ImmutableArray<int> sizes, ImmutableArray<int> lowerBounds);
+        public ImmutableArray<int> LowerBounds { get; }
+        public int Rank { get; }
+        public ImmutableArray<int> Sizes { get; }
+    }
+    public struct Blob {
+        public bool IsDefault { get; }
+        public int Length { get; }
+        public ArraySegment<byte> GetBytes();
+    }
+    public class BlobBuilder {
+        public BlobBuilder(int capacity=256);
+        protected internal int ChunkCapacity { get; }
+        public int Count { get; }
+        protected int FreeBytes { get; }
+        public void Align(int alignment);
+        protected virtual BlobBuilder AllocateChunk(int minimalSize);
+        public void Clear();
+        public bool ContentEquals(BlobBuilder other);
+        protected void Free();
+        protected virtual void FreeChunk();
+        public BlobBuilder.Blobs GetBlobs();
+        public void LinkPrefix(BlobBuilder prefix);
+        public void LinkSuffix(BlobBuilder suffix);
+        public void PadTo(int position);
+        public Blob ReserveBytes(int byteCount);
+        public byte[] ToArray();
+        public byte[] ToArray(int start, int byteCount);
+        public ImmutableArray<byte> ToImmutableArray();
+        public ImmutableArray<byte> ToImmutableArray(int start, int byteCount);
+        public int TryWriteBytes(Stream source, int byteCount);
+        public void WriteBoolean(bool value);
+        public void WriteByte(byte value);
+        public unsafe void WriteBytes(byte* buffer, int byteCount);
+        public void WriteBytes(byte value, int byteCount);
+        public void WriteBytes(byte[] buffer);
+        public void WriteBytes(byte[] buffer, int start, int byteCount);
+        public void WriteBytes(ImmutableArray<byte> buffer);
+        public void WriteBytes(ImmutableArray<byte> buffer, int start, int byteCount);
+        public void WriteCompressedInteger(int value);
+        public void WriteCompressedSignedInteger(int value);
+        public void WriteConstant(object value);
+        public void WriteContentTo(Stream destination);
+        public void WriteContentTo(BlobBuilder destination);
+        public void WriteContentTo(ref BlobWriter destination);
+        public void WriteDateTime(DateTime value);
+        public void WriteDecimal(decimal value);
+        public void WriteDouble(double value);
+        public void WriteGuid(Guid value);
+        public void WriteInt16(short value);
+        public void WriteInt16BE(short value);
+        public void WriteInt32(int value);
+        public void WriteInt32BE(int value);
+        public void WriteInt64(long value);
+        public void WriteReference(int reference, bool isSmall);
+        public void WriteSByte(sbyte value);
+        public void WriteSerializedString(string value);
+        public void WriteSingle(float value);
+        public void WriteUInt16(ushort value);
+        public void WriteUInt16BE(ushort value);
+        public void WriteUInt32(uint value);
+        public void WriteUInt32BE(uint value);
+        public void WriteUInt64(ulong value);
+        public void WriteUserString(string value);
+        public void WriteUTF16(char[] value);
+        public void WriteUTF16(string value);
+        public void WriteUTF8(string value, bool allowUnpairedSurrogates=true);
+        public struct Blobs : IDisposable, IEnumerable, IEnumerable<Blob>, IEnumerator, IEnumerator<Blob> {
+            public Blob Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public BlobBuilder.Blobs GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<Blob> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.Blob>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public struct BlobContentId : IEquatable<BlobContentId> {
+        public BlobContentId(byte[] id);
+        public BlobContentId(ImmutableArray<byte> id);
+        public BlobContentId(Guid guid, uint stamp);
+        public Guid Guid { get; }
+        public bool IsDefault { get; }
+        public uint Stamp { get; }
+        public override bool Equals(object obj);
+        public bool Equals(BlobContentId other);
+        public static BlobContentId FromHash(byte[] hashCode);
+        public static BlobContentId FromHash(ImmutableArray<byte> hashCode);
+        public override int GetHashCode();
+        public static Func<IEnumerable<Blob>, BlobContentId> GetTimeBasedProvider();
+        public static bool operator ==(BlobContentId left, BlobContentId right);
+        public static bool operator !=(BlobContentId left, BlobContentId right);
+    }
     public struct BlobReader {
+        public unsafe byte* CurrentPointer { get; }
+        public unsafe byte* StartPointer { get; }
+        public void Align(byte alignment);
+        public void ReadBytes(int byteCount, byte[] buffer, int bufferOffset);
+        public void SeekOffset(int offset);
+        public void SkipBytes(int count);
     }
+    public struct BlobWriter {
+        public BlobWriter(byte[] buffer);
+        public BlobWriter(byte[] buffer, int start, int count);
+        public BlobWriter(int size);
+        public BlobWriter(Blob blob);
+        public Blob Blob { get; }
+        public int Length { get; }
+        public int Offset { get; set; }
+        public int RemainingBytes { get; }
+        public void Align(int alignment);
+        public void Clear();
+        public bool ContentEquals(BlobWriter other);
+        public void PadTo(int offset);
+        public byte[] ToArray();
+        public byte[] ToArray(int start, int byteCount);
+        public ImmutableArray<byte> ToImmutableArray();
+        public ImmutableArray<byte> ToImmutableArray(int start, int byteCount);
+        public void WriteBoolean(bool value);
+        public void WriteByte(byte value);
+        public unsafe void WriteBytes(byte* buffer, int byteCount);
+        public void WriteBytes(byte value, int byteCount);
+        public void WriteBytes(byte[] buffer);
+        public void WriteBytes(byte[] buffer, int start, int byteCount);
+        public void WriteBytes(ImmutableArray<byte> buffer);
+        public void WriteBytes(ImmutableArray<byte> buffer, int start, int byteCount);
+        public int WriteBytes(Stream source, int byteCount);
+        public void WriteBytes(BlobBuilder source);
+        public void WriteCompressedInteger(int value);
+        public void WriteCompressedSignedInteger(int value);
+        public void WriteConstant(object value);
+        public void WriteDateTime(DateTime value);
+        public void WriteDecimal(decimal value);
+        public void WriteDouble(double value);
+        public void WriteGuid(Guid value);
+        public void WriteInt16(short value);
+        public void WriteInt16BE(short value);
+        public void WriteInt32(int value);
+        public void WriteInt32BE(int value);
+        public void WriteInt64(long value);
+        public void WriteReference(int reference, bool isSmall);
+        public void WriteSByte(sbyte value);
+        public void WriteSerializedString(string str);
+        public void WriteSingle(float value);
+        public void WriteUInt16(ushort value);
+        public void WriteUInt16BE(ushort value);
+        public void WriteUInt32(uint value);
+        public void WriteUInt32BE(uint value);
+        public void WriteUInt64(ulong value);
+        public void WriteUserString(string value);
+        public void WriteUTF16(char[] value);
+        public void WriteUTF16(string value);
+        public void WriteUTF8(string value, bool allowUnpairedSurrogates);
+    }
     public struct CustomAttribute {
+        public CustomAttributeValue<TType> DecodeValue<TType>(ICustomAttributeTypeProvider<TType> provider);
     }
+    public struct CustomAttributeNamedArgument<TType> {
+        public CustomAttributeNamedArgument(string name, CustomAttributeNamedArgumentKind kind, TType type, object value);
+        public CustomAttributeNamedArgumentKind Kind { get; }
+        public string Name { get; }
+        public TType Type { get; }
+        public object Value { get; }
+    }
+    public struct CustomAttributeTypedArgument<TType> {
+        public CustomAttributeTypedArgument(TType type, object value);
+        public TType Type { get; }
+        public object Value { get; }
+    }
+    public struct CustomAttributeValue<TType> {
+        public CustomAttributeValue(ImmutableArray<CustomAttributeTypedArgument<TType>> fixedArguments, ImmutableArray<CustomAttributeNamedArgument<TType>> namedArguments);
+        public ImmutableArray<CustomAttributeTypedArgument<TType>> FixedArguments { get; }
+        public ImmutableArray<CustomAttributeNamedArgument<TType>> NamedArguments { get; }
+    }
     public struct FieldDefinition {
+        public TType DecodeSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
+    public interface IConstructedTypeProvider<TType> : ISZArrayTypeProvider<TType> {
+        TType GetArrayType(TType elementType, ArrayShape shape);
+        TType GetByReferenceType(TType elementType);
+        TType GetGenericInstance(TType genericType, ImmutableArray<TType> typeArguments);
+        TType GetPointerType(TType elementType);
+    }
+    public interface ICustomAttributeTypeProvider<TType> : IPrimitiveTypeProvider<TType>, ISZArrayTypeProvider<TType>, ITypeProvider<TType> {
+        TType GetSystemType();
+        TType GetTypeFromSerializedName(string name);
+        PrimitiveTypeCode GetUnderlyingEnumType(TType type);
+        bool IsSystemType(TType type);
+    }
+    public enum ILOpCode : ushort {
+        Add = (ushort)88,
+        Add_ovf = (ushort)214,
+        Add_ovf_un = (ushort)215,
+        And = (ushort)95,
+        Arglist = (ushort)65024,
+        Beq = (ushort)59,
+        Beq_s = (ushort)46,
+        Bge = (ushort)60,
+        Bge_s = (ushort)47,
+        Bge_un = (ushort)65,
+        Bge_un_s = (ushort)52,
+        Bgt = (ushort)61,
+        Bgt_s = (ushort)48,
+        Bgt_un = (ushort)66,
+        Bgt_un_s = (ushort)53,
+        Ble = (ushort)62,
+        Ble_s = (ushort)49,
+        Ble_un = (ushort)67,
+        Ble_un_s = (ushort)54,
+        Blt = (ushort)63,
+        Blt_s = (ushort)50,
+        Blt_un = (ushort)68,
+        Blt_un_s = (ushort)55,
+        Bne_un = (ushort)64,
+        Bne_un_s = (ushort)51,
+        Box = (ushort)140,
+        Br = (ushort)56,
+        Br_s = (ushort)43,
+        Break = (ushort)1,
+        Brfalse = (ushort)57,
+        Brfalse_s = (ushort)44,
+        Brtrue = (ushort)58,
+        Brtrue_s = (ushort)45,
+        Call = (ushort)40,
+        Calli = (ushort)41,
+        Callvirt = (ushort)111,
+        Castclass = (ushort)116,
+        Ceq = (ushort)65025,
+        Cgt = (ushort)65026,
+        Cgt_un = (ushort)65027,
+        Ckfinite = (ushort)195,
+        Clt = (ushort)65028,
+        Clt_un = (ushort)65029,
+        Constrained = (ushort)65046,
+        Conv_i = (ushort)211,
+        Conv_i1 = (ushort)103,
+        Conv_i2 = (ushort)104,
+        Conv_i4 = (ushort)105,
+        Conv_i8 = (ushort)106,
+        Conv_ovf_i = (ushort)212,
+        Conv_ovf_i_un = (ushort)138,
+        Conv_ovf_i1 = (ushort)179,
+        Conv_ovf_i1_un = (ushort)130,
+        Conv_ovf_i2 = (ushort)181,
+        Conv_ovf_i2_un = (ushort)131,
+        Conv_ovf_i4 = (ushort)183,
+        Conv_ovf_i4_un = (ushort)132,
+        Conv_ovf_i8 = (ushort)185,
+        Conv_ovf_i8_un = (ushort)133,
+        Conv_ovf_u = (ushort)213,
+        Conv_ovf_u_un = (ushort)139,
+        Conv_ovf_u1 = (ushort)180,
+        Conv_ovf_u1_un = (ushort)134,
+        Conv_ovf_u2 = (ushort)182,
+        Conv_ovf_u2_un = (ushort)135,
+        Conv_ovf_u4 = (ushort)184,
+        Conv_ovf_u4_un = (ushort)136,
+        Conv_ovf_u8 = (ushort)186,
+        Conv_ovf_u8_un = (ushort)137,
+        Conv_r_un = (ushort)118,
+        Conv_r4 = (ushort)107,
+        Conv_r8 = (ushort)108,
+        Conv_u = (ushort)224,
+        Conv_u1 = (ushort)210,
+        Conv_u2 = (ushort)209,
+        Conv_u4 = (ushort)109,
+        Conv_u8 = (ushort)110,
+        Cpblk = (ushort)65047,
+        Cpobj = (ushort)112,
+        Div = (ushort)91,
+        Div_un = (ushort)92,
+        Dup = (ushort)37,
+        Endfilter = (ushort)65041,
+        Endfinally = (ushort)220,
+        Initblk = (ushort)65048,
+        Initobj = (ushort)65045,
+        Isinst = (ushort)117,
+        Jmp = (ushort)39,
+        Ldarg = (ushort)65033,
+        Ldarg_0 = (ushort)2,
+        Ldarg_1 = (ushort)3,
+        Ldarg_2 = (ushort)4,
+        Ldarg_3 = (ushort)5,
+        Ldarg_s = (ushort)14,
+        Ldarga = (ushort)65034,
+        Ldarga_s = (ushort)15,
+        Ldc_i4 = (ushort)32,
+        Ldc_i4_0 = (ushort)22,
+        Ldc_i4_1 = (ushort)23,
+        Ldc_i4_2 = (ushort)24,
+        Ldc_i4_3 = (ushort)25,
+        Ldc_i4_4 = (ushort)26,
+        Ldc_i4_5 = (ushort)27,
+        Ldc_i4_6 = (ushort)28,
+        Ldc_i4_7 = (ushort)29,
+        Ldc_i4_8 = (ushort)30,
+        Ldc_i4_m1 = (ushort)21,
+        Ldc_i4_s = (ushort)31,
+        Ldc_i8 = (ushort)33,
+        Ldc_r4 = (ushort)34,
+        Ldc_r8 = (ushort)35,
+        Ldelem = (ushort)163,
+        Ldelem_i = (ushort)151,
+        Ldelem_i1 = (ushort)144,
+        Ldelem_i2 = (ushort)146,
+        Ldelem_i4 = (ushort)148,
+        Ldelem_i8 = (ushort)150,
+        Ldelem_r4 = (ushort)152,
+        Ldelem_r8 = (ushort)153,
+        Ldelem_ref = (ushort)154,
+        Ldelem_u1 = (ushort)145,
+        Ldelem_u2 = (ushort)147,
+        Ldelem_u4 = (ushort)149,
+        Ldelema = (ushort)143,
+        Ldfld = (ushort)123,
+        Ldflda = (ushort)124,
+        Ldftn = (ushort)65030,
+        Ldind_i = (ushort)77,
+        Ldind_i1 = (ushort)70,
+        Ldind_i2 = (ushort)72,
+        Ldind_i4 = (ushort)74,
+        Ldind_i8 = (ushort)76,
+        Ldind_r4 = (ushort)78,
+        Ldind_r8 = (ushort)79,
+        Ldind_ref = (ushort)80,
+        Ldind_u1 = (ushort)71,
+        Ldind_u2 = (ushort)73,
+        Ldind_u4 = (ushort)75,
+        Ldlen = (ushort)142,
+        Ldloc = (ushort)65036,
+        Ldloc_0 = (ushort)6,
+        Ldloc_1 = (ushort)7,
+        Ldloc_2 = (ushort)8,
+        Ldloc_3 = (ushort)9,
+        Ldloc_s = (ushort)17,
+        Ldloca = (ushort)65037,
+        Ldloca_s = (ushort)18,
+        Ldnull = (ushort)20,
+        Ldobj = (ushort)113,
+        Ldsfld = (ushort)126,
+        Ldsflda = (ushort)127,
+        Ldstr = (ushort)114,
+        Ldtoken = (ushort)208,
+        Ldvirtftn = (ushort)65031,
+        Leave = (ushort)221,
+        Leave_s = (ushort)222,
+        Localloc = (ushort)65039,
+        Mkrefany = (ushort)198,
+        Mul = (ushort)90,
+        Mul_ovf = (ushort)216,
+        Mul_ovf_un = (ushort)217,
+        Neg = (ushort)101,
+        Newarr = (ushort)141,
+        Newobj = (ushort)115,
+        Nop = (ushort)0,
+        Not = (ushort)102,
+        Or = (ushort)96,
+        Pop = (ushort)38,
+        Readonly = (ushort)65054,
+        Refanytype = (ushort)65053,
+        Refanyval = (ushort)194,
+        Rem = (ushort)93,
+        Rem_un = (ushort)94,
+        Ret = (ushort)42,
+        Rethrow = (ushort)65050,
+        Shl = (ushort)98,
+        Shr = (ushort)99,
+        Shr_un = (ushort)100,
+        Sizeof = (ushort)65052,
+        Starg = (ushort)65035,
+        Starg_s = (ushort)16,
+        Stelem = (ushort)164,
+        Stelem_i = (ushort)155,
+        Stelem_i1 = (ushort)156,
+        Stelem_i2 = (ushort)157,
+        Stelem_i4 = (ushort)158,
+        Stelem_i8 = (ushort)159,
+        Stelem_r4 = (ushort)160,
+        Stelem_r8 = (ushort)161,
+        Stelem_ref = (ushort)162,
+        Stfld = (ushort)125,
+        Stind_i = (ushort)223,
+        Stind_i1 = (ushort)82,
+        Stind_i2 = (ushort)83,
+        Stind_i4 = (ushort)84,
+        Stind_i8 = (ushort)85,
+        Stind_r4 = (ushort)86,
+        Stind_r8 = (ushort)87,
+        Stind_ref = (ushort)81,
+        Stloc = (ushort)65038,
+        Stloc_0 = (ushort)10,
+        Stloc_1 = (ushort)11,
+        Stloc_2 = (ushort)12,
+        Stloc_3 = (ushort)13,
+        Stloc_s = (ushort)19,
+        Stobj = (ushort)129,
+        Stsfld = (ushort)128,
+        Sub = (ushort)89,
+        Sub_ovf = (ushort)218,
+        Sub_ovf_un = (ushort)219,
+        Switch = (ushort)69,
+        Tail = (ushort)65044,
+        Throw = (ushort)122,
+        Unaligned = (ushort)65042,
+        Unbox = (ushort)121,
+        Unbox_any = (ushort)165,
+        Volatile = (ushort)65043,
+        Xor = (ushort)97,
+    }
+    public static class ILOpCodeExtensions {
+        public static int GetBranchOperandSize(this ILOpCode opCode);
+        public static ILOpCode GetLongBranch(this ILOpCode opCode);
+        public static ILOpCode GetShortBranch(this ILOpCode opCode);
+        public static bool IsBranch(this ILOpCode opCode);
+    }
+    public class ImageFormatLimitationException : Exception {
+        public ImageFormatLimitationException();
+        public ImageFormatLimitationException(string message);
+        public ImageFormatLimitationException(string message, Exception innerException);
+    }
+    public interface IPrimitiveTypeProvider<TType> {
+        TType GetPrimitiveType(PrimitiveTypeCode typeCode);
+    }
+    public interface ISignatureTypeProvider<TType> : IConstructedTypeProvider<TType>, IPrimitiveTypeProvider<TType>, ISZArrayTypeProvider<TType>, ITypeProvider<TType> {
+        TType GetFunctionPointerType(MethodSignature<TType> signature);
+        TType GetGenericMethodParameter(int index);
+        TType GetGenericTypeParameter(int index);
+        TType GetModifiedType(MetadataReader reader, bool isRequired, TType modifier, TType unmodifiedType);
+        TType GetPinnedType(TType elementType);
+    }
+    public interface ISZArrayTypeProvider<TType> {
+        TType GetSZArrayType(TType elementType);
+    }
+    public interface ITypeProvider<TType> {
+        TType GetTypeFromDefinition(MetadataReader reader, TypeDefinitionHandle handle, byte rawTypeKind);
+        TType GetTypeFromReference(MetadataReader reader, TypeReferenceHandle handle, byte rawTypeKind);
+        TType GetTypeFromSpecification(MetadataReader reader, TypeSpecificationHandle handle, byte rawTypeKind);
+    }
     public struct MemberReference {
+        public TType DecodeFieldSignature<TType>(ISignatureTypeProvider<TType> provider);
+        public MethodSignature<TType> DecodeMethodSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
     public sealed class MetadataReader {
+        public int MetadataLength { get; }
+        public unsafe byte* MetadataPointer { get; }
+        public MetadataStringDecoder UTF8Decoder { get; }
+        public BlobReader GetBlobReader(StringHandle handle);
     }
     public struct MethodDefinition {
+        public MethodSignature<TType> DecodeSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
+    public struct MethodSignature<TType> {
+        public MethodSignature(SignatureHeader header, TType returnType, int requiredParameterCount, int genericParameterCount, ImmutableArray<TType> parameterTypes);
+        public int GenericParameterCount { get; }
+        public SignatureHeader Header { get; }
+        public ImmutableArray<TType> ParameterTypes { get; }
+        public int RequiredParameterCount { get; }
+        public TType ReturnType { get; }
+    }
     public struct MethodSpecification {
+        public ImmutableArray<TType> DecodeSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
+    public enum PrimitiveSerializationTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    public enum PrimitiveTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        IntPtr = (byte)24,
+        Object = (byte)28,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        TypedReference = (byte)22,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+        UIntPtr = (byte)25,
+        Void = (byte)1,
+    }
     public struct PropertyDefinition {
+        public MethodSignature<TType> DecodeSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
+    public struct ReservedBlob<THandle> where THandle : struct {
+        public Blob Content { get; }
+        public THandle Handle { get; }
+        public BlobWriter CreateWriter();
+    }
+    public enum SignatureTypeKind : byte {
+        Class = (byte)18,
+        Unknown = (byte)0,
+        ValueType = (byte)17,
+    }
     public struct StandaloneSignature {
+        public ImmutableArray<TType> DecodeLocalSignature<TType>(ISignatureTypeProvider<TType> provider);
+        public MethodSignature<TType> DecodeMethodSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
     public struct TypeSpecification {
+        public TType DecodeSignature<TType>(ISignatureTypeProvider<TType> provider);
     }
 }
```

