# .NET Core 2.0.0 Release Notes - August 14, 2017

.NET Core 2.0.0 and SDK 2.0.0 are available for download and testing.

* [Getting Started](https://www.microsoft.com/net/core/)
* [Downloads](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.0-download.md)

The blog roundup

* [.NET Core](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-core-2-0/)
* [NETStandard2](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-standard-2-0/)
* [ASP.NET Core](https://blogs.msdn.microsoft.com/webdev/2017/08/14/announcing-asp-net-core-2-0/)
* [EF Core](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-entity-framework-core-2-0/)

The .NET Core SDK 2.0.0 includes .NET Core 2.0.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.0.0, the following command will show that you're running version `2.0.0` of the tools.

`dotnet --version`

A [number of improvements and additions](2.0.0-commit.md) to .NET Core 2.0 by an [incredible array of folks](2.0.0-contributor.md). You can see details for other areas of the release in the [.NET Blog](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-core-2-0/) and have a look at [.NET Core 2.0.0 Known Issues](2.0.0-known-issues.md) document as there are a few things to be aware of before installing.

Your feedback is important and appreciated. We've created [dotnet/core #812](https://github.com/dotnet/core/issues/812) for your questions and comments.

## Azure AppServices

Deployment of .NET Core 2.0 support on Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carfully staged across regions over a period of time. Availability will roll out as follows:

* West US 2 and North Central US - up and running.
* Tomorrow morning, expand to about 20% of all regions
* Tuesday morning complete the deployment if no issues are found.

## .NET Core 2.0 Highlights

### NETStandard 2

An incredible number of APIs have been added to NETStandard2. See [Announcing NETStandard2](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-standard-2-0/) for details. 

### Platform updates

We have an exciting addition to the supported platform line-up with SUSE. Debian and Fedora have released updates recently which are also supported in 2.0.

* [SUSE Linux Enterprise Server 12 SP2](https://www.suse.com/products/server/)
* [Debian 9](https://www.debian.org/News/2017/20170617)
* [Fedora 25 and 26](https://getfedora.org)

#### High Sierra

.NET 2.0 has been tested on macOS High Sierra to ensure compatibility. Please start an conversation in [dotnet/core #812](https://github.com/dotnet/core/issues/812) if issues are encountered.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.0 images.

### Installer Package Name Changes

We received much feedback that our names and versions were confusing and generally messy. Great discussions were had with contributors to craft a plan which is implemented in Preview 2. You can see the conversation and details in [dotnet/designs/issues/2](https://github.com/dotnet/designs/issues/2) and [dotnet/core-setup/issues/1599](https://github.com/dotnet/core-setup/issues/1599).

### Server Hosting Bundles

Because the Runtime Package Store contains crossgen'ed files for a specific release, the hosting bundles will now install side-by-side. This will allow for previous applications to retain the performance benefits while applications targeting new Core versions will at the same time make use of the updated Store.

### Support

.NET Core 2.0 is being released as a 'current' release. See the [.NET Core support document](https://github.com/dotnet/core/blob/master/microsoft-support.md) for details on release types. We have also posted [OS Lifecycle Support Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) detailing OS version policies.

### WCF

The [WCF release page](https://github.com/dotnet/wcf/releases/tag/v2.0.0) has details on fixes from the WCF team.

## ASP.NET Core

Please see the [ASP.NET Core release notes](https://github.com/aspnet/Home/releases/tag/2.0.0) and [ASP.NET Core](https://blogs.msdn.microsoft.com/webdev/2017/08/14/announcing-asp-net-core-2-0/) for highlights on work from ASP.NET Core, MVC, Entity Framework Core and others.
