# System.Security

``` diff
+namespace System.Security {
+    public sealed class AllowPartiallyTrustedCallersAttribute : Attribute {
+        public AllowPartiallyTrustedCallersAttribute();
+    }
+    public sealed class SecureString : IDisposable {
+        public SecureString();
+        public unsafe SecureString(char* value, int length);
+        public int Length { get; }
+        public void AppendChar(char c);
+        public void Clear();
+        public SecureString Copy();
+        public void Dispose();
+        public void InsertAt(int index, char c);
+        public bool IsReadOnly();
+        public void MakeReadOnly();
+        public void RemoveAt(int index);
+        public void SetAt(int index, char c);
+    }
+    public static class SecureStringMarshal {
+        public static IntPtr SecureStringToCoTaskMemAnsi(SecureString s);
+        public static IntPtr SecureStringToCoTaskMemUnicode(SecureString s);
+        public static IntPtr SecureStringToGlobalAllocAnsi(SecureString s);
+        public static IntPtr SecureStringToGlobalAllocUnicode(SecureString s);
+    }
+    public sealed class SecurityCriticalAttribute : Attribute {
+        public SecurityCriticalAttribute();
+    }
+    public class SecurityException : Exception {
+        public SecurityException();
+        public SecurityException(string message);
+        public SecurityException(string message, Exception inner);
+        public override string ToString();
+    }
+    public sealed class SecuritySafeCriticalAttribute : Attribute {
+        public SecuritySafeCriticalAttribute();
+    }
+    public abstract class SecurityState {
+        protected SecurityState();
+        public abstract void EnsureState();
+        public bool IsStateAvailable();
+    }
+    public sealed class SecurityTransparentAttribute : Attribute {
+        public SecurityTransparentAttribute();
+    }
+    public sealed class UnverifiableCodeAttribute : Attribute {
+        public UnverifiableCodeAttribute();
+    }
+    public class VerificationException : Exception {
+        public VerificationException();
+        public VerificationException(string message);
+        public VerificationException(string message, Exception innerException);
+    }
+}
```

