import type { Config } from 'tailwindcss'

export default {
  content: ['./index.html', './src/**/*.{ts,tsx}', '../src/dev/devtools.tsx'],
  theme: {
    extend: {
      colors: {
        background: {
          100: 'var(--background-100)',
          200: 'var(--background-200)',
        },
        'gray-alpha': {
          100: 'var(--gray-alpha-100)',
          200: 'var(--gray-alpha-200)',
          300: 'var(--gray-alpha-300)',
          400: 'var(--gray-alpha-400)',
          500: 'var(--gray-alpha-500)',
          600: 'var(--gray-alpha-600)',
          700: 'var(--gray-alpha-700)',
          800: 'var(--gray-alpha-800)',
          900: 'var(--gray-alpha-900)',
          1000: 'var(--gray-alpha-1000)',
        },

        amber: {
          100: 'hsla(var(--amber-100-value), <alpha-value>)',
          200: 'hsla(var(--amber-200-value), <alpha-value>)',
          300: 'hsla(var(--amber-300-value), <alpha-value>)',
          400: 'hsla(var(--amber-400-value), <alpha-value>)',
          500: 'hsla(var(--amber-500-value), <alpha-value>)',
          600: 'hsla(var(--amber-600-value), <alpha-value>)',
          700: 'hsla(var(--amber-700-value), <alpha-value>)',
          800: 'hsla(var(--amber-800-value), <alpha-value>)',
          900: 'hsla(var(--amber-900-value), <alpha-value>)',
          1000: 'hsla(var(--amber-1000-value), <alpha-value>)',
        },
        blue: {
          100: 'hsla(var(--blue-100-value), <alpha-value>)',
          200: 'hsla(var(--blue-200-value), <alpha-value>)',
          300: 'hsla(var(--blue-300-value), <alpha-value>)',
          400: 'hsla(var(--blue-400-value), <alpha-value>)',
          500: 'hsla(var(--blue-500-value), <alpha-value>)',
          600: 'hsla(var(--blue-600-value), <alpha-value>)',
          700: 'hsla(var(--blue-700-value), <alpha-value>)',
          800: 'hsla(var(--blue-800-value), <alpha-value>)',
          900: 'hsla(var(--blue-900-value), <alpha-value>)',
          1000: 'hsla(var(--blue-1000-value), <alpha-value>)',
        },
        gray: {
          100: 'hsla(var(--gray-100-value), <alpha-value>)',
          200: 'hsla(var(--gray-200-value), <alpha-value>)',
          300: 'hsla(var(--gray-300-value), <alpha-value>)',
          400: 'hsla(var(--gray-400-value), <alpha-value>)',
          500: 'hsla(var(--gray-500-value), <alpha-value>)',
          600: 'hsla(var(--gray-600-value), <alpha-value>)',
          700: 'hsla(var(--gray-700-value), <alpha-value>)',
          800: 'hsla(var(--gray-800-value), <alpha-value>)',
          900: 'hsla(var(--gray-900-value), <alpha-value>)',
          1000: 'hsla(var(--gray-1000-value), <alpha-value>)',
        },
        green: {
          100: 'hsla(var(--green-100-value), <alpha-value>)',
          200: 'hsla(var(--green-200-value), <alpha-value>)',
          300: 'hsla(var(--green-300-value), <alpha-value>)',
          400: 'hsla(var(--green-400-value), <alpha-value>)',
          500: 'hsla(var(--green-500-value), <alpha-value>)',
          600: 'hsla(var(--green-600-value), <alpha-value>)',
          700: 'hsla(var(--green-700-value), <alpha-value>)',
          800: 'hsla(var(--green-800-value), <alpha-value>)',
          900: 'hsla(var(--green-900-value), <alpha-value>)',
          1000: 'hsla(var(--green-1000-value), <alpha-value>)',
        },
        pink: {
          100: 'hsla(var(--pink-100-value), <alpha-value>)',
          200: 'hsla(var(--pink-200-value), <alpha-value>)',
          300: 'hsla(var(--pink-300-value), <alpha-value>)',
          400: 'hsla(var(--pink-400-value), <alpha-value>)',
          500: 'hsla(var(--pink-500-value), <alpha-value>)',
          600: 'hsla(var(--pink-600-value), <alpha-value>)',
          700: 'hsla(var(--pink-700-value), <alpha-value>)',
          800: 'hsla(var(--pink-800-value), <alpha-value>)',
          900: 'hsla(var(--pink-900-value), <alpha-value>)',
          1000: 'hsla(var(--pink-1000-value), <alpha-value>)',
        },
        purple: {
          100: 'hsla(var(--purple-100-value), <alpha-value>)',
          200: 'hsla(var(--purple-200-value), <alpha-value>)',
          300: 'hsla(var(--purple-300-value), <alpha-value>)',
          400: 'hsla(var(--purple-400-value), <alpha-value>)',
          500: 'hsla(var(--purple-500-value), <alpha-value>)',
          600: 'hsla(var(--purple-600-value), <alpha-value>)',
          700: 'hsla(var(--purple-700-value), <alpha-value>)',
          800: 'hsla(var(--purple-800-value), <alpha-value>)',
          900: 'hsla(var(--purple-900-value), <alpha-value>)',
          1000: 'hsla(var(--purple-1000-value), <alpha-value>)',
        },
        red: {
          100: 'hsla(var(--red-100-value), <alpha-value>)',
          200: 'hsla(var(--red-200-value), <alpha-value>)',
          300: 'hsla(var(--red-300-value), <alpha-value>)',
          400: 'hsla(var(--red-400-value), <alpha-value>)',
          500: 'hsla(var(--red-500-value), <alpha-value>)',
          600: 'hsla(var(--red-600-value), <alpha-value>)',
          700: 'hsla(var(--red-700-value), <alpha-value>)',
          800: 'hsla(var(--red-800-value), <alpha-value>)',
          900: 'hsla(var(--red-900-value), <alpha-value>)',
          1000: 'hsla(var(--red-1000-value), <alpha-value>)',
        },
        teal: {
          100: 'hsla(var(--teal-100-value), <alpha-value>)',
          200: 'hsla(var(--teal-200-value), <alpha-value>)',
          300: 'hsla(var(--teal-300-value), <alpha-value>)',
          400: 'hsla(var(--teal-400-value), <alpha-value>)',
          500: 'hsla(var(--teal-500-value), <alpha-value>)',
          600: 'hsla(var(--teal-600-value), <alpha-value>)',
          700: 'hsla(var(--teal-700-value), <alpha-value>)',
          800: 'hsla(var(--teal-800-value), <alpha-value>)',
          900: 'hsla(var(--teal-900-value), <alpha-value>)',
          1000: 'hsla(var(--teal-1000-value), <alpha-value>)',
        },
      },
    },
  },
  plugins: [],
} satisfies Config
