import os

import infra.basetest


class TestPythonPyQt5(infra.basetest.BRTest):
    # We use a specific configuration for:
    # - using Aarch64, to have more than 256MB memory,
    # - using a kernel config fragment, to enable VKMS,
    # - to have an ext4 rootfs image exposed as a virtio storage
    #   (rather than cpio initrd). This will save some memory, as the
    #   rootfs image is big.
    kernel_fragment = \
        infra.filepath("tests/package/test_python_pyqt5/linux-vkms.fragment")
    rootfs_overlay = \
        infra.filepath("tests/package/test_python_pyqt5/rootfs-overlay")
    config = \
        f"""
        BR2_aarch64=y
        BR2_TOOLCHAIN_EXTERNAL=y
        BR2_TARGET_GENERIC_GETTY_PORT="ttyAMA0"
        BR2_LINUX_KERNEL=y
        BR2_LINUX_KERNEL_CUSTOM_VERSION=y
        BR2_LINUX_KERNEL_CUSTOM_VERSION_VALUE="6.1.81"
        BR2_LINUX_KERNEL_USE_CUSTOM_CONFIG=y
        BR2_LINUX_KERNEL_CUSTOM_CONFIG_FILE="board/qemu/aarch64-virt/linux.config"
        BR2_LINUX_KERNEL_CONFIG_FRAGMENT_FILES="{kernel_fragment}"
        BR2_PACKAGE_DEJAVU=y
        BR2_PACKAGE_LIBDRM=y
        BR2_PACKAGE_MESA3D=y
        BR2_PACKAGE_MESA3D_GALLIUM_DRIVER_SWRAST=y
        BR2_PACKAGE_MESA3D_LLVM=y
        BR2_PACKAGE_MESA3D_OPENGL_EGL=y
        BR2_PACKAGE_MESA3D_OPENGL_ES=y
        BR2_PACKAGE_PYTHON3=y
        BR2_PACKAGE_PYTHON_PYQT5=y
        BR2_PACKAGE_QT5=y
        BR2_PACKAGE_QT5BASE_EGLFS=y
        BR2_PACKAGE_QT5BASE_FONTCONFIG=y
        BR2_PACKAGE_QT5BASE_WIDGETS=y
        BR2_ROOTFS_OVERLAY="{rootfs_overlay}"
        BR2_TARGET_ROOTFS_EXT2=y
        BR2_TARGET_ROOTFS_EXT2_4=y
        BR2_TARGET_ROOTFS_EXT2_SIZE="256M"
        # BR2_TARGET_ROOTFS_TAR is not set
        """

    def test_run(self):
        drive = os.path.join(self.builddir, "images", "rootfs.ext4")
        kern = os.path.join(self.builddir, "images", "Image")
        self.emulator.boot(arch="aarch64",
                           kernel=kern,
                           kernel_cmdline=["root=/dev/vda console=ttyAMA0"],
                           options=["-M", "virt", "-cpu", "cortex-a57", "-m", "512M",
                                    "-drive", f"file={drive},if=virtio,format=raw"])
        self.emulator.login()

        # We run the test application with a customized message.
        # NOTE: to manually debug this test, a Qemu emulator with
        # virtio-gpu can be used by starting it the command line from
        # the run log generated by this test, and by adding the
        # arguments "-device virtio-gpu -display gtk". With this, the
        # test application will be observable on the Qemu window. Once
        # logged, we can use the "card1" DRM/KMS device (virtio-gpu,
        # instead of card0, which is vkms on "card0") by using the
        # command:
        #     echo '{"device":"/dev/dri/card1"}' > cfg.json
        #     export QT_QPA_EGLFS_KMS_CONFIG="$PWD/cfg.json"
        # The Qt debug can also be enabled with the command:
        #     export QT_LOGGING_RULES=*=true
        # Then, run the /root/pyqt5test.py application.
        msg = "Hello Buildroot."
        cmd = f'/root/pyqt5test.py "{msg}"'
        self.assertRunOk(cmd, timeout=30)

        # We check the test message is present in the file created by
        # the previous application execution.
        cmd = f'grep -F "{msg}" /root/message.txt'
        self.assertRunOk(cmd)
