# StructureController

<img src="img/controller.png" alt="" align="right" />

Claim this structure to take control over the room. The controller structure cannot be damaged or destroyed. 

It can be addressed by [`Room.controller`](#Room.controller) property.

<table class="table gameplay-info">
    <tbody>
    <tr>
        <th><strong>Level</strong></th>
        <th>Upgrade to next level</th>
        <th>Downgrade timer</th>
    </tr>
    <tr>
        <td>1</td>
        <td>200 energy</td>
        <td>20,000 ticks</td>
    </tr>
    <tr>
        <td>2</td>
        <td>45,000 energy</td>
        <td>10,000 ticks</td>
    </tr>
    <tr>
        <td>3</td>
        <td>135,000 energy</td>
        <td>20,000 ticks</td>
    </tr>
    <tr>
        <td>4</td>
        <td>405,000 energy</td>
        <td>40,000 ticks</td>
    </tr>
    <tr>
        <td>5</td>
        <td>1,215,000 energy</td>
        <td>80,000 ticks</td>
    </tr>
    <tr>
        <td>6</td>
        <td>3,645,000 energy</td>
        <td>120,000 ticks</td>
    </tr>
    <tr>
        <td>7</td>
        <td>10,935,000 energy</td>
        <td>150,000 ticks</td>
    </tr>
    <tr>
        <td>8</td>
        <td>—</td>
        <td>200,000 ticks</td>
    </tr>
    </tbody>
</table>
	
### Safe mode	
	
<table class=gameplay-info>
    <tbody>
    <tr>
        <td><strong>Effect</strong></td>
        <td>Blocks <code>attack</code>, <code>rangedAttack</code>, <code>rangedMassAttack</code>, <code>dismantle</code>, <code>heal</code>, <code>rangedHeal</code>, <code>attackController</code>, and <code>withdraw</code> methods of all hostile creeps in the room, plus <code>enableRoom</code> and <code>usePower</code> methods of hostile Power Creeps. Only one room can be in safe mode at the same time.<br/>
	When safe mode is active, all hostile creeps become visually transparent and passable - your creeps can move through them freely (but not vice versa).</td>
    </tr>
    <tr>
        <td><strong>Duration</strong></td>
        <td>20,000 ticks</td>
    </tr>
    <tr>
        <td><strong>Cooldown</strong></td>
        <td>50,000 ticks (no cooldown in Novice Areas, also no cooldown for initial Safe Mode in your first room)</td>
    </tr>
    <tr>
        <td><strong>Generation</strong></td>
        <td>
            <ul>
                <li>Each new controller level generates one available activation</li>
                <li>Can be generated by creeps using 1,000 ghodium</li>
                <li>All available activations are reset if the controller is downgraded</li>
            </ul>
        </td>
    </tr>
    </tbody>
</table>

{% page inherited/OwnedStructure.md %}

{% api_property isPowerEnabled 'boolean' %}
Whether using power is enabled in this room. Use [`PowerCreep.enableRoom`](#PowerCreep.enableRoom) to turn powers on.

{% api_property level 'number' %}



Current controller level, from 0 to 8.



{% api_property progress 'number' %}



The current progress of upgrading the controller to the next level.



{% api_property progressTotal 'number' %}



The progress needed to reach the next level.



{% api_property reservation 'object' %}



An object with the controller reservation info if present:

{% api_method_params %}
username : string
The name of a player who reserved this controller.
===
ticksToEnd : number
The amount of game ticks when the reservation will end.
{% endapi_method_params %}


{% api_property safeMode 'number' %}



How many ticks of safe mode remaining, or undefined.



{% api_property safeModeAvailable 'number' %}



Safe mode activations available to use.



{% api_property safeModeCooldown 'number' %}



During this period in ticks new safe mode activations will be blocked, undefined if cooldown is inactive.



{% api_property sign 'object' %}



An object with the controller sign info if present:

{% api_method_params %}
username : string
The name of a player who signed this controller.
===
text : string
The sign text.
===
time : number
The sign time in game ticks.
===
datetime : Date
The sign real date.
{% endapi_method_params %}


{% api_property ticksToDowngrade 'number' %}



The amount of game ticks when this controller will lose one level. This timer is set to 50% on level upgrade or downgrade, and it can be increased by using <code><a href="#Creep.upgradeController">Creep.upgradeController</a></code>. Must be full to upgrade the controller to the next level.



{% api_property upgradeBlocked 'number' %}



The amount of game ticks while this controller cannot be upgraded due to attack. Safe mode is also unavailable during this period.



{% api_method activateSafeMode '' A %}

```javascript
room.controller.activateSafeMode();
```

Activate safe mode if available.



### Return value

One of the following codes:
{% api_return_codes %}
OK | The operation has been scheduled successfully.
ERR_NOT_OWNER | You are not the owner of this controller.
ERR_BUSY | There is another room in safe mode already.
ERR_NOT_ENOUGH_RESOURCES | There is no safe mode activations available.
ERR_TIRED | The previous safe mode is still cooling down, or the controller is `upgradeBlocked`, or the controller is downgraded for 50% plus 5000 ticks or more.
{% endapi_return_codes %}



{% api_method unclaim '' A %}

```javascript
room.controller.unclaim();
```

Make your claimed controller neutral again.



### Return value

One of the following codes:
{% api_return_codes %}
OK | The operation has been scheduled successfully.
ERR_NOT_OWNER | You are not the owner of this controller.
{% endapi_return_codes %}


