title: Contribute to Screeps docs and earn money
---

Documentation is an important part of any program platform, and we put a lot of effort to fill our documentation with quality content. If you want to help us create and improve our documentation, this page will explain the process how you do this. For each article that we’ll accept and publish in this doc section, you’ll get either **$50** on your PayPal account or **5 Subscription Tokens** (roughly equivalent to $90) on your game account depending on your choice.

## Articles we need

We welcome articles with:

* Precise description of complex game mechanics and nuances not fully covered in our official docs.
* Step-by-step tutorials for achieving popular and simple game objectives.
* Reviews of various solutions and approaches to solve popular tasks in Screeps.
* Detailed how-tos on setting the outside environment, using third-party utilities, libraries, compilers.

## General tips to consider

* Choose topics least covered in the official documentation and other User-Contributed Articles.
* If you want to amend an existing article, your submission should be substantial and on par with writing an original article in terms of volume. If your submission has not enough content, or too closely resembles a current article either by Screeps or on another source, it may be rejected.
* Don’t write articles with a lot of ready code or give complex ready solutions that players might prefer finding themselves. Instead, describe specific issues and challenges they could face and offer directions where to find solutions.
* Involve other users to discuss your Pull Request on the review stage to improve your article’s quality.
* Link to your published article from your own website or social media posts. This actually improves the page rankings of your own site because of an SEO aspect called link authority.

## Content guidelines

Articles should be informational but friendly. Use the active voice whenever possible, and the pronouns you or we instead of I. Avoid unnecessary information. Brief, to-the-point explanations are preferred. To be considered, submissions must be written in English and contain high-quality content. The primary qualities we look for in an article are:

* Accuracy: Instructions should be straightforward, technically correct and thoroughly tested. Include brief explanations of each step to explain the purpose of each action. Articles can use technical jargon pertinent to Screeps, JavaScript, and related topics, but use common sense - if a term implies an advanced concept that fewer people would know, take a sentence or two to explain it, or link to a documentation page.
* Completeness: If you write a guide or a how-to, it should leave readers with a finished, working configuration and give them an idea of where to go from there.
* Originality: Content should be original material written for Screeps. We will not accept submissions which are duplicated from other sources, including personal blogs.

If you would like to see whether your work is in line with our requirements before taking the time to write a full article, writing samples can be submitted to contact@screeps.com.

## The submission process

Submit your article as a pull request to [screeps/docs](https://github.com/screeps/docs/tree/master/source/contributed/) on GitHub.

All articles will remain on GitHub for up to 2 weeks for the community to comment on or submit pull requests of their own. Along the process, you may receive questions or comments from us, pull requests with edits, or a request for a resubmission with changes.

When accepted, we will submit the final version to your GitHub fork as a pull request. You will have 36 hours to respond and approve our publication of the final version. If you respond positively, we will publish the article and you’ll receive payment. Non-response will be taken as a go-ahead to publish.

## Legal information

COPYRIGHT OWNERSHIP. Writer agrees that the Work is being created by the writer for the Screeps Documentation Contributed Articles repository and that each form of Work is being created by the writer, at all stages of development, shall be and remain the sole and exclusive property of Screeps. At Screeps’s sole, absolute and unfettered discretion, Screeps may make any alterations to the Work.

CREDIT. Nothing contained in this Agreement shall be deeded to require Screeps to use the Work, or any part thereof, in connection with Screeps Documentation or otherwise. Credit for the Work shall read, “Contributed by writer’s name.”

PAYMENT. Upon publication of a submission to the Screeps Documentation Repository, the writer will be paid either the sum of USD $50.00 either as an electronic payment or a credit of 5 Subscription Tokens to their Screeps account.