/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import java.io.PrintStream;

public class Log {
    private static PrintStream out;
    private static PrintStream err;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int TRACE = 4;
    private static int level;

    public static void trace(String msg) {
        if (level >= 4) {
            out.println(msg);
        }
    }

    public static void debug(String msg) {
        if (level >= 3) {
            out.println(msg);
        }
    }

    public static void info(String msg) {
        if (level >= 2) {
            out.println(msg);
        }
    }

    public static void warn(String msg) {
        err.println(msg);
    }

    public static void error(String msg) {
        err.println(msg);
    }

    public static void initializeLog(PrintStream o, PrintStream e) {
        out = o;
        err = e;
    }

    public static void setLogLevel(String l) {
        switch (l) {
            case "warn": {
                level = 1;
                break;
            }
            case "info": {
                level = 2;
                break;
            }
            case "debug": {
                level = 3;
                break;
            }
            case "trace": {
                level = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such log level \"" + l + "\"");
            }
        }
    }

    public static boolean isTracing() {
        return level >= 4;
    }

    public static boolean isDebugging() {
        return level >= 3;
    }

    static {
        level = 1;
    }
}

